/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.engine.sql.util;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.df.common.constant.DataSetMethodEnum;
import com.jxdinfo.hussar.df.common.constant.app.DataSetTypeEnum;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.DfColumnValue;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.SqlDataSetModel;
import com.jxdinfo.hussar.df.data.set.api.dto.DataSetFieldParamDto;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModelBase;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetQueryModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetSortModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetTables;
import com.jxdinfo.hussar.df.data.set.api.model.DfDataSetModelField;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.server.operation.DfDataSetOperation;
import com.jxdinfo.hussar.df.data.set.server.util.DfExternalApiUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.dto.MsTableDto;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessPmDto;
import com.jxdinfo.hussar.support.engine.api.enums.ConditionType;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfEnginePushUtil {
    private static final Logger logger = LoggerFactory.getLogger(DfEnginePushUtil.class);
    private static final String path = "hussar/df/dataSet/";
    private static EngineBussnessdataConfigService configService = (EngineBussnessdataConfigService)SpringContextUtil.getBean(EngineBussnessdataConfigService.class);

    public static PushBackCtx getPushBackCtx(DataSetModelBase dataSetModelBase) {
        String functionType = DataSetTypeEnum.parseFunctionType((String)dataSetModelBase.getDataSetType());
        String modelName = dataSetModelBase.getDataSetCode();
        PushBackCtx ctx = new PushBackCtx();
        ModelTableMappingDTO modelTableMapping = null;
        ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
        switch (functionType) {
            case "DATASET": {
                DataSetModel dataSetModel = (DataSetModel)dataSetModelBase;
                if (dataSetModel.getTables().size() > 1) {
                    modelTableMapping = modelRelateService.getModelTableMapping(String.valueOf(dataSetModel.getDataSetId()));
                    ctx.setColumnMap(DfEnginePushUtil.getMasterColumnMap(dataSetModel.getTables(), String.valueOf(dataSetModel.getDataSetId())));
                } else {
                    modelTableMapping = modelRelateService.getModelTableMapping(String.valueOf(dataSetModel.getDataSetId()));
                    ctx.setColumnMap(DfEnginePushUtil.getColumnMap(String.valueOf(dataSetModel.getDataSetId())));
                }
                if (dataSetModel.getTables().size() > 1) {
                    ctx.isMs = true;
                    break;
                }
                ctx.isMs = false;
                break;
            }
            case "SQL_DATASET": {
                SqlDataSetModel sqlDataSetModel = (SqlDataSetModel)dataSetModelBase;
                ArrayList<String> tableName = new ArrayList<String>();
                tableName.add(sqlDataSetModel.getSourceDataModelName());
                modelTableMapping = modelRelateService.getModelTableMapping(String.valueOf(sqlDataSetModel.getDataSetId()));
                ctx.setColumnMap(DfEnginePushUtil.getColumnMap(String.valueOf(sqlDataSetModel.getDataSetId())));
                break;
            }
            default: {
                return ctx;
            }
        }
        ctx.setModelId(modelTableMapping.getRelatedId());
        ctx.setModelName(modelName);
        ctx.build();
        return ctx;
    }

    public static PushBackCtx getPushCustomBack() {
        return null;
    }

    public static String getRelationById(DataSetModel dataSetModel) {
        DataSetTables masterTable = new DataSetTables();
        for (DataSetTables dataSetTables : dataSetModel.getTables()) {
            if (!dataSetTables.isPrimaryTable()) continue;
            return String.valueOf(dataSetModel.getDataSetId());
        }
        return dataSetModel.getDataSetId() + masterTable.getTableId();
    }

    public static Map<String, MetadataColumn> getColumnMap(String modelId) {
        ModelTableMappingDTO tableInfo = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(modelId);
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        if (HussarUtils.isNotEmpty((Object)tableInfo)) {
            for (MetadataColumn column : tableInfo.getColumns()) {
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    public static Map<String, MetadataColumn> getMasterColumnMap(List<DataSetTables> dataSetTablesList, String id) {
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        ModelTableMappingDTO tableInfo = null;
        for (DataSetTables dataSetTables : dataSetTablesList) {
            if (dataSetTables.isPrimaryTable()) {
                tableInfo = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(id);
            } else {
                TableInfoDto tableInfoDto = DfExternalApiUtil.getTableByName((String)dataSetTables.getName(), (boolean)false);
                tableInfo = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(id + tableInfoDto.getTableId());
            }
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumns()) {
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    public static SingleTableDto getPushDto(List<ProjectionField> projectionFields, PushBackCtx ctx, String businessId, String methodName, String methodDesc) {
        SingleTableDto dto = DfEnginePushUtil.getSingleTableDto(ctx, businessId, methodName, methodDesc);
        dto.setPmList(new ArrayList());
        for (ProjectionField field : projectionFields) {
            MetadataColumn column = DfEnginePushUtil.getRelationShipField(ctx, field);
            if (field.getField() == null) continue;
            if ("calc".equals(field.getType())) {
                DataSetFieldParamDto nodeBusinessPmDto = new DataSetFieldParamDto();
                nodeBusinessPmDto.setParameterType(ParameterType.express);
                nodeBusinessPmDto.setExpression(field.getExpression());
                nodeBusinessPmDto.setParameterAlias(field.getFieldAlias());
                nodeBusinessPmDto.setFunctionJavaType("java.lang.Double");
                nodeBusinessPmDto.setTitle(field.getRename());
                dto.getPmList().add(nodeBusinessPmDto);
                continue;
            }
            DfEnginePushUtil.getPm(dto.getPmList(), field, column);
        }
        return dto;
    }

    public static SingleTableDto getPushQueryDto(List<ProjectionField> projectionFields, PushBackCtx ctx, String businessId, String methodName, String methodDesc) {
        SingleTableDto dto = DfEnginePushUtil.getSingleTableDto(ctx, businessId, methodName, methodDesc);
        dto.setPmList(new ArrayList());
        for (ProjectionField field : projectionFields) {
            MetadataColumn column = DfEnginePushUtil.getRelationShipField(ctx, field);
            if (field.getField() == null) continue;
            if ("calc".equals(field.getType())) {
                DataSetFieldParamDto nodeBusinessPmDto = new DataSetFieldParamDto();
                nodeBusinessPmDto.setParameterType(ParameterType.express);
                nodeBusinessPmDto.setExpression(field.getExpression());
                nodeBusinessPmDto.setParameterAlias(field.getFieldAlias());
                nodeBusinessPmDto.setFunctionJavaType("java.lang.Double");
                nodeBusinessPmDto.setTitle(field.getRename());
                dto.getPmList().add(nodeBusinessPmDto);
                continue;
            }
            DfEnginePushUtil.getPm(dto.getPmList(), field, column);
        }
        return dto;
    }

    public static void getPm(List<NodeBusinessPm> pmList, ProjectionField field, MetadataColumn column) {
        DataSetFieldParamDto pm = DfEnginePushUtil.getNodeBusinessPm(field.getField(), column);
        pm.setParameterType(ParameterType.column);
        pm.setFunctionJavaType(column.getJavaType());
        pm.setTitle(field.getRename());
        pmList.add((NodeBusinessPm)pm);
    }

    public static DataSetFieldParamDto getNodeBusinessPm(String parameterAlias, MetadataColumn column) {
        DataSetFieldParamDto pm = new DataSetFieldParamDto();
        pm.setColumnId(column.getColumnId());
        pm.setParameterAlias(parameterAlias);
        return pm;
    }

    public static MetadataColumn getRelationShipField(PushBackCtx ctx, ProjectionField field) {
        String fieldName;
        Map columnMap = ctx.getColumnMap();
        MetadataColumn column = (MetadataColumn)columnMap.get(fieldName = field.getTable() + "-" + field.getField());
        if (column != null) {
            return column;
        }
        return null;
    }

    public static SingleTableDto getTableQueryDto(PushBackCtx engineCtx, DataSetModel dataSetModel) {
        DataSetMethodEnum engineMethod = engineCtx.isMs ? DataSetMethodEnum.DATA_SET_MsTable_QUERY : DataSetMethodEnum.DATA_SET_SingleTable_QUERY;
        SingleTableDto dto = null;
        dto = "publish".equals(dataSetModel.getDataSetMethod()) ? DfEnginePushUtil.getPushDto(dataSetModel.getProjection(), engineCtx, DfEnginePushUtil.getUrl("POST", "tableQuery", path + dataSetModel.getDataSetId()), engineMethod.value.getName(), engineMethod.value.getDesc()) : DfEnginePushUtil.getPushDto(dataSetModel.getProjection(), engineCtx, DfEnginePushUtil.getUrl("POST", "previewData", "/dataSet/" + dataSetModel.getDataSetId()), engineMethod.value.getName(), engineMethod.value.getDesc());
        dto.setPagination(true);
        dto.setResultTypeList(true);
        Map columnMap = engineCtx.getColumnMap();
        dto.setWhere(new ArrayList());
        if (ToolUtil.isNotEmpty((Object)dataSetModel.getQuery())) {
            DfEnginePushUtil.getWhere(dataSetModel.getParameterValues(), dto.getWhereList(), columnMap, dataSetModel.getQuery(), null);
        }
        if (ToolUtil.isNotEmpty((Object)dataSetModel.getSort())) {
            for (DataSetSortModel sortField : dataSetModel.getSort()) {
                MetadataColumn column = DfEnginePushUtil.getMetadataColumn(columnMap, sortField.getTable() + "-" + sortField.getField());
                if (column == null) continue;
                dto.addSort(column.getColumnId(), sortField.getDirection().equals("ASC") ? OrderByType.ASC : OrderByType.DESC);
            }
        }
        return dto;
    }

    public static SingleTableDto getEchartQueryDto(PushBackCtx engineCtx, DataSetModel dataSetModel) {
        DataSetMethodEnum engineMethod = null;
        engineMethod = engineCtx.isMs ? DataSetMethodEnum.DATA_SET_MsTable_CHART_QUERY : DataSetMethodEnum.DATA_SET_Single_CHART_QUERY;
        SingleTableDto dto = null;
        dto = DfEnginePushUtil.getPushQueryDto(dataSetModel.getProjection(), engineCtx, DfEnginePushUtil.getUrl("POST", "echartQuery", path + dataSetModel.getDataSetId()), engineMethod.value.getName(), engineMethod.value.getDesc());
        dto.setPagination(false);
        dto.setResultTypeList(true);
        Map columnMap = engineCtx.getColumnMap();
        dto.setWhere(new ArrayList());
        if (ToolUtil.isNotEmpty((Object)dataSetModel.getQuery())) {
            DfEnginePushUtil.getWhere(dataSetModel.getParameterValues(), dto.getWhereList(), columnMap, dataSetModel.getQuery(), null);
        }
        if (ToolUtil.isNotEmpty((Object)dataSetModel.getSort())) {
            for (DataSetSortModel sortField : dataSetModel.getSort()) {
                MetadataColumn column = DfEnginePushUtil.getMetadataColumn(columnMap, sortField.getTable() + "-" + sortField.getField());
                if (column == null) continue;
                dto.addSort(column.getColumnId(), sortField.getDirection().equals("ASC") ? OrderByType.ASC : OrderByType.DESC);
            }
        }
        return dto;
    }

    public static void pushTableQuery(PushBackCtx engineCtx, DataSetModelBase dataSetModel, DfDataSetOperation dataSetOPeration) {
        String functionType = DataSetTypeEnum.parseFunctionType((String)dataSetModel.getDataSetType());
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = null;
        switch (functionType) {
            case "DATASET": {
                DataSetModel dataSetModel1 = (DataSetModel)dataSetModel;
                dto = DfEnginePushUtil.getTableQueryDto(engineCtx, dataSetModel1);
                if (dataSetModel1.getTables().size() <= 1) break;
                isMs = true;
                break;
            }
            case "SQL_DATASET": {
                SqlDataSetModel sqlDataSetModel = (SqlDataSetModel)dataSetModel;
                dto = DfEnginePushUtil.getSqlDataSetQuery(engineCtx, sqlDataSetModel, dataSetOPeration);
            }
        }
        DfEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    private static SingleTableDto getSqlDataSetQuery(PushBackCtx engineCtx, SqlDataSetModel sqlDataSetModel, DfDataSetOperation dataSetOPeration) {
        DataSetMethodEnum engineMethod = null;
        SingleTableDto dto = new SingleTableDto();
        if (dataSetOPeration.getPage().booleanValue()) {
            engineMethod = DataSetMethodEnum.SINGLE_TABLE_SELECT_CUSTOM_PAGE;
            dto.setPagination(true);
        } else {
            engineMethod = DataSetMethodEnum.SINGLE_TABLE_SELECT_CUSTOM;
        }
        String dataSetPath = path + sqlDataSetModel.getDataSetId();
        if (HussarUtils.isNotEmpty((Object)sqlDataSetModel.getDisDataSet()) && sqlDataSetModel.getDisDataSet()) {
            dataSetPath = null;
        }
        dto = DfEnginePushUtil.getPushCustomSqlDto(sqlDataSetModel, engineCtx, DfEnginePushUtil.getUrl(dataSetOPeration.getType(), dataSetOPeration.getName(), dataSetPath), engineMethod.value.getName(), engineMethod.value.getDesc());
        dto.setResultTypeList(true);
        return dto;
    }

    private static SingleTableDto getPushCustomSqlDto(SqlDataSetModel sqlDataSetModel, PushBackCtx engineCtx, String url, String name, String desc) {
        SingleTableDto dto = DfEnginePushUtil.getSingleTableDto(engineCtx, url, name, desc);
        List fields = sqlDataSetModel.getProjection();
        dto.setPmList(new ArrayList());
        for (ProjectionField dataSetModelField : fields) {
            MetadataColumn column;
            if (dataSetModelField.getFieldAlias() == null || (column = DfEnginePushUtil.getCustomRelationShipField(sqlDataSetModel.getDataSetCode(), String.valueOf(sqlDataSetModel.getDataSetId()), engineCtx, dataSetModelField)) == null) continue;
            DataSetFieldParamDto nodeBusinessPmDto = new DataSetFieldParamDto();
            nodeBusinessPmDto.setParameterType(ParameterType.column);
            nodeBusinessPmDto.setParameterAlias(dataSetModelField.getFieldAlias());
            nodeBusinessPmDto.setDataType(column.getDataType());
            nodeBusinessPmDto.setFunctionJavaType(column.getJavaType());
            nodeBusinessPmDto.setColumnId(column.getColumnId());
            dto.getPmList().add(nodeBusinessPmDto);
        }
        return dto;
    }

    private static MetadataColumn getCustomRelationShipField(String dataSetCode, String modleId, PushBackCtx engineCtx, ProjectionField dataSetModelField) {
        String fieldName;
        Map columnMap = engineCtx.getColumnMap();
        MetadataColumn column = (MetadataColumn)columnMap.get(fieldName = dataSetCode + modleId + "-" + dataSetModelField.getFieldAlias());
        if (column != null) {
            return column;
        }
        return null;
    }

    private static MetadataColumn getRelationShipField(PushBackCtx ctx, DfDataSetModelField field) {
        MetadataColumn column;
        Map columnMap = ctx.getColumnMap();
        String fieldName = field.getSourceDataModelId() + "-" + field.getName().toUpperCase();
        if (ctx.isMs && (column = (MetadataColumn)columnMap.get(fieldName)) != null) {
            return column;
        }
        return DfEnginePushUtil.getMetadataColumn(columnMap, fieldName);
    }

    public static void pushEchartQuery(PushBackCtx engineCtx, DataSetModel dataSetModel) {
        boolean isMs = false;
        SingleTableDto dto = DfEnginePushUtil.getEchartQueryDto(engineCtx, dataSetModel);
        if (dataSetModel.getTables().size() > 1) {
            isMs = true;
        }
        DfEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static <T extends SingleTableDto> void push(PushBackCtx ctx, List<String> flowColumns, T dto, int type) {
        switch (type) {
            case 1: {
                configService.saveSingleTableService(dto, ctx);
                break;
            }
            case 2: {
                MsTableDto msTableDto = new MsTableDto();
                msTableDto.setBusinessId(dto.getBusinessId());
                msTableDto.setMethodDesc(dto.getMethodDesc());
                msTableDto.setMethodName(dto.getMethodName());
                msTableDto.setWhere(dto.getWhereList());
                msTableDto.setBusinessCode(dto.getBusinessCode());
                msTableDto.setPagination(dto.isPagination());
                msTableDto.setResultTypeList(dto.isResultTypeList());
                msTableDto.setPmList(dto.getPmList());
                msTableDto.setSortVOList(dto.getSortVOList());
                configService.saveMasterSlaveService(msTableDto, ctx);
                break;
            }
        }
    }

    public static void pushApi(PushBackCtx ctx) {
        configService.pushApi(ctx);
    }

    public static void getWhere(List<DfColumnValue> variables, List<NodeBusinessPm> whereList, Map<String, MetadataColumn> columnMap, List<DataSetQueryModel> fields, Long pId) {
        for (DataSetQueryModel field : fields) {
            NodeBusinessPmDto nodeBusinessPm = new NodeBusinessPmDto();
            if ("row".equals(field.getType())) {
                MetadataColumn column = DfEnginePushUtil.getMetadataColumn(columnMap, field.getTable() + "-" + field.getField());
                if (column == null) continue;
                if (!field.getParamType().equals("constant")) {
                    DfColumnValue dfColumnValue1 = variables.stream().filter(dfColumnValue -> dfColumnValue.getCode().equals(field.getValue())).findFirst().orElse(null);
                    if (HussarUtils.isNotEmpty((Object)dfColumnValue1)) {
                        nodeBusinessPm.setParameterAlias(column.getColumnAlias());
                        nodeBusinessPm.setColumnId(column.getColumnId());
                    }
                } else {
                    nodeBusinessPm.setDefaultValue((String)field.getValue());
                    nodeBusinessPm = DfEnginePushUtil.getNodeBusinessPm(field.getQueryAttrName(), column);
                }
                nodeBusinessPm.setMatchType("and".equals(field.getPreCondition()) ? MatchTypeEnum.AND : MatchTypeEnum.OR);
                nodeBusinessPm.setOperatorType(DfExternalApiUtil.getOperatorType((String)field.getCondition()));
                nodeBusinessPm.setParameterType(ParameterType.where);
                nodeBusinessPm.setParentId(pId);
                nodeBusinessPm.setConditionType(ConditionType.PRE);
                whereList.add((NodeBusinessPm)nodeBusinessPm);
                continue;
            }
            if (!"child".equals(field.getType()) || !HussarUtils.isNotEmpty((Object)field.getChildren())) continue;
            nodeBusinessPm = new NodeBusinessPmDto();
            nodeBusinessPm.setMatchType("and".equals(field.getPreCondition()) ? MatchTypeEnum.AND : MatchTypeEnum.OR);
            Long id = LrEngineUtil.nextId();
            nodeBusinessPm.setParameterId(id);
            nodeBusinessPm.setParameterType(ParameterType.where);
            nodeBusinessPm.setParentId(pId);
            whereList.add((NodeBusinessPm)nodeBusinessPm);
            DfEnginePushUtil.getWhere(variables, whereList, columnMap, field.getChildren(), id);
        }
    }

    public static MetadataColumn getMetadataColumn(Map<String, MetadataColumn> columnMap, String name) {
        MetadataColumn column = columnMap.get(name);
        if (column == null) {
            return null;
        }
        return column;
    }

    public static String getUrl(String getOrPost, String name, String dataSetPath) {
        return String.format("%s %s", getOrPost, FileUtil.posixPath((String[])new String[]{File.separator, AppContextUtil.getServiceID(), dataSetPath, name}));
    }

    private static SingleTableDto getSingleTableDto(PushBackCtx ctx, String businessId, String methodName, String methodDesc) {
        HussarException.throwByNull((Object)methodName, (String)"\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        MsTableDto dto = ctx.isMs ? new MsTableDto() : new SingleTableDto();
        dto.setBusinessId(businessId);
        dto.setMethodName(methodName);
        dto.setMethodDesc(methodDesc);
        return dto;
    }
}

