/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.engine.base.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.df.common.constant.app.DataSetTypeEnum;
import com.jxdinfo.hussar.df.common.factory.DataSetFactory;
import com.jxdinfo.hussar.df.common.properties.DfProperties;
import com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto;
import com.jxdinfo.hussar.df.data.set.api.customsql.vo.TestDfCustomSqlVo;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModel;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModelBase;
import com.jxdinfo.hussar.df.data.set.api.model.api.ApiModelInfo;
import com.jxdinfo.hussar.df.data.set.api.processor.DataSetProcessor;
import com.jxdinfo.hussar.df.data.set.engine.sql.util.DfEnginePushUtil;
import com.jxdinfo.hussar.df.data.set.server.dataset.service.impl.DataSetPushPushServiceImpl;
import com.jxdinfo.hussar.df.data.set.server.operation.DfDataSetOperation;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BaseDataSetProcessor
implements DataSetProcessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaseDataSetProcessor.class);
    private final EngineBussnessdataConfigService configService;

    public BaseDataSetProcessor(EngineBussnessdataConfigService configService) {
        this.configService = configService;
    }

    @PostConstruct
    public void register() {
        DataSetFactory.register((String)DataSetTypeEnum.DATA_SET.getFunctionType(), (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void sync(String id) throws IOException, LcdpException {
        DataSetPushPushServiceImpl bean = (DataSetPushPushServiceImpl)SpringUtil.getBean(DataSetPushPushServiceImpl.class);
        DataSetModel dataSetModel = (DataSetModel)DataSetUtil.getDataModel((String)id, DataSetModel.class);
        DfProperties dfProperties = (DfProperties)SpringUtil.getBean(DfProperties.class);
        if (dfProperties.isLowCode()) {
            bean.syncData(dataSetModel);
        } else {
            bean.noCodesync(dataSetModel);
        }
    }

    public void publish(String id) throws IOException, LcdpException {
        DataSetModel dataSetModel = (DataSetModel)DataSetUtil.getDataModel((String)id, DataSetModel.class);
        DataSetPushPushServiceImpl bean = (DataSetPushPushServiceImpl)SpringUtil.getBean(DataSetPushPushServiceImpl.class);
        PushBackCtx publishCtx = new PushBackCtx();
        publishCtx.setModelName(dataSetModel.getDataSetCode());
        publishCtx = DfEnginePushUtil.getPushBackCtx((DataSetModelBase)dataSetModel);
        DfDataSetOperation dfDataSetOPeration = new DfDataSetOperation();
        DfEnginePushUtil.pushTableQuery(publishCtx, (DataSetModelBase)dataSetModel, dfDataSetOPeration);
        DfEnginePushUtil.pushEchartQuery(publishCtx, dataSetModel);
        if (HussarUtils.isNotEmpty((Object)publishCtx)) {
            this.configService.pushApi(publishCtx);
        }
    }

    public void publish(ApiModelInfo apiModelInfo) {
    }

    public DataSetModel parse(JSONObject object) throws LcdpException {
        DataSetModel dataSetModel;
        try {
            dataSetModel = (DataSetModel)JSON.parseObject((String)object.toString(), DataSetModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6570\u636e\u96c6\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6570\u636e\u96c6\u5bf9\u8c61\u5f02\u5e38");
        }
        if (dataSetModel == null) {
            dataSetModel = new DataSetModel();
        }
        return dataSetModel;
    }

    public TestDfCustomSqlVo priviewDataBySql(CustomSqlDto sqlDataSetModel) {
        return null;
    }
}

