/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.engine.sql.util;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.df.common.constant.DfEngineColumnType;
import com.jxdinfo.hussar.df.common.util.DfColumnTypeUtil;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.SqlDataSetModel;
import com.jxdinfo.hussar.df.data.set.api.model.DfDataSetModelField;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.server.util.DfEngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DfCustomSqlConnector {
    public static TableInfoDto tableInfoInCreate(SysDataSource sysDataSource, SqlDataSetModel dataModel) {
        TableInfoDto tableDto = DfCustomSqlConnector.tableInfoInEdit(sysDataSource, dataModel);
        tableDto.setTableDec(dataModel.getDataSetDesc());
        return tableDto;
    }

    public static TableInfoDto tableInfoInEdit(SysDataSource sysDataSource, SqlDataSetModel dataModel) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(dataModel.getDataSetCode() + dataModel.getDataSetId());
        tableDto.setDatasourceId(sysDataSource.getId());
        tableDto.setPollName(sysDataSource.getDbName());
        tableDto.setTableAlias(dataModel.getDataSetCode());
        tableDto.setColumnList(DfCustomSqlConnector.transfer(dataModel.getProjection()));
        return tableDto;
    }

    private static List<MetadataColumn> transfer(List<ProjectionField> fields) {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        for (ProjectionField field : fields) {
            MetadataColumn metadataColumn = DfCustomSqlConnector.getMetadataColumn(field);
            columns.add(metadataColumn);
        }
        return columns;
    }

    private static MetadataColumn getMetadataColumn(ProjectionField modelField) {
        String fieldSourceDataType = modelField.getSourceDataType();
        int preIndex = fieldSourceDataType.indexOf("(");
        String dataType = preIndex > -1 ? fieldSourceDataType.substring(0, preIndex) : modelField.getSourceDataType();
        MetadataColumn metadataColumn = new MetadataColumn();
        metadataColumn.setColumnAlias(modelField.getFieldAlias());
        metadataColumn.setColumnName(modelField.getFieldAlias());
        metadataColumn.setColumnComment(modelField.getRename());
        metadataColumn.setDataType(dataType);
        Optional engineColumnType = DfEngineColumnTypeUtil.getEngineColumnType((String)modelField.getDataType());
        if (engineColumnType.isPresent()) {
            metadataColumn.setJdbcType(((DfEngineColumnType)engineColumnType.get()).getJdbcType().getName());
            metadataColumn.setJavaType(((DfEngineColumnType)engineColumnType.get()).getJavaType());
        }
        return metadataColumn;
    }

    private static void dealColumn(List<ColumnInfoDto> columnInfo, List<DfDataSetModelField> fields) {
        for (DfDataSetModelField field : fields) {
            Optional engineColumnType;
            ColumnInfoDto column = new ColumnInfoDto();
            column.setColumnName(field.getSourceFieldName());
            column.setColumnAlias(field.getName());
            column.setColumnComment(field.getComment());
            column.setDataType(field.getSourceDataType());
            column.setDataDot(Integer.valueOf(field.getDataDot()));
            column.setDataLength(Long.valueOf(field.getDataLength()));
            column.setDataIsEmpty(Integer.valueOf(field.getDataIsEmpty() ? 1 : 0));
            column.setTfModelColumnId(field.getId());
            if (ToolUtil.isNotEmpty((Object)field.getUsage())) {
                if ("primary".equals(field.getUsage())) {
                    column.setPrimarys("1");
                }
                column.setPurpose(field.getUsage());
            }
            if ((engineColumnType = DfColumnTypeUtil.getEngineColumnType((String)field.getDataType())).isPresent()) {
                column.setJdbcType(((DfEngineColumnType)engineColumnType.get()).getJdbcType().getName());
                column.setJavaType(((DfEngineColumnType)engineColumnType.get()).getJavaType());
            }
            columnInfo.add(column);
        }
    }

    public static List<ColumnInfoDto> transferColumn(List<ProjectionField> fields, String updateType) {
        ArrayList<ColumnInfoDto> columns = new ArrayList<ColumnInfoDto>();
        for (ProjectionField field : fields) {
            MetadataColumn metadataColumn = DfCustomSqlConnector.getMetadataColumn(field);
            ColumnInfoDto columnInfoDto = (ColumnInfoDto)BeanUtil.copyProperties((Object)metadataColumn, ColumnInfoDto.class);
            columnInfoDto.setPk("0");
            columnInfoDto.setIncrease("0");
            columnInfoDto.setRequired("0");
            if (ToolUtil.isNotEmpty((Object)updateType)) {
                columnInfoDto.setOperation(updateType);
            }
            columns.add(columnInfoDto);
        }
        return columns;
    }
}

