/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.engine.sql.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.df.common.constant.DfEngineColumnType;
import com.jxdinfo.hussar.df.common.constant.DfTypeConversionEnum;
import com.jxdinfo.hussar.df.common.constant.app.DataSetTypeEnum;
import com.jxdinfo.hussar.df.common.factory.DataSetFactory;
import com.jxdinfo.hussar.df.common.util.DfColumnTypeUtil;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.SqlDataSetModel;
import com.jxdinfo.hussar.df.data.set.api.customsql.vo.TestDfCustomSqlVo;
import com.jxdinfo.hussar.df.data.set.api.model.DataSetModelBase;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.api.model.api.ApiModelInfo;
import com.jxdinfo.hussar.df.data.set.api.processor.DataSetProcessor;
import com.jxdinfo.hussar.df.data.set.engine.base.processor.BaseDataSetProcessor;
import com.jxdinfo.hussar.df.data.set.engine.sql.util.DfCustomSqlConnector;
import com.jxdinfo.hussar.df.data.set.engine.sql.util.DfEnginePushUtil;
import com.jxdinfo.hussar.df.data.set.engine.sql.util.SqlOperationUtil;
import com.jxdinfo.hussar.df.data.set.server.operation.DfDataSetOperation;
import com.jxdinfo.hussar.df.data.set.server.operation.OperationBuilder;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfExternalApiUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.sf.jsqlparser.JSQLParserException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.stereotype.Component;

@Component
public class SqlDataSetProcessor
implements DataSetProcessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaseDataSetProcessor.class);
    private final EngineBussnessdataConfigService configService;

    public SqlDataSetProcessor(EngineBussnessdataConfigService configService) {
        this.configService = configService;
    }

    @PostConstruct
    public void register() {
        DataSetFactory.register((String)DataSetTypeEnum.SQL_DATA_SET.getFunctionType(), (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void sync(String id) throws IOException, LcdpException {
        SqlDataSetModel sqlDataSetModel = (SqlDataSetModel)DataSetUtil.getDataModel((String)id, SqlDataSetModel.class);
        this.metaDataSync(sqlDataSetModel);
        this.syncModel(sqlDataSetModel);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void publish(String id) throws IOException, LcdpException {
        void var4_7;
        SqlDataSetModel sqlDataSetModel = (SqlDataSetModel)DataSetUtil.getDataModel((String)id, SqlDataSetModel.class);
        PushBackCtx publishCtx = new PushBackCtx();
        publishCtx.setModelName(sqlDataSetModel.getDataSetCode());
        publishCtx = DfEnginePushUtil.getPushBackCtx((DataSetModelBase)sqlDataSetModel);
        ArrayList arrayList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)sqlDataSetModel.getDisDataSet()) && sqlDataSetModel.getDisDataSet()) {
            if (!HussarUtils.isNotEmpty((Object)sqlDataSetModel.getFunction())) throw new HussarException("Api\u63a5\u53e3\u4fe1\u606f\u4e3a\u7a7a");
            List<DfDataSetOperation> list = this.initApiOperation(sqlDataSetModel.getFunction());
        } else {
            List list = new DfDataSetOperation().init();
        }
        for (DfDataSetOperation dataSetOPeration : var4_7) {
            DfEnginePushUtil.pushTableQuery(publishCtx, (DataSetModelBase)sqlDataSetModel, dataSetOPeration);
        }
        if (!HussarUtils.isNotEmpty((Object)publishCtx)) return;
        this.configService.pushApi(publishCtx);
    }

    public void publish(ApiModelInfo apiModelInfo) {
        SqlDataSetModel sqlDataSetModel = (SqlDataSetModel)DataSetUtil.getDataModel((String)apiModelInfo.getDataSetId(), SqlDataSetModel.class);
        PushBackCtx publishCtx = new PushBackCtx();
        publishCtx.setModelName(sqlDataSetModel.getDataSetCode());
        publishCtx = DfEnginePushUtil.getPushBackCtx((DataSetModelBase)sqlDataSetModel);
        String apiUrl = apiModelInfo.getApiurl();
        Boolean page = apiModelInfo.getPage();
        if (!HussarUtils.isNotEmpty((Object)apiUrl)) {
            throw new HussarException("apiUrl\u8def\u5f84\u4e3a\u7a7a");
        }
        DfDataSetOperation dataSetOPeration = new OperationBuilder().setName(apiUrl).setType("POST").setPage(page).build();
        sqlDataSetModel.setDisDataSet(true);
        DfEnginePushUtil.pushTableQuery(publishCtx, (DataSetModelBase)sqlDataSetModel, dataSetOPeration);
        if (HussarUtils.isNotEmpty((Object)publishCtx)) {
            this.configService.pushApi(publishCtx);
        }
    }

    private List<DfDataSetOperation> initApiOperation(List<ApiModelInfo> fuction) {
        ArrayList<DfDataSetOperation> dfDataSetOPerationList = new ArrayList<DfDataSetOperation>();
        for (ApiModelInfo apiModelInfo : fuction) {
            DfDataSetOperation dfDataSetOPeration = new OperationBuilder().setName(apiModelInfo.getApiurl()).setPage(apiModelInfo.getIsPage()).setType(apiModelInfo.getRequestMethod()).build();
            dfDataSetOPerationList.add(dfDataSetOPeration);
        }
        return dfDataSetOPerationList;
    }

    public SqlDataSetModel parse(JSONObject object) throws LcdpException {
        SqlDataSetModel dataSetModel;
        try {
            dataSetModel = (SqlDataSetModel)JSON.parseObject((String)object.toString(), SqlDataSetModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6570\u636e\u96c6\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6570\u636e\u96c6\u5bf9\u8c61\u5f02\u5e38");
        }
        return dataSetModel;
    }

    public void getmetaColumn(List<ProjectionField> projectionFields, TableInfoDto tableInfo, List<MetadataColumn> metaColumnList) {
        for (ProjectionField projectionField : projectionFields) {
            for (MetadataColumn metadataColumn : tableInfo.getColumnList()) {
                if (!projectionField.getField().equals(metadataColumn.getColumnName()) || !projectionField.getTable().equals(metadataColumn.getTableName())) continue;
                metadataColumn.setColumnAlias(projectionField.getFieldAlias());
                metaColumnList.add(metadataColumn);
            }
        }
    }

    public TestDfCustomSqlVo priviewDataBySql(com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto sqlDataSetModel) {
        HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        SysDataSource sysDataSource = DfExternalApiUtil.getDataSourceId((Long)Long.valueOf(sqlDataSetModel.getDataSourceId()));
        CustomSqlDto customSqlDto = new CustomSqlDto();
        customSqlDto.setSql(sqlDataSetModel.getCustomSql());
        customSqlDto.setPollName(sysDataSource.getDbName());
        Page page = new Page();
        if (sqlDataSetModel.isPagination()) {
            page.setSize((long)sqlDataSetModel.getSize().intValue());
            page.setCurrent((long)sqlDataSetModel.getCurrent().intValue());
            page.setOptimizeJoinOfCountSql(false);
            customSqlDto.setPage(page);
        } else {
            customSqlDto.setPage(null);
        }
        customSqlDto.setParseSql(true);
        HashMap params = new HashMap();
        sqlDataSetModel.getParameterValues().forEach(dfColumnValue -> params.put(dfColumnValue.getCode(), dfColumnValue.getValue()));
        customSqlDto.setParams(params);
        Object object = null;
        try {
            object = hussarDdlService.customSql(customSqlDto);
        }
        catch (BadSqlGrammarException badE) {
            throw new HussarException("sql\u6267\u884c\u9519\u8bef\uff1a" + badE.getCause().getLocalizedMessage());
        }
        catch (MyBatisSystemException myBatisE) {
            throw new HussarException("sql\u6267\u884c\u9519\u8bef\uff1a" + myBatisE.getCause().getCause().getLocalizedMessage());
        }
        catch (HussarException e) {
            if (e.getCause() != null && e.getCause() instanceof JSQLParserException) {
                throw new HussarException("sql\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5sql");
            }
            throw new HussarException(e.getMessage());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage());
        }
        TestDfCustomSqlVo testDfCustomSqlVo = new TestDfCustomSqlVo();
        Map resultMap = (Map)object;
        JSONObject jsonObject = new JSONObject(resultMap);
        Page pageResult = new Page();
        if (sqlDataSetModel.isPagination()) {
            pageResult = (Page)jsonObject.get((Object)"data");
            testDfCustomSqlVo.setTotal(Long.valueOf(pageResult == null ? 0L : pageResult.getTotal()));
            testDfCustomSqlVo.setQueryResult(pageResult == null ? new ArrayList() : pageResult.getRecords());
        } else {
            List mapList = (List)jsonObject.get((Object)"data");
            testDfCustomSqlVo.setTotal(Long.valueOf(mapList.size()));
            testDfCustomSqlVo.setQueryResult(mapList);
        }
        List metadataColumns = (List)jsonObject.get((Object)"columnList");
        testDfCustomSqlVo.setProjectionFields(this.getProjectionFields(metadataColumns));
        return testDfCustomSqlVo;
    }

    public void syncModel(SqlDataSetModel sqlDataSetModel) {
        ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        ModelPublishDTO mpdto = SqlOperationUtil.modelToEngine(sqlDataSetModel);
        mpdto.setType(DfTypeConversionEnum.getValueByKey((String)"SQL_DATASET").getValue());
        resultList.add(mpdto);
        modelRelateService.save(resultList);
    }

    public void metaDataSync(SqlDataSetModel sqlDataSetModel) {
        SysDataSource datasource = DfExternalApiUtil.getDataSourceId((Long)sqlDataSetModel.getDataSourceId());
        TableInfoDto tableInfoDto = DfCustomSqlConnector.tableInfoInCreate(datasource, sqlDataSetModel);
        MetadataParam metadataParam = new MetadataParam();
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(DfCustomSqlConnector.transferColumn(sqlDataSetModel.getProjection(), ""));
        HussarMetadataService metaService = (HussarMetadataService)SpringUtil.getBean(HussarMetadataService.class);
        TableInfoDto tableInfoByTableName = metaService.getTableInfoByName(tableInfoDto.getTableName());
        if (tableInfoByTableName == null) {
            metaService.insertTableInfo(metadataParam);
        } else {
            Long tableId = tableInfoByTableName.getTableId();
            tableInfoDto.setTableId(tableId);
            metaService.updateTableInfo(metadataParam);
        }
    }

    private List<ProjectionField> getProjectionFields(List<MetadataColumn> metadataColumns) {
        ArrayList<ProjectionField> projectionFields = new ArrayList<ProjectionField>();
        for (MetadataColumn metadataColumn : metadataColumns) {
            ProjectionField projectionField = new ProjectionField();
            projectionField.setField(metadataColumn.getColumnName());
            projectionField.setFieldAlias(metadataColumn.getColumnAlias());
            projectionField.setTable(metadataColumn.getTableName());
            projectionField.setDataDot(metadataColumn.getDataDot());
            DfEngineColumnType dfEngineColumnType = DfColumnTypeUtil.getEngineColumnTypeByJavaType((String)metadataColumn.getJavaType()).orElse(null);
            projectionField.setDataType(dfEngineColumnType == null ? null : dfEngineColumnType.getDataType());
            projectionFields.add(projectionField);
        }
        return projectionFields;
    }
}

