/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.document.word.dao.WordPdfRelationshipMapper;
import com.jxdinfo.document.word.enums.OwnErrorEnum;
import com.jxdinfo.document.word.model.WordAndPdfRelationship;
import com.jxdinfo.document.word.service.WordPdfRelationshipService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.word.service.impl.wordPdfRelationshipServiceImpl")
public class WordPdfRelationshipServiceImpl
extends HussarServiceImpl<WordPdfRelationshipMapper, WordAndPdfRelationship>
implements WordPdfRelationshipService {
    @Resource
    private WordPdfRelationshipMapper mapper;

    public ApiResponse<Integer> add(WordAndPdfRelationship wordAndPdfRelationship) {
        if (HussarUtils.isEmpty((Object)wordAndPdfRelationship.getDocId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        int row = this.mapper.insert(wordAndPdfRelationship);
        return ApiResponse.success((Object)row);
    }

    public Long getFileIdByDocId(Long docId) {
        if (HussarUtils.isEmpty((Object)docId)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordAndPdfRelationship::getDocId, (Object)docId);
        WordAndPdfRelationship wordAndPdfRelationship = (WordAndPdfRelationship)this.mapper.selectOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)wordAndPdfRelationship)) {
            return null;
        }
        Long fileId = wordAndPdfRelationship.getPdfId();
        return fileId;
    }
}

