/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.jxdinfo.document.editor.core.word.constant.WordConstant;
import com.jxdinfo.document.editor.core.word.factory.WordExporterFactory;
import com.jxdinfo.document.editor.core.word.factory.WordJsonParseFactory;
import com.jxdinfo.document.word.model.WordEditorDetails;
import com.jxdinfo.document.word.service.WordEditorDetailsService;
import com.jxdinfo.document.word.service.WordParticularService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.document.word.service.impl.WordParticularServiceImpl")
public class WordParticularServiceImpl
implements WordParticularService {
    @Resource
    private WordEditorDetailsService wordEditorDetailsService;

    public Map<String, String> wordParticularImport(MultipartFile file) {
        return WordJsonParseFactory.get((String)WordConstant.DOCX_TYPE).parse(file);
    }

    public Map<String, String> getWordParticularById(Long identification, String identificationType) {
        ApiResponse wordEditorDetailsByDocId;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if ("business".equals(identificationType)) {
            ApiResponse wordEditorDetailsById = this.wordEditorDetailsService.getWordEditorDetailsById(identification);
            if (wordEditorDetailsById.isSuccess()) {
                WordEditorDetails data = (WordEditorDetails)wordEditorDetailsById.getData();
                resultMap.put("detailContent", data.getDetailContent());
                resultMap.put("detailOptions", data.getDetailOptions());
            }
        } else if ("relevance".equals(identificationType) && (wordEditorDetailsByDocId = this.wordEditorDetailsService.getWordEditorDetailsByDocId(identification)).isSuccess()) {
            WordEditorDetails data = (WordEditorDetails)wordEditorDetailsByDocId.getData();
            resultMap.put("detailContent", data.getDetailContent());
            resultMap.put("detailOptions", data.getDetailOptions());
        }
        return resultMap;
    }

    public void exportFile(Map<String, String> configDetails, OutputStream outputStream) {
        if (HussarUtils.isNotEmpty(configDetails)) {
            String jsonConfig = configDetails.get("detailContent");
            String detailOptions = configDetails.get("detailOptions");
            WordExporterFactory.get((String)WordConstant.DOCX_TYPE).output(jsonConfig, detailOptions, outputStream);
        }
    }

    public void saveWordParticular(String detailContent, String detailOptions) {
    }
}

