/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.util;

import com.jxdinfo.document.word.cnst.SystemErrorEnum;
import com.jxdinfo.document.word.util.SFunction;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    private static Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    private static Map<Class, SerializedLambda> classSerializedLambdaMap = new ConcurrentHashMap<Class, SerializedLambda>();

    public static <T> String convertToFieldName(SFunction<T> fn) {
        SerializedLambda lambda = BeanUtils.getSerializedLambda(fn);
        String methodName = lambda.getImplMethodName();
        String prefix = null;
        if (methodName.startsWith("get")) {
            prefix = "get";
        } else if (methodName.startsWith("is")) {
            prefix = "is";
        }
        if (prefix == null) {
            logger.info("\u65e0\u6548\u7684getter\u65b9\u6cd5: " + methodName);
        }
        return BeanUtils.toLowerCaseFirstOne(methodName.replaceFirst(prefix, ""));
    }

    static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    static SerializedLambda getSerializedLambda(Serializable fn) {
        SerializedLambda lambda = classSerializedLambdaMap.get(fn.getClass());
        if (lambda == null) {
            try {
                Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(Boolean.TRUE);
                lambda = (SerializedLambda)method.invoke((Object)fn, new Object[0]);
                classSerializedLambdaMap.put(fn.getClass(), lambda);
            }
            catch (Exception e) {
                logger.error(SystemErrorEnum.UNKNOWN_ERROR.getMsg(), (Throwable)e);
            }
        }
        return lambda;
    }
}

