/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.excel.tools.core.common.utils.CheckUtil;
import com.jxdinfo.document.excel.tools.word.service.IExcelWordCommonService;
import com.jxdinfo.hussar.application.report.dao.SysReportMapper;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.impl.SysReportServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="com.jxdinfo.document.excel.tools.report.impl.ReportExcelTemplateServiceImpl")
public class ExcelTemplateReportServiceImpl
extends SysReportServiceImpl {
    @Resource
    private IExcelWordCommonService excelWordCommonService;
    @Resource
    private SysReportMapper sysReportMapper;
    private static final Logger logger = LoggerFactory.getLogger(ExcelTemplateReportServiceImpl.class);

    @HussarTransactional(rollbackFor={Exception.class})
    public Long addReport(SysReport sysReport) {
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 addReport \u5f00\u59cb");
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u5f00\u59cb ");
        if (sysReport.getReportGroupId() == null) {
            sysReport.setReportGroupId(CheckUtil.checkGroupIdGetLong((String)"1"));
        }
        Long reportId = super.addReport(sysReport);
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u7ed3\u675f \u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e reportId  {}", (Object)reportId);
        if (reportId != null) {
            logger.info("\u6839\u636e\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5\u7684\u62a5\u8868\u4e3b\u952e\u67e5\u8be2\u57fa\u7840\u8be6\u60c5\u4fe1\u606f\u5f00\u59cb");
            SysReport sysReportById = this.getSysReportById(reportId);
            logger.info("\u6839\u636e\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5\u7684\u62a5\u8868\u4e3b\u952e\u67e5\u8be2\u57fa\u7840\u8be6\u60c5\u4fe1\u606f\u7ed3\u675f SysReport{}", (Object)sysReportById);
            String reportIdString = reportId.toString();
            String groupIdString = sysReportById.getReportGroupId().toString();
            logger.info("\u8c03\u7528 \u516c\u5171\u65b9\u6cd5 updateDocumentByTemplate \u5f00\u59cb");
            this.excelWordCommonService.updateDocumentByTemplate(reportIdString, sysReportById.getReportName(), groupIdString);
            logger.info("\u8c03\u7528 \u516c\u5171\u65b9\u6cd5 updateDocumentByTemplate \u7ed3\u675f");
        }
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 addReport \u7ed3\u675f");
        return reportId;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editReport(SysReport sysReport) {
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 editReport \u5f00\u59cb");
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u7f16\u8f91\u65b9\u6cd5 editReport \u5f00\u59cb ");
        Long reportId = sysReport.getReportId();
        boolean flag = super.editReport(sysReport);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u7f16\u8f91\u65b9\u6cd5editReport\u7ed3\u675f \u7f16\u8f91\u65b9\u6cd5\u7684\u8fd4\u56de\u7ed3\u679c flag {}", (Object)flag);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u7f16\u8f91\u65b9\u6cd5editReport\u7ed3\u675f \u62a5\u8868\u4e3b\u952e reportId  {}", (Object)reportId);
        if (flag) {
            logger.info("\u6839\u636e\u62a5\u8868\u7684\u7f16\u8f91\u65b9\u6cd5\u7684\u62a5\u8868\u4e3b\u952e\u67e5\u8be2\u57fa\u7840\u8be6\u60c5\u4fe1\u606f\u5f00\u59cb");
            SysReport sysReportById = this.getSysReportById(reportId);
            logger.info("\u6839\u636e\u62a5\u8868\u7684\u7f16\u8f91\u65b9\u6cd5\u7684\u62a5\u8868\u4e3b\u952e\u67e5\u8be2\u57fa\u7840\u8be6\u60c5\u4fe1\u606f\u7ed3\u675f SysReport{}", (Object)sysReportById);
            String reportIdString = reportId.toString();
            String groupIdString = sysReportById.getReportGroupId().toString();
            logger.info("editReport \u8c03\u7528\u516c\u5171\u65b9\u6cd5 updateDocumentByTemplate \u5f00\u59cb");
            this.excelWordCommonService.updateDocumentByTemplate(reportIdString, sysReportById.getReportName(), groupIdString);
            logger.info("editReport \u8c03\u7528\u516c\u5171\u65b9\u6cd5 updateDocumentByTemplate \u7ed3\u675f");
        }
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 editReport \u7ed3\u675f");
        return flag;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean delReport(List<Long> reportIds) {
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 delReport \u5f00\u59cb");
        boolean flag = !CollectionUtils.isEmpty(reportIds) && this.sysReportMapper.deleteBatchIds(reportIds) >= 1;
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 delReport \u7ed3\u675f flag {}", (Object)flag);
        return flag;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Long addReport(SysReport sysReport, String groupId) {
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5addReport\u5f00\u59cb");
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5addReport\u5f00\u59cb ");
        sysReport.setReportGroupId(CheckUtil.checkGroupIdGetLong((String)groupId));
        Long reportId = super.addReport(sysReport);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u7ed3\u675f \u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e reportId  {}", (Object)reportId);
        if (reportId != null) {
            String reportIdString = reportId.toString();
            logger.info("\u8c03\u7528\u516c\u5171\u65b9\u6cd5 updateDocumentByTemplate \u5f00\u59cb");
            this.excelWordCommonService.updateDocumentByTemplate(reportIdString, sysReport.getReportName(), groupId);
            logger.info("\u8c03\u7528\u516c\u5171\u65b9\u6cd5 updateDocumentByTemplate \u7ed3\u675f");
        }
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 addReport \u7ed3\u675f");
        return reportId;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Long copyReport(SysReport sysReport) {
        logger.info("copyReport\u8c03\u7528\u62a5\u8868\u7684\u65b9\u6cd5 copyReport \u5f00\u59cb");
        logger.info("copyReport\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u5f00\u59cb ");
        Long id = IdWorker.getId((Object)new Date());
        sysReport.setReportId(id);
        Long reportId = super.addReport(sysReport);
        logger.info("copyReport\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u7ed3\u675f \u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e reportId  {}", (Object)reportId);
        logger.info("copyReport\u8c03\u7528\u62a5\u8868\u7684\u65b9\u6cd5 copyReport \u7ed3\u675f");
        return reportId;
    }
}

