/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.word.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.CommonDocumentInterface;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.dto.DocumentSaveDetailsDto;
import com.jxdinfo.document.common.factory.DocumentFactory;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.model.DocImportCtx;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSaveDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.excel.tools.core.common.constants.CommonConstants;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.FrontendEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.CheckUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.InitDataUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.JsonUtil;
import com.jxdinfo.document.excel.tools.file.service.IOssFileService;
import com.jxdinfo.document.excel.tools.report.impl.ExcelTemplateReportServiceImpl;
import com.jxdinfo.document.excel.tools.statement.service.IExcelCoreService;
import com.jxdinfo.document.excel.tools.word.service.IExcelWordCommonService;
import com.jxdinfo.hussar.application.excel.Dto.ExcelExporterDto;
import com.jxdinfo.hussar.application.excel.Vo.IWorkbookData;
import com.jxdinfo.hussar.application.excel.service.IExcelExporterService;
import com.jxdinfo.hussar.application.excel.service.IExcelImportService;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.document.excel.tools.word.service.impl.ExcelTemplateWordServiceImpl")
public class ExcelTemplateWordServiceImpl
implements CommonDocumentInterface,
InitializingBean {
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Resource
    private IExcelWordCommonService excelWordCommonService;
    @Resource
    private ExcelTemplateReportServiceImpl excelTemplateService;
    @Resource
    private IExcelImportService excelImportService;
    @Resource
    private IExcelExporterService excelExporterService;
    @Resource
    private IOssFileService ossFileService;
    @Resource
    private IExcelCoreService excelCoreService;
    private static final Logger logger = LoggerFactory.getLogger(ExcelTemplateWordServiceImpl.class);

    public void checkDocId(Long docId) {
        if (docId == null) {
            throw new IllegalArgumentException(FrontendEnum.RETURN_ID_NULL.getDescription());
        }
    }

    public DocumentDetailsVo queryDocumentDetail(Long templateId) {
        return this.queryOffice(templateId);
    }

    public DocumentDetailsVo queryOffice(Long templateId) {
        logger.info("queryOffice \u542f\u52a8");
        this.checkDocId(templateId);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u67e5\u8be2\u65b9\u6cd5\uff0c\u8fd4\u56de\u57fa\u7840\u6570\u636e\u4fe1\u606f");
        SysReport template = this.excelTemplateService.getSysReportById(templateId);
        DocumentDetailsVo detailsVo = new DocumentDetailsVo();
        detailsVo.setId(templateId);
        detailsVo.setType(DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeCode());
        if (template == null) {
            detailsVo.setContent("\u62a5\u8868\u672a\u4ece\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u6570\u636e\uff0c\u8bf7\u6392\u67e5\u4e3b\u952e\u662f\u5426\u5728\u62a5\u8868\u8868\u5b58\u5728");
        } else {
            detailsVo.setContent(template.getDesignInformation());
            detailsVo.setDocumentName(template.getReportName());
        }
        HashMap<String, Object> extendResult = new HashMap<String, Object>(16);
        extendResult.put("docId", templateId);
        if (template != null) {
            extendResult.put("modelName", template.getReportName());
            extendResult.put("groupId", template.getReportGroupId());
        }
        detailsVo.setExtendResult(extendResult);
        return detailsVo;
    }

    public Long addBlankDocument(String documentName, String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        logger.info("\u6dfb\u52a0\u7a7a\u767d\u6587\u6863,\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u5f00\u59cb");
        SysReport sysReport = new SysReport();
        sysReport.setReportName(reportName);
        sysReport.setReportGroupId(CommonConstants.L_1);
        sysReport.setDesignInformation(InitDataUtil.initJsonData());
        Long reportId = this.excelTemplateService.addReport(sysReport);
        logger.info("\u6dfb\u52a0\u7a7a\u767d\u6587\u6863,\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u7ed3\u675f\uff0c\u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e:{}", (Object)reportId);
        return reportId;
    }

    public Long copyDocument(Long templateId) {
        this.checkDocId(templateId);
        SysReport sysReportById = this.excelTemplateService.getSysReportById(templateId);
        if (sysReportById == null) {
            logger.error("\u6839\u636e\u6587\u6863id\u67e5\u8be2\u6587\u6863\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6392\u67e5\u6587\u6863id\u662f\u5426\u6b63\u786e");
            return 1L;
        }
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u590d\u5236\u65b9\u6cd5\uff0c\u8fd4\u56de\u65b0\u62a5\u544a\u6a21\u677f\u4e3b\u952e");
        Long reportId = this.excelTemplateService.copyReport(sysReportById);
        if (reportId != null) {
            logger.info("\u8c03\u7528\u62a5\u8868\u7684\u590d\u5236\u65b9\u6cd5\uff0c\u8fd4\u56de\u65b0\u62a5\u544a\u6a21\u677f\u4e3b\u952e:{}", (Object)reportId);
            this.excelWordCommonService.copyDocumentByTemplate(reportId.toString(), sysReportById.getReportName(), templateId.toString());
            return reportId;
        }
        return null;
    }

    public void downloadDocument(HttpServletResponse httpServletResponse, Long templateId) {
        logger.info("downloadDocument \u62a5\u544a\u6a21\u677f\u4e0d\u5b58\u5728\u6587\u4ef6\u4e0b\u8f7d");
    }

    public void previewPDF(HttpServletResponse httpServletResponse, Long aLong) {
        logger.info("previewPDF \u62a5\u544a\u6a21\u677f\u4e0d\u5b58\u5728\u6587\u4ef6\u9884\u89c8");
    }

    public ApiResponse<Long> importDocument(MultipartFile file, Long groupId, String docName) {
        logger.info("importDocument \u5bfc\u5165excel \u542f\u52a8");
        try {
            logger.info("\u8c03\u7528\u62a5\u8868\u7684\u5bfc\u5165\u65b9\u6cd5\u5f00\u59cb");
            String groupIdString = CheckUtil.checkGroupIdString((Long)groupId);
            IWorkbookData workbookData = this.excelImportService.handleExcelImport(file);
            logger.info("\u8c03\u7528\u62a5\u8868\u7684\u5bfc\u5165\u65b9\u6cd5\u7ed3\u675f\u8fd4\u56de\u7684\u62a5\u8868\u7684\u6570\u636e\u7ed3\u6784:{}", (Object)workbookData);
            HashMap<String, IWorkbookData> reportStructure = new HashMap<String, IWorkbookData>(16);
            reportStructure.put("workBook", workbookData);
            SysReport sysReport = new SysReport();
            sysReport.setReportName(docName);
            sysReport.setReportGroupId(CheckUtil.checkGroupIdGetLong((String)groupIdString));
            sysReport.setDesignInformation(JsonUtil.asJSONString(reportStructure));
            Long reportId = this.excelTemplateService.addReport(sysReport);
            return ApiResponse.success((Object)reportId);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25");
        }
    }

    public void exportDocument(HttpServletResponse httpServletResponse, Long templateId) {
        this.checkDocId(templateId);
        logger.info("exportDocument \u4e0b\u8f7d\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u5f00\u59cb");
        ExcelExporterDto excelExporterDto = new ExcelExporterDto();
        excelExporterDto.setReportId(templateId);
        Long fileId = this.excelExporterService.reportExportByConfig(excelExporterDto, Boolean.valueOf(false));
        logger.info("exportDocument \u83b7\u53d6\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u7ed3\u675f\uff0c\u8fd4\u56de\u6587\u4ef6id{}", (Object)fileId);
        this.ossFileService.fileDownload(httpServletResponse, fileId);
    }

    public DocDataBindInfo getBindConfig(GenerateReportParam generateReportParam) {
        return null;
    }

    public Long generateReport(Long aLong, JSONObject jsonObject) {
        return 0L;
    }

    public JSONObject executeJsGenerateReportJson(Long id, String data, boolean fullReplace) {
        return null;
    }

    public DocumentSplitVo getDocumentById(Long aLong) {
        return null;
    }

    public Long addBlankDocument(String documentName, String type, String groupId) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        logger.info("\u6dfb\u52a0\u7a7a\u767d\u6587\u6863addBlankDocument,\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u5f00\u59cb");
        SysReport sysReport = new SysReport();
        sysReport.setReportName(reportName);
        sysReport.setReportGroupId(CheckUtil.checkGroupIdGetLong((String)groupId));
        sysReport.setDesignInformation(InitDataUtil.initJsonData());
        Long reportId = this.excelTemplateService.addReport(sysReport, groupId);
        logger.info("\u6dfb\u52a0\u7a7a\u767d\u6587\u6863addBlankDocument,\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addReport \u7ed3\u675f\uff0c\u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e:{}", (Object)reportId);
        return reportId;
    }

    public boolean deleteDocument(Long templateId) {
        this.checkDocId(templateId);
        logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u516c\u5171\u8868 \u5f00\u59cb");
        this.wordTypeInfoService.deleteByReportId(templateId);
        logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u516c\u5171\u8868 \u7ed3\u675f");
        try {
            logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u62a5\u8868\u8868 \u5f00\u59cb");
            boolean flag = this.excelTemplateService.delReport(Collections.singletonList(templateId));
            logger.info("deleteDocument \u5220\u9664\u6587\u6863 \u62a5\u8868\u8868 \u7ed3\u675f");
            return flag;
        }
        catch (Exception e) {
            logger.error("deleteDocument \u5220\u9664\u6587\u6863 \u62a5\u8868\u8868 \u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public void downDocument(HttpServletResponse httpServletResponse, Long templateId) {
        this.checkDocId(templateId);
        logger.info("downDocument \u4e0b\u8f7d\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u5f00\u59cb");
        ExcelExporterDto excelExporterDto = new ExcelExporterDto();
        excelExporterDto.setReportId(templateId);
        Long fileId = this.excelExporterService.reportExportByConfig(excelExporterDto, Boolean.valueOf(false));
        logger.info("downDocument \u83b7\u53d6\u62a5\u8868excel\u6587\u6863\u65b9\u6cd5\u7ed3\u675f\uff0c\u8fd4\u56de\u6587\u4ef6id{}", (Object)fileId);
        this.ossFileService.fileDownload(httpServletResponse, fileId);
    }

    public void insertOrUpdateDocument(Map<String, JSONObject> sysDocumentMap, String docId) {
        this.checkDocId(Long.valueOf(docId));
        SysReport sysReportById = this.excelTemplateService.getSysReportById(Long.parseLong(docId));
        JSONObject baseInfo = sysDocumentMap.get("baseInfo");
        SysReport sysReport = (SysReport)JSON.parseObject((String)JSON.toJSONString((Object)baseInfo), SysReport.class);
        if (sysReportById == null) {
            this.excelTemplateService.addReport(sysReport);
        } else {
            this.excelTemplateService.editReport(sysReport);
        }
    }

    public void createDocumentRelationFile(String documentPath, Long docId) {
        logger.info("createDocumentRelationFile \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
    }

    public Long importDocumentData(String unZipPath, String cacheKey, DocImportCtx docImportCtx) {
        logger.info("importDocumentData \u8bf7\u671f\u5f85\u4e0b\u4e2a\u7248\u672c");
        return null;
    }

    public Long dealImageSize(Long docId) {
        logger.info("dealImageSize \u6682\u4e0d\u5904\u7406");
        return 0L;
    }

    public ApiResponse<Object> generateReport(GenerateReportParam generateReportParam) {
        logger.info("generateReport \u8fdb\u5165excel\u6a21\u677f\u7684\u751f\u6210\u62a5\u544a");
        return this.excelCoreService.generateExcelReport(generateReportParam);
    }

    public ApiResponse<DocumentSaveDetailsVo> saveWordEditorDetail(DocumentSaveDetailsDto documentSaveDetailsDto) {
        DocumentSaveDetailsVo result = new DocumentSaveDetailsVo();
        logger.info("saveWordEditorDetail \u8fdb\u5165excel\u6a21\u677f\u7684\u4fdd\u5b58\u6587\u6863");
        String docId = documentSaveDetailsDto.getDocId();
        String groupId = CheckUtil.checkGroupIdGetString((String)documentSaveDetailsDto.getGroupId());
        String docName = documentSaveDetailsDto.getDocName();
        int type = documentSaveDetailsDto.getDocType();
        Map excelParam = documentSaveDetailsDto.getParam();
        if (StringUtils.isBlank((CharSequence)docId)) {
            logger.error("docId \u53c2\u6570\u7a7a,\u8fdb\u5165\u65b0\u589e\u903b\u8f91");
            SysReport addReport = new SysReport();
            if (ObjectUtils.isNotEmpty((Object)excelParam) && excelParam.containsKey("content")) {
                String content = (String)excelParam.get("content");
                addReport.setDesignInformation(content);
            }
            addReport.setReportName(docName);
            addReport.setReportGroupId(CheckUtil.checkGroupIdGetLong((String)groupId));
            Long addId = this.excelTemplateService.addReport(addReport, groupId);
            result.setDocId(addId.toString());
        } else {
            logger.error("docId \u53c2\u6570\u4e0d\u4e3a\u7a7a,\u8fdb\u5165\u4fee\u6539\u903b\u8f91");
            SysReport byId = this.excelTemplateService.getSysReportById(Long.parseLong(docId));
            if (byId == null) {
                logger.error("\u6839\u636e\u6587\u6863id\u67e5\u8be2\u4e0d\u5230\u6587\u6863\uff0c\u8fdb\u884c\u65b0\u589e\u903b\u8f91");
                SysReport updateaddReport = new SysReport();
                if (ObjectUtils.isNotEmpty((Object)excelParam) && excelParam.containsKey("content")) {
                    String content = (String)excelParam.get("content");
                    updateaddReport.setDesignInformation(content);
                }
                updateaddReport.setReportName(docName);
                updateaddReport.setReportGroupId(CheckUtil.checkGroupIdGetLong((String)groupId));
                this.excelTemplateService.addReport(updateaddReport, groupId);
            } else {
                logger.error("\u6839\u636e\u6587\u6863id\u67e5\u8be2\u5230\u6587\u6863\uff0c\u8fdb\u884c\u4fee\u6539\u903b\u8f91");
                if (ObjectUtils.isNotEmpty((Object)excelParam) && excelParam.containsKey("content")) {
                    String content = (String)excelParam.get("content");
                    byId.setDesignInformation(content);
                }
                byId.setReportName(docName);
                byId.setReportGroupId(CheckUtil.checkGroupIdGetLong((String)groupId));
                this.excelTemplateService.editReport(byId);
                result.setDocId(docId);
            }
        }
        result.setDocName(docName);
        result.setDocType(type);
        result.setGroupId(groupId);
        return ApiResponse.success((Object)result);
    }

    public void afterPropertiesSet() {
        DocumentFactory.add((String)DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeName(), (CommonDocumentInterface)this);
    }
}

