/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.statement.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.FrontendEnum;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ResultEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.CheckUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.JsonUtil;
import com.jxdinfo.document.excel.tools.core.common.vo.IWorkbookDataVo;
import com.jxdinfo.document.excel.tools.core.common.vo.IWorksheetDataVo;
import com.jxdinfo.document.excel.tools.dataset.vo.ExcelDataSetVo;
import com.jxdinfo.document.excel.tools.dataset.vo.ExcelSuperQueryConditionVo;
import com.jxdinfo.document.excel.tools.report.impl.ExcelInstanceReportServiceImpl;
import com.jxdinfo.document.excel.tools.statement.service.IExcelGenerateService;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.application.reportsnapshot.Vo.SnapShotVo;
import com.jxdinfo.hussar.application.reportsnapshot.model.SysReportSnapshot;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetCondition;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.excel.tools.statement.service.impl.ExcelGenerateServiceImpl")
public class ExcelGenerateServiceImpl
implements IExcelGenerateService {
    @Autowired
    private ISysReportService sysReportService;
    @Autowired
    private ExcelInstanceReportServiceImpl instanceReportService;
    private static final Logger logger = LoggerFactory.getLogger(ExcelGenerateServiceImpl.class);

    public ApiResponse<Object> generateExcelReport(GenerateReportParam generateReportParam) {
        Long reportId = generateReportParam.getBusinessId();
        if (reportId == null) {
            return ApiResponse.fail((String)FrontendEnum.RETURN_NULL_TEMPLATE_ID.getDescription());
        }
        HashMap<String, String> exParam = new HashMap<String, String>();
        exParam.put("type", "analyzeEln");
        exParam.put("preHookName", "Excel");
        exParam.put("generateReportParam", JsonUtil.asJSONString((Object)generateReportParam));
        SysReport sysReport = this.sysReportService.getSysReportById(reportId, JsonUtil.asJSONString(exParam));
        if (sysReport == null) {
            return ApiResponse.fail((String)ResultEnum.RETURN_DB_DATA_NULL_TEMPLATE_ERROR.getDescription());
        }
        Map oldDesignMap = (Map)JsonUtil.convertValue((Object)sysReport.getDesignInformation(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        IWorkbookDataVo oldWorkbookData = (IWorkbookDataVo)JsonUtil.convertValue(oldDesignMap.get("workBook"), (TypeReference)new TypeReference<IWorkbookDataVo>(){});
        List loopArea = (List)JsonUtil.convertValue(oldDesignMap.get("loopArea"), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
        SnapShotVo sysReportSnapshot = new SnapShotVo();
        sysReportSnapshot.setReportId(String.valueOf(reportId));
        sysReportSnapshot.setSnapshotName(sysReport.getReportName());
        sysReportSnapshot.setDesignInformation(JsonUtil.asJSONString((Object)oldWorkbookData));
        sysReportSnapshot.setSeq(sysReport.getSeq());
        sysReportSnapshot.setDataSetCommonParamConfig(this.getDataSetCommonParam(generateReportParam, sysReport));
        sysReportSnapshot.setLoopArea(loopArea);
        Long snapshotId = this.instanceReportService.addSnapshot(sysReportSnapshot, CheckUtil.checkGroupIdString((Long)sysReport.getReportGroupId()));
        SysReportSnapshot sysReportSnapshotById = this.instanceReportService.getSysReportSnapshotById(snapshotId);
        logger.info("\u62a5\u544a\u751f\u6210\u7684\u4e3b\u952e {} ", (Object)sysReportSnapshotById.getSnapshotId());
        if (sysReportSnapshotById.getDesignInformation() != null) {
            IWorkbookDataVo workbookData = (IWorkbookDataVo)JsonUtil.convertValue((Object)sysReportSnapshotById.getDesignInformation(), (TypeReference)new TypeReference<IWorkbookDataVo>(){});
            Map sheets = workbookData.getSheets();
            for (String sheetId : oldWorkbookData.getSheetOrder()) {
                if (sheets == null) continue;
                IWorksheetDataVo oldSheet = (IWorksheetDataVo)oldWorkbookData.getSheets().get(sheetId);
                ((IWorksheetDataVo)sheets.get(sheetId)).setRowHeader(oldSheet.getRowHeader());
                ((IWorksheetDataVo)sheets.get(sheetId)).setColumnHeader(oldSheet.getColumnHeader());
                workbookData.setSheets(sheets);
            }
            sysReportSnapshotById.setDesignInformation(JsonUtil.asJSONString((Object)workbookData));
            this.instanceReportService.saveOrUpdate((BaseEntity)sysReportSnapshotById);
        }
        return ApiResponse.success((Object)snapshotId, (String)"\u751f\u6210\u6210\u529f");
    }

    public List<DataSetCommonParam> getDataSetCommonParam(GenerateReportParam generateReportParam, SysReport sysReport) {
        ArrayList<DataSetCommonParam> dataSetCommonParams = new ArrayList<DataSetCommonParam>();
        List excelDataSetVos = (List)JsonUtil.convertValue((Object)sysReport.getDataset(), (TypeReference)new TypeReference<List<ExcelDataSetVo>>(){});
        Map customParams = generateReportParam.getCustomParams();
        if (!customParams.containsKey("dataSetParam") || CollectionUtils.isEmpty((Collection)excelDataSetVos) || MapUtils.isEmpty((Map)customParams)) {
            return dataSetCommonParams;
        }
        List dataSetParamList = (List)JsonUtil.convertValue(customParams.get("dataSetParam"), (TypeReference)new TypeReference<List<ExcelSuperQueryConditionVo>>(){});
        if (CollectionUtils.isEmpty((Collection)dataSetParamList)) {
            return dataSetCommonParams;
        }
        Map<String, List<ExcelSuperQueryConditionVo>> dataSetParamMap = dataSetParamList.stream().collect(Collectors.groupingBy(ExcelSuperQueryConditionVo::getDataSetId));
        for (ExcelDataSetVo excelDataSetVo : excelDataSetVos) {
            List<ExcelSuperQueryConditionVo> excelSuperQueryConditionVos = dataSetParamMap.get(excelDataSetVo.getId());
            if (CollectionUtils.isEmpty(excelSuperQueryConditionVos)) continue;
            DataSetCommonParam dataSetCommonParam = ExcelGenerateServiceImpl.getDataSetCommonParam(excelDataSetVo, excelSuperQueryConditionVos);
            dataSetCommonParams.add(dataSetCommonParam);
        }
        return dataSetCommonParams;
    }

    public static DataSetCommonParam getDataSetCommonParam(ExcelDataSetVo excelDataSetVo, List<ExcelSuperQueryConditionVo> excelSuperQueryConditionVos) {
        DataSetCommonParam dataSetCommonParam = new DataSetCommonParam();
        DataSetCondition dataSetCondition = new DataSetCondition();
        dataSetCondition.setDataSetId(excelDataSetVo.getId());
        dataSetCondition.setDataSetFunctionType("CUSTOM_SQL");
        dataSetCondition.setPagination(false);
        List superQueryConditions = (List)JsonUtil.convertValue(excelSuperQueryConditionVos, (TypeReference)new TypeReference<List<SuperQueryConditionDto>>(){});
        dataSetCondition.setSuperQueryConditionDto(superQueryConditions);
        dataSetCommonParam.setDataSetCondition(dataSetCondition);
        return dataSetCommonParam;
    }
}

