/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.word.service.impl;

import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.model.WordDocTypeInfo;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.excel.tools.core.common.constants.CommonConstants;
import com.jxdinfo.document.excel.tools.core.common.utils.CheckUtil;
import com.jxdinfo.document.excel.tools.word.service.IExcelWordCommonService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.excel.tools.word.service.impl.ExcelWordCommonServiceImpl")
public class ExcelWordCommonServiceImpl
implements IExcelWordCommonService {
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    private static final Logger logger = LoggerFactory.getLogger(ExcelWordCommonServiceImpl.class);

    public boolean updateDocumentByTemplate(String templateId, String documentName, String groupId) {
        try {
            Long templateIdLong = Long.parseLong(templateId);
            Long groupIdLong = CheckUtil.checkGroupIdGetLong((String)groupId);
            Long id = (Long)this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(templateIdLong, documentName, DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeCode(), groupIdLong).getData();
            logger.info("updateDocumentByTemplate report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u7ed3\u675f:\u516c\u5171\u8868\u4e3b\u952e{}", (Object)id);
            return true;
        }
        catch (Exception e) {
            logger.error("updateDocumentByTemplate report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean copyDocumentByTemplate(String templateId, String documentName, String oldTemplateId) {
        try {
            Long groupIdLong = CommonConstants.L_1;
            Long oldTemplateIdLong = Long.parseLong(oldTemplateId);
            WordDocTypeInfo wordDocTypeInfo = this.wordTypeInfoService.getInfoByReportId(oldTemplateIdLong);
            if (HussarUtils.isNotEmpty((Object)wordDocTypeInfo)) {
                groupIdLong = wordDocTypeInfo.getGroupId();
            }
            Long templateIdLong = Long.parseLong(templateId);
            Long id = (Long)this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(templateIdLong, documentName, DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeCode(), groupIdLong).getData();
            logger.info("copyDocumentByTemplate report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u7ed3\u675f:\u516c\u5171\u8868\u4e3b\u952e{}", (Object)id);
            return true;
        }
        catch (Exception e) {
            logger.error("copyDocumentByTemplate report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean updateDocumentByReport(String reportId, String documentName, String groupId) {
        try {
            Long reportIdLong = Long.parseLong(reportId);
            Long groupIdLong = CheckUtil.checkGroupIdGetLong((String)groupId);
            WordDocTypeInfo wordDocTypeInfo = this.wordTypeInfoService.getInfoByReportId(reportIdLong);
            if (HussarUtils.isNotEmpty((Object)wordDocTypeInfo)) {
                documentName = StringUtils.isBlank((CharSequence)documentName) ? wordDocTypeInfo.getReportName() : documentName;
            }
            Long id = (Long)this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(reportIdLong, documentName, DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeCode(), groupIdLong).getData();
            logger.info("updateDocumentByReport report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u7ed3\u675f:\u516c\u5171\u8868\u4e3b\u952e{}", (Object)id);
            return true;
        }
        catch (Exception e) {
            logger.error("updateDocumentByReport report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean copyDocumentByReport(String reportId, String documentName, String oldReportId) {
        try {
            Long groupIdLong = CommonConstants.L_1;
            Long oldReportIdLong = Long.parseLong(oldReportId);
            WordDocTypeInfo wordDocTypeInfo = this.wordTypeInfoService.getInfoByReportId(oldReportIdLong);
            if (HussarUtils.isNotEmpty((Object)wordDocTypeInfo)) {
                groupIdLong = wordDocTypeInfo.getGroupId();
                documentName = StringUtils.isBlank((CharSequence)documentName) ? wordDocTypeInfo.getReportName() : documentName;
            }
            Long reportIdLong = Long.parseLong(reportId);
            Long id = (Long)this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(reportIdLong, documentName, DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeCode(), groupIdLong).getData();
            logger.info("copyDocumentByReport report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u7ed3\u675f:\u516c\u5171\u8868\u4e3b\u952e{}", (Object)id);
            return true;
        }
        catch (Exception e) {
            logger.error("copyDocumentByReport report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean updateDocumentByComponentTemplate(String componentId, String documentName, String groupId) {
        try {
            Long componentIdLong = Long.parseLong(componentId);
            Long groupIdLong = CheckUtil.checkGroupIdGetLong((String)groupId);
            Long id = (Long)this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(componentIdLong, documentName, DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeCode(), groupIdLong).getData();
            logger.info("updateDocumentByComponentTemplate report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u7ed3\u675f:\u516c\u5171\u8868\u4e3b\u952e{}", (Object)id);
            return true;
        }
        catch (Exception e) {
            logger.error("updateDocumentByComponentTemplate report-tool-logger-\u66f4\u65b0\u6587\u6863\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }
}

