/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.excel.tools.core.common.utils.CheckUtil;
import com.jxdinfo.document.excel.tools.report.impl.ExcelTemplateReportServiceImpl;
import com.jxdinfo.document.excel.tools.word.service.IExcelWordCommonService;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.reportsnapshot.Vo.SnapShotVo;
import com.jxdinfo.hussar.application.reportsnapshot.model.SysReportSnapshot;
import com.jxdinfo.hussar.application.reportsnapshot.service.impl.SysReportSnapShotServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="com.jxdinfo.document.excel.tools.report.impl.ExcelInstanceReportServiceImpl")
public class ExcelInstanceReportServiceImpl
extends SysReportSnapShotServiceImpl {
    @Resource
    private IExcelWordCommonService excelWordCommonService;
    @Resource
    private ExcelTemplateReportServiceImpl reportExcelTemplateService;
    private static final Logger logger = LoggerFactory.getLogger(ExcelInstanceReportServiceImpl.class);

    @HussarTransactional(rollbackFor={Exception.class})
    public Long addSnapshot(SnapShotVo snapShotVo) {
        logger.info("\u8c03\u7528\u62a5\u8868\u5feb\u7167\u7684\u62d3\u5c55\u65b9\u6cd5 addSnapshot \u5f00\u59cb");
        Long id = super.addSnapshot(snapShotVo);
        logger.info("\u8c03\u7528 \u62a5\u8868\u5feb\u7167\u7684\u65b0\u589e\u65b9\u6cd5 addSnapshot \u7ed3\u675f \u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e id  {}", (Object)id);
        if (id != null) {
            SysReportSnapshot sysReportSnapshotById = this.getSysReportSnapshotById(id);
            String templateId = sysReportSnapshotById.getReportId();
            SysReport sysReportById = this.reportExcelTemplateService.getSysReportById(Long.valueOf(templateId));
            String reportIdString = id.toString();
            String groupIdString = sysReportById.getReportGroupId().toString();
            this.excelWordCommonService.updateDocumentByReport(reportIdString, sysReportSnapshotById.getSnapshotName(), groupIdString);
        }
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 addSnapshot \u7ed3\u675f");
        return id;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean editSnapshot(SysReportSnapshot sysReportSnapshot) {
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 editSnapshot \u5f00\u59cb");
        Long snapshotId = sysReportSnapshot.getSnapshotId();
        boolean flag = super.editSnapshot(sysReportSnapshot);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u7f16\u8f91\u65b9\u6cd5editSnapshot\u7ed3\u675f \u7f16\u8f91\u65b9\u6cd5\u7684\u8fd4\u56de\u7ed3\u679c flag {}", (Object)flag);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u7f16\u8f91\u65b9\u6cd5editSnapshot\u7ed3\u675f \u62a5\u8868\u4e3b\u952e snapshotId  {}", (Object)snapshotId);
        if (flag) {
            SysReportSnapshot sysReportSnapshotById = this.getSysReportSnapshotById(snapshotId);
            String templateId = sysReportSnapshotById.getReportId();
            SysReport sysReportById = this.reportExcelTemplateService.getSysReportById(Long.valueOf(templateId));
            String reportIdString = snapshotId.toString();
            String groupIdString = sysReportById == null ? "1" : CheckUtil.checkGroupIdString((Long)sysReportById.getReportGroupId());
            this.excelWordCommonService.updateDocumentByReport(reportIdString, sysReportSnapshotById.getSnapshotName(), groupIdString);
        }
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 editSnapshot \u7ed3\u675f");
        return flag;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Long addSnapshot(SnapShotVo snapShotVo, String groupId) {
        logger.info("\u8c03\u7528\u62a5\u8868\u5feb\u7167\u7684\u62d3\u5c55\u65b9\u6cd5 addSnapshot groupId  \u5f00\u59cb");
        Long id = super.addSnapshot(snapShotVo);
        logger.info("\u8c03\u7528 \u62a5\u8868\u5feb\u7167\u7684\u65b0\u589e\u65b9\u6cd5 addSnapshot \u7ed3\u675f groupId \u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e id  {}", (Object)id);
        if (id != null) {
            this.excelWordCommonService.updateDocumentByReport(String.valueOf(id), snapShotVo.getSnapshotName(), groupId);
        }
        logger.info("\u8c03\u7528 \u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 addSnapshot groupId \u7ed3\u675f");
        return id;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Long copyReport(SnapShotVo snapShotVo) {
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u62d3\u5c55\u65b9\u6cd5 copyReport \u5f00\u59cb");
        Long id = IdWorker.getId((Object)new Date());
        snapShotVo.setSnapshotId(id);
        Long reportId = super.addSnapshot(snapShotVo);
        logger.info("\u8c03\u7528\u62a5\u8868\u7684\u65b0\u589e\u65b9\u6cd5 addSnapshot \u7ed3\u675f \u8fd4\u56de\u7684\u62a5\u8868\u4e3b\u952e reportId  {}", (Object)reportId);
        return reportId;
    }
}

