/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.mongo.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.reportToolThreadPool.ReportFormThreadPool;
import com.jxdinfo.document.excel.tools.mongo.service.ExcelToolLsBorderInfoService;
import com.jxdinfo.document.excel.tools.mongo.service.ExcelToolLsCellDataService;
import com.jxdinfo.document.excel.tools.mongo.service.ExcelToolLsOtherDataService;
import com.jxdinfo.document.excel.tools.mongo.service.ExcelToolMongoService;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.excel.tools.mongo.service.impl.ReportToolFromMongoServiceImpl")
public class ExcelToolMongoServiceImpl
implements ExcelToolMongoService {
    @Autowired
    private ExcelToolLsCellDataService lsCellDataService;
    @Autowired
    private ExcelToolLsOtherDataService lsOtherDataService;
    @Autowired
    private ExcelToolLsBorderInfoService lsBorderInfoService;

    public String getAllData(String gridKey) {
        JSONObject lsSheetsRes = this.lsOtherDataService.getLsOtherDataByGridKey(gridKey);
        JSONArray lsSheets = lsSheetsRes.getJSONArray("allSheets");
        ThreadPoolTaskExecutor taskExecutor = ReportFormThreadPool.reportToolTemplateSheetDataByQueryThreadPool();
        CompletableFuture<Map> celldataFuture = CompletableFuture.supplyAsync(() -> this.lsCellDataService.getLsCellDataByGridKey(gridKey), (Executor)taskExecutor);
        CompletableFuture<Map> borderInfoFuture = CompletableFuture.supplyAsync(() -> this.lsBorderInfoService.getLsBorderInfoByGridKey(gridKey), (Executor)taskExecutor);
        Map celldataRes = celldataFuture.join();
        Map borderInfoRes = borderInfoFuture.join();
        ArrayList<CompletableFuture<Void>> mergeTasks = new ArrayList<CompletableFuture<Void>>();
        for (Object sheet : lsSheets) {
            JSONObject sheetObj = (JSONObject)sheet;
            mergeTasks.add(CompletableFuture.runAsync(() -> {
                JSONArray borderInfo;
                JSONArray celldata = (JSONArray)celldataRes.get(sheetObj.getString("index"));
                if (celldata != null) {
                    sheetObj.put("celldata", (Object)celldata);
                }
                if ((borderInfo = (JSONArray)borderInfoRes.get(sheetObj.getString("index"))) != null && !borderInfo.isEmpty()) {
                    if (!sheetObj.containsKey((Object)"config")) {
                        sheetObj.put("config", (Object)new JSONObject());
                    }
                    sheetObj.getJSONObject("config").put("borderInfo", (Object)borderInfo);
                }
            }, (Executor)taskExecutor));
        }
        CompletableFuture.allOf(mergeTasks.toArray(new CompletableFuture[0])).join();
        return lsSheets.toJSONString();
    }
}

