/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.mongo.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.document.excel.tools.mongo.model.ExcelToolLsCellData;
import com.jxdinfo.document.excel.tools.mongo.repository.ExcelLsCellDataRepository;
import com.jxdinfo.document.excel.tools.mongo.service.ExcelToolLsCellDataService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.excel.tools.mongo.service.impl.ExcelToolLsCellDataServiceImpl")
public class ExcelToolLsCellDataServiceImpl
implements ExcelToolLsCellDataService {
    @Autowired
    private ExcelLsCellDataRepository excelLsCellDataRepository;

    public Map<String, Object> getLsCellDataByGridKey(String gridKey) {
        List<ExcelToolLsCellData> excelToolLsCellDataList = this.excelLsCellDataRepository.findLsCellDataByGridKey(gridKey);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < excelToolLsCellDataList.size(); ++i) {
            ExcelToolLsCellData excelToolLsCellData = excelToolLsCellDataList.get(i);
            if (map.containsKey(excelToolLsCellData.getSheetIndex())) continue;
            JSONArray celldata = this.getLsCellDataByGridKeyAndSheetIndex(gridKey, excelToolLsCellData.getSheetIndex());
            map.put(excelToolLsCellData.getSheetIndex(), celldata);
        }
        return map;
    }

    public JSONArray getLsCellDataByGridKeyAndSheetIndex(String gridKey, String sheetIndex) {
        List<ExcelToolLsCellData> excelToolLsCellDataList = this.excelLsCellDataRepository.findLsCellDataByGridKeyAndSheetIndexOrderByOrder(gridKey, sheetIndex);
        JSONArray celldata = new JSONArray();
        for (int i = 0; i < excelToolLsCellDataList.size(); ++i) {
            ExcelToolLsCellData excelToolLsCellData = excelToolLsCellDataList.get(i);
            celldata.addAll((Collection)excelToolLsCellData.getCelldata());
        }
        return celldata;
    }
}

