/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.common.file.service.OssFileService;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.FrontendEnum;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ResultEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import com.jxdinfo.document.excel.tools.report.external.service.ExcelReportToolTemplateExternalService;
import com.jxdinfo.document.excel.tools.report.external.vo.ExcelDynamicDataStructureResultVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.model.ReportToolFormInstance;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsOtherDataService;
import com.jxdinfo.document.excel.tools.report.template.template.model.ReportToolFormTemplate;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateService;
import com.jxdinfo.hussar.license.ModuleVerify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.report.external.service.impl.ExcelReportToolTemplateExternalServiceImpl")
public class ExcelReportToolTemplateExternalServiceImpl
implements ExcelReportToolTemplateExternalService {
    @Autowired
    private ReportToolFormTemplateService reportToolFormTemplateService;
    @Autowired
    private ReportToolFormInstanceService reportToolFormInstanceService;
    @Autowired
    private ReportToolFormLsOtherDataService lsOtherDataService;
    @Autowired
    private OssFileService ossFileService;

    @Override
    public ApiResponse<List<ExcelDynamicDataStructureResultVo>> getTemplateDynamicDataStructure(String templateId, String reportId) {
        JSONArray nSheets;
        ReportToolFormTemplate reportToolFormTemplate;
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        if (StringUtils.isBlank((CharSequence)templateId)) {
            if (StringUtils.isBlank((CharSequence)reportId)) {
                return ApiResponse.fail((int)FrontendEnum.RETURN_NULL_REPORT_ID_OR_TEMPLATE_ID.getCode(), (String)FrontendEnum.RETURN_NULL_REPORT_ID_OR_TEMPLATE_ID.getDescription());
            }
            ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceService.getById((Serializable)((Object)reportId));
            if (reportToolFormInstance == null) {
                return ApiResponse.fail((int)ResultEnum.RETURN_DB_DATA_NULL_REPORT_ERROR.getCode(), (String)ResultEnum.RETURN_DB_DATA_NULL_REPORT_ERROR.getDescription());
            }
            templateId = reportToolFormInstance.getTemplateId().toString();
        }
        if ((reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateService.getById((Serializable)((Object)templateId))) == null) {
            return ApiResponse.fail((int)ResultEnum.RETURN_DB_DATA_NULL_TEMPLATE_ERROR.getCode(), (String)ResultEnum.RETURN_DB_DATA_NULL_TEMPLATE_ERROR.getDescription());
        }
        String templateJson = reportToolFormTemplate.getTemplateJson();
        String templatePath = reportToolFormTemplate.getTemplatePath();
        String jsonStr = "";
        if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
            jsonStr = templateJson;
        } else if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            jsonStr = this.ossFileService.getContent(templatePath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        List<Object> resultList = new ArrayList();
        if (!jsonStr.isEmpty()) {
            Object sheetObj = ZipUtil.unZipReport((String)jsonStr);
            if (sheetObj instanceof JSONArray) {
                nSheets = (JSONArray)sheetObj;
            } else {
                nSheets = new JSONArray();
                nSheets.add(sheetObj);
            }
        } else {
            JSONObject lsSheetsRes = this.lsOtherDataService.getLsOtherDataByGridKey(templateId);
            nSheets = lsSheetsRes.getJSONArray("allSheets");
        }
        if (nSheets != null) {
            for (Object sheetObject : nSheets) {
                JSONObject sheet = (JSONObject)sheetObject;
                ExcelDynamicDataStructureResultVo excelDynamicDataStructureResultVo = new ExcelDynamicDataStructureResultVo();
                excelDynamicDataStructureResultVo.setTemplateId(templateId);
                excelDynamicDataStructureResultVo.setIndex(sheet.getString("index"));
                excelDynamicDataStructureResultVo.setName(sheet.getString("name"));
                excelDynamicDataStructureResultVo.setOrder(sheet.getInteger("order"));
                String dynamicDataStructure = sheet.getString("dynamicDataStructure");
                if (StringUtils.isBlank((CharSequence)dynamicDataStructure)) continue;
                JSONObject configDataJson = JSONObject.parseObject((String)dynamicDataStructure);
                excelDynamicDataStructureResultVo.setDynamicDataStructure(configDataJson);
                resultList.add(excelDynamicDataStructureResultVo);
            }
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            resultList = resultList.stream().sorted(Comparator.comparing(ExcelDynamicDataStructureResultVo::getOrder)).collect(Collectors.toList());
        }
        return ApiResponse.success(resultList);
    }
}

