/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.template.template.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.document.excel.tools.common.datasource.dao.DataSourceMapper;
import com.jxdinfo.document.excel.tools.common.datasource.model.ReportToolTemplateDataSource;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceCustomService;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceService;
import com.jxdinfo.document.excel.tools.common.file.service.OssFileService;
import com.jxdinfo.document.excel.tools.common.reportcellrules.model.ReportCellRules;
import com.jxdinfo.document.excel.tools.common.reportcellrules.service.ReportCellRulesService;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ReportStatusEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.InitDataUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.LoadLsDataUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.reportToolThreadPool.ReportFormThreadPool;
import com.jxdinfo.document.excel.tools.report.external.service.WordExcelCommonService;
import com.jxdinfo.document.excel.tools.report.instance.instance.model.ReportToolFormInstance;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceService;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceUtilService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsBorderInfoService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsCellDataService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsOtherDataService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFromMongoService;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.model.ReportToolTemplateAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.service.TemplateFileLinkCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.dao.ReportToolFormTemplateMapper;
import com.jxdinfo.document.excel.tools.report.template.template.model.ReportToolFormTemplate;
import com.jxdinfo.document.excel.tools.report.template.template.model.ReportToolFormTemplateParam;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateParamCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateService;
import com.jxdinfo.document.excel.tools.report.template.template.vo.QueryFormParameterListVo;
import com.jxdinfo.document.excel.tools.report.template.template.vo.ReportToolFromTemplateBaseVo;
import com.jxdinfo.document.excel.tools.report.template.template.vo.ReportToolFromTemplateConfigVo;
import com.jxdinfo.document.excel.tools.report.template.template.vo.ReportToolFromTemplateQueryResultVo;
import com.jxdinfo.document.excel.tools.report.template.template.vo.SaveReportToolFormTemplateParamVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.license.ModuleVerify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service(value="excel.tools.report.template.template.service.impl.ReportToolFormTemplateCustomServiceImpl")
public class ReportToolFormTemplateCustomServiceImpl
implements ReportToolFormTemplateCustomService {
    @Value(value="${report-save-to-server}")
    private String reportSaveToServer;
    @Autowired
    private ReportToolFormTemplateMapper reportToolFormTemplateMapper;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataSourceCustomService dataSourceCustomService;
    @Autowired
    private ReportToolFormTemplateParamCustomService reportToolFormTemplateParamCustomService;
    @Autowired
    private TemplateFileLinkCustomService templateFileLinkCustomService;
    @Autowired
    private ReportToolFormLsCellDataService lsCellDataService;
    @Autowired
    private ReportToolFormLsOtherDataService lsOtherDataService;
    @Autowired
    private ReportToolFormLsBorderInfoService lsBorderInfoService;
    @Autowired
    private ReportToolFromMongoService reportToolFromMongoService;
    @Autowired
    private ReportCellRulesService reportCellRulesService;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private OssFileService ossFileService;
    @Autowired
    private ReportToolFormTemplateService reportToolFormTemplateService;
    @Autowired
    private ReportToolFormInstanceService reportToolFormInstanceService;
    @Autowired
    private WordExcelCommonService wordExcelCommonService;
    @Autowired
    private ReportToolFormInstanceUtilService reportToolFormInstanceUtilService;
    private static final ParserConfig parserConfig = new ParserConfig();
    protected static final Logger logger;

    private Boolean isReportSaveToServer() {
        String serverFlag = String.valueOf(this.reportSaveToServer);
        return serverFlag.equals(ReportStatusEnum.TRUE_STRING.getValue());
    }

    private void setTemplateJson(String json, ReportToolFormTemplate reportToolFormTemplate) {
        String id = String.valueOf(reportToolFormTemplate.getId());
        Object templateObj = ZipUtil.unZipReport((String)json);
        JSONArray templateJsonData = new JSONArray();
        if (templateObj instanceof JSONObject) {
            templateJsonData.add(templateObj);
        } else if (templateObj instanceof JSONArray) {
            templateJsonData = (JSONArray)templateObj;
        }
        if (this.isReportSaveToServer().booleanValue()) {
            for (int i = 0; i < templateJsonData.size(); ++i) {
                JSONObject sheet = templateJsonData.getJSONObject(i);
                sheet.remove((Object)"load");
            }
            String jsonData = ZipUtil.zipReport((String)templateJsonData.toJSONString());
            Long fileId = this.ossFileService.fileUpload(jsonData, id + ".json");
            reportToolFormTemplate.setTemplatePath(this.ossFileService.getFilePath(fileId, false));
            reportToolFormTemplate.setTemplateJson("");
        } else {
            StopWatch queryWatch = new StopWatch();
            queryWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u67e5\u8be2Mongo celldata\uff0ctemplateId={}", (Object)id);
            ThreadPoolTaskExecutor taskExecutor = ReportFormThreadPool.reportToolTemplateSheetThreadPool();
            CompletableFuture<Map> cellDataFuture = CompletableFuture.supplyAsync(() -> {
                Map<String, Object> cellData = this.lsCellDataService.getLsCellDataByGridKey(id);
                int dataSize = cellData == null ? 0 : cellData.size();
                logger.info("report-tool-logger-Mongo celldata\u67e5\u8be2\u5b8c\u6210\uff0ctemplateId={}\uff0c\u8fd4\u56desheet\u6570\u91cf={}", (Object)id, (Object)dataSize);
                return cellData;
            }, (Executor)taskExecutor);
            Map cellDataRes = cellDataFuture.join();
            queryWatch.stop();
            logger.info("report-tool-logger-Mongo celldata\u67e5\u8be2\u603b\u8017\u65f6={}ms\uff0ctemplateId={}", (Object)queryWatch.getTotalTimeMillis(), (Object)id);
            StopWatch borderDelWatch = new StopWatch();
            borderDelWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u5220\u9664Mongo borderInfo\uff0ctemplateId={}", (Object)id);
            this.lsBorderInfoService.deleteLsBorderInfoByGridKey(id);
            borderDelWatch.stop();
            logger.info("report-tool-logger-Mongo borderInfo\u5220\u9664\u5b8c\u6210\uff0ctemplateId={}\uff0c\u8017\u65f6={}ms", (Object)id, (Object)borderDelWatch.getTotalTimeMillis());
            StopWatch cellDelWatch = new StopWatch();
            cellDelWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u5220\u9664Mongo celldata\uff0ctemplateId={}", (Object)id);
            this.lsCellDataService.deleteLsCellDataByGridKey(id);
            cellDelWatch.stop();
            logger.info("report-tool-logger-Mongo celldata\u5220\u9664\u5b8c\u6210\uff0ctemplateId={}\uff0c\u8017\u65f6={}ms", (Object)id, (Object)cellDelWatch.getTotalTimeMillis());
            StopWatch lsOtherDelWatch = new StopWatch();
            lsOtherDelWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u5220\u9664Mongo otherData\uff0ctemplateId={}", (Object)id);
            this.lsOtherDataService.deleteLsOtherDataByGridKey(id);
            lsOtherDelWatch.stop();
            logger.info("report-tool-logger-Mongo otherData\u5220\u9664\u5b8c\u6210\uff0ctemplateId={}\uff0c\u8017\u65f6={}ms", (Object)id, (Object)lsOtherDelWatch.getTotalTimeMillis());
            for (int i = 0; i < templateJsonData.size(); ++i) {
                StopWatch stopIndexWatch = new StopWatch();
                stopIndexWatch.start();
                JSONObject sheet = templateJsonData.getJSONObject(i);
                String sheetIndex = sheet.getString("index");
                logger.info("report-tool-logger-\u5f00\u59cb\u5904\u7406sheet\uff0ctemplateId={}\uff0csheetIndex={}", (Object)id, (Object)sheetIndex);
                try {
                    JSONArray celldata = sheet.getJSONArray("celldata");
                    if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)celldata)) {
                        celldata = (JSONArray)cellDataRes.get(sheetIndex);
                    }
                    sheet.remove((Object)"celldata");
                    JSONArray borderInfo = null;
                    if (sheet.containsKey((Object)"config") && sheet.getJSONObject("config").containsKey((Object)"borderInfo")) {
                        borderInfo = sheet.getJSONObject("config").getJSONArray("borderInfo");
                        sheet.getJSONObject("config").remove((Object)"borderInfo");
                    }
                    sheet.remove((Object)"load");
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)celldata)) {
                        this.reportToolFromMongoService.saveCellData(id, celldata, sheetIndex);
                    }
                    this.reportToolFromMongoService.saveBorderInfoData(id, borderInfo, sheetIndex);
                    this.reportToolFromMongoService.saveLsOtherData(id, sheetIndex, sheet);
                    stopIndexWatch.stop();
                    logger.info("report-tool-logger-sheet\u5904\u7406\u5b8c\u6210\uff0ctemplateId={}\uff0csheetIndex={}\uff0c\u8017\u65f6={}ms", new Object[]{id, sheetIndex, stopIndexWatch.getTotalTimeMillis()});
                    continue;
                }
                catch (Exception e) {
                    stopIndexWatch.stop();
                    logger.error("report-tool-logger-sheet\u5904\u7406\u5931\u8d25\uff0ctemplateId={}\uff0csheetIndex={}\uff0c\u8017\u65f6={}ms\uff0c\u9519\u8bef={}", new Object[]{id, sheetIndex, stopIndexWatch.getTotalTimeMillis(), e.getMessage(), e});
                }
            }
            reportToolFormTemplate.setTemplateJson("");
            reportToolFormTemplate.setTemplatePath("");
        }
    }

    private void setBaseInfo(SaveReportToolFormTemplateParamVo formTemplateVo, ReportToolFormTemplate reportToolFormTemplate, String id, boolean addOrUpdate) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        logger.info("report-tool-logger-\u8bbe\u7f6e\u62a5\u8868\u6a21\u677f\u57fa\u7840\u4fe1\u606f\u5f00\u59cb \u6a21\u677f\u4e3b\u952e {}", (Object)id);
        String businessId = formTemplateVo.getBusinessId();
        reportToolFormTemplate.setCode(formTemplateVo.getCode());
        reportToolFormTemplate.setName(formTemplateVo.getName());
        reportToolFormTemplate.setOpenComponentInsert(formTemplateVo.getOpenComponentInsert());
        reportToolFormTemplate.setMultiSheetFlag(formTemplateVo.getMultiSheetFlag());
        if (addOrUpdate) {
            reportToolFormTemplate.setCreateId(BaseSecurityUtil.getUser().getId());
            reportToolFormTemplate.setCreateTime(LocalDateTime.now());
            reportToolFormTemplate.setCreateName(BaseSecurityUtil.getUser().getUserName());
        }
        reportToolFormTemplate.setId(Long.parseLong(id));
        reportToolFormTemplate.setBusinessId(StringUtils.isEmpty((CharSequence)businessId) ? String.valueOf(IdWorker.getId((Object)new Date())) : businessId);
        stopWatch.stop();
        logger.info("report-tool-logger-\u8bbe\u7f6e\u62a5\u8868\u6a21\u677f\u57fa\u7840\u4fe1\u606f\u8017\u65f6 {}", (Object)stopWatch.getTotalTimeMillis());
        logger.info("report-tool-logger-\u8bbe\u7f6e\u62a5\u8868\u6a21\u677f\u57fa\u7840\u4fe1\u606f\u7ed3\u675f \u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)reportToolFormTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<ReportToolFromTemplateBaseVo> saveReportFormTemplate(SaveReportToolFormTemplateParamVo formTemplateVo) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        logger.info("report-tool-logger-\u4fdd\u5b58\u62a5\u8868\u6a21\u677f\u5f00\u59cb\uff0ctemplateId={}", (Object)formTemplateVo.getTemplateId());
        ReportToolFromTemplateBaseVo result = new ReportToolFromTemplateBaseVo();
        this.reportCellRulesService.initUser(BaseSecurityUtil.getUser());
        String templateId = formTemplateVo.getTemplateId();
        List<Map<String, Object>> formParameterList = formTemplateVo.getFormParameterList();
        ReportToolFormTemplate reportToolFormTemplate = new ReportToolFormTemplate();
        boolean addOrUpdate = StringUtils.isEmpty((CharSequence)templateId);
        String id = addOrUpdate ? String.valueOf(IdWorker.getId((Object)new Date())) : templateId;
        boolean baseFlag = false;
        try {
            String string = id.intern();
            synchronized (string) {
                this.setBaseInfo(formTemplateVo, reportToolFormTemplate, id, addOrUpdate);
                result.setTemplateId(id);
                result.setBusinessId(reportToolFormTemplate.getBusinessId());
                String templateData = formTemplateVo.getTemplateJson();
                this.setTemplateJson(templateData, reportToolFormTemplate);
                baseFlag = this.reportToolFormTemplateService.saveOrUpdate(reportToolFormTemplate);
            }
            if (baseFlag) {
                this.setReportToolTemplateDataSource(id, addOrUpdate);
                this.dealFormParameterList(formParameterList, id);
                this.dealReportCellRules(formTemplateVo.getReportCellRules(), id);
                this.wordExcelCommonService.updateDocumentByTemplate(id, reportToolFormTemplate.getName(), formTemplateVo.getGroupId());
            }
            stopWatch.stop();
            logger.info("report-tool-logger-\u4fdd\u5b58\u62a5\u8868\u6a21\u677f\u5b8c\u6210\uff0c\u603b\u8017\u65f6={}ms\uff0ctemplateId={}", (Object)stopWatch.getTotalTimeMillis(), (Object)id);
            return ApiResponse.success((Object)result);
        }
        catch (Exception e) {
            stopWatch.stop();
            logger.error("report-tool-logger-\u4fdd\u5b58\u62a5\u8868\u6a21\u677f\u5931\u8d25\uff0c\u603b\u8017\u65f6={}ms\uff0ctemplateId={}\uff0c\u9519\u8bef\u4fe1\u606f={}", new Object[]{stopWatch.getTotalTimeMillis(), id, e.getMessage(), e});
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealFormParameterList(List<Map<String, Object>> formParameterList, String templateId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        logger.info("report-tool-logger-\u5f00\u59cb\u5904\u7406\u62a5\u8868\u6a21\u677f\u7684\u53c2\u6570\u4fe1\u606f \u6a21\u677f\u4e3b\u952e{}", (Object)templateId);
        try {
            if (CollectionUtils.isEmpty(formParameterList)) {
                return;
            }
            ArrayList<ReportToolFormTemplateParam> addReportToolFormTemplateParamList = new ArrayList<ReportToolFormTemplateParam>();
            for (Map<String, Object> formParam : formParameterList) {
                ReportToolFormTemplateParam reportToolFormTemplateParam = new ReportToolFormTemplateParam(formParam);
                addReportToolFormTemplateParamList.add(reportToolFormTemplateParam);
            }
            this.reportToolFormTemplateParamCustomService.saveOrUpdateByBusinessId(templateId, addReportToolFormTemplateParamList);
        }
        finally {
            stopWatch.stop();
            logger.info("report-tool-logger-\u7ed3\u675f\u5904\u7406\u62a5\u8868\u6a21\u677f\u7684\u53c2\u6570\u4fe1\u606f \u6a21\u677f\u4e3b\u952e{}\uff0c\u8017\u65f6{}ms", (Object)templateId, (Object)stopWatch.getTotalTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealReportCellRules(List<ReportCellRules> reportCellRules, String templateId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        logger.info("report-tool-logger-\u5f00\u59cb\u5904\u7406\u62a5\u8868\u6a21\u677f\u7684\u5408\u5e76\u89c4\u5219\u4fe1\u606f \u6a21\u677f\u4e3b\u952e{}", (Object)templateId);
        try {
            this.reportCellRulesService.saveOrUpdateByBusinessId(templateId, reportCellRules);
        }
        finally {
            stopWatch.stop();
            logger.info("report-tool-logger-\u7ed3\u675f\u5904\u7406\u62a5\u8868\u6a21\u677f\u7684\u5408\u5e76\u89c4\u5219\u4fe1\u606f \u6a21\u677f\u4e3b\u952e{}\uff0c\u8017\u65f6{}ms", (Object)templateId, (Object)stopWatch.getTotalTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReportToolTemplateDataSource(String templateId, boolean addOrUpdate) {
        if (addOrUpdate) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u5904\u7406\u62a5\u8868\u6a21\u677f\u7684\u6570\u636e\u6e90\u4fe1\u606f \u6a21\u677f\u4e3b\u952e{}", (Object)templateId);
            try {
                List reportToolTemplateDataSourceList = this.dataSourceService.list((Wrapper)new QueryWrapper().lambda().eq(ReportToolTemplateDataSource::getTemplateId, (Object)ReportStatusEnum.DEFAULT_DATA_SOURCE_FORM_TEMPLATE_ID.getValue()));
                for (ReportToolTemplateDataSource e : reportToolTemplateDataSourceList) {
                    e.setId(String.valueOf(IdWorker.getId((Object)new Date())));
                    e.setTemplateId(templateId);
                    e.setBaseExtendType("base");
                }
                this.dataSourceService.saveBatch((Collection)reportToolTemplateDataSourceList);
            }
            finally {
                stopWatch.stop();
                logger.info("report-tool-logger-\u7ed3\u675f\u5904\u7406\u62a5\u8868\u6a21\u677f\u7684\u6570\u636e\u6e90\u4fe1\u606f \u6a21\u677f\u4e3b\u952e{}\uff0c\u8017\u65f6{}ms", (Object)templateId, (Object)stopWatch.getTotalTimeMillis());
            }
        }
    }

    @Override
    public ApiResponse<ReportToolFromTemplateQueryResultVo> getReportFormTemplateInfo(ReportToolFromTemplateBaseVo reportToolFromTemplateBaseVo) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        String id = reportToolFromTemplateBaseVo.getTemplateId();
        ReportToolFromTemplateQueryResultVo resultVo = new ReportToolFromTemplateQueryResultVo();
        if (id.isEmpty()) {
            resultVo.setJson("");
            return ApiResponse.success((Object)resultVo);
        }
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)id));
        String multiSheetFlag = reportToolFormTemplate.getMultiSheetFlag();
        resultVo.setOpenComponentInsert(reportToolFormTemplate.getOpenComponentInsert());
        resultVo.setMultiSheetFlag(multiSheetFlag);
        if (StringUtils.isNotEmpty((CharSequence)multiSheetFlag) && !multiSheetFlag.equals("1")) {
            String templateJson = reportToolFormTemplate.getTemplateJson();
            String templatePath = reportToolFormTemplate.getTemplatePath();
            if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
                String json = this.ossFileService.getContent(templatePath);
                json = StringUtil.cleaningHtml((String)json);
                resultVo.setJson(json);
            } else if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
                resultVo.setJson(templateJson);
            }
        }
        List<ReportToolFormTemplateParam> reportFormTemplateParamList = this.reportToolFormTemplateParamCustomService.getListByBusinessId(id);
        List reportCellRules = this.reportCellRulesService.getListByBusinessId(id);
        resultVo.setFormParameterList(reportFormTemplateParamList);
        resultVo.setReportCellRules(reportCellRules);
        return ApiResponse.success((Object)resultVo);
    }

    @Override
    public ApiResponse<ReportToolFromTemplateBaseVo> copyReportFromTemplate(ReportToolFromTemplateBaseVo reportToolFromTemplateBaseVo) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        String templateId = reportToolFromTemplateBaseVo.getTemplateId();
        String businessId = reportToolFromTemplateBaseVo.getBusinessId();
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)templateId));
        long id = IdWorker.getId((Object)new Date());
        reportToolFormTemplate.setId(id);
        reportToolFormTemplate.setBusinessId(businessId);
        String templatePath = reportToolFormTemplate.getTemplatePath();
        String jsonData = reportToolFormTemplate.getTemplateJson();
        if (StringUtils.isNotBlank((CharSequence)templatePath)) {
            jsonData = this.ossFileService.getContent(templatePath);
        }
        if (ObjectUtils.isEmpty((Object)reportToolFormTemplate.getTemplatePath()) && ObjectUtils.isEmpty((Object)reportToolFormTemplate.getTemplateJson())) {
            jsonData = this.getReportFormTemplateInfo(templateId).getTemplateJson();
        }
        this.setTemplateJson(jsonData, reportToolFormTemplate);
        ReportToolFromTemplateBaseVo resultVo = new ReportToolFromTemplateBaseVo();
        int i = this.reportToolFormTemplateMapper.insert(reportToolFormTemplate);
        if (i > 0) {
            LinkedHashMap<String, String> dataSourceIdMap = new LinkedHashMap<String, String>();
            List reportToolTemplateDataSourceList = this.dataSourceCustomService.getListByBusinessId(templateId);
            for (ReportToolTemplateDataSource reportToolTemplateDataSource : reportToolTemplateDataSourceList) {
                reportToolTemplateDataSource.setTemplateId(String.valueOf(id));
                String dataSourceId = IdWorker.get32UUID();
                dataSourceIdMap.put(reportToolTemplateDataSource.getId(), dataSourceId);
                reportToolTemplateDataSource.setId(dataSourceId);
            }
            this.dataSourceService.saveOrUpdateBatch((Collection)reportToolTemplateDataSourceList);
            List<ReportToolTemplateAttachmentFileLink> attachmentFileLinkList = this.templateFileLinkCustomService.getListByBusinessId(Long.parseLong(templateId));
            this.templateFileLinkCustomService.saveOrUpdateByBusinessId(reportToolFormTemplate.getId(), attachmentFileLinkList);
            List<ReportToolFormTemplateParam> reportFormTemplateParamList = this.reportToolFormTemplateParamCustomService.getListByBusinessId(templateId);
            this.reportToolFormTemplateParamCustomService.saveOrUpdateByBusinessId(String.valueOf(reportToolFormTemplate.getId()), reportFormTemplateParamList);
            this.reportCellRulesService.initUser(BaseSecurityUtil.getUser());
            List cellRules = this.reportCellRulesService.getListByBusinessId(templateId);
            cellRules.forEach(rule -> rule.setDataSourceId((String)dataSourceIdMap.get(rule.getDataSourceId())));
            this.reportCellRulesService.saveOrUpdateByBusinessId(String.valueOf(reportToolFormTemplate.getId()), cellRules);
            resultVo.setTemplateId(String.valueOf(id));
            resultVo.setBusinessId(businessId);
            return ApiResponse.success((Object)resultVo);
        }
        resultVo.setTemplateId(String.valueOf(id));
        resultVo.setBusinessId(businessId);
        return ApiResponse.fail((int)ReportStatusEnum.RETURN_CODE_MINUS_ONE.getCode(), (Object)resultVo, (String)"\u5931\u8d25");
    }

    @Override
    public ApiResponse<Map<String, Object>> batchDelReportFormTemplateById(List<String> templateIds) {
        try {
            int t = this.reportToolFormTemplateMapper.deleteBatchIds(templateIds);
            if (t > 0) {
                for (String templateId : templateIds) {
                    this.reportToolFormTemplateParamCustomService.deleteByBusinessId(templateId);
                    List reportTemplateDataSourceList = this.dataSourceMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(ReportToolTemplateDataSource::getTemplateId, (Object)templateId));
                    if (CollectionUtils.isNotEmpty((Collection)reportTemplateDataSourceList)) {
                        for (ReportToolTemplateDataSource ds : reportTemplateDataSourceList) {
                            this.dataSourceMapper.deleteById((Serializable)((Object)ds.getId()));
                        }
                    }
                    this.lsOtherDataService.deleteLsOtherDataByGridKey(templateId);
                    this.lsCellDataService.deleteLsCellDataByGridKey(templateId);
                    this.lsBorderInfoService.deleteLsBorderInfoByGridKey(templateId);
                }
                return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<List<ReportToolFormTemplateParam>> getTemplateFormParameterList(QueryFormParameterListVo param) {
        try {
            String templateId = param.getTemplateId();
            String reportId = param.getReportId();
            if (StringUtils.isBlank((CharSequence)templateId)) {
                ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceService.getById((Serializable)((Object)reportId));
                templateId = String.valueOf(reportToolFormInstance.getTemplateId());
            }
            List<ReportToolFormTemplateParam> reportFormTemplateParamList = this.reportToolFormTemplateParamCustomService.getListByBusinessId(templateId);
            return ApiResponse.success(reportFormTemplateParamList);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public JSONArray reportFormLoadUrlJson(String gridKey, String configData) {
        long start = new Date().getTime();
        String businessId = gridKey;
        JSONArray resJson = null;
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)businessId));
        String templateJson = reportToolFormTemplate.getTemplateJson();
        String templatePath = reportToolFormTemplate.getTemplatePath();
        String jsonStr = "";
        long start1 = new Date().getTime();
        if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
            jsonStr = templateJson;
        } else if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            jsonStr = this.ossFileService.getContent(templatePath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        long end1 = new Date().getTime();
        System.out.println("-------reportFormLoadUrl\u8bfb\u53d6jsonStr------" + (end1 - start1));
        if (!jsonStr.isEmpty()) {
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            long start2 = new Date().getTime();
            resJson = LoadLsDataUtil.lsLoadUrlJson((JSONArray)nSheets);
            long end2 = new Date().getTime();
            System.out.println("-------reportFormLoadUrl\u5904\u7406\u6570\u636e------" + (end2 - start2));
        } else {
            long start22 = new Date().getTime();
            JSONObject lsSheetsRes = this.lsOtherDataService.getLsOtherDataByGridKey(businessId);
            JSONArray lsSheets = lsSheetsRes.getJSONArray("allSheets");
            long end22 = new Date().getTime();
            System.out.println("-------getLsOtherDataByGridKey------" + (end22 - start22));
            long start24 = new Date().getTime();
            int currentSheetIndex = lsSheetsRes.getIntValue("currentSheetIndex");
            JSONObject currentSheet = lsSheets.getJSONObject(currentSheetIndex);
            JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, currentSheet.getString("index"));
            currentSheet.put("celldata", (Object)celldata);
            long end25 = new Date().getTime();
            System.out.println("--------\u5904\u7406celldata------" + (end25 - start24));
            long start25 = new Date().getTime();
            ExecutorService executorService = Executors.newFixedThreadPool(lsSheets.size());
            CountDownLatch latch = new CountDownLatch(lsSheets.size());
            int i = 0;
            while (i < lsSheets.size()) {
                int finalI = i++;
                executorService.submit(() -> {
                    JSONObject sheet = lsSheets.getJSONObject(finalI);
                    JSONArray borderInfo = this.lsBorderInfoService.getLsBorderInfoByGridKeyAndSheetIndex(businessId, sheet.getString("index"));
                    if (borderInfo.size() > 0) {
                        if (!sheet.containsKey((Object)"config")) {
                            sheet.put("config", (Object)new JSONObject());
                        }
                        sheet.getJSONObject("config").put("borderInfo", (Object)borderInfo);
                    }
                    latch.countDown();
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            executorService.shutdown();
            long end24 = new Date().getTime();
            System.out.println("-------\u5904\u7406borderInfo------" + (end24 - start25));
            System.out.println("-------\u5904\u7406celldata/borderInfo------" + (end24 - start24));
            long start23 = new Date().getTime();
            resJson = lsSheets;
            long end23 = new Date().getTime();
            System.out.println("-------lsSheets.toJSONString()------" + (end23 - start23));
        }
        long end = new Date().getTime();
        System.out.println("-------reportFormLoadUrl\u603b\u65f6\u957f------" + (end - start));
        this.reportToolFormInstanceUtilService.configDataReplace(configData, resJson);
        return resJson;
    }

    @Override
    public JSONObject reportFormLoadSheetUrlJson(String gridKey, String index) {
        String businessId = gridKey;
        JSONObject resJson = null;
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)businessId));
        String templateJson = reportToolFormTemplate.getTemplateJson();
        String templatePath = reportToolFormTemplate.getTemplatePath();
        String jsonStr = "";
        if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
            jsonStr = templateJson;
        } else if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            jsonStr = this.ossFileService.getContent(templatePath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        if (!jsonStr.isEmpty()) {
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            resJson = LoadLsDataUtil.lsLoadSheetUrlJson((JSONArray)nSheets, (String)index);
        } else {
            long start = new Date().getTime();
            JSONObject resObj = new JSONObject();
            String[] indexArr = index.split(",");
            System.out.println("----indexArr----" + indexArr.length);
            for (int i = 0; i < indexArr.length; ++i) {
                JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, indexArr[i]);
                resObj.put(indexArr[i], (Object)celldata);
            }
            long start1 = new Date().getTime();
            resJson = resObj;
            System.out.println("--celldata---resObj----" + (start1 - start));
            long end1 = new Date().getTime();
            System.out.println("-----resObj.toJSONString()-----" + (end1 - start1));
        }
        return resJson;
    }

    @Override
    public String reportFormLoadUrlStr(String gridKey, String configData) {
        long start = new Date().getTime();
        String businessId = gridKey;
        String resStr = "";
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)businessId));
        String templateJson = reportToolFormTemplate.getTemplateJson();
        String templatePath = reportToolFormTemplate.getTemplatePath();
        String jsonStr = "";
        long start1 = new Date().getTime();
        if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
            jsonStr = templateJson;
        } else if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            jsonStr = this.ossFileService.getContent(templatePath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        long end1 = new Date().getTime();
        System.out.println("-------reportFormLoadUrl\u8bfb\u53d6jsonStr------" + (end1 - start1));
        if (!jsonStr.isEmpty()) {
            long start2 = new Date().getTime();
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            this.reportToolFormInstanceUtilService.configDataReplace(configData, nSheets);
            resStr = LoadLsDataUtil.lsLoadUrlStr((JSONArray)nSheets);
            long end2 = new Date().getTime();
            System.out.println("-------reportFormLoadUrl\u5904\u7406\u6570\u636e------" + (end2 - start2));
        } else {
            long start22 = new Date().getTime();
            JSONObject lsSheetsRes = this.lsOtherDataService.getLsOtherDataByGridKey(businessId);
            JSONArray lsSheets = lsSheetsRes.getJSONArray("allSheets");
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)lsSheets)) {
                return "";
            }
            long end22 = new Date().getTime();
            System.out.println("-------getLsOtherDataByGridKey------" + (end22 - start22));
            long start24 = new Date().getTime();
            int currentSheetIndex = lsSheetsRes.getIntValue("currentSheetIndex");
            JSONObject currentSheet = lsSheets.getJSONObject(currentSheetIndex);
            JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, currentSheet.getString("index"));
            currentSheet.put("celldata", (Object)celldata);
            long end25 = new Date().getTime();
            System.out.println("--------\u5904\u7406celldata------" + (end25 - start24));
            long start25 = new Date().getTime();
            ExecutorService executorService = Executors.newFixedThreadPool(lsSheets.size());
            CountDownLatch latch = new CountDownLatch(lsSheets.size());
            int i = 0;
            while (i < lsSheets.size()) {
                int finalI = i++;
                executorService.submit(() -> {
                    JSONObject sheet = lsSheets.getJSONObject(finalI);
                    JSONArray borderInfo = this.lsBorderInfoService.getLsBorderInfoByGridKeyAndSheetIndex(businessId, sheet.getString("index"));
                    if (borderInfo.size() > 0) {
                        if (!sheet.containsKey((Object)"config")) {
                            sheet.put("config", (Object)new JSONObject());
                        }
                        sheet.getJSONObject("config").put("borderInfo", (Object)borderInfo);
                    }
                    latch.countDown();
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            executorService.shutdown();
            long end24 = new Date().getTime();
            System.out.println("-------\u5904\u7406borderInfo------" + (end24 - start25));
            System.out.println("-------\u5904\u7406celldata/borderInfo------" + (end24 - start24));
            long start23 = new Date().getTime();
            this.reportToolFormInstanceUtilService.configDataReplace(configData, lsSheets);
            resStr = lsSheets.toJSONString();
            long end23 = new Date().getTime();
            System.out.println("-------lsSheets.toJSONString()------" + (end23 - start23));
        }
        long end = new Date().getTime();
        System.out.println("-------reportFormLoadUrl\u603b\u65f6\u957f------" + (end - start));
        return ZipUtil.zipReport((String)resStr);
    }

    @Override
    public String reportFormLoadSheetUrlStr(String gridKey, String index, String parentSheet, String oldSheetName, String newSheetName) {
        String businessId = gridKey;
        String resStr = "";
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)businessId));
        String templateJson = reportToolFormTemplate.getTemplateJson();
        String templatePath = reportToolFormTemplate.getTemplatePath();
        String jsonStr = "";
        if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
            jsonStr = templateJson;
        } else if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            jsonStr = this.ossFileService.getContent(templatePath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        if (!jsonStr.isEmpty()) {
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            resStr = LoadLsDataUtil.lsLoadSheetUrlStr((JSONArray)nSheets, (String)index);
        } else {
            long start = new Date().getTime();
            JSONObject resObj = new JSONObject();
            String[] indexArr = parentSheet != null && !parentSheet.isEmpty() ? parentSheet.split(",") : index.split(",");
            System.out.println("----indexArr----" + indexArr.length);
            for (int i = 0; i < indexArr.length; ++i) {
                JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, indexArr[i]);
                if (parentSheet != null && !parentSheet.isEmpty()) {
                    resObj.put(index, (Object)celldata);
                    continue;
                }
                resObj.put(indexArr[i], (Object)celldata);
            }
            long start1 = new Date().getTime();
            System.out.println("--celldata---resObj----" + (start1 - start));
            if (parentSheet != null && !parentSheet.isEmpty() && resObj.containsKey((Object)index)) {
                JSONArray sheetArray = resObj.getJSONArray(index);
                for (int i = 0; i < sheetArray.size(); ++i) {
                    String vValue;
                    Object vValueObj;
                    JSONObject vObj;
                    JSONObject cell = sheetArray.getJSONObject(i);
                    if (!cell.containsKey((Object)"v") || !(vObj = cell.getJSONObject("v")).containsKey((Object)"v") || !vObj.containsKey((Object)"m") || !((vValueObj = vObj.get((Object)"v")) instanceof String) || !(vValue = (String)vObj.get((Object)"v")).contains(oldSheetName)) continue;
                    String newValue = vValue.replace(oldSheetName, newSheetName);
                    vObj.put("v", (Object)newValue);
                    vObj.put("m", (Object)newValue);
                }
            }
            resStr = resObj.toJSONString();
            long end1 = new Date().getTime();
            System.out.println("-----resObj.toJSONString()-----" + (end1 - start1));
        }
        return ZipUtil.zipReport((String)resStr);
    }

    @Override
    public String reportFormLoadUrlStrIsInstance(String gridKey) {
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)gridKey));
        if (reportToolFormTemplate == null) {
            return "";
        }
        String resStr = "";
        String templateJson = reportToolFormTemplate.getTemplateJson();
        String templatePath = reportToolFormTemplate.getTemplatePath();
        String jsonStr = "";
        if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
            jsonStr = templateJson;
        } else if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            jsonStr = this.ossFileService.getContent(templatePath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        if (!jsonStr.isEmpty()) {
            Object nSheets = ZipUtil.unZipReport((String)jsonStr);
            if (nSheets != null) {
                resStr = JSON.toJSONString((Object)ZipUtil.unZipReport((String)jsonStr), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
        } else {
            resStr = this.reportToolFromMongoService.getAllData(gridKey);
        }
        return ZipUtil.zipReport((String)resStr);
    }

    @Override
    public Long addEmptyFormTemplate(String name) {
        String jsonData = InitDataUtil.initJsonData();
        return this.addImportFormTemplate(name, jsonData);
    }

    @Override
    public Long addImportFormTemplate(String name, String jsonData) {
        Long id = IdWorker.getId((Object)new Date());
        ReportToolFormTemplate reportToolFormTemplate = new ReportToolFormTemplate();
        reportToolFormTemplate.setId(id);
        reportToolFormTemplate.setName(StringUtils.isNotEmpty((CharSequence)name) ? name : "\u65e0\u6807\u9898\u6587\u6863");
        reportToolFormTemplate.setOpenComponentInsert("0");
        reportToolFormTemplate.setCreateId(BaseSecurityUtil.getUser().getId());
        reportToolFormTemplate.setCreateTime(LocalDateTime.now());
        reportToolFormTemplate.setCreateName(BaseSecurityUtil.getUser().getUserName());
        reportToolFormTemplate.setMultiSheetFlag("1");
        this.setTemplateJson(jsonData, reportToolFormTemplate);
        this.reportToolFormTemplateMapper.insert(reportToolFormTemplate);
        return reportToolFormTemplate.getId();
    }

    @Override
    public ReportToolFormTemplate getReportFormTemplateInfo(String templateId) {
        if (StringUtils.isEmpty((CharSequence)templateId)) {
            return new ReportToolFormTemplate();
        }
        ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById((Serializable)((Object)templateId));
        if (reportToolFormTemplate == null) {
            return new ReportToolFormTemplate();
        }
        reportToolFormTemplate.setTemplateJson(this.reportFormLoadUrlStrIsInstance(templateId));
        return reportToolFormTemplate;
    }

    @Override
    public ReportToolFromTemplateConfigVo getReportFormTemplateConfig(String templateId) {
        ReportToolFromTemplateConfigVo resultVo = new ReportToolFromTemplateConfigVo();
        List<ReportToolFormTemplateParam> reportFormTemplateParamList = this.reportToolFormTemplateParamCustomService.getListByBusinessId(templateId);
        List reportCellRules = this.reportCellRulesService.getListByBusinessId(templateId);
        List reportToolTemplateDataSourceList = this.dataSourceCustomService.getListByBusinessId(templateId);
        List<ReportToolTemplateAttachmentFileLink> attachmentFileLinkList = this.templateFileLinkCustomService.getListByBusinessId(Long.parseLong(templateId));
        resultVo.setDataSourceList(reportToolTemplateDataSourceList);
        resultVo.setFormParameterList(reportFormTemplateParamList);
        resultVo.setAttachmentFileLinkList(attachmentFileLinkList);
        resultVo.setReportCellRules(reportCellRules);
        return resultVo;
    }

    @Override
    public ReportToolFormTemplate getBase(Long templateId) {
        return (ReportToolFormTemplate)this.reportToolFormTemplateMapper.selectById(templateId);
    }

    static {
        parserConfig.setAutoTypeSupport(true);
        logger = LoggerFactory.getLogger(ReportToolFormTemplateCustomServiceImpl.class);
    }
}

