/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.CommonDocumentInterface;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.factory.DocumentFactory;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.FrontendEnum;
import com.jxdinfo.document.excel.tools.report.export.service.ExportExcelService;
import com.jxdinfo.document.excel.tools.report.external.service.WordExcelCommonService;
import com.jxdinfo.document.excel.tools.report.template.component.component.model.ReportToolFormComponentTemplate;
import com.jxdinfo.document.excel.tools.report.template.component.component.service.ComponentTemplateCustomService;
import com.jxdinfo.document.excel.tools.report.template.component.component.service.ComponentTemplateService;
import com.jxdinfo.document.excel.tools.report.template.component.component.vo.ReportToolFromComponentTemplateBaseVo;
import com.jxdinfo.document.excel.tools.report.template.component.component.vo.ReportToolFromComponentTemplateConfigVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="excel.tools.report.external.service.impl.FormComponentTemplateExternalServiceImpl")
public class FormComponentTemplateExternalServiceImpl
implements CommonDocumentInterface,
InitializingBean {
    @Resource
    private ComponentTemplateCustomService toolFormComponentTemplateCustomService;
    @Resource
    private ComponentTemplateService componentTemplateService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Autowired
    private WordExcelCommonService wordExcelCommonService;
    @Resource
    private ExportExcelService exportExcelService;
    private static final Logger logger = LoggerFactory.getLogger(FormComponentTemplateExternalServiceImpl.class);

    public void checkDocId(Long templateComponentId) {
        if (templateComponentId == null) {
            throw new IllegalArgumentException(FrontendEnum.RETURN_ID_NULL.getDescription());
        }
    }

    public DocumentDetailsVo queryDocumentDetail(Long templateComponentId) {
        return this.queryOffice(templateComponentId);
    }

    public DocumentDetailsVo queryOffice(Long templateComponentId) {
        this.checkDocId(templateComponentId);
        ReportToolFormComponentTemplate componentTemplate = this.toolFormComponentTemplateCustomService.getReportFormCompTemplateInfo(String.valueOf(templateComponentId));
        ReportToolFromComponentTemplateConfigVo configInfo = this.toolFormComponentTemplateCustomService.getReportFormCompTemplateConfig(String.valueOf(templateComponentId));
        DocumentDetailsVo detailsVo = new DocumentDetailsVo();
        detailsVo.setId(templateComponentId);
        detailsVo.setType(DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeCode());
        detailsVo.setDocumentName(componentTemplate.getName());
        detailsVo.setContent(componentTemplate.getTemplateJson());
        HashMap<String, Object> extendResult = new HashMap<String, Object>(16);
        extendResult.put("baseInfo", componentTemplate);
        extendResult.put("configInfo", configInfo);
        detailsVo.setExtendResult(extendResult);
        return detailsVo;
    }

    public Long addBlankDocument(String documentName, String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        Long reportId = this.toolFormComponentTemplateCustomService.addEmptyFormTemplateComponent(reportName);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(reportId, reportName, DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeCode());
        return reportId;
    }

    public Long copyDocument(Long templateComponentId) {
        this.checkDocId(templateComponentId);
        ReportToolFormComponentTemplate componentTemplate = (ReportToolFormComponentTemplate)this.componentTemplateService.getById(templateComponentId);
        ApiResponse<ReportToolFromComponentTemplateBaseVo> result = this.toolFormComponentTemplateCustomService.copyReportFormCompTemplate(String.valueOf(templateComponentId));
        if (result.isSuccess()) {
            ReportToolFromComponentTemplateBaseVo resultData = (ReportToolFromComponentTemplateBaseVo)result.getData();
            String reportId = resultData.getTemplateComponentId();
            this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(Long.valueOf(reportId), componentTemplate.getName(), DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeCode());
            return Long.valueOf(reportId);
        }
        return null;
    }

    public void downloadDocument(HttpServletResponse httpServletResponse, Long templateComponentId) {
        logger.info("downloadDocument \u62a5\u544a\u6a21\u677f\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6587\u4ef6\u4e0b\u8f7d");
    }

    public void previewPDF(HttpServletResponse httpServletResponse, Long aLong) {
    }

    public ApiResponse<Long> importDocument(MultipartFile multipartFile, Long templateComponentId, String s) {
        return null;
    }

    public void exportDocument(HttpServletResponse httpServletResponse, Long templateComponentId) {
        logger.info("exportDocument \u62a5\u544a\u6a21\u677f\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6587\u4ef6\u4e0b\u8f7d");
    }

    public DocDataBindInfo getBindConfig(GenerateReportParam generateReportParam) {
        return null;
    }

    public Long generateReport(Long aLong, JSONObject jsonObject) {
        return 0L;
    }

    public JSONObject executeJsGenerateReportJson(Long aLong, String s) {
        return null;
    }

    public DocumentSplitVo getDocumentById(Long aLong) {
        return null;
    }

    public Long addBlankDocument(String documentName, String type, String groupId) {
        if (StringUtils.isBlank((CharSequence)type)) {
            logger.error("type \u53c2\u6570\u7a7a");
        }
        String reportName = StringUtils.isBlank((CharSequence)documentName) ? "\u65e0\u6807\u9898\u6587\u6863" : documentName;
        Long reportId = this.toolFormComponentTemplateCustomService.addEmptyFormTemplateComponent(reportName);
        this.wordExcelCommonService.updateDocumentByComponentTemplate(String.valueOf(reportId), reportName, groupId);
        return reportId;
    }

    public boolean deleteDocument(Long componentId) {
        this.checkDocId(componentId);
        this.wordTypeInfoService.deleteByReportId(componentId);
        ApiResponse<Boolean> result = this.toolFormComponentTemplateCustomService.del(Arrays.asList(String.valueOf(componentId)));
        return (Boolean)result.getData();
    }

    public void downDocument(HttpServletResponse httpServletResponse, Long componentId) {
        this.checkDocId(componentId);
        this.exportExcelService.exportComponentXlsx(httpServletResponse, componentId);
    }

    public void afterPropertiesSet() {
        DocumentFactory.add((String)DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeName(), (CommonDocumentInterface)this);
    }
}

