/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.template.component.component.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.document.excel.tools.common.datasource.model.ReportToolTemplateDataSource;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceCustomService;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceService;
import com.jxdinfo.document.excel.tools.common.datasource.service.ExcelReportDataSourceService;
import com.jxdinfo.document.excel.tools.common.file.service.OssFileService;
import com.jxdinfo.document.excel.tools.common.reportcellrules.model.ReportCellRules;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ReportStatusEnum;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ResultEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.DateUtils;
import com.jxdinfo.document.excel.tools.core.common.utils.InitDataUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.model.ComponentAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.service.ComponentFileLinkCustomService;
import com.jxdinfo.document.excel.tools.report.template.component.component.dao.ComponentTemplateMapper;
import com.jxdinfo.document.excel.tools.report.template.component.component.model.ReportToolFormComponentTemplate;
import com.jxdinfo.document.excel.tools.report.template.component.component.service.ComponentTemplateCustomService;
import com.jxdinfo.document.excel.tools.report.template.component.component.service.ComponentTemplateService;
import com.jxdinfo.document.excel.tools.report.template.component.component.vo.ReportToolFormComponentTemplatePageParamVO;
import com.jxdinfo.document.excel.tools.report.template.component.component.vo.ReportToolFormComponentTemplatePageVO;
import com.jxdinfo.document.excel.tools.report.template.component.component.vo.ReportToolFromComponentTemplateBaseVo;
import com.jxdinfo.document.excel.tools.report.template.component.component.vo.ReportToolFromComponentTemplateConfigVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.report.template.component.component.service.impl.reportToolToolFormComponentTemplateCustomServiceImpl")
public class ComponentTemplateCustomServiceImpl
implements ComponentTemplateCustomService {
    @Resource
    private ComponentTemplateMapper componentTemplateMapper;
    @Value(value="${report-save-to-server}")
    private String reportSaveToServer;
    @Resource
    private OssFileService ossFileService;
    @Resource
    private ComponentTemplateService componentTemplateService;
    @Resource
    private ExcelReportDataSourceService excelReportDataSourceService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private DataSourceCustomService dataSourceCustomService;
    @Resource
    private ComponentFileLinkCustomService componentFileLinkCustomService;
    @Resource
    private ExcelReportDataSourceService reportDataSourceService;
    private static final Logger logger = LoggerFactory.getLogger(ComponentTemplateCustomServiceImpl.class);
    private static final String RETURN_CODE = "0";

    @Override
    public ApiResponse<Map<String, Object>> saveReportFormCompTemplate(HttpServletRequest request) {
        try {
            HashMap<String, Long> ans = new HashMap<String, Long>();
            String name = request.getParameter("name");
            String code = request.getParameter("code");
            String businessId = request.getParameter("businessId");
            String json = request.getParameter("json");
            Part fpImageZip = request.getPart("imgZipBlob");
            QueryWrapper qw = new QueryWrapper();
            qw.lambda().eq(ReportToolFormComponentTemplate::getName, (Object)name);
            List reportToolFormComponentTemplateList = this.componentTemplateMapper.selectList((Wrapper)qw);
            if (reportToolFormComponentTemplateList != null && !reportToolFormComponentTemplateList.isEmpty()) {
                boolean flag = false;
                for (int i = 0; i < reportToolFormComponentTemplateList.size(); ++i) {
                    if (((ReportToolFormComponentTemplate)reportToolFormComponentTemplateList.get(i)).getId().toString().equals(businessId)) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    return ApiResponse.fail((int)-1, (String)"\u62a5\u8868\u7ec4\u4ef6\u540d\u79f0\u5df2\u5b58\u5728");
                }
            }
            Long newId = IdWorker.getId((Object)new Date());
            ReportToolFormComponentTemplate reportToolFormComponentTemplate = new ReportToolFormComponentTemplate();
            if (businessId.isEmpty()) {
                reportToolFormComponentTemplate.setId(newId);
                reportToolFormComponentTemplate.setCreateId(BaseSecurityUtil.getUser().getId());
                reportToolFormComponentTemplate.setCreateName(BaseSecurityUtil.getUser().getUserName());
                reportToolFormComponentTemplate.setCreateTime(LocalDateTime.now());
                ans.put(ReportStatusEnum.PARAM_BUSINESS_ID.getValue(), newId);
            } else {
                reportToolFormComponentTemplate.setId(Long.valueOf(businessId));
            }
            reportToolFormComponentTemplate.setName(name);
            reportToolFormComponentTemplate.setCode(code);
            String msg = "";
            if (this.reportSaveToServer.equals("true")) {
                Long fileId = this.ossFileService.fileUpload(json, reportToolFormComponentTemplate.getId().toString() + ".json");
                String pathAndName = this.ossFileService.getFilePath(fileId, false);
                reportToolFormComponentTemplate.setTemplatePath(pathAndName);
                reportToolFormComponentTemplate.setTemplateJson("");
                msg = "\u5199\u5165\u81f3\u6587\u4ef6";
            } else {
                reportToolFormComponentTemplate.setTemplateJson(json);
                reportToolFormComponentTemplate.setTemplatePath("");
                msg = "\u5b58\u5165\u6570\u636e\u5e93";
            }
            if (fpImageZip != null) {
                InputStream fis = fpImageZip.getInputStream();
                Long fileImgId = this.ossFileService.fileUpload(fis, reportToolFormComponentTemplate.getId() + ReportStatusEnum.PARAM_PNG.getValue());
                String imgPath = this.ossFileService.getFilePath(fileImgId, false);
                reportToolFormComponentTemplate.setImgPath(imgPath);
            }
            int b = 0;
            b = ObjectUtils.isEmpty((Object)businessId) ? this.componentTemplateMapper.insert(reportToolFormComponentTemplate) : this.componentTemplateMapper.updateById(reportToolFormComponentTemplate);
            if (b > 0) {
                return ApiResponse.success(ans, (String)msg);
            }
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> getReportFormCompTemplateInfo(Map<String, Object> param) {
        try {
            HashMap<String, String> ans = new HashMap<String, String>();
            String compId = param.get("id").toString();
            if (compId.isEmpty()) {
                ans.put(ReportStatusEnum.PARAM_REPORT_JSON.getValue(), "");
                return ApiResponse.success(ans);
            }
            ReportToolFormComponentTemplate reportToolFormComponentTemplate = (ReportToolFormComponentTemplate)this.componentTemplateMapper.selectById(Long.valueOf(compId));
            String templateJson = reportToolFormComponentTemplate.getTemplateJson();
            String templatePath = reportToolFormComponentTemplate.getTemplatePath();
            if (StringUtils.isNotEmpty((CharSequence)templateJson)) {
                ans.put(ReportStatusEnum.PARAM_REPORT_JSON.getValue(), templateJson);
            } else if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
                String json = this.ossFileService.getContent(templatePath);
                json = StringUtil.cleaningHtml((String)json);
                ans.put(ReportStatusEnum.PARAM_REPORT_JSON.getValue(), json);
            }
            return ApiResponse.success(ans);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<List<ReportToolFormComponentTemplate>> getReportFormComponentList(Map<String, Object> param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList reportToolFormComponentTemplateList = this.componentTemplateMapper.selectList((Wrapper)queryWrapper);
        if (reportToolFormComponentTemplateList.size() > 0) {
            for (ReportToolFormComponentTemplate reportToolFormComponentTemplate : reportToolFormComponentTemplateList) {
                String templateJson = reportToolFormComponentTemplate.getTemplateJson();
                String templatePath = reportToolFormComponentTemplate.getTemplatePath();
                if (!templateJson.isEmpty() || templatePath.isEmpty()) continue;
                String json = this.ossFileService.getContent(templatePath);
                json = StringUtil.cleaningHtml((String)json);
                reportToolFormComponentTemplate.setTemplateJson(json);
            }
        } else {
            reportToolFormComponentTemplateList = new ArrayList();
        }
        return ApiResponse.success(reportToolFormComponentTemplateList);
    }

    @Override
    public ApiResponse<ReportToolFormComponentTemplatePageVO> hussarQueryPage(ReportToolFormComponentTemplatePageParamVO paramVO) {
        try {
            Page pager = new Page(paramVO.getCurrent().longValue(), paramVO.getSize().longValue());
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)paramVO.getName())) {
                queryWrapper.like((Object)"name", (Object)paramVO.getName());
            }
            ReportToolFormComponentTemplatePageVO reportFormComponentTemplatePageVO = new ReportToolFormComponentTemplatePageVO();
            List list = ((Page)this.componentTemplateService.page((IPage)pager, (Wrapper)queryWrapper)).getRecords();
            reportFormComponentTemplatePageVO.setData(list);
            reportFormComponentTemplatePageVO.setCount(pager.getTotal());
            reportFormComponentTemplatePageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)reportFormComponentTemplatePageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<Boolean> del(List<String> ids) {
        try {
            return ApiResponse.success((Object)this.componentTemplateService.removeByIds(ids));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public Map<String, Object> dealComponentData(String templateId, List<ReportCellRules> reportCellRules, JSONObject formParam) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> compIdSortMap = this.dealComponentIdSortData(formParam, templateId, reportCellRules);
        if (!compIdSortMap.isEmpty()) {
            HashSet compIdSet = new HashSet();
            HashMap<String, Boolean> gdFlagMap = new HashMap<String, Boolean>();
            HashMap<String, JSONObject> jsonCompIdsMap = new HashMap<String, JSONObject>();
            for (String key : compIdSortMap.keySet()) {
                List<String> compIds = new ArrayList();
                JSONArray jsonArray = new JSONArray();
                boolean gdFlag = false;
                Object value = compIdSortMap.get(key);
                if (value instanceof List) {
                    logger.error("list{}", value);
                    List list = (List)value;
                    boolean arrayFlag = false;
                    if (!list.isEmpty()) {
                        for (Object elem : list) {
                            if (elem instanceof String) continue;
                            arrayFlag = true;
                        }
                    }
                    if (arrayFlag) {
                        logger.error("jsonArray{}", value);
                        gdFlag = true;
                        jsonArray = (JSONArray)compIdSortMap.get(key);
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            String tempId = IdWorker.get32UUID();
                            compIds.add(tempId);
                            JSONObject jsonObj = jsonArray.getJSONObject(i);
                            jsonArray.getJSONObject(i).put("id", (Object)tempId);
                            logger.error("jsonCompIdsMap{}", (Object)jsonObj);
                            jsonCompIdsMap.put(tempId, jsonObj);
                            gdFlagMap.put(tempId, gdFlag);
                        }
                    } else {
                        compIds = (List)value;
                    }
                }
                logger.error("gdFlag{}", (Object)gdFlag);
                compIdSet.addAll(compIds);
                HashMap<String, Serializable> componentTemplate = new HashMap<String, Serializable>();
                componentTemplate.put("isComponent", Boolean.valueOf(true));
                ArrayList coms = new ArrayList();
                for (String compId : compIds) {
                    HashMap<String, Object> comMap = new HashMap<String, Object>();
                    comMap.put("templateId", compId);
                    if (gdFlag) {
                        logger.error("model{}", ((JSONObject)jsonCompIdsMap.get(compId)).get((Object)"model"));
                        comMap.put("model", ((JSONObject)jsonCompIdsMap.get(compId)).get((Object)"model"));
                        logger.error("config{}", ((JSONObject)jsonCompIdsMap.get(compId)).get((Object)"config"));
                        comMap.put("config", ((JSONObject)jsonCompIdsMap.get(compId)).get((Object)"config"));
                    } else {
                        ArrayList<String> dsTypeList = new ArrayList<String>();
                        dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_BASE.getValue());
                        dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_EXTEND.getValue());
                        List reportCompTemplateDataSourceList = this.dataSourceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ReportToolTemplateDataSource::getTemplateId, (Object)compId)).in(ReportToolTemplateDataSource::getBaseExtendType, dsTypeList));
                        Map dataSourceDealResultMap = new HashMap();
                        if (!reportCompTemplateDataSourceList.isEmpty()) {
                            dataSourceDealResultMap = this.reportDataSourceService.dealDataSource(reportCompTemplateDataSourceList, "", formParam, reportCellRules);
                        }
                        comMap.put("model", dataSourceDealResultMap);
                    }
                    coms.add(comMap);
                }
                componentTemplate.put("coms", coms);
                result.put(key, componentTemplate);
            }
            ArrayList comTemplates = new ArrayList();
            for (String compId : compIdSet) {
                HashMap<String, Object> comTemplate = new HashMap<String, Object>();
                comTemplate.put("id", compId);
                if (gdFlagMap.get(compId) != null && ((Boolean)gdFlagMap.get(compId)).booleanValue()) {
                    comTemplate.put("json", ((JSONObject)jsonCompIdsMap.get(compId)).get((Object)"json"));
                    comTemplates.add(comTemplate);
                    continue;
                }
                try {
                    ReportToolFormComponentTemplate reportToolFormComponentTemplate = (ReportToolFormComponentTemplate)this.componentTemplateService.getById(Long.valueOf(Long.parseLong(compId)));
                    String componentTemplateJson = "";
                    if (StringUtils.isNotEmpty((CharSequence)reportToolFormComponentTemplate.getTemplateJson())) {
                        componentTemplateJson = reportToolFormComponentTemplate.getTemplateJson();
                    } else if (StringUtils.isNotEmpty((CharSequence)reportToolFormComponentTemplate.getTemplatePath())) {
                        String json = this.ossFileService.getContent(reportToolFormComponentTemplate.getTemplatePath());
                        componentTemplateJson = StringUtil.cleaningHtml((String)json);
                    }
                    comTemplate.put("json", componentTemplateJson);
                    comTemplates.add(comTemplate);
                }
                catch (Exception e) {
                    result.put("errorMsg", "\u7ec4\u4ef6\u3010ID\uff1a" + compId + "\u3011\u4e0d\u5b58\u5728");
                }
            }
            result.put("comTemplates", comTemplates);
        }
        return result;
    }

    @Override
    public Map<String, Object> dealDynamicRCCompData(String templateId, List<ReportCellRules> reportCellRules, JSONObject formParam) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> dsTypeList = new ArrayList<String>();
        dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_DYNAMICRCCOMP.getValue());
        List ReportToolTemplateDataSourceList = this.excelReportDataSourceService.getListByTemplateIdAndTypes(templateId, dsTypeList);
        if (!ReportToolTemplateDataSourceList.isEmpty()) {
            HashMap<String, JSONObject> dynamicRCCompRangeMap = new HashMap<String, JSONObject>();
            for (int i = 0; i < ReportToolTemplateDataSourceList.size(); ++i) {
                ReportToolTemplateDataSource ReportToolTemplateDataSource2 = (ReportToolTemplateDataSource)ReportToolTemplateDataSourceList.get(i);
                String dsName = ReportToolTemplateDataSource2.getName();
                if (ReportToolTemplateDataSource2.getDynamicRcCompRange() == null || ReportToolTemplateDataSource2.getDynamicRcCompRange().isEmpty()) {
                    dynamicRCCompRangeMap.put(dsName, null);
                    continue;
                }
                JSONObject range = JSONObject.parseObject((String)ReportToolTemplateDataSource2.getDynamicRcCompRange());
                dynamicRCCompRangeMap.put(dsName, range);
            }
            Map dataMap = this.reportDataSourceService.dealDataSource(ReportToolTemplateDataSourceList, "", formParam, reportCellRules);
            for (String key : dataMap.keySet()) {
                HashMap<String, Boolean> dynamicRCCompMap = new HashMap<String, Boolean>();
                dynamicRCCompMap.put("isExtendComp", true);
                dynamicRCCompMap.put("range", (Boolean)dynamicRCCompRangeMap.get(key));
                dynamicRCCompMap.put("data", (Boolean)dataMap.get(key));
                result.put(key, dynamicRCCompMap);
            }
        }
        return result;
    }

    public Map<String, Object> dealComponentIdSortData(JSONObject formParam, String templateId, List<ReportCellRules> reportCellRules) {
        Map<String, Object> componentIdSortMap = new HashMap<String, Object>();
        ArrayList<String> dsTypeList = new ArrayList<String>();
        dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_COMP_INSERT_POINT.getValue());
        List reportToolTemplateDataSourceList = this.excelReportDataSourceService.getListByTemplateIdAndTypes(templateId, dsTypeList);
        if (!reportToolTemplateDataSourceList.isEmpty()) {
            Map dataMap = this.reportDataSourceService.dealDataSource(reportToolTemplateDataSourceList, "", formParam, reportCellRules);
            System.out.println("--------------");
            System.out.println(dataMap);
            componentIdSortMap = dataMap;
        }
        return componentIdSortMap;
    }

    @Override
    public Long addEmptyFormTemplateComponent(String name) {
        Long id = IdWorker.getId((Object)new Date());
        String jsonData = InitDataUtil.initJsonData();
        ReportToolFormComponentTemplate reportToolFormComponentTemplate = new ReportToolFormComponentTemplate();
        reportToolFormComponentTemplate.setId(id);
        reportToolFormComponentTemplate.setName(StringUtils.isNotBlank((CharSequence)name) ? name : "\u65e0\u6807\u9898\u6587\u6863");
        reportToolFormComponentTemplate.setCreateId(BaseSecurityUtil.getUser().getId());
        reportToolFormComponentTemplate.setCreateName(BaseSecurityUtil.getUser().getUserName());
        reportToolFormComponentTemplate.setCreateTime(LocalDateTime.now());
        reportToolFormComponentTemplate.setCode(DateUtils.hexTimestamp());
        this.fileIsDb(reportToolFormComponentTemplate, jsonData);
        this.componentTemplateService.save(reportToolFormComponentTemplate);
        return reportToolFormComponentTemplate.getId();
    }

    @Override
    public ApiResponse<ReportToolFromComponentTemplateBaseVo> copyReportFormCompTemplate(String templateComponentId) {
        ReportToolFromComponentTemplateBaseVo result = new ReportToolFromComponentTemplateBaseVo();
        ReportToolFormComponentTemplate componentTemplate = (ReportToolFormComponentTemplate)this.componentTemplateService.getById((Serializable)((Object)templateComponentId));
        if (componentTemplate == null) {
            return ApiResponse.fail((String)ResultEnum.RETURN_DB_DATA_NULL_TEMPLATE_COMPONENT_ERROR.getDescription());
        }
        Long id = IdWorker.getId((Object)new Date());
        componentTemplate.setId(id);
        componentTemplate.setCode(DateUtils.hexTimestamp());
        componentTemplate.setCreateId(BaseSecurityUtil.getUser().getId());
        componentTemplate.setCreateName(BaseSecurityUtil.getUser().getUserName());
        componentTemplate.setCreateTime(LocalDateTime.now());
        String templateJson = componentTemplate.getTemplateJson();
        String templatePath = componentTemplate.getTemplatePath();
        if (com.jxdinfo.hussar.platform.core.utils.StringUtil.isNotEmpty((Object)templatePath)) {
            templateJson = this.ossFileService.getContent(templatePath);
            templateJson = StringUtil.cleaningHtml((String)templateJson);
        }
        this.fileIsDb(componentTemplate, templateJson);
        if (this.componentTemplateService.save(componentTemplate)) {
            List reportToolTemplateDataSourceList = this.dataSourceCustomService.getListByBusinessId(templateComponentId);
            this.dataSourceCustomService.copyByBusinessId(componentTemplate.getId().toString(), reportToolTemplateDataSourceList);
            List<ComponentAttachmentFileLink> componentAttachmentFileLinkList = this.componentFileLinkCustomService.getListByBusinessId(templateComponentId);
            this.componentFileLinkCustomService.copyByBusinessId(componentTemplate.getId().toString(), componentAttachmentFileLinkList);
        }
        result.setTemplateComponentId(componentTemplate.getId().toString());
        return ApiResponse.success((Object)result);
    }

    @Override
    public ReportToolFormComponentTemplate getReportFormCompTemplateInfo(String templateComponentId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)templateComponentId)) {
            return new ReportToolFormComponentTemplate();
        }
        ReportToolFormComponentTemplate componentTemplate = (ReportToolFormComponentTemplate)this.componentTemplateService.getById((Serializable)((Object)templateComponentId));
        if (componentTemplate == null) {
            return new ReportToolFormComponentTemplate();
        }
        String templatePath = componentTemplate.getTemplatePath();
        if (StringUtils.isNotEmpty((CharSequence)templatePath)) {
            String templateJson = this.ossFileService.getContent(templatePath);
            templateJson = StringUtil.cleaningHtml((String)templateJson);
            componentTemplate.setTemplateJson(templateJson);
        }
        return componentTemplate;
    }

    @Override
    public ReportToolFromComponentTemplateConfigVo getReportFormCompTemplateConfig(String templateComponentId) {
        ReportToolFromComponentTemplateConfigVo result = new ReportToolFromComponentTemplateConfigVo();
        List reportToolTemplateDataSourceList = this.dataSourceCustomService.getListByBusinessId(templateComponentId);
        List<ComponentAttachmentFileLink> componentAttachmentFileLinkList = this.componentFileLinkCustomService.getListByBusinessId(templateComponentId);
        result.setDataSourceList(reportToolTemplateDataSourceList);
        result.setAttachmentFileLinkList(componentAttachmentFileLinkList);
        return result;
    }

    private void fileIsDb(ReportToolFormComponentTemplate componentTemplate, String templateJson) {
        if (this.reportSaveToServer.equals("true")) {
            Long fileId = this.ossFileService.fileUpload(templateJson, componentTemplate.getId().toString());
            componentTemplate.setTemplatePath(this.ossFileService.getFilePath(fileId, false));
            componentTemplate.setTemplateJson("");
        } else {
            componentTemplate.setTemplateJson(templateJson);
            componentTemplate.setTemplatePath("");
        }
    }
}

