/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.instance.instance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.document.excel.tools.common.datasource.model.ReportToolTemplateDataSource;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceService;
import com.jxdinfo.document.excel.tools.common.datasource.service.ExcelReportDataSourceService;
import com.jxdinfo.document.excel.tools.common.file.service.OssFileService;
import com.jxdinfo.document.excel.tools.common.reportcellrules.service.ReportCellRulesService;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ReportStatusEnum;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ResultEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.DateUtils;
import com.jxdinfo.document.excel.tools.core.common.utils.InitDataUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.LoadLsDataUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.reportToolThreadPool.ReportFormThreadPool;
import com.jxdinfo.document.excel.tools.report.external.service.WordExcelCommonService;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.model.ReportToolInstanceAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.service.InstanceFileLinkCustomService;
import com.jxdinfo.document.excel.tools.report.instance.instance.dao.ReportToolFormInstanceMapper;
import com.jxdinfo.document.excel.tools.report.instance.instance.model.ReportToolFormInstance;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceCustomService;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceService;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceUtilService;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.CopyReportInfoParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.GenerateReportConstructParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.GenerateReportConstructResultVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.GenerateReportParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.GenerateReportResultVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.MongoQueryBaseParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.MongoQueryJsonObjectParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.MongoQueryParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.ReportToolFormBaseParamVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.ReportToolFormInstanceBaseVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.ReportToolFormInstanceConfigVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.ReportToolFormInstanceQueryResultVo;
import com.jxdinfo.document.excel.tools.report.instance.instance.vo.SaveReportInfoParamVo;
import com.jxdinfo.document.excel.tools.report.mongo.model.ReportToolFormLsBorderInfo;
import com.jxdinfo.document.excel.tools.report.mongo.model.ReportToolFormLsCellData;
import com.jxdinfo.document.excel.tools.report.mongo.model.ReportToolFormLsOtherData;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsBorderInfoService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsCellDataService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFormLsOtherDataService;
import com.jxdinfo.document.excel.tools.report.mongo.service.ReportToolFromMongoService;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.model.ReportToolTemplateAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.service.TemplateFileLinkCustomService;
import com.jxdinfo.document.excel.tools.report.template.component.component.service.ComponentTemplateCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.model.ReportToolFormTemplate;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Primary
@Service(value="excel.tools.report.instance.instance.service.impl.ReportToolFormInstanceCustomServiceImpl")
@HussarDs(value="master")
public class ReportToolFormInstanceCustomServiceImpl
implements ReportToolFormInstanceCustomService {
    @Value(value="${report-save-to-server}")
    private String reportSaveToServer;
    private static final Logger logger = LoggerFactory.getLogger(ReportToolFormInstanceCustomServiceImpl.class);
    @Autowired
    private ReportToolFormInstanceMapper reportToolFormInstanceMapper;
    @Autowired
    private ReportToolFormInstanceService reportToolFormInstanceService;
    @Autowired
    private ReportToolFromMongoService reportToolFromMongoService;
    @Autowired
    private ReportToolFormTemplateService reportToolFormTemplateService;
    @Autowired
    private ReportToolFormTemplateCustomService reportToolFormTemplateCustomService;
    @Autowired
    private ReportCellRulesService reportCellRulesService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private ExcelReportDataSourceService reportDataSourceService;
    @Autowired
    private ComponentTemplateCustomService componentTemplateCustomService;
    @Autowired
    private OssFileService ossFileService;
    @Autowired
    private InstanceFileLinkCustomService instanceFileLinkCustomService;
    @Autowired
    private TemplateFileLinkCustomService templateFileLinkCustomService;
    @Autowired
    private ReportToolFormLsOtherDataService lsOtherDataService;
    @Autowired
    private ReportToolFormLsCellDataService lsCellDataService;
    @Autowired
    private ReportToolFormLsBorderInfoService lsBorderInfoService;
    @Autowired
    private ReportToolFormInstanceUtilService reportToolFormInstanceUtilService;
    @Autowired
    private WordExcelCommonService wordExcelCommonService;
    private String configData = null;

    private Boolean isReportSaveToServer() {
        String serverFlag = String.valueOf(this.reportSaveToServer);
        return serverFlag.equals(ReportStatusEnum.TRUE_STRING.getValue());
    }

    private void setReportJson(String json, ReportToolFormInstance reportToolFormInstance) {
        String reportId = String.valueOf(reportToolFormInstance.getId());
        if (this.isReportSaveToServer().booleanValue()) {
            Long fileId = this.ossFileService.fileUpload(json, reportToolFormInstance.getId().toString() + "." + "json");
            reportToolFormInstance.setReportPath(this.ossFileService.getFilePath(fileId, false));
            reportToolFormInstance.setReportData("");
        } else {
            JSONArray jsonData;
            Object reportObj = ZipUtil.unZipReport((String)json);
            if (reportObj == null) {
                logger.error("reportObj is null  \u6a21\u677f\u7684\u89e3\u6790\u6709\u95ee\u9898");
                return;
            }
            JSONArray jSONArray = jsonData = reportObj instanceof JSONObject ? new JSONArray().fluentAdd(reportObj) : (JSONArray)reportObj;
            if (jsonData == null) {
                return;
            }
            this.reportToolFormInstanceUtilService.configDataReplace(this.configData, jsonData);
            StopWatch queryWatch = new StopWatch();
            queryWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u67e5\u8be2Mongo celldata\uff0creportId={}", (Object)reportId);
            ThreadPoolTaskExecutor taskExecutor = ReportFormThreadPool.reportToolTemplateSheetThreadPool();
            CompletableFuture<Map> cellDataFuture = CompletableFuture.supplyAsync(() -> {
                Map<String, Object> cellData = this.lsCellDataService.getLsCellDataByGridKey(reportId);
                int dataSize = cellData == null ? 0 : cellData.size();
                logger.info("report-tool-logger-Mongo celldata\u67e5\u8be2\u5b8c\u6210\uff0creportId={}\uff0c\u8fd4\u56desheet\u6570\u91cf={}", (Object)reportId, (Object)dataSize);
                return cellData;
            }, (Executor)taskExecutor);
            Map cellDataRes = cellDataFuture.join();
            queryWatch.stop();
            logger.info("report-tool-logger-Mongo celldata\u67e5\u8be2\u603b\u8017\u65f6={}ms\uff0creportId={}", (Object)queryWatch.getTotalTimeMillis(), (Object)reportId);
            StopWatch borderDelWatch = new StopWatch();
            borderDelWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u5220\u9664Mongo borderInfo\uff0creportId={}", (Object)reportId);
            this.lsBorderInfoService.deleteLsBorderInfoByGridKey(reportId);
            borderDelWatch.stop();
            logger.info("report-tool-logger-Mongo borderInfo\u5220\u9664\u5b8c\u6210\uff0creportId={}\uff0c\u8017\u65f6={}ms", (Object)reportId, (Object)borderDelWatch.getTotalTimeMillis());
            StopWatch cellDelWatch = new StopWatch();
            cellDelWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u5220\u9664Mongo celldata\uff0creportId={}", (Object)reportId);
            this.lsCellDataService.deleteLsCellDataByGridKey(reportId);
            cellDelWatch.stop();
            logger.info("report-tool-logger-Mongo celldata\u5220\u9664\u5b8c\u6210\uff0creportId={}\uff0c\u8017\u65f6={}ms", (Object)reportId, (Object)cellDelWatch.getTotalTimeMillis());
            StopWatch lsOtherDelWatch = new StopWatch();
            lsOtherDelWatch.start();
            logger.info("report-tool-logger-\u5f00\u59cb\u5220\u9664Mongo otherData\uff0creportId={}", (Object)reportId);
            this.lsOtherDataService.deleteLsOtherDataByGridKey(reportId);
            lsOtherDelWatch.stop();
            logger.info("report-tool-logger-Mongo otherData\u5220\u9664\u5b8c\u6210\uff0creportId={}\uff0c\u8017\u65f6={}ms", (Object)reportId, (Object)lsOtherDelWatch.getTotalTimeMillis());
            for (int i = 0; i < jsonData.size(); ++i) {
                StopWatch stopIndexWatch = new StopWatch();
                stopIndexWatch.start();
                JSONObject sheet = jsonData.getJSONObject(i);
                String sheetIndex = sheet.getString("index");
                logger.info("report-tool-logger-\u5f00\u59cb\u5904\u7406sheet\uff0creportId={}\uff0csheetIndex={}", (Object)reportId, (Object)sheetIndex);
                try {
                    JSONArray celldata = sheet.getJSONArray("celldata");
                    if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)celldata)) {
                        celldata = (JSONArray)cellDataRes.get(sheetIndex);
                    }
                    sheet.remove((Object)"celldata");
                    JSONArray borderInfo = null;
                    if (sheet.containsKey((Object)"config") && sheet.getJSONObject("config").containsKey((Object)"borderInfo")) {
                        borderInfo = sheet.getJSONObject("config").getJSONArray("borderInfo");
                        sheet.getJSONObject("config").remove((Object)"borderInfo");
                    }
                    sheet.remove((Object)"load");
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)celldata)) {
                        this.reportToolFromMongoService.saveCellData(reportId, celldata, sheetIndex);
                    }
                    this.reportToolFromMongoService.saveBorderInfoData(reportId, borderInfo, sheetIndex);
                    this.reportToolFromMongoService.saveLsOtherData(reportId, sheetIndex, sheet);
                    stopIndexWatch.stop();
                    logger.info("report-tool-logger-sheet\u5904\u7406\u5b8c\u6210\uff0creportId={}\uff0csheetIndex={}\uff0c\u8017\u65f6={}ms", new Object[]{reportId, sheetIndex, stopIndexWatch.getTotalTimeMillis()});
                    continue;
                }
                catch (Exception e) {
                    stopIndexWatch.stop();
                    logger.error("report-tool-logger-sheet\u5904\u7406\u5931\u8d25\uff0creportId={}\uff0csheetIndex={}\uff0c\u8017\u65f6={}ms\uff0c\u9519\u8bef={}", new Object[]{reportId, sheetIndex, stopIndexWatch.getTotalTimeMillis(), e.getMessage(), e});
                }
            }
            reportToolFormInstance.setReportData("");
            reportToolFormInstance.setReportPath("");
        }
    }

    @Override
    public ApiResponse<ReportToolFormInstanceQueryResultVo> getReportInfo(ReportToolFormBaseParamVo reportToolFormBaseParamVo) {
        ReportToolFormInstanceQueryResultVo resultVo = new ReportToolFormInstanceQueryResultVo();
        String reportId = reportToolFormBaseParamVo.getReportId();
        if (reportId.isEmpty()) {
            resultVo.setJson("");
            return ApiResponse.success((Object)resultVo);
        }
        ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceService.getById((Serializable)((Object)reportId));
        if (reportToolFormInstance == null) {
            return ApiResponse.fail((String)ResultEnum.RETURN_DB_DATA_NULL_REPORT_ERROR.getDescription());
        }
        String multiSheetFlag = reportToolFormInstance.getMultiSheetFlag();
        resultVo.setMultiSheetFlag(multiSheetFlag);
        String reportJson = reportToolFormInstance.getReportData();
        String reportPath = reportToolFormInstance.getReportPath();
        if (StringUtils.isNotEmpty((CharSequence)reportPath)) {
            resultVo.setJson(this.ossFileService.getContent(reportPath));
        } else if (StringUtils.isNotEmpty((CharSequence)reportJson)) {
            resultVo.setJson(reportJson);
        }
        resultVo.setPreData(reportToolFormInstance.getPreData());
        return ApiResponse.success((Object)resultVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<ReportToolFormInstanceBaseVo> saveReportInfo(SaveReportInfoParamVo saveReportInfoParamVo) {
        ReportToolFormInstanceBaseVo resultVo = new ReportToolFormInstanceBaseVo();
        String reportId = saveReportInfoParamVo.getReportId();
        String reportJson = saveReportInfoParamVo.getJson();
        String multiSheetFlag = saveReportInfoParamVo.getMultiSheetFlag();
        Boolean reportSaveToServer = this.isReportSaveToServer();
        String string = reportId.intern();
        synchronized (string) {
            ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceService.getById((Serializable)((Object)reportId));
            if (reportToolFormInstance == null) {
                return ApiResponse.fail((String)ResultEnum.RETURN_DB_DATA_NULL_REPORT_ERROR.getDescription());
            }
            reportToolFormInstance.setMultiSheetFlag(multiSheetFlag);
            this.setReportJson(reportJson, reportToolFormInstance);
            boolean b = this.reportToolFormInstanceService.saveOrUpdate(reportToolFormInstance);
            if (b) {
                resultVo.setReportId(reportId);
                resultVo.setBusinessId(reportToolFormInstance.getBusinessId());
                this.wordExcelCommonService.updateDocumentByReport(reportId, null, saveReportInfoParamVo.getGroupId());
                return ApiResponse.success((Object)resultVo, (String)(reportSaveToServer != false ? ResultEnum.RETURN_SAVE_FILE_DATA_SUCCESS.getDescription() : ResultEnum.RETURN_SAVE_MONGO_DATA_SUCCESS.getDescription()));
            }
            return ApiResponse.fail((String)ResultEnum.RETURN_SAVE_ERROR.getDescription());
        }
    }

    @Override
    public ApiResponse<GenerateReportResultVo> generateReport(GenerateReportParamVo reportVo) {
        try {
            JSONObject nPreData;
            String multiSheetFlag;
            String templateJson;
            ReportToolFormTemplate reportToolFormTemplate;
            GenerateReportResultVo resultVo = new GenerateReportResultVo();
            String templateId = reportVo.getTemplateId();
            String reportId = reportVo.getReportId();
            String businessId = reportVo.getBusinessId();
            this.configData = reportVo.getConfigData();
            JSONObject formParam = JSONObject.parseObject((String)JSONObject.toJSONString(reportVo.getFormParam()));
            String msg = "";
            SecurityUser user = BaseSecurityUtil.getUser();
            ReportToolFormInstance reportToolFormInstance = new ReportToolFormInstance();
            if (StringUtils.isNotEmpty((CharSequence)reportId)) {
                reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceService.getById((Serializable)((Object)reportId));
                if (reportToolFormInstance == null) {
                    return ApiResponse.fail((String)"\u672a\u627e\u5230\u8be5\u62a5\u544a");
                }
                if (StringUtils.isBlank((CharSequence)templateId)) {
                    templateId = String.valueOf(reportToolFormInstance.getTemplateId());
                }
                reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateService.getById((Serializable)((Object)templateId));
                templateJson = this.reportToolFormTemplateCustomService.reportFormLoadUrlStrIsInstance(templateId);
                multiSheetFlag = reportToolFormTemplate.getMultiSheetFlag();
                this.instanceFileLinkCustomService.deleteByReportId(reportId);
                List<ReportToolTemplateAttachmentFileLink> reportTempAttachmentFileLinkList = this.templateFileLinkCustomService.getListByBusinessId(Long.valueOf(templateId));
                this.instanceFileLinkCustomService.saveByReportIdAndTemplateFiles(reportId, reportTempAttachmentFileLinkList);
                this.setReportJson(templateJson, reportToolFormInstance);
            } else {
                reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateService.getById((Serializable)((Object)templateId));
                templateJson = this.reportToolFormTemplateCustomService.reportFormLoadUrlStrIsInstance(templateId);
                multiSheetFlag = reportToolFormTemplate.getMultiSheetFlag();
                reportToolFormInstance.setId(IdWorker.getId((Object)new Date()));
                reportId = String.valueOf(reportToolFormInstance.getId());
                long count = this.reportToolFormInstanceService.count();
                reportToolFormInstance.setReportNo("REPORT-" + DateUtils.getNowYear() + "-" + count);
                List<ReportToolTemplateAttachmentFileLink> reportTempAttachmentFileLinkList = this.templateFileLinkCustomService.getListByBusinessId(Long.valueOf(templateId));
                this.instanceFileLinkCustomService.saveByReportIdAndTemplateFiles(reportId, reportTempAttachmentFileLinkList);
                this.setReportJson(templateJson, reportToolFormInstance);
            }
            List reportCellRules = this.reportCellRulesService.getListByBusinessId(templateId);
            ArrayList<String> dsTypeList = new ArrayList<String>();
            dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_BASE.getValue());
            dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_EXTEND.getValue());
            List reportToolTemplateDataSourceList = this.dataSourceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ReportToolTemplateDataSource::getTemplateId, (Object)templateId)).in(ReportToolTemplateDataSource::getBaseExtendType, dsTypeList));
            if (!reportToolTemplateDataSourceList.isEmpty()) {
                Map dataMap = this.reportDataSourceService.dealDataSource(reportToolTemplateDataSourceList, msg, formParam, reportCellRules);
                reportToolFormInstance.setPreData(JSONObject.toJSONString((Object)dataMap));
            }
            if (reportToolFormTemplate.getOpenComponentInsert() != null && reportToolFormTemplate.getOpenComponentInsert().equals("1")) {
                Map<String, Object> componentDataMap = this.componentTemplateCustomService.dealComponentData(templateId, reportCellRules, formParam);
                if (componentDataMap.containsKey("errorMsg")) {
                    return ApiResponse.fail((int)10003, (String)componentDataMap.get("errorMsg").toString());
                }
                if (ObjectUtils.isNotEmpty((Object)componentDataMap.get("comTemplates"))) {
                    if (ObjectUtils.isNotEmpty((Object)reportToolFormInstance.getPreData())) {
                        nPreData = (JSONObject)JSON.parse((String)reportToolFormInstance.getPreData());
                        for (String key : componentDataMap.keySet()) {
                            nPreData.put(key, componentDataMap.get(key));
                        }
                        reportToolFormInstance.setPreData(JSON.toJSONString((Object)nPreData));
                    } else {
                        reportToolFormInstance.setPreData(JSON.toJSONString(componentDataMap));
                    }
                }
            }
            Map<String, Object> dynamicRCCompData = this.componentTemplateCustomService.dealDynamicRCCompData(templateId, reportCellRules, formParam);
            if (ObjectUtils.isNotEmpty((Object)reportToolFormInstance.getPreData())) {
                nPreData = (JSONObject)JSON.parse((String)reportToolFormInstance.getPreData());
                for (String key : dynamicRCCompData.keySet()) {
                    nPreData.put(key, dynamicRCCompData.get(key));
                }
                reportToolFormInstance.setPreData(JSON.toJSONString((Object)nPreData));
            } else {
                reportToolFormInstance.setPreData(JSON.toJSONString(dynamicRCCompData));
            }
            if (StringUtils.isEmpty((CharSequence)businessId)) {
                businessId = String.valueOf(IdWorker.getId((Object)new Date()));
            }
            reportToolFormInstance.setBusinessId(businessId);
            reportToolFormInstance.setTemplateId(Long.valueOf(templateId));
            reportToolFormInstance.setCreateId(user.getUserId());
            reportToolFormInstance.setCreateName(user.getUserName());
            LocalDateTime now = LocalDateTime.now();
            reportToolFormInstance.setCreateTime(now);
            reportToolFormInstance.setMultiSheetFlag(multiSheetFlag);
            boolean b = this.reportToolFormInstanceService.saveOrUpdate(reportToolFormInstance);
            if (b) {
                resultVo.setTemplateId(templateId);
                resultVo.setBusinessId(businessId);
                resultVo.setReportId(reportId);
                this.wordExcelCommonService.updateDocumentByReport(reportId, reportToolFormTemplate.getName(), reportVo.getGroupId());
                return ApiResponse.success((Object)resultVo);
            }
            return ApiResponse.fail((String)"\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("generateReport error", (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<ReportToolFormInstanceBaseVo> copyReportInfo(CopyReportInfoParamVo copyReportInfo) {
        ReportToolFormInstanceBaseVo result = new ReportToolFormInstanceBaseVo();
        ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceService.getById((Serializable)((Object)copyReportInfo.getOldReportId()));
        if (reportToolFormInstance == null) {
            return ApiResponse.fail((String)ResultEnum.RETURN_DB_DATA_NULL_REPORT_ERROR.getDescription());
        }
        String newReportId = copyReportInfo.getNewReportId();
        Long id = StringUtils.isEmpty((CharSequence)newReportId) ? IdWorker.getId((Object)new Date()) : Long.parseLong(newReportId);
        SecurityUser user = BaseSecurityUtil.getUser();
        reportToolFormInstance.setId(id);
        reportToolFormInstance.setBusinessId(copyReportInfo.getBusinessId());
        String reportPath = reportToolFormInstance.getReportPath();
        if (com.jxdinfo.hussar.platform.core.utils.StringUtil.isNotEmpty((Object)reportPath)) {
            String jsonData = this.ossFileService.getContent(reportPath);
            this.setReportJson(jsonData, reportToolFormInstance);
        }
        long count = this.reportToolFormInstanceService.count();
        reportToolFormInstance.setReportNo("REPORT-" + DateUtils.getNowYear() + "-" + count);
        reportToolFormInstance.setCreateId(user.getUserId());
        reportToolFormInstance.setCreateName(user.getUserName());
        reportToolFormInstance.setCreateTime(LocalDateTime.now());
        this.reportToolFormInstanceService.saveOrUpdate(reportToolFormInstance);
        List<ReportToolInstanceAttachmentFileLink> reportToolInstanceAttachmentFileLinks = this.instanceFileLinkCustomService.getListByReportId(copyReportInfo.getOldReportId());
        this.instanceFileLinkCustomService.saveOrUpdateByBusinessIdCopy(String.valueOf(id), reportToolInstanceAttachmentFileLinks);
        if (reportToolFormInstance.getReportData().isEmpty() && reportToolFormInstance.getReportPath().isEmpty()) {
            ExecutorService executorService = Executors.newFixedThreadPool(3);
            CountDownLatch latch = new CountDownLatch(3);
            executorService.submit(() -> {
                List<ReportToolFormLsOtherData> lsOtherDataList = this.lsOtherDataService.getLsOtherDataListByGridKey(copyReportInfo.getOldReportId());
                for (ReportToolFormLsOtherData lsOtherData : lsOtherDataList) {
                    lsOtherData.setId("");
                    this.reportToolFromMongoService.saveLsOtherData(String.valueOf(id), lsOtherData.getSheetIndex(), lsOtherData.getOtherData());
                }
                latch.countDown();
            });
            executorService.submit(() -> {
                List<ReportToolFormLsCellData> lsCellDataList = this.lsCellDataService.getLsCellDataListByGridKey(copyReportInfo.getOldReportId());
                for (ReportToolFormLsCellData lsCellData : lsCellDataList) {
                    lsCellData.setId("");
                    this.reportToolFromMongoService.saveCellData(String.valueOf(id), lsCellData.getCelldata(), lsCellData.getSheetIndex());
                }
                latch.countDown();
            });
            executorService.submit(() -> {
                List<ReportToolFormLsBorderInfo> lsBorderInfoList = this.lsBorderInfoService.getLsBorderInfoListByGridKey(copyReportInfo.getOldReportId());
                for (ReportToolFormLsBorderInfo lsBorderInfo : lsBorderInfoList) {
                    lsBorderInfo.setId("");
                    this.reportToolFromMongoService.saveBorderInfoData(String.valueOf(id), lsBorderInfo.getBorderInfo(), lsBorderInfo.getSheetIndex());
                }
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("generateReport mongo \u6570\u636e\u5904\u7406 error  ", (Throwable)e);
            }
            finally {
                executorService.shutdown();
            }
        }
        result.setReportId(String.valueOf(id));
        result.setBusinessId(copyReportInfo.getBusinessId());
        return ApiResponse.success((Object)result);
    }

    @Override
    public Long addEmptyFormReport() {
        Long id = IdWorker.getId((Object)new Date());
        String jsonData = InitDataUtil.initJsonData();
        ReportToolFormInstance reportToolFormInstance = new ReportToolFormInstance();
        reportToolFormInstance.setId(id);
        reportToolFormInstance.setCreateTime(LocalDateTime.now());
        reportToolFormInstance.setCreateId(BaseSecurityUtil.getUser().getId());
        reportToolFormInstance.setCreateName(BaseSecurityUtil.getUser().getUserName());
        long count = this.reportToolFormInstanceService.count();
        reportToolFormInstance.setReportNo("REPORT-" + DateUtils.getNowYear() + "-" + count);
        this.setReportJson(jsonData, reportToolFormInstance);
        this.reportToolFormInstanceMapper.insert(reportToolFormInstance);
        return reportToolFormInstance.getId();
    }

    @Override
    public JSONArray reportFormLoadUrlJson(MongoQueryBaseParamVo param) {
        String reportPath;
        String businessId = param.getGridKey();
        JSONArray resJson = null;
        ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceMapper.selectById((Serializable)((Object)businessId));
        String jsonStr = "";
        if (reportToolFormInstance != null && StringUtils.isNotEmpty((CharSequence)(reportPath = reportToolFormInstance.getReportPath()))) {
            jsonStr = this.ossFileService.getContent(reportPath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            if (nSheets != null) {
                resJson = LoadLsDataUtil.lsLoadUrlJson((JSONArray)nSheets);
            }
        } else {
            JSONObject lsSheetsRes = this.lsOtherDataService.getLsOtherDataByGridKey(businessId);
            JSONArray lsSheets = lsSheetsRes.getJSONArray("allSheets");
            int currentSheetIndex = lsSheetsRes.getIntValue("currentSheetIndex");
            JSONObject currentSheet = lsSheets.getJSONObject(currentSheetIndex);
            JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, currentSheet.getString("index"));
            currentSheet.put("celldata", (Object)celldata);
            ExecutorService executorService = Executors.newFixedThreadPool(lsSheets.size());
            CountDownLatch latch = new CountDownLatch(lsSheets.size());
            int i = 0;
            while (i < lsSheets.size()) {
                int finalI = i++;
                executorService.submit(() -> {
                    JSONObject sheet = lsSheets.getJSONObject(finalI);
                    JSONArray borderInfo = this.lsBorderInfoService.getLsBorderInfoByGridKeyAndSheetIndex(businessId, sheet.getString("index"));
                    if (borderInfo != null && borderInfo.size() > 0) {
                        if (!sheet.containsKey((Object)"config")) {
                            sheet.put("config", (Object)new JSONObject());
                        }
                        sheet.getJSONObject("config").put("borderInfo", (Object)borderInfo);
                    }
                    latch.countDown();
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("JSONArray reportFormLoadUrlJson borderInfo \u7ebf\u7a0b\u6c60\u5f02\u5e38", (Throwable)e);
            }
            executorService.shutdown();
            resJson = lsSheets;
        }
        return resJson;
    }

    @Override
    public JSONObject reportFormLoadSheetUrlJson(MongoQueryJsonObjectParamVo param) {
        String reportPath;
        String businessId = param.getGridKey();
        String index = param.getIndex();
        JSONObject resJson = null;
        ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceMapper.selectById((Serializable)((Object)businessId));
        String jsonStr = "";
        if (reportToolFormInstance != null && StringUtils.isNotEmpty((CharSequence)(reportPath = reportToolFormInstance.getReportPath()))) {
            jsonStr = this.ossFileService.getContent(reportPath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        if (!jsonStr.isEmpty()) {
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            resJson = LoadLsDataUtil.lsLoadSheetUrlJson((JSONArray)nSheets, (String)index);
        } else {
            JSONObject resObj = new JSONObject();
            String[] indexArr = index.split(",");
            logger.info("----indexArr----{}", (Object)indexArr.length);
            for (int i = 0; i < indexArr.length; ++i) {
                JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, indexArr[i]);
                resObj.put(indexArr[i], (Object)celldata);
            }
            resJson = resObj;
        }
        return resJson;
    }

    @Override
    public String reportFormLoadUrlStr(MongoQueryBaseParamVo param) {
        String reportPath;
        String businessId = param.getGridKey();
        String resStr = null;
        ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceMapper.selectById((Serializable)((Object)businessId));
        String jsonStr = "";
        if (reportToolFormInstance != null && StringUtils.isNotEmpty((CharSequence)(reportPath = reportToolFormInstance.getReportPath()))) {
            jsonStr = this.ossFileService.getContent(reportPath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        if (!jsonStr.isEmpty()) {
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            if (nSheets != null) {
                resStr = LoadLsDataUtil.lsLoadUrlStr((JSONArray)nSheets);
            }
        } else {
            JSONObject lsSheetsRes = this.lsOtherDataService.getLsOtherDataByGridKey(businessId);
            JSONArray lsSheets = lsSheetsRes.getJSONArray("allSheets");
            int currentSheetIndex = lsSheetsRes.getIntValue("currentSheetIndex");
            JSONObject currentSheet = lsSheets.getJSONObject(currentSheetIndex);
            JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, currentSheet.getString("index"));
            currentSheet.put("celldata", (Object)celldata);
            ExecutorService executorService = Executors.newFixedThreadPool(lsSheets.size());
            CountDownLatch latch = new CountDownLatch(lsSheets.size());
            int i = 0;
            while (i < lsSheets.size()) {
                int finalI = i++;
                executorService.submit(() -> {
                    JSONObject sheet = lsSheets.getJSONObject(finalI);
                    JSONArray borderInfo = this.lsBorderInfoService.getLsBorderInfoByGridKeyAndSheetIndex(businessId, sheet.getString("index"));
                    if (borderInfo != null && borderInfo.size() > 0) {
                        if (!sheet.containsKey((Object)"config")) {
                            sheet.put("config", (Object)new JSONObject());
                        }
                        sheet.getJSONObject("config").put("borderInfo", (Object)borderInfo);
                    }
                    latch.countDown();
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("reportFormLoadUrlStr borderInfo \u7ebf\u7a0b\u6c60\u5f02\u5e38", (Throwable)e);
            }
            executorService.shutdown();
            resStr = lsSheets.toJSONString();
        }
        return ZipUtil.zipReport((String)resStr);
    }

    @Override
    public String reportFormLoadSheetUrlStr(MongoQueryParamVo param) {
        String reportPath;
        String businessId = param.getGridKey();
        String index = param.getIndex();
        String parentSheet = param.getParentSheet();
        String oldSheetName = param.getOldSheetName();
        String newSheetName = param.getNewSheetName();
        String resStr = null;
        ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceMapper.selectById((Serializable)((Object)businessId));
        String jsonStr = "";
        if (reportToolFormInstance != null && StringUtils.isNotEmpty((CharSequence)(reportPath = reportToolFormInstance.getReportPath()))) {
            jsonStr = this.ossFileService.getContent(reportPath);
            jsonStr = StringUtil.cleaningHtml((String)jsonStr);
        }
        if (!jsonStr.isEmpty()) {
            JSONArray nSheets = (JSONArray)ZipUtil.unZipReport((String)jsonStr);
            resStr = LoadLsDataUtil.lsLoadSheetUrlStr((JSONArray)nSheets, (String)index);
        } else {
            JSONObject resObj = new JSONObject();
            String[] indexArr = parentSheet != null && !parentSheet.isEmpty() ? parentSheet.split(",") : index.split(",");
            for (int i = 0; i < indexArr.length; ++i) {
                JSONArray celldata = this.lsCellDataService.getLsCellDataByGridKeyAndSheetIndex(businessId, indexArr[i]);
                if (parentSheet != null && !parentSheet.isEmpty()) {
                    resObj.put(index, (Object)celldata);
                    continue;
                }
                resObj.put(indexArr[i], (Object)celldata);
            }
            if (parentSheet != null && !parentSheet.isEmpty() && resObj.containsKey((Object)index)) {
                JSONArray sheetArray = resObj.getJSONArray(index);
                for (int i = 0; i < sheetArray.size(); ++i) {
                    String vValue;
                    Object vValueObj;
                    JSONObject vObj;
                    JSONObject cell = sheetArray.getJSONObject(i);
                    if (!cell.containsKey((Object)"v") || !(vObj = cell.getJSONObject("v")).containsKey((Object)"v") || !vObj.containsKey((Object)"m") || !((vValueObj = vObj.get((Object)"v")) instanceof String) || !(vValue = (String)vObj.get((Object)"v")).contains(oldSheetName)) continue;
                    String newValue = vValue.replace(oldSheetName, newSheetName);
                    vObj.put("v", (Object)newValue);
                    vObj.put("m", (Object)newValue);
                }
            }
            resStr = resObj.toJSONString();
        }
        return ZipUtil.zipReport((String)resStr);
    }

    @Override
    public ReportToolFormInstance getReportInfo(String reportId) {
        if (StringUtils.isEmpty((CharSequence)reportId)) {
            return new ReportToolFormInstance();
        }
        ReportToolFormInstance reportToolFormInstance = (ReportToolFormInstance)this.reportToolFormInstanceMapper.selectById((Serializable)((Object)reportId));
        if (reportToolFormInstance == null) {
            return new ReportToolFormInstance();
        }
        String reportJson = reportToolFormInstance.getReportData();
        String reportPath = reportToolFormInstance.getReportPath();
        if (StringUtils.isNotEmpty((CharSequence)reportPath)) {
            reportJson = this.ossFileService.getContent(reportPath);
            reportJson = StringUtil.cleaningHtml((String)reportJson);
            reportToolFormInstance.setReportData(reportJson);
            return reportToolFormInstance;
        }
        if (StringUtils.isNotEmpty((CharSequence)reportJson)) {
            return reportToolFormInstance;
        }
        reportToolFormInstance.setReportData(ZipUtil.zipReport((String)this.reportToolFromMongoService.getAllData(reportId)));
        return reportToolFormInstance;
    }

    @Override
    public ReportToolFormInstanceConfigVo getReportConfig(String reportId) {
        ReportToolFormInstanceConfigVo reportToolFormInstanceConfigVo = new ReportToolFormInstanceConfigVo();
        if (StringUtils.isEmpty((CharSequence)reportId)) {
            return reportToolFormInstanceConfigVo;
        }
        List<ReportToolInstanceAttachmentFileLink> reportToolInstanceAttachmentFileLinks = this.instanceFileLinkCustomService.getListByReportId(reportId);
        reportToolFormInstanceConfigVo.setAttachmentFileLinkList(reportToolInstanceAttachmentFileLinks);
        return reportToolFormInstanceConfigVo;
    }

    @Override
    public ApiResponse<Boolean> deleteReportByIds(List<String> reportIds) {
        try {
            int t = this.reportToolFormInstanceMapper.deleteBatchIds(reportIds);
            if (t > 0) {
                for (String reportId : reportIds) {
                    this.instanceFileLinkCustomService.deleteByReportId(reportId);
                    this.lsOtherDataService.deleteLsOtherDataByGridKey(reportId);
                    this.lsCellDataService.deleteLsCellDataByGridKey(reportId);
                    this.lsBorderInfoService.deleteLsBorderInfoByGridKey(reportId);
                }
                return ApiResponse.success((Object)true, (String)"\u5220\u9664\u6210\u529f");
            }
            return ApiResponse.success((Object)false, (String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<GenerateReportConstructResultVo> generateReportConstruct(GenerateReportConstructParamVo reportVo) {
        try {
            JSONObject nPreData;
            GenerateReportConstructResultVo resultVo = new GenerateReportConstructResultVo();
            String msg = "";
            String templateId = reportVo.getTemplateId();
            JSONObject formParam = JSONObject.parseObject((String)JSONObject.toJSONString(reportVo.getFormParam()));
            ReportToolFormTemplate reportToolFormTemplate = (ReportToolFormTemplate)this.reportToolFormTemplateService.getById((Serializable)((Object)templateId));
            List reportCellRules = this.reportCellRulesService.getListByBusinessId(templateId);
            ArrayList<String> dsTypeList = new ArrayList<String>();
            dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_BASE.getValue());
            dsTypeList.add(ReportStatusEnum.PARAM_SOURCE_TYPE_EXTEND.getValue());
            List reportToolTemplateDataSourceList = this.dataSourceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ReportToolTemplateDataSource::getTemplateId, (Object)templateId)).in(ReportToolTemplateDataSource::getBaseExtendType, dsTypeList));
            if (!reportToolTemplateDataSourceList.isEmpty()) {
                Map dataMap = this.reportDataSourceService.dealDataSource(reportToolTemplateDataSourceList, msg, formParam, reportCellRules);
                resultVo.setPreData(JSONObject.toJSONString((Object)dataMap));
            }
            if (reportToolFormTemplate.getOpenComponentInsert() != null && reportToolFormTemplate.getOpenComponentInsert().equals("1")) {
                Map<String, Object> componentDataMap = this.componentTemplateCustomService.dealComponentData(templateId, reportCellRules, formParam);
                if (componentDataMap.containsKey("errorMsg")) {
                    return ApiResponse.fail((int)10003, (String)componentDataMap.get("errorMsg").toString());
                }
                if (ObjectUtils.isNotEmpty((Object)componentDataMap.get("comTemplates"))) {
                    if (ObjectUtils.isNotEmpty((Object)resultVo.getPreData())) {
                        nPreData = (JSONObject)JSON.parse((String)resultVo.getPreData());
                        for (String key : componentDataMap.keySet()) {
                            nPreData.put(key, componentDataMap.get(key));
                        }
                        resultVo.setPreData(JSON.toJSONString((Object)nPreData));
                    } else {
                        resultVo.setPreData(JSON.toJSONString(componentDataMap));
                    }
                }
            }
            Map<String, Object> dynamicRCCompData = this.componentTemplateCustomService.dealDynamicRCCompData(templateId, reportCellRules, formParam);
            if (ObjectUtils.isNotEmpty((Object)resultVo.getPreData())) {
                nPreData = (JSONObject)JSON.parse((String)resultVo.getPreData());
                for (String key : dynamicRCCompData.keySet()) {
                    nPreData.put(key, dynamicRCCompData.get(key));
                }
                resultVo.setPreData(JSON.toJSONString((Object)nPreData));
            } else {
                resultVo.setPreData(JSON.toJSONString(dynamicRCCompData));
            }
            resultVo.setTemplateId(templateId);
            return ApiResponse.success((Object)resultVo);
        }
        catch (Exception e) {
            logger.error("generateReport error", (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

