/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.common.reportcellrules.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.excel.tools.common.reportcellrules.dao.ReportCellRulesMapper;
import com.jxdinfo.document.excel.tools.common.reportcellrules.model.ReportCellRules;
import com.jxdinfo.document.excel.tools.common.reportcellrules.service.ReportCellRulesService;
import com.jxdinfo.document.excel.tools.common.reportcellrules.vo.ReportCellRulesQueryVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.common.reportcellrules.service.impl.ReportCellRulesServiceImpl")
@HussarDs(value="master")
public class ReportCellRulesServiceImpl
extends HussarServiceImpl<ReportCellRulesMapper, ReportCellRules>
implements ReportCellRulesService {
    @Autowired
    private ReportCellRulesMapper rulesMapper;
    private static final Logger logger = LoggerFactory.getLogger(ReportCellRulesServiceImpl.class);
    private SecurityUser user;

    @Override
    public ApiResponse<List<ReportCellRules>> getListByCondition(ReportCellRulesQueryVo reportCellRulesQueryVo) {
        QueryWrapper ew = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reportCellRulesQueryVo.getBusinessId())) {
            ew.lambda().eq(ReportCellRules::getBusinessId, (Object)reportCellRulesQueryVo.getBusinessId());
        }
        if (StringUtils.isNotEmpty((CharSequence)reportCellRulesQueryVo.getDataSourceId())) {
            ew.lambda().eq(ReportCellRules::getDataSourceId, (Object)reportCellRulesQueryVo.getDataSourceId());
        }
        return ApiResponse.success((Object)this.rulesMapper.selectList((Wrapper)ew));
    }

    @Override
    public List<ReportCellRules> getListByBusinessId(String businessId) {
        QueryWrapper ew = new QueryWrapper();
        ew.lambda().eq(ReportCellRules::getBusinessId, (Object)businessId);
        return this.rulesMapper.selectList((Wrapper)ew);
    }

    @Override
    public void saveOrUpdateByBusinessId(String businessId, List<ReportCellRules> reportCellRulesList) {
        if (businessId == null) {
            return;
        }
        this.deleteByBusinessId(businessId);
        if (CollectionUtils.isEmpty(reportCellRulesList)) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        HashMap dataMap = new HashMap(8);
        int saveFlag = 0;
        for (ReportCellRules reportCellRules : reportCellRulesList) {
            reportCellRules.setBusinessId(businessId);
            reportCellRules.setId(IdWorker.getId((Object)new Date()));
            reportCellRules.setCreateTime(LocalDateTime.now());
            if (this.user != null) {
                reportCellRules.setCreateName(this.user.getUserName());
                reportCellRules.setCreateId(this.user.getId());
            }
            if (!dataMap.containsKey(String.valueOf(saveFlag)) || ((List)dataMap.get(String.valueOf(saveFlag))).size() >= 1000) {
                dataMap.put(String.valueOf(++saveFlag), new ArrayList());
            }
            ((List)dataMap.get(String.valueOf(saveFlag))).add(reportCellRules);
        }
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        for (Map.Entry entry : dataMap.entrySet()) {
            List cellRulesList = (List)entry.getValue();
            futures.add(executorService.submit(() -> {
                this.saveOrUpdateBatch(cellRulesList);
                return "null";
            }));
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (ExecutionException executionException) {
            logger.error("cellRulesList\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)executionException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            logger.error("cellRulesList\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)interruptedException.getMessage());
        }
    }

    @Override
    public void deleteByBusinessId(String businessId) {
        List<ReportCellRules> reportCellRulesList = this.getListByBusinessId(businessId);
        if (CollectionUtils.isEmpty(reportCellRulesList)) {
            return;
        }
        this.removeByIds(reportCellRulesList.stream().map(ReportCellRules::getId).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public void initUser(SecurityUser user) {
        this.user = user == null ? BaseSecurityUtil.getUser() : user;
    }

    @Override
    public void saveOrUpdateByBusinessId(String businessId, List<ReportCellRules> reportCellRulesList, SecurityUser currentUser) {
        this.initUser(currentUser);
        this.saveOrUpdateByBusinessId(businessId, reportCellRulesList);
    }
}

