/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.common.datasource.vo.MergeCellVo;
import com.jxdinfo.document.excel.tools.common.reportcellrules.model.ReportCellRules;
import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeCellsUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCellsDataUtil {
    protected static final Logger logger = LoggerFactory.getLogger(MergeCellsDataUtil.class);

    public static void templateMergeCells(Map<String, Object> ansData, List<MergeCellVo> cellVos) {
        for (Map.Entry<String, Object> data : ansData.entrySet()) {
            String key = data.getKey();
            String value = JSONObject.toJSONString((Object)data.getValue());
            try {
                JSONArray jsonArray = JSONArray.parseArray((String)value);
                MergeCellsDataUtil.dealCellRules(cellVos, key, jsonArray, ansData);
            }
            catch (Exception exception) {
                try {
                    JSONObject jsonObject = JSON.parseObject((String)value);
                    MergeCellsDataUtil.dealCellRules(cellVos, key, jsonObject, ansData);
                }
                catch (Exception e) {
                    logger.error("JSON\u89e3\u6790\u5931\u8d25{}", (Object)e.getMessage());
                }
            }
        }
    }

    public static void dealCellRules(List<MergeCellVo> cellVos, String k, JSONArray jsonArray, Map<String, Object> ansData) {
        ReportCellRules reportCellRules = MergeCellVo.getCellRulesByDataSourceName(cellVos, k);
        if (Objects.isNull(reportCellRules)) {
            ansData.put(k, jsonArray);
        } else {
            String mainCells = reportCellRules.getMainCells();
            String mergeCells = reportCellRules.getMergeCells();
            ansData.put(k, new MergeCellsUtil().dynamicMerge(jsonArray, mainCells, mergeCells));
        }
    }

    public static void dealCellRules(List<MergeCellVo> cellVos, String k, JSONObject jsonObject, Map<String, Object> ansData) {
        ReportCellRules reportCellRules = MergeCellVo.getCellRulesByDataSourceName(cellVos, k);
        if (Objects.isNull(reportCellRules)) {
            ansData.put(k, jsonObject);
        } else {
            String mainCells = reportCellRules.getMainCells();
            String mergeCells = reportCellRules.getMergeCells();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
            ansData.put(k, new MergeCellsUtil().dynamicMerge(jsonArray, mainCells, mergeCells).get(0));
        }
    }
}

