/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.common.file.service.impl;

import com.jxdinfo.document.excel.tools.common.file.service.OssFileService;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ReportStatusEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service(value="excel.tools.common.file.service.impl.OssFileServiceImpl")
public class OssFileServiceImpl
implements OssFileService {
    @Autowired
    private OssService ossService;
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    private static final Logger logger = LoggerFactory.getLogger(OssFileServiceImpl.class);

    @Override
    public Long fileUpload(String text, String fileName) {
        ApiResponse result = this.ossService.backgroundUpload(OssFileServiceImpl.convertStringToMultipartFile(text, fileName));
        return (Long)result.getData();
    }

    @Override
    public Long fileZipUpload(InputStream inputStream, String fileName) {
        Long fileId = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(ReportStatusEnum.PARAM_PNG.getValue())) {
                    MultipartFile file = OssFileServiceImpl.convertInputStreamToMultipartFile(zipInputStream, fileName);
                    ApiResponse result = this.ossService.backgroundUpload(file);
                    fileId = (Long)result.getData();
                    break;
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ZIP \u5904\u7406\u5931\u8d25", e);
        }
        return fileId;
    }

    @Override
    public Long fileUpload(byte[] fileByte, String fileName) {
        MultipartFile file = OssFileServiceImpl.convertByteToMultipartFile(fileByte, fileName);
        ApiResponse result = this.ossService.backgroundUpload(file);
        return (Long)result.getData();
    }

    @Override
    public Long fileUpload(InputStream inputStream, String fileName) {
        MultipartFile file = OssFileServiceImpl.convertInputStreamToMultipartFile(inputStream, fileName);
        ApiResponse result = this.ossService.backgroundUpload(file);
        return (Long)result.getData();
    }

    @Override
    public Long fileUpload(ByteArrayOutputStream outputStream, String fileName) {
        MultipartFile file = OssFileServiceImpl.convertByCommons(outputStream, fileName);
        ApiResponse result = this.ossService.backgroundUpload(file);
        return (Long)result.getData();
    }

    @Override
    public String getFilePath(Long fileId, boolean originalNameFlag) {
        AttachmentManagerModelVo vo = this.attachmentManagerService.getByFileId(fileId);
        if (ObjectUtils.isEmpty((Object)vo)) {
            return null;
        }
        return originalNameFlag ? vo.getAttachmentDir() + File.separator + vo.getFileName() : vo.getPath();
    }

    @Override
    public Long getFileIdByPath(String filePath) {
        return FileUtil.extractFileId((String)filePath);
    }

    @Override
    public boolean isExist(Long fileId) {
        return (Boolean)this.ossService.isExist(fileId).getData();
    }

    @Override
    public AttachmentManagerModelVo getByfFileId(Long fileId) {
        AttachmentManagerModelVo vo = this.attachmentManagerService.getByFileId(fileId);
        if (ObjectUtils.isEmpty((Object)vo)) {
            return null;
        }
        return vo;
    }

    @Override
    public InputStream getFileStream(String fp) {
        Long fId = this.getFileIdByPath(fp);
        if (fId > 0L) {
            try {
                byte[] data = (byte[])this.ossService.backgroundDownload(fId).getData();
                return new ByteArrayInputStream(data);
            }
            catch (HussarException hussarException) {
                logger.info("{} getFileStream fp oss \u672a\u627e\u5230:{}", new Object[]{fp, hussarException.getMessage(), hussarException});
                return this.getLocalFileStream(fp);
            }
        }
        return this.getLocalFileStream(fp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getContent(String fp) {
        try (InputStream is = this.getFileStream(fp);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void fileDownload(HttpServletResponse response, Long fileId) {
        try {
            InputStream is = this.getFileStream(String.valueOf(fileId));
            AttachmentManagerModelVo attachmentManagerModelVo = this.getByfFileId(fileId);
            String fileName = attachmentManagerModelVo.getFileName();
            Long fileSize = attachmentManagerModelVo.getAttachmentSize();
            try (BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len;
                fileName = URLEncoder.encode(fileName, "UTF-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                response.setContentType("application/octet-stream");
                response.setContentLengthLong(fileSize.longValue());
                byte[] buff = new byte[4096];
                while ((len = is.read(buff)) > 0) {
                    ((OutputStream)os).write(buff, 0, len);
                    ((OutputStream)os).flush();
                }
            }
        }
        catch (Exception e) {
            logger.info("{} fileDownload:{}", new Object[]{fileId, e.getMessage(), e});
        }
    }

    public static MultipartFile convertStringToMultipartFile(String text, String fileName) {
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        FileItem fileItem = factory.createItem(fileName, "text/plain", true, fileName);
        try (OutputStream os = fileItem.getOutputStream();){
            os.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommonsMultipartFile(fileItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultipartFile convertInputStreamToMultipartFile(InputStream inputStream, String fileName) {
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            FileItem fileItem = factory.createItem(fileName, "application/octet-stream", true, fileName);
            try (OutputStream os = fileItem.getOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
            finally {
                inputStream.close();
            }
            return new CommonsMultipartFile(fileItem);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    public static MultipartFile convertByCommons(ByteArrayOutputStream imageStream, String fileName) {
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            FileItem fileItem = factory.createItem(fileName, OssFileServiceImpl.detectContentType(fileName), true, fileName);
            try (OutputStream os = fileItem.getOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                ByteArrayInputStream is = new ByteArrayInputStream(imageStream.toByteArray());
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
            return new CommonsMultipartFile(fileItem);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    public static MultipartFile convertByteToMultipartFile(byte[] data, String fileName) {
        String contentType = OssFileServiceImpl.detectContentType(fileName);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        FileItem fileItem = factory.createItem(fileName, contentType, true, fileName);
        try (OutputStream os = fileItem.getOutputStream();){
            os.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommonsMultipartFile(fileItem);
    }

    public static String detectContentType(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        switch (extension.toLowerCase()) {
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "txt": {
                return "text/plain";
            }
            case "doc": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
        }
        return "application/octet-stream";
    }

    public InputStream getLocalFileStream(String fp) {
        try {
            File file = new File(fp);
            if (file.exists()) {
                return new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
            }
            logger.error("getLocalFileStream \u8bfb\u53d6\u672c\u5730\u8def\u5f84 \u65e0\u6587\u4ef6");
            return null;
        }
        catch (IOException e) {
            logger.error("getLocalFileStream  \u8bfb\u53d6\u672c\u5730\u8def\u5f84\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u8f93\u5165\u6d41: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

