/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.common.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.document.excel.tools.common.datasource.dao.DataSourceMapper;
import com.jxdinfo.document.excel.tools.common.datasource.model.ReportToolTemplateDataSource;
import com.jxdinfo.document.excel.tools.common.datasource.service.ExcelReportDataSourceService;
import com.jxdinfo.document.excel.tools.common.datasource.vo.MergeCellVo;
import com.jxdinfo.document.excel.tools.common.reportcellrules.model.ReportCellRules;
import com.jxdinfo.document.excel.tools.common.util.MergeCellsDataUtil;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ReportStatusEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.ReportUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.YMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.common.datasource.service.impl.ExcelReportDataSourceServiceImpl")
public class ExcelReportDataSourceServiceImpl
implements ExcelReportDataSourceService {
    @Autowired
    private DataSource dataSource;
    private static final Logger logger = LoggerFactory.getLogger(ExcelReportDataSourceServiceImpl.class);
    @Qualifier(value="excel.tools.common.datasource.dao.DataSourceMapper")
    @Autowired
    private DataSourceMapper dataSourceMapper;

    private ReportCellRules getRule(List<ReportCellRules> rules, String dataSourceId) {
        if (CollectionUtils.isEmpty(rules)) {
            return null;
        }
        return rules.stream().filter(rule -> StringUtils.equals((CharSequence)dataSourceId, (CharSequence)rule.getDataSourceId())).findFirst().orElse(null);
    }

    @Override
    public Map<String, Object> dealDataSource(List<ReportToolTemplateDataSource> reportToolTemplateDataSourceList, String msg, JSONObject param, List<ReportCellRules> rules) {
        ArrayList<Object> objectList;
        ArrayList oList;
        ArrayList<MergeCellVo> voList = new ArrayList<MergeCellVo>();
        ArrayList sqlOrRestList = new ArrayList();
        HashMap<String, Object> ansData = new HashMap<String, Object>();
        for (ReportToolTemplateDataSource reportTemplateDataSource : reportToolTemplateDataSourceList) {
            String id = reportTemplateDataSource.getId();
            String name = reportTemplateDataSource.getName();
            MergeCellVo cellVo = new MergeCellVo(id, name, this.getRule(rules, id));
            if (reportTemplateDataSource.getType().equals(ReportStatusEnum.PARAM_SOURCE_TYPE_SQL.getValue())) {
                String sql = ReportUtil.replaceSqlPlaceholders((String)reportTemplateDataSource.getContent(), (String)JSONObject.toJSONString((Object)param));
                if (sql.startsWith(ReportStatusEnum.SOURCE_REST_REQUEST_ERROR.getValue())) {
                    String[] split = sql.split(",");
                    msg = msg + reportTemplateDataSource.getContent() + ":" + split[2];
                    continue;
                }
                HashMap<String, Object> sqlMap = new HashMap<String, Object>();
                sqlMap.put("type", "sql");
                sqlMap.put("sql", sql);
                sqlMap.put("name", name);
                sqlMap.put("id", id);
                sqlOrRestList.add(sqlMap);
                cellVo.setMontageName(sql + ":" + name + ":" + (String)id);
            } else if (reportTemplateDataSource.getType().equals(ReportStatusEnum.PARAM_SOURCE_TYPE_REST.getValue())) {
                String url = reportTemplateDataSource.getContent();
                String params = ReportUtil.replaceRestPlaceholders((String)reportTemplateDataSource.getInParameter(), (String)JSONObject.toJSONString((Object)param));
                if (!url.contains(ReportStatusEnum.PARAM_HTTP.getValue())) {
                    Object port = YMLUtils.getValue((String)"application.yml", (String)"server.port");
                    url = "http://127.0.0.1:" + port.toString() + url;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ReportStatusEnum.PARAM_SOURCE_NAME.getValue(), name);
                map.put(ReportStatusEnum.PARAM_REPORT_SOURCE_PARAM.getValue(), JSONObject.parseObject((String)params));
                map.put(ReportStatusEnum.PARAM_SOURCE_URL.getValue(), url);
                map.put(ReportStatusEnum.PARAM_SOURCE_TYPE.getValue(), reportTemplateDataSource.getAccessMethod());
                map.put("id", id);
                sqlOrRestList.add(map);
                cellVo.setMontageName(url + ":" + reportTemplateDataSource.getAccessMethod() + ":" + reportTemplateDataSource.getName() + ":" + (String)id);
            } else if (reportTemplateDataSource.getType().equals(ReportStatusEnum.PARAM_SOURCE_TYPE_SINGLECOMP.getValue())) {
                JSONArray singleCompVal = new JSONArray();
                singleCompVal.add((Object)reportTemplateDataSource.getContent());
                ansData.put(reportTemplateDataSource.getName(), singleCompVal);
            }
            voList.add(cellVo);
        }
        Map ansMap = ReportUtil.doBatchSqlOrRest(sqlOrRestList, (DataSource)this.dataSource);
        if (ansMap == null) {
            return ansData;
        }
        List sqlAnsList = (List)ansMap.get("SQL");
        for (Map map : sqlAnsList) {
            if (map.containsKey(ReportStatusEnum.RETURN_CODE_MINUS_SIX.getValue())) {
                msg = msg + map.get(ReportStatusEnum.RETURN_CODE_MINUS_SIX.getValue()) + ":" + ReportStatusEnum.RETURN_CODE_MINUS_SIX.getDescription();
                continue;
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (Map.Entry entry : map.entrySet()) {
                String k = (String)entry.getKey();
                Map vMap = (Map)entry.getValue();
                for (Map.Entry entry2 : vMap.entrySet()) {
                    String k1 = (String)entry2.getKey();
                    Object v1 = entry2.getValue();
                    dataMap.put(k1, String.valueOf(v1));
                }
                String s = MergeCellVo.getDataSourceNameByMontage(voList, k);
                if (ansData.containsKey(s)) {
                    Object v = ansData.get(s);
                    if (v instanceof ArrayList) {
                        oList = (ArrayList)v;
                        oList.add(dataMap);
                        ansData.put(s, oList);
                        continue;
                    }
                    objectList = new ArrayList<Object>();
                    objectList.add(v);
                    objectList.add(dataMap);
                    ansData.put(s, objectList);
                    continue;
                }
                ansData.put(s, dataMap);
            }
        }
        Map restAnsMap = (Map)ansMap.get("REST");
        for (Map.Entry entry : restAnsMap.entrySet()) {
            String k = (String)entry.getKey();
            String v = String.valueOf(entry.getValue());
            HashMap dataMap = new HashMap();
            if (v.startsWith(ReportStatusEnum.SOURCE_REST_REQUEST_ERROR.getValue())) {
                msg = msg + k + ":" + v;
                continue;
            }
            if (!ReportUtil.isJsonString((String)v)) {
                msg = msg + k + ":\u8fd4\u56de\u7684\u7ed3\u679c\u4e0d\u662fjson";
                continue;
            }
            JSONObject parseObj = (JSONObject)JSON.parse((String)v);
            if (parseObj.containsKey((Object)ReportStatusEnum.PARAM_SOURCE_REST_DATA.getValue())) {
                if (parseObj.get((Object)ReportStatusEnum.PARAM_SOURCE_REST_DATA.getValue()) instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)parseObj.get((Object)ReportStatusEnum.PARAM_SOURCE_REST_DATA.getValue());
                    for (Map.Entry e : jsonObject.entrySet()) {
                        String k2 = (String)e.getKey();
                        Object v2 = e.getValue();
                        dataMap.put(k2, v2);
                    }
                } else if (parseObj.get((Object)ReportStatusEnum.PARAM_SOURCE_REST_DATA.getValue()) instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)parseObj.get((Object)ReportStatusEnum.PARAM_SOURCE_REST_DATA.getValue());
                    String string = MergeCellVo.getDataSourceNameByMontage(voList, k);
                    ansData.put(string, jsonArray);
                }
            } else {
                for (Map.Entry entry3 : parseObj.entrySet()) {
                    dataMap.put((String)entry3.getKey(), entry3.getValue());
                }
            }
            String restName = MergeCellVo.getDataSourceNameByMontage(voList, k);
            if (!ObjectUtils.isNotEmpty(dataMap)) continue;
            if (ansData.containsKey(restName)) {
                Object v2 = ansData.get(restName);
                if (v2 instanceof ArrayList) {
                    oList = (ArrayList)v2;
                    oList.add(dataMap);
                    ansData.put(restName, oList);
                    continue;
                }
                objectList = new ArrayList();
                objectList.add(v2);
                objectList.add(dataMap);
                ansData.put(restName, objectList);
                continue;
            }
            ansData.put(restName, dataMap);
        }
        MergeCellsDataUtil.templateMergeCells(ansData, voList);
        return ansData;
    }

    @Override
    public List<ReportToolTemplateDataSource> getListByTemplateIdAndTypes(String templateId, List<String> dsTypeList) {
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            QueryWrapper qw = new QueryWrapper();
            qw.lambda().eq(ReportToolTemplateDataSource::getTemplateId, (Object)templateId);
            if (ObjectUtils.isNotEmpty(dsTypeList)) {
                qw.lambda().in(ReportToolTemplateDataSource::getType, dsTypeList);
            }
            return this.dataSourceMapper.selectList((Wrapper)qw);
        }
        return Collections.emptyList();
    }
}

