/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.mergeCells;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeGroup;
import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeGroupProcessor;
import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeGroupRecursive;
import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MergeCellsUtil {
    public JSONArray dynamicMerge(JSONArray jsonArray, String mainColumns, String mergeColumns) {
        if (StringUtils.isEmpty((CharSequence)mainColumns) && StringUtils.isEmpty((CharSequence)mergeColumns)) {
            return jsonArray;
        }
        List<Object> mainColumnsList = new ArrayList();
        List<Object> mergeColumnsList = new ArrayList();
        ArrayList<String> mergeChildColumnsList = new ArrayList<String>();
        LinkedList<String> mainAndChildColumnsList = new LinkedList<String>();
        if (StringUtils.isNotEmpty((CharSequence)mainColumns)) {
            mainColumnsList = Arrays.asList(mainColumns.split(","));
            mainAndChildColumnsList.addAll(mainColumnsList);
        }
        if (StringUtils.isNotEmpty((CharSequence)mergeColumns)) {
            mergeColumnsList = Arrays.asList(mergeColumns.split(","));
        }
        if (CollectionUtils.isNotEmpty(mainColumnsList) && CollectionUtils.isNotEmpty(mergeColumnsList)) {
            for (String string : mergeColumnsList) {
                if (mainColumnsList.contains(string)) continue;
                mergeChildColumnsList.add(string);
            }
        }
        if (CollectionUtils.isNotEmpty(mergeChildColumnsList)) {
            mainAndChildColumnsList.addAll(mergeChildColumnsList);
        }
        List<Map<String, Object>> dataList = this.jsonArrayToMapList(jsonArray);
        IntStream.range(0, dataList.size()).forEach(i -> ((Map)dataList.get(i)).put("logicalIndex", i));
        dataList.forEach(row -> System.out.println(row.get("logicalIndex") + ":" + row));
        ArrayList<MergeRegion> arrayList = new ArrayList<MergeRegion>();
        MergeGroupRecursive mergeGroupRecursive = new MergeGroupRecursive(mainAndChildColumnsList);
        MergeGroup mainGroup = mergeGroupRecursive.buildMergeGroups(dataList, mainColumnsList, mergeChildColumnsList, 0, arrayList, 0);
        MergeGroupProcessor processor = new MergeGroupProcessor();
        processor.setMergeRegions(arrayList);
        processor.setColumnIndexCache(mergeGroupRecursive.getColumnIndexCache());
        mainGroup.calculateSpans(dataList, mergeColumnsList, processor.getColumnIndexCache(), processor.getMergeRegions());
        return this.buildResult(dataList, mergeColumnsList);
    }

    private List<Map<String, Object>> jsonArrayToMapList(JSONArray jsonArray) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        try {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObj = jsonArray.getJSONObject(i);
                LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>();
                Set entries = jsonObj.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof JSONArray) {
                        rowMap.put(key, this.convertNestedJson(value));
                        continue;
                    }
                    rowMap.put(key, value);
                }
                dataList.add(rowMap);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON \u89e3\u6790\u5931\u8d25", e);
        }
        return dataList;
    }

    private Object convertNestedJson(Object obj) {
        if (obj instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>();
            JSONArray arr = (JSONArray)obj;
            for (int i = 0; i < arr.size(); ++i) {
                list.add(this.convertNestedJson(arr.get(i)));
            }
            return list;
        }
        if (obj instanceof JSONObject) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            JSONObject jsonObj = (JSONObject)obj;
            for (Map.Entry entry : jsonObj.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                map.put(key, this.convertNestedJson(value));
            }
            return map;
        }
        return obj;
    }

    private JSONArray buildResult(List<Map<String, Object>> dataList, List<String> mergeColumns) {
        JSONArray result = new JSONArray();
        for (Map<String, Object> row : dataList) {
            JSONObject mergedRow = new JSONObject(true);
            row.forEach((key, value) -> {
                if (key.startsWith("__span_")) {
                    return;
                }
                if (mergeColumns.contains(key)) {
                    JSONObject cell = new JSONObject();
                    cell.put("rowSpan", (Object)row.getOrDefault("__span_" + key, 1));
                    cell.put("colSpan", (Object)1);
                    cell.put("value", value);
                    cell.put("useAfterCellMc", (Object)true);
                    cell.put("extend", (Object)true);
                    mergedRow.put(key, (Object)cell);
                } else {
                    mergedRow.put(key, value);
                }
            });
            result.add((Object)mergedRow);
        }
        return result;
    }
}

