/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.yaml.snakeyaml.Yaml;

public class YMLUtils {
    private static Map<String, LinkedHashMap> ymls = new ConcurrentHashMap<String, LinkedHashMap>();
    private static Map<String, Long> times = new ConcurrentHashMap<String, Long>();
    private static ThreadLocal<String> nowFileName = new ThreadLocal();

    public static void loadYml(String fileName) {
        nowFileName.set(fileName);
        if (ymls.containsKey(fileName)) {
            long lastReadTime;
            long expireTime = (Integer)Optional.ofNullable(YMLUtils.getValue("global.setting-expire-time")).orElse(0) * 1000;
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastReadTime = Optional.ofNullable(times.get(fileName)).orElse(-1L * expireTime).longValue()) > expireTime) {
                times.put(fileName, currentTime);
                ymls.put(fileName, (LinkedHashMap)new Yaml().loadAs(YMLUtils.class.getResourceAsStream("/" + fileName), LinkedHashMap.class));
            }
        } else {
            times.put(fileName, System.currentTimeMillis());
            ymls.put(fileName, (LinkedHashMap)new Yaml().loadAs(YMLUtils.class.getResourceAsStream("/" + fileName), LinkedHashMap.class));
        }
    }

    public static Object getValue(String key) {
        String[] keys = key.split("[.]");
        Map<String, LinkedHashMap> ymls1 = ymls;
        Map ymlInfo = (Map)ymls.get(nowFileName.get()).clone();
        for (int i = 0; i < keys.length; ++i) {
            Object value = ymlInfo.get(keys[i]);
            if (!ObjectUtils.isNotEmpty(value)) continue;
            if (i < keys.length - 1) {
                ymlInfo = (Map)value;
                continue;
            }
            if (value == null) {
                return null;
            }
            return value;
        }
        return null;
    }

    public static Object getValue(String fileName, String key) {
        YMLUtils.loadYml(fileName);
        return YMLUtils.getValue(key);
    }
}

