/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Map;

public final class JsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String asJSONString(Object entity) {
        try {
            return mapper.writeValueAsString(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> asJSONMap(String json) {
        try {
            return (Map)mapper.readValue(json, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T convertValue(Object entity, TypeReference<T> typeReference) {
        try {
            if (entity instanceof String) {
                return (T)mapper.readValue((String)entity, typeReference);
            }
            return (T)mapper.convertValue(entity, typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    }
}

