/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders.ComputedRes;
import com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders.DataBinderContext;

public class LsUtil {
    public static JSONArray transCellDataToData(JSONArray celldata) {
        JSONArray data = new JSONArray();
        for (int i = 0; i < celldata.size(); ++i) {
            JSONObject cell = celldata.getJSONObject(i);
            int r = cell.getIntValue("r");
            int c = cell.getIntValue("c");
            JSONObject v = cell.getJSONObject("v");
            try {
                data.getJSONArray(r);
            }
            catch (Exception e) {
                data.set(r, (Object)new JSONArray());
            }
            JSONArray row = data.getJSONArray(r);
            row.set(c, (Object)v);
        }
        return data;
    }

    public static JSONArray transDataToCellData(JSONArray data) {
        JSONArray celldata = new JSONArray();
        for (int i = 0; i < data.size(); ++i) {
            JSONArray r = data.getJSONArray(i);
            if (r == null) continue;
            for (int j = 0; j < r.size(); ++j) {
                JSONObject c = r.getJSONObject(j);
                if (c == null) continue;
                JSONObject co = new JSONObject();
                co.put("r", (Object)i);
                co.put("c", (Object)j);
                co.put("v", (Object)c);
                celldata.add((Object)co);
            }
        }
        return celldata;
    }

    public static JSONArray transDataToCellData(JSONArray data, int start) {
        JSONArray celldata = new JSONArray();
        for (int i = 0; i < data.size(); ++i) {
            JSONArray r = data.getJSONArray(i);
            if (r == null) continue;
            for (int j = 0; j < r.size(); ++j) {
                JSONObject c = r.getJSONObject(j);
                if (c == null) continue;
                JSONObject co = new JSONObject();
                co.put("r", (Object)(i + start));
                co.put("c", (Object)j);
                co.put("v", (Object)c);
                celldata.add((Object)co);
            }
        }
        return celldata;
    }

    public static Object getFirstValueFromCell(JSONObject c) {
        JSONArray v = LsUtil.getCellValueFromData(c);
        if (v != null && v.size() > 0) {
            return v.get(0);
        }
        return null;
    }

    public static JSONArray getCellValueFromData(JSONObject c) {
        if (c == null) {
            return null;
        }
        JSONArray ret = new JSONArray();
        Object cv = c.get((Object)"v");
        if (cv == null) {
            if (c.get((Object)"ct") != null && c.getJSONObject("ct").get((Object)"s") != null && c.getJSONObject("ct").getJSONArray("s").size() > 0) {
                JSONArray s = c.getJSONObject("ct").getJSONArray("s");
                for (int i = 0; i < s.size(); ++i) {
                    ret.add(s.getJSONObject(i).get((Object)"v"));
                }
            }
        } else {
            ret.add(cv);
        }
        return ret;
    }

    public static JSONArray deepCopyJSONArray(JSONArray original) {
        JSONArray copiedArray = new JSONArray();
        for (int i = 0; i < original.size(); ++i) {
            Object element = original.get(i);
            if (element instanceof JSONArray) {
                copiedArray.add((Object)LsUtil.deepCopyJSONArray((JSONArray)element));
                continue;
            }
            if (element instanceof JSONObject) {
                copiedArray.add((Object)LsUtil.deepCopyJSONObject((JSONObject)element));
                continue;
            }
            copiedArray.add(element);
        }
        return copiedArray;
    }

    public static JSONObject deepCopyJSONObject(JSONObject original) {
        JSONObject copiedObject = new JSONObject();
        for (String key : original.keySet()) {
            Object value = original.get((Object)key);
            if (value instanceof JSONArray) {
                copiedObject.put(key, (Object)LsUtil.deepCopyJSONArray((JSONArray)value));
                continue;
            }
            if (value instanceof JSONObject) {
                copiedObject.put(key, (Object)LsUtil.deepCopyJSONObject((JSONObject)value));
                continue;
            }
            copiedObject.put(key, value);
        }
        return copiedObject;
    }

    public static Object getDataObj(JSONObject data, String ns, int tailCut) {
        Object d = data;
        if (ns.length() > 0) {
            String[] ss = ns.split("\\.");
            for (int i = 0; i < ss.length - tailCut; ++i) {
                if (!(d instanceof JSONObject)) {
                    return "";
                }
                d = d.get((Object)ss[i]);
                if (d != null) continue;
                return "";
            }
        }
        return d;
    }

    public static Object getDataObj1(JSONObject data, String ns, int tailCut) {
        Object d = data;
        if (ns.length() > 0) {
            String[] ss = ns.split("\\.");
            for (int i = 0; i < ss.length - tailCut; ++i) {
                if (d instanceof JSONArray) {
                    JSONArray dArr = new JSONArray();
                    for (int j = 0; j < ((JSONArray)d).size(); ++j) {
                        Object t = ((JSONArray)d).get(j);
                        if (!(t instanceof JSONObject)) continue;
                        Object v = ((JSONObject)t).get((Object)ss[i]);
                        if (v != null && v instanceof JSONObject) {
                            dArr.add(((JSONObject)t).getJSONObject(ss[i]).get((Object)"value"));
                            continue;
                        }
                        dArr.add(((JSONObject)t).get((Object)ss[i]));
                    }
                    d = dArr;
                    continue;
                }
                if (!(d instanceof JSONObject)) {
                    return "";
                }
                d = d.get((Object)ss[i]);
                if (d != null) continue;
                return "";
            }
        }
        return d;
    }

    public static Object getSingleDataObj(JSONObject data, String ns, int tailCut) {
        Object d = data;
        if (ns.length() > 0) {
            String[] ss = ns.split("\\.");
            for (int i = 0; i < ss.length - tailCut; ++i) {
                if (!(d instanceof JSONObject)) {
                    return "";
                }
                d = d.get((Object)ss[i]);
                if (d == null) {
                    return "";
                }
                if (!(d instanceof JSONArray) || ((JSONArray)d).size() <= 0) continue;
                d = ((JSONArray)d).get(0);
            }
        }
        if (d instanceof JSONArray && ((JSONArray)d).size() > 0) {
            d = ((JSONArray)d).get(0);
        }
        return d;
    }

    public static String getStrValue(Object rd) {
        if (rd != null) {
            if (rd instanceof JSONObject) {
                JSONObject nrd = (JSONObject)rd;
                if (nrd.get((Object)"value") != null) {
                    if (nrd.get((Object)"value") instanceof String) {
                        return nrd.getString("value");
                    }
                    return nrd.get((Object)"value").toString();
                }
                return "";
            }
            return rd.toString();
        }
        return "";
    }

    public static void setCellValue2Data(JSONObject c, JSONArray vs, JSONObject modelEmpty) {
        if (vs == null || vs.size() == 0) {
            return;
        }
        if (c.get((Object)"v") == null && c.get((Object)"ct") != null && c.getJSONObject("ct").get((Object)"s") != null && c.getJSONObject("ct").getJSONArray("s").size() > 0) {
            JSONArray cts = c.getJSONObject("ct").getJSONArray("s");
            for (int i = 0; i < cts.size(); ++i) {
                if (vs.size() <= i || vs.get(i) == null) continue;
                cts.getJSONObject(i).put("v", vs.get(i));
                if (cts.getJSONObject(i).get((Object)"m") == null) continue;
                cts.getJSONObject(i).put("m", vs.get(i));
            }
            return;
        }
        if (vs.size() > 0) {
            c.put("v", vs.get(0));
            if (c.get((Object)"m") != null) {
                c.put("m", vs.get(0));
            }
        }
        if (modelEmpty != null && modelEmpty.keySet().size() > 0) {
            c.put("modelEmpty", (Object)modelEmpty.getBooleanValue("flag"));
            c.put("placeholder", (Object)modelEmpty.getString("placeholder"));
        }
    }

    public static Object getDataValue(Object rd) {
        if (rd != null) {
            if (rd instanceof JSONObject && ((JSONObject)rd).get((Object)"value") != null) {
                return ((JSONObject)rd).get((Object)"value");
            }
            return rd;
        }
        return "";
    }

    public static int getNrn(DataBinderContext opt, int r) {
        ComputedRes computedRes = opt.getComputedRes();
        if (r < computedRes.getRds().size()) {
            return computedRes.getRds().getJSONObject(r).getIntValue("nrn");
        }
        return computedRes.getRds().getJSONObject(computedRes.getRds().size() - 1).getIntValue("nrn") + 1;
    }

    public static int getNrn(JSONObject opt, int r) {
        JSONObject computedRes = opt.getJSONObject("computedRes");
        if (r < computedRes.getJSONArray("rds").size()) {
            return computedRes.getJSONArray("rds").getJSONObject(r).getIntValue("nrn");
        }
        return computedRes.getJSONArray("rds").getJSONObject(computedRes.getJSONArray("rds").size() - 1).getIntValue("nrn") + 1;
    }
}

