/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelExportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ColorHelper;
import java.util.Objects;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FontKey {
    private final int workbookHash;
    private final boolean bold;
    private final short fontHeight;
    private final String fontName;
    private final boolean italic;
    private final boolean strikeout;
    private final short typeOffset;
    private final byte underline;
    private final String colorHex;
    private final short fontHeightInPoints;

    public FontKey(XSSFWorkbook destWorkbook, XSSFFont font) {
        this.workbookHash = System.identityHashCode(destWorkbook);
        if (font == null) {
            this.bold = false;
            this.fontHeight = (short)200;
            this.fontName = ExcelExportConstant.ff_IntegerToName.get(13);
            this.italic = false;
            this.strikeout = false;
            this.typeOffset = 0;
            this.underline = 0;
            this.colorHex = ColorHelper.getDefaultColor().getARGBHex();
            this.fontHeightInPoints = (short)10;
        } else {
            this.bold = font.getBold();
            this.fontHeight = font.getFontHeight();
            this.fontName = font.getFontName();
            this.italic = font.getItalic();
            this.strikeout = font.getStrikeout();
            this.typeOffset = font.getTypeOffset();
            this.underline = font.getUnderline();
            this.colorHex = font.getXSSFColor() != null ? font.getXSSFColor().getARGBHex() : ColorHelper.getDefaultColor().getARGBHex();
            this.fontHeightInPoints = font.getFontHeightInPoints();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontKey fontKey = (FontKey)o;
        return this.workbookHash == fontKey.workbookHash && this.bold == fontKey.bold && this.fontHeight == fontKey.fontHeight && this.italic == fontKey.italic && this.strikeout == fontKey.strikeout && this.typeOffset == fontKey.typeOffset && this.underline == fontKey.underline && this.fontHeightInPoints == fontKey.fontHeightInPoints && Objects.equals(this.fontName, fontKey.fontName) && Objects.equals(this.colorHex, fontKey.colorHex);
    }

    public int hashCode() {
        return Objects.hash(this.workbookHash, this.bold, this.fontHeight, this.fontName, this.italic, this.strikeout, this.typeOffset, this.underline, this.fontHeightInPoints, this.colorHex);
    }

    public String toString() {
        return "FontKey{workbookHash=" + this.workbookHash + ", bold=" + this.bold + ", fontHeight=" + this.fontHeight + ", fontName='" + this.fontName + '\'' + ", italic=" + this.italic + ", strikeout=" + this.strikeout + ", typeOffset=" + this.typeOffset + ", underline=" + this.underline + ", colorHex='" + this.colorHex + '\'' + ", fontHeightInPoints=" + this.fontHeightInPoints + '}';
    }

    public int getWorkbookHash() {
        return this.workbookHash;
    }

    public boolean isBold() {
        return this.bold;
    }

    public short getFontHeight() {
        return this.fontHeight;
    }

    public String getFontName() {
        return this.fontName;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public short getTypeOffset() {
        return this.typeOffset;
    }

    public byte getUnderline() {
        return this.underline;
    }

    public String getColorHex() {
        return this.colorHex;
    }

    public short getFontHeightInPoints() {
        return this.fontHeightInPoints;
    }
}

