/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.jxdinfo.document.excel.tools.core.common.utils.FilePathUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.cache.StyleCache;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ActiveSheetHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.BorderHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.CheckParamHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ConditionFormatHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.CreateChartHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ExcelDataValidationHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.HyperlinkHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.PrintHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportCellCommentHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportCellContentHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportCellFormulaHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportCellStyleHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportCellWHHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportDataValidationHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportFontHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportFormatHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportFreezePaneHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ReportImagesHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ScaleHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor.CopyExcelProcessor;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.vo.DownloadExcelParamVo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.core.common.utils.excel.ReportToolExportExcelUtil")
public class ReportToolExportExcelUtil {
    private static final ParserConfig parserConfig = new ParserConfig();
    private static final Logger logger;
    private String reqURL;
    private JSONObject formulaTextStyle;
    private String exportActiveIndex;
    private final CheckParamHelper checkParamHelper = new CheckParamHelper();

    public static JSONArray getExcelDataJson(String filePath) {
        StringBuilder sb = new StringBuilder();
        File file = new File(filePath);
        try {
            for (File listFile : Objects.requireNonNull(file.listFiles())) {
                FileUtils.readLines((File)listFile, (String)"utf-8").forEach(sb::append);
            }
            return JSONArray.parseArray((String)sb.toString());
        }
        catch (Exception e1) {
            try {
                JSONObject obj = JSONObject.parseObject((String)sb.toString());
                JSONArray arr = new JSONArray();
                arr.add((Object)obj);
                return arr;
            }
            catch (Exception e2) {
                throw new RuntimeException("Not a valid JSON array or object");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWorkbookToResponse(XSSFWorkbook wb, HttpServletResponse response, DownloadExcelParamVo param) throws IOException {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            if (StringUtils.isNotBlank((CharSequence)param.getMethod()) && param.getMethod().equals("get")) {
                response.setContentType("multipart/form-data");
                String safeName = param.getExportName().trim() + ".xlsx";
                String downLoadFileName = URLEncoder.encode(safeName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
            } else {
                response.setContentType("application/octet-stream");
            }
            wb.write((OutputStream)os);
            ((OutputStream)os).flush();
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportLuckySheetXlsx(String jsonStr, DownloadExcelParamVo param, HttpServletResponse response) {
        XSSFWorkbook wb = this.exportLuckySheetXlsx(jsonStr, param);
        try {
            ReportToolExportExcelUtil.writeWorkbookToResponse(wb, response, param);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51faExcel\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public XSSFWorkbook exportLuckySheetXlsx(String jsonStr, DownloadExcelParamVo param) {
        this.checkParamHelper.checkParam(param);
        this.reqURL = this.checkParamHelper.getReqURL();
        this.exportActiveIndex = this.checkParamHelper.getExportActiveIndex();
        this.formulaTextStyle = this.checkParamHelper.getFormulaTextStyle();
        JSONArray sheets = ReportToolExportExcelUtil.getExcelDataJson(jsonStr);
        this.checkParamHelper.setActiveIndex(sheets);
        List<CompletableFuture> futures = sheets.stream().map(sheet -> CompletableFuture.supplyAsync(() -> {
            try {
                return this.saveFile((JSONObject)sheet);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5de5\u4f5c\u8868\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException("\u5de5\u4f5c\u8868\u5904\u7406\u5931\u8d25", e);
            }
        })).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        List<String> tempFiles = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        XSSFWorkbook wb = CopyExcelProcessor.mergeWithOPCPackage(tempFiles, this.checkParamHelper.getActiveSheetIndex());
        tempFiles.forEach(tempFilePath -> {
            if (tempFilePath != null) {
                try {
                    Files.deleteIfExists(Paths.get(tempFilePath, new String[0]));
                }
                catch (IOException e) {
                    logger.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: {}", tempFilePath, (Object)e);
                }
            }
        });
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveFile(JSONObject sheetJson) {
        String fullName = null;
        XSSFWorkbook threadWb = new XSSFWorkbook();
        StyleCache styleCache = new StyleCache(threadWb);
        this.processSheet(threadWb, sheetJson, styleCache);
        try {
            fullName = FilePathUtil.getFilePathSplicing("exportExcel") + File.separator + "temp_" + UUID.randomUUID() + "index_" + CheckParamHelper.getIndexMap().get(sheetJson.getString("index")) + ".xlsx";
            FileOutputStream out = new FileOutputStream(fullName);
            threadWb.write((OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        finally {
            try {
                threadWb.close();
                styleCache.dispose();
            }
            catch (IOException e) {
                logger.error("\u5173\u95edthreadWb\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
        return fullName;
    }

    private void processSheet(XSSFWorkbook wb, JSONObject sheetJson, StyleCache styleCache) {
        ScaleHelper scaleHelper = new ScaleHelper(sheetJson);
        XSSFSheet sheet = wb.createSheet(sheetJson.getString("name"));
        sheet.setForceFormulaRecalculation(true);
        long t = new Date().getTime();
        JSONObject frozen = sheetJson.getJSONObject("frozen");
        ReportFreezePaneHelper.setFreezePane(sheet, frozen);
        long t1 = new Date().getTime();
        System.out.println("-----\u8bbe\u7f6e\u884c\u5217\u51bb\u7ed3-----" + (t1 - t));
        JSONArray visibledatarow = sheetJson.getJSONArray("visibledatarow");
        JSONArray visibledatacolumn = sheetJson.getJSONArray("visibledatacolumn");
        ReportCellWHHelper reportCellWHHelper = new ReportCellWHHelper(sheetJson);
        reportCellWHHelper.setCellWH(sheet, visibledatarow, visibledatacolumn);
        visibledatarow = visibledatarow == null ? reportCellWHHelper.getVisibleDataRow() : visibledatarow;
        visibledatacolumn = visibledatacolumn == null ? reportCellWHHelper.getVisibleDataColumn() : visibledatacolumn;
        long t2 = new Date().getTime();
        System.out.println("-----\u8bbe\u7f6e\u884c\u9ad8\u5217\u5bbd-----" + (t2 - t1));
        JSONObject images = sheetJson.getJSONObject("images");
        ReportImagesHelper.setImages(wb, sheet, images, visibledatarow, visibledatacolumn, this.reqURL);
        long t3 = new Date().getTime();
        System.out.println("------\u8bbe\u7f6e\u56fe\u7247------" + (t3 - t2));
        JSONArray jsonObjectList = sheetJson.getJSONArray("celldata");
        JSONObject htmlData = sheetJson.getJSONObject("htmlData");
        JSONObject dataVerification = sheetJson.getJSONObject("dataVerification");
        this.setCellValue(wb, sheet, jsonObjectList, visibledatarow, visibledatacolumn, htmlData, styleCache, dataVerification);
        long t4 = new Date().getTime();
        System.out.println("------\u8bbe\u7f6e\u5355\u5143\u683c\u6837\u5f0f------" + (t4 - t3));
        ReportDataValidationHelper.setDataValidation(dataVerification, sheet);
        long t5 = new Date().getTime();
        System.out.println("------\u8bbe\u7f6e\u6570\u636e\u9a8c\u8bc1------" + (t5 - t4));
        JSONArray borderInfoObjectList = sheetJson.getJSONObject("config").getJSONArray("borderInfo");
        if (borderInfoObjectList != null) {
            BorderHelper borderHelper = new BorderHelper(wb, styleCache);
            borderHelper.setBorder(borderInfoObjectList, sheet);
        }
        long t6 = new Date().getTime();
        System.out.println("------\u8bbe\u7f6e\u8fb9\u6846------" + (t6 - t5));
        JSONArray conditionFormat = sheetJson.getJSONArray("luckysheet_conditionformat_save");
        if (conditionFormat != null && !conditionFormat.isEmpty()) {
            ConditionFormatHelper.setConditionFormat(conditionFormat, sheet);
        }
        long t7 = new Date().getTime();
        System.out.println("------\u8bbe\u7f6e\u6761\u4ef6\u683c\u5f0f------" + (t7 - t6));
        JSONObject hyperlink = sheetJson.getJSONObject("hyperlink");
        HyperlinkHelper.setHyperlink(sheet, hyperlink);
        long t8 = new Date().getTime();
        System.out.println("------\u8bbe\u7f6e\u8d85\u94fe\u63a5------" + (t8 - t7));
        JSONArray chartsData = sheetJson.getJSONArray("chart");
        if (sheetJson.containsKey((Object)"pageConfig") && sheetJson.getJSONObject("pageConfig") != null) {
            JSONObject chartImgsUrl = sheetJson.getJSONObject("pageConfig").getJSONObject("chartImgsUrl");
            if (ObjectUtils.isNotEmpty((Object)chartImgsUrl)) {
                CreateChartHelper.createChart(wb, sheet, chartsData, visibledatarow, visibledatacolumn, chartImgsUrl);
            }
            long t9 = new Date().getTime();
            System.out.println("------\u8bbe\u7f6e\u56fe\u8868------" + (t9 - t8));
        }
        ActiveSheetHelper.setActiveSheet(sheet, (String)sheetJson.get((Object)"index"), this.exportActiveIndex);
        PrintHelper.setPrintSetting(wb, sheet, sheetJson.getJSONObject("printPageData"));
        sheet.setZoom((int)(scaleHelper.getExportScale() * 100.0f));
    }

    public XSSFCellStyle createCellStyle(XSSFSheet sheet, XSSFWorkbook wb, StyleCache styleCache, JSONObject jsonObjectValue, int cellContentType) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        try {
            if (jsonObjectValue.get((Object)"mc") != null && ((JSONObject)jsonObjectValue.get((Object)"mc")).get((Object)"rs") != null && ((JSONObject)jsonObjectValue.get((Object)"mc")).get((Object)"cs") != null) {
                int r = Integer.parseInt(((JSONObject)jsonObjectValue.get((Object)"mc")).get((Object)"r").toString());
                int rs = Integer.parseInt(((JSONObject)jsonObjectValue.get((Object)"mc")).get((Object)"rs").toString());
                int c = Integer.parseInt(((JSONObject)jsonObjectValue.get((Object)"mc")).get((Object)"c").toString());
                int cs = Integer.parseInt(((JSONObject)jsonObjectValue.get((Object)"mc")).get((Object)"cs").toString());
                CellRangeAddress region = new CellRangeAddress(r, r + rs - 1, c, c + cs - 1);
                sheet.addMergedRegion(region);
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            }
        }
        catch (Exception e) {
            logger.error("\u5408\u5e76\u5355\u5143\u683c\u5931\u8d25: {}", (Object)e.getMessage());
        }
        if (cellContentType == 3) {
            return styleCache.getStyle(wb, cellStyle);
        }
        ReportCellStyleHelper.alignment(jsonObjectValue, cellStyle);
        ReportCellStyleHelper.backGround(jsonObjectValue, cellStyle);
        ReportCellStyleHelper.textBeak(jsonObjectValue, cellStyle);
        return styleCache.getStyle(wb, cellStyle, ReportFontHelper.createFont(wb, styleCache, jsonObjectValue));
    }

    private void setCellValue(XSSFWorkbook wb, XSSFSheet sheet, JSONArray jsonObjectList, JSONArray visibledatarow, JSONArray visibledatacolumn, JSONObject htmlData, StyleCache styleCache, JSONObject dataVerification) {
        if (ObjectUtils.isEmpty((Object)jsonObjectList)) {
            return;
        }
        for (int index = 0; index < jsonObjectList.size(); ++index) {
            JSONObject cellInitTextStyle;
            JSONObject object = jsonObjectList.getJSONObject(index);
            ExcelDataValidationHelper.setCellValueFlag(dataVerification, object);
            JSONObject jsonObjectValue = object.getJSONObject("v");
            JSONObject initTextStyle = new JSONObject();
            initTextStyle.put("fc", (Object)"#cccccc");
            initTextStyle.put("it", (Object)1);
            if (this.formulaTextStyle != null) {
                initTextStyle = this.formulaTextStyle;
            }
            if ((cellInitTextStyle = jsonObjectValue.getJSONObject("initTextStyle")) != null) {
                for (String key : initTextStyle.keySet()) {
                    jsonObjectValue.put(key, cellInitTextStyle.get((Object)key));
                }
            }
            JSONObject ct = jsonObjectValue.getJSONObject("ct");
            String fa = ReportFormatHelper.getFormat(ct);
            String v = "";
            String m = "";
            String cgid = "";
            if (jsonObjectValue.get((Object)"m") != null) {
                m = jsonObjectValue.getString("m");
            }
            if (jsonObjectValue.get((Object)"cgid") != null) {
                cgid = jsonObjectValue.getString("cgid");
            }
            if (jsonObjectValue.get((Object)"v") != null) {
                v = jsonObjectValue.getString("v");
            }
            int cellContentType = ReportFormatHelper.getContentType(v, jsonObjectValue, fa);
            int r = object.getIntValue("r");
            int c = object.getIntValue("c");
            XSSFRow row = sheet.getRow(r);
            if (row == null) {
                row = sheet.createRow(r);
            }
            if (row.getCell(c) == null) {
                row.createCell(c);
            }
            XSSFCell cell = row.getCell(c);
            XSSFCellStyle cellStyle = this.createCellStyle(sheet, wb, styleCache, jsonObjectValue, cellContentType);
            ReportFormatHelper.setDataFormat(wb, ct, (CellStyle)cellStyle, fa);
            ReportCellContentHelper reportCellContentHelper = new ReportCellContentHelper(wb, styleCache);
            switch (cellContentType) {
                case 0: {
                    reportCellContentHelper.setCellContent(cell, cellStyle, CellType.STRING, v);
                    break;
                }
                case 1: {
                    reportCellContentHelper.setCellContent(cell, cellStyle, CellType.NUMERIC, v);
                    break;
                }
                case 2: {
                    if (StringUtils.isBlank((CharSequence)fa)) {
                        reportCellContentHelper.setCellContent(cell, cellStyle, CellType.STRING, v);
                        break;
                    }
                    reportCellContentHelper.dealCellContextData(fa, m, v, cell, cellStyle);
                    break;
                }
                case 3: {
                    if ("html".equals(fa)) {
                        reportCellContentHelper.dealCellContextHtml(cgid, v, htmlData, this.reqURL, sheet, cell, cellStyle, jsonObjectValue);
                        break;
                    }
                    reportCellContentHelper.dealCellContextSelf(jsonObjectValue.getJSONObject("ct").getJSONArray("s"), this.reqURL, sheet, cell, jsonObjectValue);
                    break;
                }
                case 4: {
                    reportCellContentHelper.dealCellContextType(jsonObjectValue.getString("type"), jsonObjectValue.getString("checked"), v, cell, cellStyle, jsonObjectValue);
                    break;
                }
                default: {
                    reportCellContentHelper.setDefaultCellContent(cell, cellStyle, v);
                }
            }
            ReportCellFormulaHelper reportCellFormulaHelper = new ReportCellFormulaHelper(cell);
            reportCellFormulaHelper.setFormula(jsonObjectValue);
            ReportCellCommentHelper.setCellComment(jsonObjectValue, sheet, visibledatarow, visibledatacolumn, cell);
        }
    }

    static {
        parserConfig.setAutoTypeSupport(true);
        logger = LoggerFactory.getLogger(ReportToolExportExcelUtil.class);
    }
}

