/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.factory.LuckySheetFactory;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.CellDataHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.SheetBaseHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.SheetConditionFormatHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.SheetConfigHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.SheetFrozenHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.ZoomRatioHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.LuckySheet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="document.excel.tools.core.common.utils.excel.importer.ImportExcelUtil")
public class ReportToolImportExcelUtil {
    @Autowired
    private CellDataHelper cellDataHelper;
    private static final Logger logger = LoggerFactory.getLogger(ReportToolImportExcelUtil.class);

    public List<LuckySheet> importExcel(MultipartFile file) throws IOException {
        logger.info("\u5bfc\u5165excel\u89e3\u6790\u5f00\u59cb\uff0c\u8fd4\u56deluckySheet\u96c6\u5408");
        ArrayList<LuckySheet> luckySheetList = new ArrayList<LuckySheet>();
        try (InputStream inputStream = file.getInputStream();
             XSSFWorkbook workbook = new XSSFWorkbook(inputStream);){
            for (int sheetIndex = 0; sheetIndex < workbook.getNumberOfSheets(); ++sheetIndex) {
                XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
                if (sheet == null) continue;
                LuckySheet luckySheet = this.convertSheetToLuckySheet(workbook, sheet, sheetIndex);
                luckySheetList.add(luckySheet);
            }
        }
        logger.info("\u5bfc\u5165excel\u89e3\u6790\u7ed3\u675f\uff0c\u8fd4\u56deluckySheet\u96c6\u5408");
        return luckySheetList;
    }

    public LuckySheet convertSheetToLuckySheet(XSSFWorkbook workbook, XSSFSheet sheet, int sheetIndex) {
        LuckySheet luckySheet = LuckySheetFactory.createLuckySheet(sheet.getSheetName());
        SheetBaseHelper.setSheetBase(workbook, sheet, sheetIndex, luckySheet);
        SheetConfigHelper.setMerge(sheet, luckySheet);
        this.cellDataHelper.setCellData(workbook, sheet, luckySheet);
        SheetConfigHelper.setRowHeightAndHidden(sheet, luckySheet);
        SheetConfigHelper.setColumnWithAndHidden(sheet, luckySheet);
        SheetConditionFormatHelper.setConditionFormat(workbook, sheet, luckySheet);
        SheetFrozenHelper.setFrozen(sheet, luckySheet);
        ZoomRatioHelper.setZoomRatio(sheet, luckySheet);
        return luckySheet;
    }
}

