/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.jxdinfo.document.excel.tools.core.common.utils.fileUpload.FileUploadUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.fileUpload.ReportToolImageCompressConfig;
import com.jxdinfo.document.excel.tools.core.common.utils.offLine.ImageSrcBase64Map;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class ImgUtil {
    public static byte[] decodeBase64ToBytes(String src) {
        String base64Encoder = src.substring(src.indexOf(",") + 1);
        return Base64.getDecoder().decode(base64Encoder);
    }

    public static BufferedImage bytesToBufferedImage(byte[] imageBytes) {
        try {
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] compressImage(BufferedImage bufferedImage, String imgType) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ReportToolImageCompressConfig compressConfig = new ReportToolImageCompressConfig();
        switch (imgType) {
            case "jpeg": 
            case "png": 
            case "gif": 
            case "bmp": {
                if ("image/png".equals(imgType) || "image/gif".equals(imgType)) {
                    bufferedImage = ImgUtil.checkImageBands(bufferedImage);
                }
                int maximum = compressConfig.getCompressMaximum();
                float quality = compressConfig.getCompressQuality();
                Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).size(compressConfig.getDefaultWidth(), compressConfig.getDefaultHeight()).keepAspectRatio(true).outputFormat(imgType.toLowerCase()).outputQuality(quality).toOutputStream((OutputStream)outputStream);
                byte[] compressed = outputStream.toByteArray();
                while (compressed.length > maximum && quality > 0.2f) {
                    outputStream.reset();
                    quality = Math.max(quality * 0.9f, 0.2f);
                    Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).size(compressConfig.getDefaultWidth(), compressConfig.getDefaultHeight()).outputQuality(quality).outputFormat(imgType.toLowerCase()).toOutputStream((OutputStream)outputStream);
                    compressed = outputStream.toByteArray();
                }
                break;
            }
            case "webp": 
            case "tiff": {
                outputStream = ImgUtil.imageToType(bufferedImage, "PNG");
                break;
            }
            case "wmf": 
            case "application/octet-stream": {
                outputStream = ImgUtil.imageToType(bufferedImage, "SVG");
                break;
            }
            default: {
                outputStream = ImgUtil.imageToType(bufferedImage, imgType.toUpperCase(Locale.ROOT));
            }
        }
        return outputStream.toByteArray();
    }

    public static BufferedImage checkImageBands(BufferedImage bufferedImage) {
        WritableRaster raster = bufferedImage.getRaster();
        int numBands = raster.getNumBands();
        if (numBands != 4) {
            bufferedImage = FileUploadUtil.generateFourBandsBufferedImage(bufferedImage);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream imageToType(BufferedImage bufferedImage, String type) throws IOException {
        BufferedImage processedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D g2d = processedImage.createGraphics();
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageWriter writer = ImageIO.getImageWritersByFormatName(type).next();
        try (ImageOutputStream imageOutput = ImageIO.createImageOutputStream(byteArrayOutputStream);){
            writer.setOutput(imageOutput);
            writer.write(processedImage);
        }
        finally {
            writer.dispose();
        }
        return byteArrayOutputStream;
    }

    public static String restoreUrls(String html) {
        if (StringUtils.isEmpty((CharSequence)html)) {
            return "";
        }
        Document doc = Jsoup.parse((String)html);
        for (Element img : doc.select("img[src]")) {
            String originalPath;
            String src = img.attr("src");
            if (!src.startsWith("data:image") || (originalPath = ImageSrcBase64Map.getBase64ToUrlMap(src)) == null) continue;
            img.attr("src", originalPath);
        }
        for (Element img : doc.select("img[data-mce-src]")) {
            String originalTinymcePath;
            String dataMceSrc = img.attr("data-mce-src");
            if (!dataMceSrc.startsWith("data:image") || (originalTinymcePath = ImageSrcBase64Map.getBase64ToUrlMap(dataMceSrc)) == null) continue;
            img.attr("data-mce-src", originalTinymcePath);
        }
        return doc.outerHtml();
    }
}

