/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper;

import com.jxdinfo.document.excel.tools.core.common.utils.CalUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelImportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.factory.LuckySheetFactory;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.ConditionFormatStyle;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.LuckySheet;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.RowAndColRange;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.SheetConditionFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.ConditionFilterType;
import org.apache.poi.ss.usermodel.ConditionType;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SheetConditionFormatHelper {
    public static void setConditionFormat(XSSFWorkbook workbook, XSSFSheet sheet, LuckySheet luckySheet) {
        XSSFSheetConditionalFormatting formatting = sheet.getSheetConditionalFormatting();
        if (Objects.isNull(formatting)) {
            return;
        }
        int formattingNum = formatting.getNumConditionalFormattings();
        if (formattingNum == 0) {
            return;
        }
        ArrayList<SheetConditionFormat> sheetConditionFormatList = new ArrayList<SheetConditionFormat>();
        for (int i = 0; i < formattingNum; ++i) {
            ConditionalFormatting cf = formatting.getConditionalFormattingAt(i);
            CellRangeAddress[] ranges = cf.getFormattingRanges();
            ArrayList<RowAndColRange> cellRangeAddressList = new ArrayList<RowAndColRange>();
            RowAndColRange rowAndColRange = new RowAndColRange();
            rowAndColRange.setRow(Arrays.asList(ranges[0].getFirstRow(), ranges[0].getLastRow()));
            rowAndColRange.setColumn(Arrays.asList(ranges[0].getFirstColumn(), ranges[0].getLastColumn()));
            cellRangeAddressList.add(rowAndColRange);
            for (int j = 0; j < cf.getNumberOfRules(); ++j) {
                ConditionalFormattingRule rule = cf.getRule(j);
                ConditionType conditionType = rule.getConditionType();
                byte type = rule.getComparisonOperation();
                ConditionFilterType conditionFilterType = rule.getConditionFilterType();
                if (!conditionType.equals(ConditionType.CELL_VALUE_IS) && !conditionType.equals(ConditionType.FORMULA) && !conditionType.equals(ConditionType.FILTER)) continue;
                String formula1 = rule.getFormula1();
                String formula2 = rule.getFormula2();
                boolean isTextContains = conditionType.equals(ConditionType.FORMULA) && SheetConditionFormatHelper.isFormatTextContains(formula1);
                conditionFilterType = isTextContains ? ConditionFilterType.CONTAINS_TEXT : conditionFilterType;
                SheetConditionFormat sheetConditionFormat = LuckySheetFactory.createConditionFormat();
                sheetConditionFormat.setType("default");
                sheetConditionFormat.setConditionName(SheetConditionFormatHelper.getConditionName(type, conditionFilterType));
                sheetConditionFormat.setConditionValue(SheetConditionFormatHelper.getConditionValue(formula1, formula2, conditionType, conditionFilterType));
                sheetConditionFormat.setConditionValueType(SheetConditionFormatHelper.getConditionValueType(conditionType));
                sheetConditionFormat.setFormat(SheetConditionFormatHelper.getConditionFormatStyle(workbook, rule));
                sheetConditionFormat.setCellrange(cellRangeAddressList);
                sheetConditionFormatList.add(sheetConditionFormat);
            }
        }
        luckySheet.setLuckysheet_conditionformat_save(sheetConditionFormatList);
    }

    private static ConditionFormatStyle getConditionFormatStyle(XSSFWorkbook workbook, ConditionalFormattingRule rule) {
        ConditionFormatStyle conditionFormatStyle = new ConditionFormatStyle();
        PatternFormatting patternFormatting = rule.getPatternFormatting();
        if (patternFormatting != null) {
            XSSFColor bgColor = (XSSFColor)patternFormatting.getFillBackgroundColorColor();
            conditionFormatStyle.setCellColor(CalUtil.getColor(workbook, bgColor));
        } else {
            conditionFormatStyle.setCellColor("#ffffff");
        }
        FontFormatting fontFormatting = rule.getFontFormatting();
        if (fontFormatting != null) {
            XSSFColor fontColor = (XSSFColor)fontFormatting.getFontColor();
            if (fontColor != null) {
                conditionFormatStyle.setTextColor(CalUtil.getColor(workbook, fontColor));
            }
            conditionFormatStyle.setTextBold(fontFormatting.isBold() ? "1" : "0");
        } else {
            conditionFormatStyle.setTextColor("#000000");
            conditionFormatStyle.setTextBold("0");
        }
        return conditionFormatStyle;
    }

    private static String getConditionValueType(ConditionType conditionType) {
        return conditionType.equals(ConditionType.FORMULA) ? "formula" : "fixedText";
    }

    private static List<String> getConditionValue(String formula1, String formula2, ConditionType conditionType, ConditionFilterType conditionFilterType) {
        ArrayList<String> conditionValue = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)formula1)) {
            conditionValue.add(StringUtil.cleanExcelImportFormulaValue(formula1));
        } else {
            if (conditionFilterType.equals((Object)ConditionFilterType.DUPLICATE_VALUES)) {
                conditionValue.add("0");
            }
            if (conditionFilterType.equals((Object)ConditionFilterType.UNIQUE_VALUES)) {
                conditionValue.add("1");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)formula2)) {
            conditionValue.add(conditionType.equals(ConditionType.FORMULA) ? (formula2.startsWith("=") ? formula2 : "=" + formula2) : formula2);
        }
        return conditionValue;
    }

    private static String getConditionName(byte type, ConditionFilterType conditionFilterType) {
        switch (type) {
            case 0: {
                return ExcelImportConstant.CONDITION_FORMAT_CELL_RULE_TYPE.get(conditionFilterType);
            }
            case 1: {
                if (conditionFilterType == null) {
                    return "betweenness";
                }
                return conditionFilterType.equals((Object)ConditionFilterType.CONTAINS_TEXT) ? "textContains" : "betweenness";
            }
            case 3: {
                return "equal";
            }
            case 4: {
                return "lessOrEqual";
            }
            case 5: {
                return "greaterThan";
            }
            case 6: {
                return "lessThan";
            }
        }
        return "";
    }

    public static boolean isFormatTextContains(String formula) {
        if (formula == null) {
            return false;
        }
        return formula.startsWith("ISNUMBER(SEARCH(") && formula.endsWith("))");
    }

    public static boolean isTextContains(String formula) {
        if (formula == null) {
            return false;
        }
        return formula.startsWith("NOT(ISERROR(SEARCH(") && formula.endsWith("))");
    }
}

