/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.RowColHelper;
import java.util.Base64;
import java.util.Map;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CreateChartHelper {
    public static void createChart(XSSFWorkbook wb, XSSFSheet sheet, JSONArray chartsData, JSONArray visibledatarow, JSONArray visibledatacolumn, JSONObject chartImgsUrl) {
        if (chartsData != null && !chartsData.isEmpty()) {
            for (int i = 0; i < chartsData.size(); ++i) {
                JSONObject chartData = chartsData.getJSONObject(i);
                String chartId = chartData.getString("chart_id");
                if (chartId == null) continue;
                String chartImgData = chartImgsUrl.getString(chartId);
                if (chartImgData != null) {
                    String base64String = chartImgData.replace("data:image/png;base64,", "");
                    byte[] imageData = Base64.getDecoder().decode(base64String);
                    int pictureIdx = wb.addPicture(imageData, 6);
                    Map<String, Integer> position = RowColHelper.getColRowMap(chartData, visibledatarow, visibledatacolumn);
                    XSSFDrawing drawing = sheet.createDrawingPatriarch();
                    ClientAnchor anchor = drawing.createAnchor(position.get("dx1").intValue(), position.get("dy1").intValue(), position.get("dx2").intValue(), position.get("dy2").intValue(), position.get("col1").intValue(), position.get("row1").intValue(), position.get("col2").intValue(), position.get("row2").intValue());
                    Picture pict = drawing.createPicture(anchor, pictureIdx);
                    pict.resize();
                    continue;
                }
                System.out.println("No data found for Chart ID: " + chartId);
            }
        }
    }
}

