/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelExportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ColorHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.IndexHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import org.apache.poi.xssf.usermodel.XSSFFontFormatting;
import org.apache.poi.xssf.usermodel.XSSFPatternFormatting;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;

public class ConditionFormatHelper {
    public static void setConditionFormat(JSONArray conditionFormatList, XSSFSheet sheet) {
        JSONObject cfComparisonOperation = ExcelExportConstant.cfComparisonOperation;
        XSSFSheetConditionalFormatting sheetCF = sheet.getSheetConditionalFormatting();
        for (int i = conditionFormatList.size() - 1; i >= 0; --i) {
            JSONObject conditionFormat = conditionFormatList.getJSONObject(i);
            String cfType = conditionFormat.getString("type");
            String cfName = conditionFormat.getString("conditionName");
            JSONArray cfValue = conditionFormat.getJSONArray("conditionValue");
            if (cfValue == null || ObjectUtils.isEmpty((Object)cfValue)) continue;
            String val1 = null;
            String val2 = null;
            if (cfValue.getString(0) != null) {
                val1 = cfValue.getString(0);
            }
            if (cfValue.size() > 1 && cfValue.getString(1) != null) {
                val2 = cfValue.getString(1);
            }
            if (val1 != null) {
                val1 = StringUtil.cleanExcelFormulaValue(val1, cfName);
            }
            if (val2 != null) {
                val2 = StringUtil.cleanExcelFormulaValue(val2, cfName);
            }
            if (cfType.equals("default")) {
                XSSFConditionalFormattingRule rule;
                String formula;
                JSONArray column;
                JSONObject cellRange;
                JSONArray cfCellRange;
                XSSFConditionalFormattingRule rule2;
                if (cfComparisonOperation.containsKey((Object)cfName)) {
                    if (StringUtil.isNumber(val1)) {
                        double eps = 1.0E-5;
                        if (cfName.equals("greaterThan")) {
                            double adjustedVal = 0.0;
                            adjustedVal = Double.parseDouble(val1) + eps;
                            val1 = String.valueOf(adjustedVal);
                        } else if (cfName.equals("lessThan")) {
                            double adjustedVal = 0.0;
                            adjustedVal = Double.parseDouble(val1) - eps;
                            val1 = String.valueOf(adjustedVal);
                        }
                    }
                    rule2 = sheetCF.createConditionalFormattingRule(cfComparisonOperation.getByte(cfName).byteValue(), val1, val2);
                    ConditionFormatHelper.handleConditionFotmatData(sheetCF, rule2, conditionFormat);
                    continue;
                }
                if (cfName.equals("formula")) {
                    rule2 = sheetCF.createConditionalFormattingRule(val1);
                    ConditionFormatHelper.handleConditionFotmatData(sheetCF, rule2, conditionFormat);
                    continue;
                }
                if (cfName.equals("textContains")) {
                    cfCellRange = conditionFormat.getJSONArray("cellrange");
                    cellRange = cfCellRange.getJSONObject(0);
                    JSONArray row = cellRange.getJSONArray("row");
                    column = cellRange.getJSONArray("column");
                    String cellPos = IndexHelper.convertToRelativeCellRange(ConditionFormatHelper.jsonArrayToIntArray(row), ConditionFormatHelper.jsonArrayToIntArray(column));
                    formula = "ISNUMBER(SEARCH(" + val1 + ", " + cellPos + "))";
                    rule = sheetCF.createConditionalFormattingRule(formula);
                    ConditionFormatHelper.handleConditionFotmatData(sheetCF, rule, conditionFormat);
                    continue;
                }
                if (!cfName.equals("duplicateValue")) continue;
                cfCellRange = conditionFormat.getJSONArray("cellrange");
                cellRange = cfCellRange.getJSONObject(0);
                JSONArray row = cellRange.getJSONArray("row");
                column = cellRange.getJSONArray("column");
                String cellRangeRef = IndexHelper.convertToCellRange(ConditionFormatHelper.jsonArrayToIntArray(row), ConditionFormatHelper.jsonArrayToIntArray(column));
                formula = StringUtils.equals((CharSequence)"0", (CharSequence)val1) ? "SUMPRODUCT(1*(" + cellRangeRef + "=" + cellRangeRef.split(":")[0].replace("$", "") + "))>1" : "SUMPRODUCT(1*(" + cellRangeRef + "=" + cellRangeRef.split(":")[0].replace("$", "") + "))=1";
                rule = sheetCF.createConditionalFormattingRule(formula);
                ConditionFormatHelper.handleConditionFotmatData(sheetCF, rule, conditionFormat);
                continue;
            }
            if (!cfType.equals("dataBar") && !cfType.equals("icons") && !cfType.equals("colorGradation")) continue;
        }
    }

    public static void handleConditionFotmatData(XSSFSheetConditionalFormatting sheetCF, XSSFConditionalFormattingRule rule, JSONObject conditionFormat) {
        XSSFFontFormatting fontFormatting;
        JSONArray cfCellRange = conditionFormat.getJSONArray("cellrange");
        JSONObject cfFormat = conditionFormat.getJSONObject("format");
        if (cfFormat.getString("cellColor") != null && !cfFormat.getString("cellColor").equals("")) {
            XSSFPatternFormatting patternFormatting = rule.createPatternFormatting();
            XSSFColor bgColor = ColorHelper.parseColorToXSSF(cfFormat.getString("cellColor"));
            patternFormatting.setFillBackgroundColor((Color)bgColor);
        }
        if (cfFormat.getString("textColor") != null && !cfFormat.getString("textColor").equals("")) {
            fontFormatting = rule.createFontFormatting();
            XSSFColor fontColor = ColorHelper.parseColorToXSSF(cfFormat.getString("textColor"));
            fontFormatting.setFontColor((Color)fontColor);
        }
        if (cfFormat.get((Object)"textBold") != null && cfFormat.getBooleanValue("textBold")) {
            fontFormatting = rule.createFontFormatting();
            fontFormatting.setFontStyle(true, false);
        }
        CellRangeAddress[] regions = new CellRangeAddress[cfCellRange.size()];
        for (int j = 0; j < cfCellRange.size(); ++j) {
            CellRangeAddress cellAddresses;
            JSONObject range = cfCellRange.getJSONObject(j);
            JSONArray column = range.getJSONArray("column");
            JSONArray row = range.getJSONArray("row");
            regions[j] = cellAddresses = new CellRangeAddress(row.getIntValue(0), row.getIntValue(1), column.getIntValue(0), column.getIntValue(1));
        }
        sheetCF.addConditionalFormatting(regions, (ConditionalFormattingRule)rule);
    }

    public static int[] jsonArrayToIntArray(JSONArray jsonArray) {
        int[] intArray = new int[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            intArray[i] = jsonArray.getIntValue(i);
        }
        return intArray;
    }
}

