/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelExportConstant;
import java.awt.Color;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class ColorHelper {
    private static final XSSFColor DEFAULT_COLOR = new XSSFColor(new byte[]{0, 0, 0}, (IndexedColorMap)new DefaultIndexedColorMap());
    private static final XSSFColor DEFAULT_COLOR_BLACK = new XSSFColor(new byte[]{-1, -1, -1}, (IndexedColorMap)new DefaultIndexedColorMap());

    public static XSSFColor getDefaultColor() {
        return DEFAULT_COLOR;
    }

    public static XSSFColor getDefaultColorBlack() {
        return DEFAULT_COLOR_BLACK;
    }

    public static XSSFColor parseColorToXSSF(String colorStr) {
        if (StringUtils.isBlank((CharSequence)colorStr)) {
            return ColorHelper.getDefaultColorBlack();
        }
        if (colorStr.contains("#")) {
            colorStr = colorStr.substring(1);
            Color color = new Color(Integer.parseInt(colorStr, 16));
            return new XSSFColor(color, (IndexedColorMap)new DefaultIndexedColorMap());
        }
        if (ExcelExportConstant.fc_FontColor.containsKey(colorStr)) {
            colorStr = ExcelExportConstant.fc_FontColor.get(colorStr);
            String[] colors = colorStr.split(",");
            Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
            return new XSSFColor(color, (IndexedColorMap)new DefaultIndexedColorMap());
        }
        if (colorStr.contains("(") && colorStr.contains(")")) {
            int strStartIndex = colorStr.indexOf("(");
            int strEndIndex = colorStr.indexOf(")");
            String[] colors = colorStr.substring(strStartIndex + 1, strEndIndex).split(",");
            Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
            return new XSSFColor(color, (IndexedColorMap)new DefaultIndexedColorMap());
        }
        if ("transparent".equals(colorStr)) {
            colorStr = ExcelExportConstant.fc_FontColor.get("White");
            String[] colors = colorStr.split(",");
            Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
            return new XSSFColor(color, (IndexedColorMap)new DefaultIndexedColorMap());
        }
        return ColorHelper.getDefaultColorBlack();
    }

    private static String colorFormat(String[] colors) {
        String R = Integer.toHexString(Integer.parseInt(colors[0].replaceAll(" ", "")));
        R = R.length() < 2 ? '0' + R : R;
        String G = Integer.toHexString(Integer.parseInt(colors[1].replaceAll(" ", "")));
        G = G.length() < 2 ? '0' + G : G;
        String B = Integer.toHexString(Integer.parseInt(colors[2].replaceAll(" ", "")));
        B = B.length() < 2 ? '0' + B : B;
        return R + G + B;
    }

    public static XSSFColor parseColorByARGBHex(final String argbHex) {
        if (argbHex == null || argbHex.length() != 8) {
            return ColorHelper.getDefaultColor();
        }
        try {
            int red = Integer.parseInt(argbHex.substring(2, 4), 16);
            int green = Integer.parseInt(argbHex.substring(4, 6), 16);
            int blue = Integer.parseInt(argbHex.substring(6, 8), 16);
            return new XSSFColor(new byte[]{(byte)red, (byte)green, (byte)blue}, (IndexedColorMap)new DefaultIndexedColorMap()){

                public String getARGBHex() {
                    return argbHex.toUpperCase();
                }
            };
        }
        catch (NumberFormatException e) {
            return ColorHelper.getDefaultColor();
        }
    }
}

