/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.strategy;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.strategy.CellDataValueStrategy;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellData;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellDataMc;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractCellDataValueStrategy
implements CellDataValueStrategy {
    protected DataFormatter dataFormatter = new DataFormatter();

    @Override
    public final void setCellDataValue(XSSFWorkbook workbook, Map<String, CellDataMc> merge, XSSFCell cell, CellData cellData) {
        this.setCellValue(workbook, cell, cellData);
        this.setFormattedValue(merge, cell, cellData);
    }

    protected abstract void setCellValue(XSSFWorkbook var1, XSSFCell var2, CellData var3);

    protected void setFormattedValue(Map<String, CellDataMc> merge, XSSFCell cell, CellData cellData) {
        cellData.getV().setM(this.dataFormatter.formatCellValue((Cell)cell));
        if (merge == null) {
            return;
        }
        for (Map.Entry<String, CellDataMc> entry : merge.entrySet()) {
            CellDataMc cellDataMc = entry.getValue();
            if (cellDataMc.getR() != cellData.getR() || cellDataMc.getC() != cellData.getC()) continue;
            cellData.getV().setMc(cellDataMc);
        }
    }
}

