/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ReportStatusEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.Matrix;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders.LsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import sun.misc.BASE64Encoder;

public class ReportUtil {
    public static void main(String[] args) {
    }

    public static void addToZipFile(String filePath, FileInputStream fis, ZipOutputStream zipOut) throws IOException {
        int length;
        File file = new File(filePath);
        ZipEntry zipEntry = new ZipEntry(file.getName());
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        zipOut.closeEntry();
        fis.close();
    }

    public static void imagesZipToPdf(InputStream is, String pdfPath, String pageOrientation, String pageSize) {
        try {
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)pageOrientation)) {
                pageOrientation = "portrait";
            }
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)pageSize)) {
                pageSize = "A4";
            }
            Rectangle docS = PageSize.A4;
            if (pageSize.equals("A5")) {
                docS = PageSize.A5;
            }
            if (pageOrientation.equals("landscape")) {
                docS = docS.rotate();
            }
            Document doc = new Document(docS);
            doc.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            FileOutputStream fos = new FileOutputStream(pdfPath);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)fos);
            doc.open();
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry en = zis.getNextEntry();
            ArrayList<Integer> imgNames = new ArrayList<Integer>();
            ArrayList<com.itextpdf.text.Image> images = new ArrayList<com.itextpdf.text.Image>();
            byte[] buffer = new byte[1024];
            while (en != null) {
                String imgName = en.getName();
                if (imgName.endsWith(".png")) {
                    int len;
                    ByteArrayOutputStream ms = new ByteArrayOutputStream();
                    while ((len = zis.read(buffer)) > 0) {
                        ms.write(buffer, 0, len);
                    }
                    com.itextpdf.text.Image img = com.itextpdf.text.Image.getInstance((byte[])ms.toByteArray());
                    img.scaleToFit(PageSize.A4.getWidth(), PageSize.A4.getHeight());
                    images.add(img);
                    imgNames.add(Integer.valueOf(imgName.substring(0, imgName.indexOf(46))));
                }
                en = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            for (int p = 1; p <= images.size(); ++p) {
                if (p > 1) {
                    doc.newPage();
                }
                int idx = imgNames.indexOf(p);
                doc.add((Element)images.get(idx));
            }
            doc.close();
            writer.close();
            fos.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static boolean isJsonString(String json) {
        String patter = "\\{.*\\}|\\[.*\\]";
        Pattern r = Pattern.compile(patter);
        Matcher m = r.matcher(json);
        return m.matches();
    }

    public static Map<String, Object> doBatchSqlOrRest(List<Map<String, Object>> urlToParamList, DataSource dataSource) {
        ConcurrentHashMap<String, Object> ans = new ConcurrentHashMap<String, Object>();
        if (urlToParamList == null || urlToParamList.size() == 0) {
            return null;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(urlToParamList.size());
        CopyOnWriteArrayList resultList = new CopyOnWriteArrayList();
        ConcurrentHashMap restAns = new ConcurrentHashMap();
        long timestamp1 = System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(urlToParamList.size());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.execute(connection -> {
            for (Map map : urlToParamList) {
                executorService.execute(() -> {
                    System.out.println("\u5f00\u59cb\u6267\u884c\u7ebf\u7a0b");
                    if (String.valueOf(map.get("type")).equalsIgnoreCase("sql")) {
                        Statement statement = null;
                        ResultSet resultSetEach = null;
                        String sql = String.valueOf(map.get("sql"));
                        String name = String.valueOf(map.get("name"));
                        String id = String.valueOf(map.get("id"));
                        try {
                            statement = connection.createStatement();
                            resultSetEach = statement.executeQuery(sql);
                            System.out.println("\u5df2\u6267\u884cSQL\uff1a" + sql);
                            ResultSetMetaData metaData = resultSetEach.getMetaData();
                            while (resultSetEach.next()) {
                                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                                    dataMap.put(metaData.getColumnLabel(i), resultSetEach.getObject(i));
                                }
                                HashMap<String, HashMap<String, Object>> SqlStrToData = new HashMap<String, HashMap<String, Object>>();
                                SqlStrToData.put(sql + ":" + name + ":" + id, dataMap);
                                resultList.add(SqlStrToData);
                            }
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                            HashMap<String, String> dataMap = new HashMap<String, String>();
                            dataMap.put("-6", sql + ";" + ex.toString());
                            resultList.add(dataMap);
                        }
                    } else if (String.valueOf(map.get("type")).equalsIgnoreCase("get")) {
                        Object paramObj = map.get("param");
                        String url = String.valueOf(map.get("url"));
                        String type = String.valueOf(map.get("type"));
                        String name = String.valueOf(map.get("name"));
                        String id = String.valueOf(map.get("id"));
                        if (ObjectUtils.isNotNull((Object[])new Object[]{paramObj}) && !(paramObj instanceof JSONObject)) {
                            restAns.put(url + ":" + type + ":" + name, "error,-8,\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u51fa\u9519\uff0c\u5e94\u4e3aJSONObject");
                        } else {
                            JSONObject param = (JSONObject)paramObj;
                            String json = ReportUtil.getJson(param, url);
                            System.out.println("\u5df2\u6267\u884cGET\u8bf7\u6c42\uff1a" + url);
                            restAns.put(url + ":" + type + ":" + name + ":" + id, json);
                        }
                    } else if (String.valueOf(map.get("type")).equalsIgnoreCase("post")) {
                        Object paramObj = map.get("param");
                        String url = String.valueOf(map.get("url"));
                        String type = String.valueOf(map.get("type"));
                        String name = String.valueOf(map.get("name"));
                        String id = String.valueOf(map.get("id"));
                        if (ObjectUtils.isNotNull((Object[])new Object[]{paramObj}) && !(paramObj instanceof JSONObject)) {
                            restAns.put(url + ":" + type + ":" + name, "error,-8,\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u51fa\u9519\uff0c\u5e94\u4e3aJSONObject");
                        } else {
                            JSONObject param = (JSONObject)paramObj;
                            String json = ReportUtil.postJson(param, url);
                            System.out.println("\u5df2\u6267\u884cPOST\u8bf7\u6c42\uff1a" + url);
                            restAns.put(url + ":" + type + ":" + name + ":" + id, json);
                        }
                    }
                    latch.countDown();
                });
            }
            executorService.shutdown();
            boolean allTasksFinished = false;
            try {
                latch.await();
                ans.put("SQL", resultList);
                ans.put("REST", restAns);
                return ans;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        return ans;
    }

    public static List<Map<String, Object>> doBatchSql(List<String> sqlList, DataSource dataSource) {
        ExecutorService executorService = Executors.newFixedThreadPool(sqlList.size());
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        long timestamp1 = System.currentTimeMillis();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.execute(connection -> {
            for (String s : sqlList) {
                executorService.execute(() -> {
                    Statement statement = null;
                    ResultSet resultSetEach = null;
                    try {
                        statement = connection.createStatement();
                        resultSetEach = statement.executeQuery(s);
                        System.out.println("\u5df2\u6267\u884cSQL\uff1a" + s);
                        ResultSetMetaData metaData = resultSetEach.getMetaData();
                        while (resultSetEach.next()) {
                            HashMap<String, Object> dataMap = new HashMap<String, Object>();
                            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                                dataMap.put(metaData.getColumnLabel(i), resultSetEach.getObject(i));
                            }
                            HashMap<String, HashMap<String, Object>> SqlStrToData = new HashMap<String, HashMap<String, Object>>();
                            SqlStrToData.put(s, dataMap);
                            resultList.add(SqlStrToData);
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        HashMap<String, String> dataMap = new HashMap<String, String>();
                        dataMap.put("-6", s + ";" + ex.toString());
                        resultList.add(dataMap);
                    }
                });
            }
            executorService.shutdown();
            boolean allTasksFinished = false;
            while (!allTasksFinished) {
                long times;
                if (executorService.isTerminated()) {
                    long timestamp2 = System.currentTimeMillis();
                    times = timestamp2 - timestamp1;
                    System.out.println("SQL\u6267\u884c\u65f6\u95f4\u4e3a\uff1a" + times + "\u6beb\u79d2");
                    allTasksFinished = true;
                    connection.close();
                    return resultList;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                long timestamp2 = System.currentTimeMillis();
                times = timestamp2 - timestamp1;
                if (times <= 300000L) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("WARNING", "timeout(\u8d85\u65f6)");
                resultList.add(map);
                executorService.shutdownNow();
                return resultList;
            }
            return null;
        });
        return resultList;
    }

    public static Map<String, Object> doBatchRequest(List<Map<String, Object>> urlToParamList) {
        if (urlToParamList.isEmpty()) {
            return null;
        }
        long timestamp1 = System.currentTimeMillis();
        HashMap<String, Object> ans = new HashMap<String, Object>();
        ExecutorService executorService = Executors.newFixedThreadPool(urlToParamList.size());
        for (Map<String, Object> stringStringMap : urlToParamList) {
            Object paramObj = stringStringMap.get("param");
            String url = String.valueOf(stringStringMap.get("url"));
            String type = String.valueOf(stringStringMap.get("type"));
            if (ObjectUtils.isNotNull((Object[])new Object[]{paramObj}) && !(paramObj instanceof JSONObject)) {
                ans.put(url + ":" + type, "error,-8,\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u51fa\u9519\uff0c\u5e94\u4e3aJSONObject");
                continue;
            }
            JSONObject param = (JSONObject)paramObj;
            executorService.execute(() -> {
                if (type.equalsIgnoreCase("POST")) {
                    String s = ReportUtil.postJson(param, url);
                    System.out.println("\u5df2\u6267\u884cPOST\u8bf7\u6c42\uff1a" + url);
                    ans.put(url + ":" + type, s);
                } else if (type.equalsIgnoreCase("GET")) {
                    String json = ReportUtil.getJson(param, url);
                    System.out.println("\u5df2\u6267\u884cGET\u8bf7\u6c42\uff1a" + url);
                    ans.put(url + ":" + type, json);
                }
            });
        }
        executorService.shutdown();
        boolean allTasksFinished = false;
        while (!allTasksFinished) {
            if (executorService.isTerminated()) {
                long timestamp2 = System.currentTimeMillis();
                long times = timestamp2 - timestamp1;
                System.out.println("REST\u6267\u884c\u65f6\u95f4\u4e3a\uff1a" + times + "\u6beb\u79d2");
                allTasksFinished = true;
                return ans;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            long timestamp2 = System.currentTimeMillis();
            long times = timestamp2 - timestamp1;
            if (times <= 300000L) continue;
            ans.put("WARNING", "timeout(\u8d85\u65f6)");
            executorService.shutdownNow();
            return ans;
        }
        return null;
    }

    public static String replaceSqlPlaceholders(String sql, String placeholder) {
        String lowerCaseSql = sql.toUpperCase();
        if (lowerCaseSql.startsWith("SELECT")) {
            if (!(lowerCaseSql.contains("CREATE") || lowerCaseSql.contains("UPDATE") || lowerCaseSql.contains("DELETE") || lowerCaseSql.contains("DROP") || lowerCaseSql.contains("TUNCATE"))) {
                JSONObject parseSlcs = new JSONObject();
                try {
                    parseSlcs = (JSONObject)JSON.parse((String)placeholder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "error,-5,\u5360\u4f4d\u7b26\u683c\u6709\u8bef\uff0c\u5e94\u4e3ajson\u5bf9\u8c61";
                }
                for (Map.Entry entry : parseSlcs.entrySet()) {
                    String k = (String)entry.getKey();
                    String v = String.valueOf(entry.getValue());
                    String s = ReportStatusEnum.SOURCE_PLACEHOLDER_FIRST_HALF.getValue() + k + ReportStatusEnum.SOURCE_PLACEHOLDER_SECOND_HALF.getValue();
                    String replace = StringUtils.replace((String)sql, (String)s, (String)v);
                    sql = sql.replaceAll(s, "'" + v + "'");
                }
                return sql;
            }
            return "error,-2,\u7981\u6b62SQL\u6ce8\u5165";
        }
        if (lowerCaseSql.startsWith("CALL")) {
            JSONObject parseSlcs = new JSONObject();
            try {
                parseSlcs = (JSONObject)JSON.parse((String)placeholder);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "error,-5,\u5360\u4f4d\u7b26\u683c\u6709\u8bef\uff0c\u5e94\u4e3ajson\u5bf9\u8c61";
            }
            for (Map.Entry entry : parseSlcs.entrySet()) {
                String k = (String)entry.getKey();
                String v = String.valueOf(entry.getValue());
                String s = ReportStatusEnum.SOURCE_PLACEHOLDER_FIRST_HALF.getValue() + k + ReportStatusEnum.SOURCE_PLACEHOLDER_SECOND_HALF.getValue();
                String replace = StringUtils.replace((String)sql, (String)s, (String)v);
                sql = sql.replaceAll(s, "'" + v + "'");
            }
            return sql;
        }
        return "error,-3,SQL\u8bed\u53e5\u683c\u5f0f\u6709\u8bef";
    }

    public static String replaceRestPlaceholders(String inParams, String placeholder) {
        if (StringUtils.isEmpty((CharSequence)inParams) || StringUtil.isStringEmptyObject(inParams)) {
            return placeholder;
        }
        JSONObject parseSlcs = new JSONObject();
        try {
            parseSlcs = (JSONObject)JSON.parse((String)placeholder);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error,-5,\u5360\u4f4d\u7b26\u683c\u6709\u8bef\uff0c\u5e94\u4e3ajson\u5bf9\u8c61";
        }
        JSONObject paramsObj = new JSONObject();
        try {
            paramsObj = (JSONObject)JSON.parse((String)StringUtil.deepParseJson(inParams).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error,-10,\u5165\u53c2\u683c\u5f0f\u6709\u8bef";
        }
        block4: for (Map.Entry param : paramsObj.entrySet()) {
            String value = param.getValue().toString();
            int i = 1;
            for (Map.Entry entry : parseSlcs.entrySet()) {
                String k = (String)entry.getKey();
                String v = String.valueOf(entry.getValue());
                String s = ReportStatusEnum.SOURCE_PLACEHOLDER_FIRST_HALF.getValue() + k + ReportStatusEnum.SOURCE_PLACEHOLDER_SECOND_HALF.getValue();
                if (StringUtil.extractBracketContent(value).equals(k)) {
                    param.setValue(param.getValue().toString().replaceAll(s, "" + v + ""));
                    continue block4;
                }
                if (parseSlcs.size() == i) {
                    param.setValue("");
                }
                ++i;
            }
        }
        return paramsObj.toJSONString();
    }

    public static String delOtherPic(String jsonStr) {
        JSONObject parseObj = (JSONObject)JSON.parse((String)jsonStr);
        JSONObject imagesObj = (JSONObject)parseObj.get((Object)"images");
        JSONObject realImagesObj = new JSONObject();
        for (Map.Entry entry : imagesObj.entrySet()) {
            String k = (String)entry.getKey();
            JSONObject vObj = (JSONObject)entry.getValue();
            if (k.contains("seal_")) continue;
            JSONObject defaultObj = (JSONObject)vObj.get((Object)"default");
            Double top = Double.valueOf(String.valueOf(defaultObj.get((Object)"top")));
            Double left = Double.valueOf(String.valueOf(defaultObj.get((Object)"left")));
            if (top >= 50.0 && top <= 300.0 && left >= 0.0 && left <= 400.0 || top >= 50.0 && top <= 300.0 && left >= 500.0 && left <= 1000.0 || top >= 600.0 && top <= 1500.0 && left >= 200.0 && left <= 800.0) continue;
            realImagesObj.put(k, (Object)vObj);
        }
        parseObj.put("images", (Object)realImagesObj);
        return JSON.toJSONString((Object)parseObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static void mergeTwoImages(List<String> picPathList, String picMergePath) throws IOException {
        int i;
        StringBuffer picMergePathSb;
        String substring;
        File file;
        if (picMergePath.contains("/") && !(file = new File(substring = (picMergePathSb = new StringBuffer(picMergePath)).substring(0, i = picMergePathSb.lastIndexOf("/")))).exists()) {
            file.mkdirs();
            System.out.println("\u521b\u5efa\u8def\u5f84\u6210\u529f");
        }
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>();
        int width = 65535;
        int height = 65535;
        int index = -1;
        int qtyNum = 0;
        for (int i2 = 0; i2 < picPathList.size(); ++i2) {
            String picPath = picPathList.get(i2);
            BufferedImage image = ImageIO.read(new File(picPath));
            int width1 = image.getWidth();
            int height1 = image.getHeight();
            if (width1 <= width) {
                width = width1;
                height = height1;
                index = i2;
            }
            imageList.add(image);
            ++qtyNum;
        }
        int sumHeight = 0;
        ArrayList<BufferedImage> afterImageList = new ArrayList<BufferedImage>();
        for (int i3 = 0; i3 < imageList.size(); ++i3) {
            BufferedImage bufferedImage1 = (BufferedImage)imageList.get(i3);
            String path = picPathList.get(i3);
            BufferedImage bufferedImage = ReportUtil.adjustPicSize(path, width);
            sumHeight += bufferedImage.getHeight();
            afterImageList.add(bufferedImage);
        }
        BufferedImage combinedImage = new BufferedImage(width, sumHeight - qtyNum * 2, 1);
        Graphics graphics = combinedImage.getGraphics();
        Graphics2D g = combinedImage.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        for (int i4 = 0; i4 < afterImageList.size(); ++i4) {
            BufferedImage bufferedImage = (BufferedImage)afterImageList.get(i4);
            if (i4 != 0) {
                g.drawImage((Image)bufferedImage, 0, height * i4, null);
                continue;
            }
            g.drawImage((Image)bufferedImage, 0, height * i4, null);
        }
        ImageIO.write((RenderedImage)combinedImage, "PNG", new File(picMergePath));
        System.out.println("\u56fe\u7247\u5df2\u7ecf\u5408\u6210\u5b8c\u6210\uff01");
    }

    public static BufferedImage adjustPicSize(String picPath, int targetWidth) throws IOException {
        File input = new File(picPath);
        BufferedImage image2 = ImageIO.read(new File(picPath));
        int height = image2.getHeight();
        int width = image2.getWidth();
        Double aspectRatio = (double)height / (double)width;
        int targetHeight = (int)((double)targetWidth * aspectRatio);
        BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, 1);
        Graphics2D g2d = (Graphics2D)resizedImage.getGraphics();
        Image originalImage = ImageIO.read(input).getScaledInstance(targetWidth, targetHeight, 1);
        g2d.drawImage(originalImage, 0, 0, null);
        g2d.dispose();
        File output = new File("output.png");
        ImageIO.write((RenderedImage)resizedImage, "PNG", output);
        BufferedImage ans = ImageIO.read(output);
        System.out.println("\u56fe\u7247\u5df2\u6210\u529f\u8c03\u6574\u4e3a" + targetWidth + "x" + targetHeight + "\u5c3a\u5bf8\uff01");
        output.delete();
        return ans;
    }

    public static void writeToFile(String content, String fileName) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.flush();
            bw.close();
            fw.close();
            System.out.println("\u5b57\u7b26\u4e32\u5df2\u6210\u529f\u5199\u5165\u6587\u4ef6\u3002");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> paramIdToPlaceHolder(String jsonData, int a, int b) {
        JSONObject parse = (JSONObject)JSON.parse((String)jsonData);
        JSONArray celldataArray = (JSONArray)parse.get((Object)"celldata");
        ArrayList<String> ansList = new ArrayList<String>();
        for (Object e : celldataArray) {
            String v2Str;
            JSONObject cellData = (JSONObject)e;
            String rStr = String.valueOf(cellData.get((Object)"r"));
            Integer rInt = Integer.valueOf(rStr);
            if (rInt < a || rInt > b || !cellData.containsKey((Object)"v")) continue;
            JSONObject v1Obj = (JSONObject)cellData.get((Object)"v");
            if (v1Obj.containsKey((Object)"v")) {
                v2Str = String.valueOf(v1Obj.get((Object)"v"));
                if (!v2Str.contains("[") || !v2Str.contains("]")) continue;
                ansList.add(v2Str.replaceAll("\\[", "").replaceAll("]", ""));
                continue;
            }
            if (!v1Obj.containsKey((Object)"m") || !(v2Str = String.valueOf(v1Obj.get((Object)"m"))).contains("[") || !v2Str.contains("]")) continue;
            ansList.add(v2Str.replaceAll("\\[", "").replaceAll("]", ""));
        }
        return ansList;
    }

    public static String base64ToFile(String jsonData) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String convertBase64ToImage(String base64Image, String imagePath, String imageFormat) {
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(imagePath, new String[0]), new OpenOption[0]);){
            String[] parts = base64Image.split(",");
            if (parts.length == 2) {
                base64Image = parts[1];
            }
            File imageFile = new File(imagePath);
            byte[] imageBytes = java.util.Base64.getDecoder().decode(base64Image);
            outputStream.write(imageBytes);
            outputStream.close();
            String string = imageFile.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String compress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes("UTF-8"));
        gzip.close();
        return out.toString("ISO-8859-1");
    }

    public static String compressEncode(Object res) throws IOException {
        String json = JSON.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String com = ReportUtil.compress(json);
        if (null == com) {
            return null;
        }
        String base = Base64.encodeBase64String((byte[])com.getBytes("ISO-8859-1"));
        return base;
    }

    public static String compressEncode(String res) throws IOException {
        String com = ReportUtil.compress(res);
        if (null == com) {
            return null;
        }
        String base = Base64.encodeBase64String((byte[])com.getBytes("ISO-8859-1"));
        return base;
    }

    /*
     * Exception decompiling
     */
    public static String decompressEncode(String zipString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copyFileToPath(String sourceFilePath, String targetDirPath) throws IOException {
        if (!Files.exists(Paths.get(targetDirPath, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(targetDirPath, new String[0]), new FileAttribute[0]);
        }
        Path sourcePath = Paths.get(sourceFilePath, new String[0]);
        String targetFilePath = targetDirPath + File.separator + sourcePath.getFileName();
        Files.copy(sourcePath, Paths.get(targetFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void stamperCheckMarkPDF(String infilePath, String outFilePath, String picPath) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(infilePath);
        PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(outFilePath));
        Rectangle pageSize = reader.getPageSize(1);
        float height = pageSize.getHeight();
        float width = pageSize.getWidth();
        int nums = reader.getNumberOfPages();
        com.itextpdf.text.Image[] nImage = ReportUtil.slicingImages(picPath, nums, -1.0);
        for (int n = 1; n <= nums; ++n) {
            PdfContentByte over = stamp.getOverContent(n);
            com.itextpdf.text.Image img = nImage[n - 1];
            float newHeight = 100.0f;
            float newWidth = img.getWidth() / (img.getHeight() / 100.0f);
            img.scaleAbsolute(newWidth, newHeight);
            img.setAbsolutePosition(width - newWidth, height / 2.0f - newHeight / 2.0f);
            over.addImage(img);
        }
        stamp.close();
        reader.close();
    }

    public static com.itextpdf.text.Image[] slicingImages(String Path2, int n, double modulus) throws BadElementException, IOException {
        com.itextpdf.text.Image[] nImage;
        block4: {
            nImage = new com.itextpdf.text.Image[n];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedImage img = ImageIO.read(new File(Path2));
            int h = img.getHeight();
            int w = img.getWidth();
            if (n < 2) break block4;
            if (modulus == -1.0) {
                int sw = w / n;
                for (int i = 0; i < n; ++i) {
                    BufferedImage subImg = i == n - 1 ? img.getSubimage(i * sw, 0, w - i * sw, h) : img.getSubimage(i * sw, 0, sw, h);
                    ImageIO.write((RenderedImage)subImg, Path2.substring(Path2.lastIndexOf(46) + 1), out);
                    nImage[i] = com.itextpdf.text.Image.getInstance((byte[])out.toByteArray());
                    out.flush();
                    out.reset();
                }
            } else {
                int one = new Double(Math.floor((double)w * modulus)).intValue();
                int sw = (w - one) / (n - 1);
                for (int i = 0; i < n; ++i) {
                    BufferedImage subImg = i == 0 ? img.getSubimage(0, 0, one, h) : (i == n - 1 ? img.getSubimage(one + (i - 1) * sw, 0, w - (i - 1) * sw - one, h) : img.getSubimage(one + (i - 1) * sw, 0, sw, h));
                    ImageIO.write((RenderedImage)subImg, Path2.substring(Path2.lastIndexOf(46) + 1), out);
                    nImage[i] = com.itextpdf.text.Image.getInstance((byte[])out.toByteArray());
                    out.flush();
                    out.reset();
                }
            }
        }
        return nImage;
    }

    public static String addPicLuckysheetJson(String picBase64, String jsonStr, Integer width, Integer height, Integer left, Integer top) {
        JSONObject parseObj = (JSONObject)JSON.parse((String)jsonStr);
        if (parseObj.containsKey((Object)"images")) {
            HashMap<String, Object> imageMap = new HashMap<String, Object>();
            HashMap<String, Object> border = new HashMap<String, Object>();
            imageMap.put("type", "1");
            imageMap.put("src", picBase64);
            imageMap.put("originWidth", width);
            imageMap.put("originHeight", height);
            HashMap<String, Integer> defaultMap = new HashMap<String, Integer>();
            defaultMap.put("top", top);
            defaultMap.put("left", left);
            defaultMap.put("width", width);
            defaultMap.put("height", height);
            imageMap.put("default", defaultMap);
            HashMap<String, Integer> cropMap = new HashMap<String, Integer>();
            cropMap.put("offsetTop", 0);
            cropMap.put("width", width);
            cropMap.put("offsetLeft", 0);
            cropMap.put("height", height);
            imageMap.put("crop", cropMap);
            imageMap.put("isFixedPos", false);
            imageMap.put("fixedLeft", left);
            imageMap.put("fixedTop", top);
            border.put("color", "#000");
            border.put("width", 0);
            border.put("style", "solid");
            border.put("radius", 0);
            imageMap.put("border", border);
            imageMap.put("belowText", true);
            JSONObject imagesObj = (JSONObject)parseObj.get((Object)"images");
            imagesObj.put("img_seal_" + IdWorker.get32UUID(), imageMap);
            parseObj.put("images", (Object)imagesObj);
            String jsonString = JSON.toJSONString((Object)parseObj);
            return jsonString;
        }
        HashMap<String, Object> imageMap = new HashMap<String, Object>();
        HashMap<String, Object> border = new HashMap<String, Object>();
        border.put("color", "#000");
        border.put("width", 0);
        border.put("style", "solid");
        border.put("radius", 0);
        imageMap.put("border", border);
        imageMap.put("originHeight", height);
        imageMap.put("fixedLeft", left);
        HashMap<String, Integer> defaultMap = new HashMap<String, Integer>();
        defaultMap.put("top", top);
        defaultMap.put("left", left);
        defaultMap.put("width", width);
        defaultMap.put("height", height);
        imageMap.put("default", defaultMap);
        imageMap.put("src", picBase64);
        imageMap.put("originWidth", width);
        imageMap.put("fixedTop", top);
        imageMap.put("isFixedPos", false);
        imageMap.put("type", "1");
        HashMap<String, Integer> cropMap = new HashMap<String, Integer>();
        cropMap.put("offsetTop", 0);
        cropMap.put("width", width);
        cropMap.put("offsetLeft", 0);
        cropMap.put("height", height);
        imageMap.put("crop", cropMap);
        imageMap.put("belowText", true);
        HashMap<String, HashMap<String, Object>> imgMap = new HashMap<String, HashMap<String, Object>>();
        imgMap.put("img_seal_" + IdWorker.get32UUID(), imageMap);
        parseObj.put("images", imgMap);
        String jsonString = JSON.toJSONString((Object)parseObj);
        return jsonString;
    }

    public static int getMaxCommonDivisor(int a, int b) {
        int temp = 0;
        while (a % b != 0) {
            temp = a % b;
            a = b;
            b = temp;
        }
        return b;
    }

    public static int getMinCommonMultiple(int a, int b) {
        return a * b / ReportUtil.getMaxCommonDivisor(a, b);
    }

    public static int getMinMultiCommonMultiple(List<Integer> arrays) {
        int val = arrays.get(0);
        for (int i = 1; i < arrays.size(); ++i) {
            val = ReportUtil.getMinCommonMultiple(val, arrays.get(i));
        }
        return val;
    }

    public static boolean isNumeric(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public static void addPdfWaterMark(String filePath, String waterMark) throws Exception {
        File file = new File(filePath);
        float fontSize = 40.0f;
        int[] color = new int[]{231, 232, 232};
        int rowSize = 150;
        int colSpace = 150;
        ReportUtil.pdfWaterMark(file, waterMark, fontSize, color, rowSize, colSpace);
        System.out.println();
    }

    public static void pdfWaterMark(File tempFile, String waterMark, float fontSize, int[] color, int rowSpace, int colSpace) throws Exception {
        PDDocument document = PDDocument.load((File)tempFile);
        document.setAllSecurityToBeRemoved(true);
        PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)new FileInputStream("simhei.ttf"), (boolean)true);
        for (PDPage page : document.getPages()) {
            PDPageContentStream stream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
            PDExtendedGraphicsState r = new PDExtendedGraphicsState();
            r.setNonStrokingAlphaConstant(Float.valueOf(0.5f));
            r.setAlphaSourceFlag(true);
            stream.setGraphicsStateParameters(r);
            if (color.length == 3) {
                stream.setNonStrokingColor(color[0], color[1], color[2]);
            }
            stream.beginText();
            stream.setFont((PDFont)font, fontSize);
            stream.newLineAtOffset(0.0f, -15.0f);
            float pageHeight = page.getMediaBox().getHeight();
            float pageWidth = page.getMediaBox().getWidth();
            stream.setTextMatrix(Matrix.getRotateInstance(0.8, pageWidth / 3.0f, pageHeight / 2.0f).createAffineTransform());
            stream.showText(waterMark);
            stream.endText();
            stream.restoreGraphicsState();
            stream.close();
        }
        document.save(tempFile);
        document.close();
    }

    public static List<String> hideSignnature(List<String> fixHtmlList) {
        String html = fixHtmlList.get(1);
        List<String> list = Arrays.asList("applicant", "reviewer", "approver");
        for (String s : list) {
            int index = html.indexOf(s);
            int start = html.lastIndexOf("<", index);
            int end = html.indexOf(">", index);
            html = html.substring(0, start) + html.substring(end + 1);
        }
        fixHtmlList.set(1, html);
        return fixHtmlList;
    }

    public static String replaceWord(String docPath) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reportNo", "1231");
        XWPFDocument document = new XWPFDocument(POIXMLDocument.openPackage((String)docPath));
        Iterator itPara = document.getParagraphsIterator();
        while (itPara.hasNext()) {
            XWPFParagraph paragraph = (XWPFParagraph)itPara.next();
            List runs = paragraph.getRuns();
            for (int i = 0; i < runs.size(); ++i) {
                String oneparaString = ((XWPFRun)runs.get(i)).getText(((XWPFRun)runs.get(i)).getTextPosition());
                if (oneparaString == null) continue;
                for (Map.Entry entry : map.entrySet()) {
                    oneparaString = oneparaString.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                ((XWPFRun)runs.get(i)).setText(oneparaString, 0);
            }
        }
        String[] split = docPath.split("\\.");
        String replace = docPath.replace("." + split[split.length - 1], "");
        replace = replace + "_temp.docx";
        FileOutputStream outStream = null;
        outStream = new FileOutputStream(replace);
        document.write((OutputStream)outStream);
        outStream.close();
        return replace;
    }

    public static Image getImageByPath(String path) {
        try {
            BufferedImage read = ImageIO.read(new File(path));
            return read;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u56fe\u7247\u83b7\u53d6\u5f02\u5e38", e);
        }
    }

    public static void faceMatting(BufferedImage bi, int alpha, Color coverColor, int deviation, Integer changeColor) {
        int state = -1;
        int width = bi.getWidth();
        int height = bi.getHeight();
        int minx = bi.getMinX();
        int miny = bi.getMinY();
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int rgb;
                int pixel = bi.getRGB(i, j);
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = pixel & 0xFF;
                int n = rgb = ObjectUtils.isNull((Object[])new Object[]{changeColor}) ? alpha + 1 << 24 | pixel & 0xFFFFFF : changeColor;
                if (coverColor.getRed() != r || coverColor.getGreen() != g || coverColor.getBlue() != b) {
                    Color aveColor = ReportUtil.getAveColor(bi, 70, j, i, height);
                    int rDeviation = ReportUtil.getAuthDeviation(aveColor.getRed(), deviation);
                    int gDeviation = ReportUtil.getAuthDeviation(aveColor.getGreen(), deviation);
                    int bDeviation = ReportUtil.getAuthDeviation(aveColor.getBlue(), deviation);
                    if (coverColor.getRed() - r < rDeviation || coverColor.getGreen() - g < gDeviation || coverColor.getBlue() - b < bDeviation) {
                        bi.setRGB(i, j, rgb);
                        continue;
                    }
                    if (pixel == rgb) {
                        state = j;
                        continue;
                    }
                    if (j - state <= 4) continue;
                    break;
                }
                bi.setRGB(i, j, rgb);
            }
            state = -1;
        }
    }

    private static int getAuthDeviation(int aveColor, int deviation) {
        BigDecimal divide = BigDecimal.valueOf(aveColor).divide(BigDecimal.valueOf(255L), 2, 4);
        BigDecimal subtract = BigDecimal.valueOf(1L).subtract(divide);
        BigDecimal multiply = subtract.multiply(BigDecimal.valueOf(deviation));
        return multiply.intValue();
    }

    private static Color getAveColor(BufferedImage bi, int proPx, int curY, int curX, int maxHeight) {
        int i1 = curY + proPx;
        ArrayList<Integer> r = new ArrayList<Integer>();
        ArrayList<Integer> g = new ArrayList<Integer>();
        ArrayList<Integer> b = new ArrayList<Integer>();
        proPx = Math.min(maxHeight, i1);
        for (int i = curY; i < proPx; ++i) {
            int pixel = bi.getRGB(curX, i);
            r.add((pixel & 0xFF0000) >> 16);
            g.add((pixel & 0xFF00) >> 8);
            b.add(pixel & 0xFF);
        }
        return new Color(ReportUtil.average(r), ReportUtil.average(g), ReportUtil.average(b));
    }

    public static int average(ArrayList<Integer> arr) {
        Integer min = Collections.min(arr);
        arr.remove(min);
        if (arr.isEmpty()) {
            return 0;
        }
        Integer max = Collections.max(arr);
        if (!min.equals(max)) {
            arr.remove(max);
        }
        int sum = arr.stream().mapToInt(j -> j).sum();
        if (arr.isEmpty()) {
            return 0;
        }
        BigDecimal divide = BigDecimal.valueOf(sum).divide(BigDecimal.valueOf(arr.size()), 2, 4);
        return divide.intValue();
    }

    public static String HtmlToString(String filePath) throws IOException {
        String path = filePath;
        File file = new File(path);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StringBuilder stringBuilder = new StringBuilder();
        String temp = "";
        while ((temp = bufferedReader.readLine()) != null) {
            stringBuilder.append(temp + "\n");
        }
        bufferedReader.close();
        String str = stringBuilder.toString();
        return str;
    }

    public static Map<String, String> changeSplitLine(Map<String, String> map, int sign) {
        if (sign != 1) {
            return map;
        }
        map.replaceAll((key, value) -> {
            if (key.contains("html-1")) {
                int firstIndex = value.indexOf("<table");
                value = value.substring(0, firstIndex + 7) + "class=\"table1\"" + value.substring(firstIndex + 7);
                int lastIndex = value.lastIndexOf("<table");
                value = value.substring(0, lastIndex + 7) + "class=\"table2\"" + value.substring(lastIndex + 7);
            }
            if (key.contains("css-1")) {
                value = value + ".table1 {\n    position: relative;\n}\n\n.table2 {\n position: absolute;\n top: 1030px}\n.table1::after {\n    content: \"\";\n    position: absolute;\n    bottom: -10px;\n    left: 0;\n    width: 100%;\n    height: 10%; /* \u8c03\u6574\u8fd9\u4e2a\u503c\u6765\u63a7\u5236\u7ebf\u7684\u5bbd\u5ea6 */\n    border-bottom: 4px solid black; /* \u7b2c\u4e00\u6761\u7ebf\u7684\u989c\u8272\u548c\u5bbd\u5ea6 */\n}\n\n.table1::before {\n    content: \"\";\n    position: absolute;\n    bottom: -5.6px;\n    left: 0;\n    width: 100%;\n    height: 10%; /* \u8c03\u6574\u8fd9\u4e2a\u503c\u6765\u63a7\u5236\u7ebf\u7684\u5bbd\u5ea6 */\n    border-bottom: 2px solid gray; /* \u7b2c\u4e8c\u6761\u7ebf\u7684\u989c\u8272\u548c\u5bbd\u5ea6 */\n}\n.table2::before {\n    content: \"\";\n    position: absolute;\n    bottom: -45px;\n    left: 0;\n    width: 100%;\n    height: 10%; /* \u8c03\u6574\u8fd9\u4e2a\u503c\u6765\u63a7\u5236\u7ebf\u7684\u5bbd\u5ea6 */\n    border-bottom: 4px solid black; /* \u7b2c\u4e00\u6761\u7ebf\u7684\u989c\u8272\u548c\u5bbd\u5ea6 */\n}\n\n.table2::after {\n    content: \"\";\n    position: absolute;\n    bottom: -48.5px;\n    left: 0;\n    width: 100%;\n    height: 10%; /* \u8c03\u6574\u8fd9\u4e2a\u503c\u6765\u63a7\u5236\u7ebf\u7684\u5bbd\u5ea6 */\n    border-bottom: 2px solid gray; /* \u7b2c\u4e8c\u6761\u7ebf\u7684\u989c\u8272\u548c\u5bbd\u5ea6 */\n}";
            }
            return value.replace("double", "hidden");
        });
        return map;
    }

    public static int calculateTextCount(String text) {
        List<Integer> indexes = ReportUtil.findSubstringIndexes(text, "<span");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indexes.size(); ++i) {
            int index = indexes.get(i);
            int first = text.indexOf(">", index);
            int last = text.indexOf("<", index + 1);
            sb.append(text.substring(first + 1, last));
        }
        return sb.toString().length();
    }

    public static String reduceFontSize(String text) {
        List<Integer> indexes = ReportUtil.findSubstringIndexes(text, "<span");
        StringBuilder sb = new StringBuilder(text);
        for (int i = 0; i < indexes.size(); ++i) {
            int index = indexes.get(i);
            int styleIndex = sb.indexOf("\">", index);
            sb.insert(styleIndex - 1, ";font-size:8pt");
            indexes = ReportUtil.findSubstringIndexes(sb.toString(), "<span");
        }
        return sb.toString();
    }

    public static String transformDateFormat(String date) {
        if (date.contains("T")) {
            date = date.substring(0, date.indexOf("T"));
        }
        String[] dateArr = date.split("-");
        String year = dateArr[0];
        String month = "0".equals(dateArr[1].charAt(0) + "") ? dateArr[1].charAt(1) + "" : dateArr[1];
        String day = "";
        if (dateArr.length == 3) {
            day = "0".equals(dateArr[2].charAt(0) + "") ? dateArr[2].charAt(1) + "" : dateArr[2];
        }
        String ret = year + "\u5e74" + month + "\u6708";
        return "".equals(day) ? ret : ret + day + "\u65e5";
    }

    public static List<String> findNumbers(String input) {
        ArrayList<String> numbers = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            numbers.add(matcher.group());
        }
        return numbers;
    }

    public static List<Integer> findSubstringIndexes(String text, String substring) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int index = text.indexOf(substring);
        while (index >= 0) {
            indexes.add(index);
            index = text.indexOf(substring, index + 1);
        }
        return indexes;
    }

    public static int countOccurrences(String str, String subStr) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(subStr, index)) != -1) {
            ++count;
            index += subStr.length();
        }
        return count;
    }

    public static boolean compareFlexibleFirstRow(String json1, String json2) {
        List<String> strings1 = ReportUtil.jsonToFirstRowDataList(json1);
        List<String> strings2 = ReportUtil.jsonToFirstRowDataList(json2);
        boolean compareFlag = true;
        for (int i = 0; i < strings1.size(); ++i) {
            if (Objects.equals(strings1.get(i), strings2.get(i))) continue;
            compareFlag = false;
            break;
        }
        return compareFlag;
    }

    public static List<String> jsonToFirstRowDataList(String json) {
        JSONObject parse1 = (JSONObject)JSON.parse((String)json);
        JSONArray data = (JSONArray)parse1.get((Object)"data");
        JSONArray firstRowData = (JSONArray)data.get(0);
        ArrayList<String> rowDataList = new ArrayList<String>();
        for (Object firstRowDatum : firstRowData) {
            JSONObject firstRowDatum1 = (JSONObject)firstRowDatum;
            if (ObjectUtils.isEmpty((Object)firstRowDatum1) || !firstRowDatum1.containsKey((Object)"v")) {
                rowDataList.add(null);
                continue;
            }
            String v = String.valueOf(firstRowDatum1.get((Object)"v"));
            rowDataList.add(v);
        }
        return rowDataList;
    }

    public static Integer searchQty(String str1, String str2) {
        String[] s2 = str1.split(str2);
        int result = s2.length - 1;
        return result;
    }

    public static String getJson(JSONObject param, String url) {
        JSONObject result = new JSONObject();
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                result = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            result.put("error", (Object)"\u8fde\u63a5\u9519\u8bef\uff01");
        }
        try {
            client.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return JSON.toJSONString((Object)result);
    }

    public static String postJson(JSONObject param, String url) {
        JSONObject result = new JSONObject();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpClient client = HttpClients.createDefault();
        StringEntity entity = new StringEntity(param.toString(), "UTF-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                result = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            result.put("error", (Object)"\u8fde\u63a5\u9519\u8bef\uff01");
        }
        try {
            client.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return JSON.toJSONString((Object)result);
    }

    public static byte[] fileToByte(File file) {
        byte[] fileBytes = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            fileBytes = new byte[(int)file.length()];
            fis.read(fileBytes);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileBytes;
    }

    public static String getLocalImageBase(String src) throws Exception {
        String encoder = "data:image/png;base64,";
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String filePath = src;
        System.out.println("filePath:" + filePath);
        FileInputStream is = new FileInputStream(filePath);
        byte[] bytes = new byte[1024];
        int len = 0;
        while ((len = is.read(bytes)) != -1) {
            data.write(bytes, 0, len);
        }
        is.close();
        BASE64Encoder base64Encoder = new BASE64Encoder();
        encoder = encoder + base64Encoder.encode(data.toByteArray()).replace("\r\n", "").trim();
        return encoder;
    }

    public static String getImageBase(String src) throws Exception {
        URL url = new URL(src);
        InputStream in = null;
        byte[] data = null;
        try {
            in = url.openStream();
            data = new byte[in.available()];
            in.read(data);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(data);
    }

    public static Set<String> getIpAddress() {
        HashSet<String> ipList = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    ipList.add(ip.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipList;
    }

    private static Boolean isBlank(BufferedImage pageImage) throws IOException {
        BufferedImage bufferedImage = pageImage;
        long count = 0L;
        int height = bufferedImage.getHeight();
        int width = bufferedImage.getWidth();
        Double areaFactor = (double)(width * height) * 0.999;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Color c = new Color(bufferedImage.getRGB(x, y));
                if (c.getRed() != c.getGreen() || c.getRed() != c.getBlue() || c.getRed() < 248) continue;
                ++count;
            }
        }
        if ((double)count >= areaFactor) {
            return true;
        }
        return false;
    }

    public static String writeToText(String dir, String content, String fileName) throws IOException {
        File file;
        String systemType = System.getProperty("os.name");
        String path = dir + "/" + fileName + ".html";
        if (systemType.contains("Windows")) {
            path = dir + "\\" + fileName + ".html";
        }
        if (!(file = new File(path)).exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(content);
        bw.flush();
        bw.close();
        fw.close();
        return path;
    }

    public static boolean convert(String srcPath, String destPath) {
        File file;
        File parent;
        String systemType = System.getProperty("os.name");
        String toPdfTool = "wkhtmltopdf";
        if (systemType.contains("Windows")) {
            String property = System.getProperty("user.dir");
            toPdfTool = property + "\\wkhtmltopdf\\bin\\wkhtmltopdf.exe";
        }
        if (!(parent = (file = new File(destPath)).getParentFile()).exists()) {
            parent.mkdirs();
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(toPdfTool);
        cmd.append(" ");
        cmd.append("--margin-left").append(" ").append("10").append(" ").append("--margin-right").append(" ").append("10").append(" ").append("--margin-top").append(" ").append("0").append(" ").append("--margin-bottom").append(" ").append("0").append(" ").append("-n --enable-local-file-access").append(" ");
        cmd.append(srcPath);
        cmd.append(" ");
        cmd.append(destPath);
        boolean result = true;
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            HtmlToPdfInterceptor error = new HtmlToPdfInterceptor(proc.getErrorStream());
            HtmlToPdfInterceptor output = new HtmlToPdfInterceptor(proc.getInputStream());
            error.start();
            output.start();
            proc.waitFor();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public static String getCurrentOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        System.out.println("---------\u5f53\u524d\u64cd\u4f5c\u7cfb\u7edf\u662f-----------" + os);
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGetPost(String apiPath, String type, Map<String, Object> paramMap) {
        OutputStreamWriter out = null;
        InputStream is = null;
        String result = null;
        try {
            URL url = new URL(apiPath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(type);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            if (type.equals("POST")) {
                out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                out.append(JSON.toJSONString(paramMap));
                out.flush();
                out.close();
            }
            is = connection.getInputStream();
            int length = connection.getContentLength();
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                result = new String(data, "UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String sendPOSTRequest(String url, MultiValueMap<String, String> params, HttpHeaders headers) {
        RestTemplate client = new RestTemplate();
        HttpMethod method = HttpMethod.POST;
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity response = client.exchange(url, method, requestEntity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public static String doGetRequest(String url, HttpHeaders headers) {
        RestTemplate client = new RestTemplate();
        HttpMethod method = HttpMethod.GET;
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)"parameters", (MultiValueMap)headers);
        ResponseEntity response = client.exchange(url, method, requestEntity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public static String saveStringToFile(String content, String filePath, String fileName) {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!filePath.endsWith(Matcher.quoteReplacement(File.separator))) {
            filePath = filePath + File.separator;
        }
        String pathAndName = filePath + fileName;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(pathAndName));
            writer.write(content);
            writer.close();
            System.out.println("\u5b57\u7b26\u4e32\u5df2\u6210\u529f\u4fdd\u5b58\u5230\u6587\u4ef6\u4e2d\u3002");
            System.out.println("\u8def\u5f84\u4e3a\uff1a" + pathAndName);
            return pathAndName;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u4fdd\u5b58\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            return "error";
        }
    }

    public static String toFileString(File file) {
        StringBuffer htmlSb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while (br.ready()) {
                htmlSb.append(br.readLine());
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String htmlStr = htmlSb.toString();
        if (htmlStr.contains("Evaluation Warning : The document was created with Spire.PDF for Java.")) {
            htmlStr = htmlStr.replace("Evaluation Warning : The document was created with Spire.PDF for Java.", "");
        }
        return htmlStr;
    }

    public static boolean saveStreamToFile(InputStream inputStream, String outputPath) {
        Boolean flag = true;
        ArrayList imagePathList = new ArrayList();
        try {
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".png")) {
                    String imgOutputPath = outputPath;
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(imgOutputPath));){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = zipInputStream.read(buffer)) > 0) {
                            bos.write(buffer, 0, len);
                        }
                        break;
                    }
                }
                entry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        catch (Exception e) {
            flag = false;
            System.out.println("\u4fdd\u5b58\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        return flag;
    }

    public static JSONObject saveLsDataChunk(String path, String id, String lsSheetStr, int chunkSize) {
        JSONObject res = new JSONObject();
        Object lsSheetObj = ZipUtil.unZipReport(lsSheetStr);
        JSONArray lsSheetList = null;
        JSONObject lsSingleSheet = null;
        if (lsSheetObj instanceof JSONObject) {
            lsSingleSheet = (JSONObject)lsSheetObj;
        } else if (lsSheetObj instanceof JSONArray) {
            lsSheetList = (JSONArray)lsSheetObj;
        }
        if (lsSingleSheet != null) {
            JSONObject sheet = lsSingleSheet;
            JSONArray sheetData = LsUtil.transCellDataToData(sheet.getJSONArray("celldata"));
            if (sheetData.size() > chunkSize) {
                String filePath = path + id;
                sheet.put("celldata", null);
                sheet.put("data", null);
                String zipOtherStr = ZipUtil.zipReport(sheet.toJSONString());
                String chunkOtherFileName = id + "_chunk.json";
                ReportUtil.saveStringToFile(zipOtherStr, filePath, chunkOtherFileName);
                for (int k = 0; k < sheetData.size(); k += chunkSize) {
                    int end = Math.min(k + chunkSize, sheetData.size());
                    List subList = sheetData.subList(k, end);
                    JSONArray subArray = new JSONArray(subList);
                    JSONArray chunkCellData = LsUtil.transDataToCellData(subArray, k);
                    String zipChunkCellData = ZipUtil.zipReport(chunkCellData.toJSONString());
                    String celldataFileName = id + "_celldata_" + k + ".json";
                    ReportUtil.saveStringToFile(zipChunkCellData, filePath, celldataFileName);
                }
                res.put("pathAndName", (Object)filePath);
                res.put("isChunk", (Object)true);
            } else {
                String pathAndName = ReportUtil.saveStringToFile(lsSheetStr, path, id + ".json");
                res.put("pathAndName", (Object)pathAndName);
                res.put("isChunk", (Object)false);
            }
        }
        if (lsSheetList != null && lsSheetList.size() > 0) {
            for (int i = 0; i < lsSheetList.size(); ++i) {
                JSONObject sheet = lsSheetList.getJSONObject(i);
                String sheetIndex = sheet.getString("index");
                JSONArray sheetData = LsUtil.transCellDataToData(sheet.getJSONArray("celldata"));
                String filePath = path + id + File.separator + sheetIndex;
                if (sheetData.size() > chunkSize) {
                    sheet.put("celldata", null);
                    sheet.put("data", null);
                    String zipOtherStr = ZipUtil.zipReport(sheet.toJSONString());
                    String chunkOtherFileName = id + "_" + i + "_chunk.json";
                    ReportUtil.saveStringToFile(zipOtherStr, filePath, chunkOtherFileName);
                    for (int k = 0; k < sheetData.size(); k += chunkSize) {
                        int end = Math.min(k + chunkSize, sheetData.size());
                        List subList = sheetData.subList(k, end);
                        JSONArray subArray = new JSONArray(subList);
                        JSONArray chunkCellData = LsUtil.transDataToCellData(subArray, k);
                        String zipChunkCellData = ZipUtil.zipReport(chunkCellData.toJSONString());
                        String celldataFileName = id + "_" + i + "_celldata_" + k + ".json";
                        ReportUtil.saveStringToFile(zipChunkCellData, filePath, celldataFileName);
                    }
                    res.put("pathAndName", (Object)(path + id));
                    res.put("isChunk", (Object)true);
                    continue;
                }
                String pathAndName = ReportUtil.saveStringToFile(sheet.toJSONString(), path + id + File.separator + sheetIndex, id + ".json");
                res.put("pathAndName", (Object)(path + id));
                res.put("isChunk", (Object)false);
            }
        }
        return res;
    }

    public static String getLsDataChunk(File folder, String id) {
        String resStr = "";
        File[] files = folder.listFiles();
        if (files != null) {
            boolean isMultSheet = false;
            for (File file : files) {
                if (!file.isDirectory()) continue;
                isMultSheet = true;
                break;
            }
            if (isMultSheet) {
                JSONObject sheetFileName = new JSONObject();
                JSONArray sheetList = new JSONArray();
                for (File fileP : files) {
                    if (!fileP.isDirectory()) continue;
                    File[] subFiles = fileP.listFiles();
                    if (subFiles.length == 1 && subFiles[0].getName().split("\\.")[0].equals(id)) {
                        try {
                            String sheetStr = FileUtils.readFileToString((File)subFiles[0], (Charset)StandardCharsets.UTF_8);
                            JSONObject sheet = (JSONObject)ZipUtil.unZipReport(sheetStr);
                            sheetList.set(sheet.getIntValue("order"), (Object)sheet);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    for (File file : subFiles) {
                        if (!file.getName().contains(id)) continue;
                        String sheetIndex = fileP.getName();
                        if (sheetFileName.get((Object)sheetIndex) == null) {
                            JSONObject sheetFileO = new JSONObject();
                            sheetFileO.put("celldata", (Object)new JSONArray());
                            sheetFileO.put("otherdata", null);
                            sheetFileName.put(sheetIndex, (Object)sheetFileO);
                        }
                        if (file.getName().contains("_celldata_")) {
                            try {
                                String cellDataStr = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                                JSONArray cellData = (JSONArray)ZipUtil.unZipReport(cellDataStr);
                                sheetFileName.getJSONObject(sheetIndex).getJSONArray("celldata").addAll((Collection)cellData);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (!file.getName().contains("_chunk")) continue;
                        try {
                            String otherDataStr = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                            JSONObject otherData = (JSONObject)ZipUtil.unZipReport(otherDataStr);
                            sheetFileName.getJSONObject(sheetIndex).put("otherdata", (Object)otherData);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                for (String sheetIndex : sheetFileName.keySet()) {
                    JSONObject sheetObj = sheetFileName.getJSONObject(sheetIndex).getJSONObject("otherdata");
                    sheetObj.put("celldata", (Object)sheetFileName.getJSONObject(sheetIndex).getJSONArray("celldata"));
                    sheetList.set(sheetObj.getIntValue("order"), (Object)sheetObj);
                }
                resStr = ZipUtil.zipReport(sheetList.toJSONString());
            } else {
                JSONObject sheetObj = new JSONObject();
                JSONArray celldataList = new JSONArray();
                for (File file : files) {
                    if (!file.getName().contains(id)) continue;
                    if (file.getName().contains("_celldata_")) {
                        try {
                            String cellDataStr = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                            JSONArray cellData = (JSONArray)ZipUtil.unZipReport(cellDataStr);
                            celldataList.addAll((Collection)cellData);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (!file.getName().contains("_chunk")) continue;
                    try {
                        JSONObject otherData;
                        String otherDataStr = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                        sheetObj = otherData = (JSONObject)ZipUtil.unZipReport(otherDataStr);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                sheetObj.put("celldata", (Object)celldataList);
                resStr = ZipUtil.zipReport(sheetObj.toJSONString());
            }
        }
        return resStr;
    }

    public static class HtmlToPdfInterceptor
    extends Thread {
        private InputStream is;

        public HtmlToPdfInterceptor(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is, "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line.toString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

