/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity.BorderKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity.FontKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ColorHelper;
import java.util.Objects;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StyleKey {
    private final int workbookHash;
    private final FontKey fontKey;
    private final short dataFormat;
    private final HorizontalAlignment alignment;
    private final VerticalAlignment verticalAlignment;
    private final BorderKey borderKey;
    private final XSSFColor fillBackgroundColorColor;
    private final XSSFColor fillForegroundColorColor;
    private final FillPatternType fillPattern;
    private final boolean wrapText;

    public StyleKey(XSSFWorkbook destWorkbook, CellStyle style, FontKey fontKey, BorderKey borderKey) {
        this.workbookHash = System.identityHashCode(destWorkbook);
        this.fontKey = fontKey;
        this.borderKey = borderKey;
        if (style == null) {
            this.dataFormat = 0;
            this.alignment = HorizontalAlignment.CENTER;
            this.verticalAlignment = VerticalAlignment.CENTER;
            this.fillBackgroundColorColor = ColorHelper.getDefaultColor();
            this.fillForegroundColorColor = ColorHelper.getDefaultColor();
            this.fillPattern = FillPatternType.NO_FILL;
            this.wrapText = false;
        } else {
            this.dataFormat = style.getDataFormat();
            this.alignment = style.getAlignment();
            this.verticalAlignment = style.getVerticalAlignment();
            if (style.getFillPattern() == FillPatternType.NO_FILL) {
                this.fillBackgroundColorColor = null;
                this.fillForegroundColorColor = null;
            } else {
                this.fillBackgroundColorColor = (XSSFColor)style.getFillBackgroundColorColor();
                this.fillForegroundColorColor = (XSSFColor)style.getFillForegroundColorColor();
            }
            this.fillPattern = style.getFillPattern();
            this.wrapText = style.getWrapText();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleKey styleKey = (StyleKey)o;
        boolean backgroundColorEquals = this.areColorsEqual(this.fillBackgroundColorColor, styleKey.fillBackgroundColorColor);
        boolean foregroundColorEquals = this.areColorsEqual(this.fillForegroundColorColor, styleKey.fillForegroundColorColor);
        if (this.workbookHash != styleKey.workbookHash) {
            return false;
        }
        if (this.dataFormat != styleKey.dataFormat) {
            return false;
        }
        if (this.alignment != styleKey.alignment) {
            return false;
        }
        if (this.verticalAlignment != styleKey.verticalAlignment) {
            return false;
        }
        if (this.fillPattern != styleKey.fillPattern) {
            return false;
        }
        if (this.wrapText != styleKey.wrapText) {
            return false;
        }
        if (!Objects.equals(this.fontKey, styleKey.fontKey)) {
            return false;
        }
        if (!Objects.equals(this.borderKey, styleKey.borderKey)) {
            return false;
        }
        return backgroundColorEquals && foregroundColorEquals;
    }

    public int hashCode() {
        int bgColorHash = this.fillBackgroundColorColor != null ? Objects.hash(this.fillBackgroundColorColor.getARGBHex()) : 0;
        int fgColorHash = this.fillForegroundColorColor != null ? Objects.hash(this.fillForegroundColorColor.getARGBHex()) : 0;
        return Objects.hash(this.workbookHash, this.fontKey, this.dataFormat, this.alignment, this.verticalAlignment, this.borderKey, bgColorHash, fgColorHash, this.fillPattern, this.wrapText);
    }

    public String toString() {
        return "StyleKey{workbookHash=" + this.workbookHash + ", fontKey=" + this.fontKey + ", dataFormat=" + this.dataFormat + ", alignment=" + this.alignment + ", verticalAlignment=" + this.verticalAlignment + ", borderKey=" + this.borderKey + ", fillBackgroundColorColor=" + this.fillBackgroundColorColor + ", fillForegroundColorColor=" + this.fillForegroundColorColor + ", fillPattern=" + this.fillPattern + ", wrapText=" + this.wrapText + '}';
    }

    private boolean areColorsEqual(XSSFColor color1, XSSFColor color2) {
        if (color1 == color2) {
            return true;
        }
        if (color1 == null || color2 == null) {
            return false;
        }
        return Objects.equals(color1.getARGBHex(), color2.getARGBHex());
    }
}

