/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ColorHelper;
import java.util.Objects;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class BorderKey {
    private final BorderStyle borderTop;
    private final BorderStyle borderBottom;
    private final BorderStyle borderLeft;
    private final BorderStyle borderRight;
    private final XSSFColor topBorderColor;
    private final XSSFColor bottomBorderColor;
    private final XSSFColor leftBorderColor;
    private final XSSFColor rightBorderColor;

    public BorderKey(XSSFCellStyle style) {
        XSSFColor defaultColor = ColorHelper.getDefaultColor();
        if (style == null) {
            this.borderTop = BorderStyle.NONE;
            this.borderBottom = BorderStyle.NONE;
            this.borderLeft = BorderStyle.NONE;
            this.borderRight = BorderStyle.NONE;
            this.topBorderColor = defaultColor;
            this.bottomBorderColor = defaultColor;
            this.leftBorderColor = defaultColor;
            this.rightBorderColor = defaultColor;
        } else {
            this.borderTop = style.getBorderTop();
            this.borderBottom = style.getBorderBottom();
            this.borderLeft = style.getBorderLeft();
            this.borderRight = style.getBorderRight();
            this.topBorderColor = style.getTopBorderXSSFColor() == null ? defaultColor : style.getTopBorderXSSFColor();
            this.bottomBorderColor = style.getBottomBorderXSSFColor() == null ? defaultColor : style.getBottomBorderXSSFColor();
            this.leftBorderColor = style.getLeftBorderXSSFColor() == null ? defaultColor : style.getLeftBorderXSSFColor();
            this.rightBorderColor = style.getRightBorderXSSFColor() == null ? defaultColor : style.getRightBorderXSSFColor();
        }
    }

    public BorderKey(BorderStyle borderTop, BorderStyle borderBottom, BorderStyle borderLeft, BorderStyle borderRight, XSSFColor topBorderColor, XSSFColor bottomBorderColor, XSSFColor rightBorderColor, XSSFColor leftBorderColor) {
        this.borderTop = borderTop;
        this.borderBottom = borderBottom;
        this.borderLeft = borderLeft;
        this.borderRight = borderRight;
        XSSFColor defaultColor = ColorHelper.getDefaultColor();
        this.topBorderColor = topBorderColor == null ? defaultColor : topBorderColor;
        this.bottomBorderColor = bottomBorderColor == null ? defaultColor : bottomBorderColor;
        this.leftBorderColor = leftBorderColor == null ? defaultColor : leftBorderColor;
        this.rightBorderColor = rightBorderColor == null ? defaultColor : rightBorderColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderKey borderKey = (BorderKey)o;
        return this.borderTop == borderKey.borderTop && this.borderBottom == borderKey.borderBottom && this.borderLeft == borderKey.borderLeft && this.borderRight == borderKey.borderRight && this.colorEquals(this.topBorderColor, borderKey.topBorderColor) && this.colorEquals(this.bottomBorderColor, borderKey.bottomBorderColor) && this.colorEquals(this.leftBorderColor, borderKey.leftBorderColor) && this.colorEquals(this.rightBorderColor, borderKey.rightBorderColor);
    }

    public int hashCode() {
        String topHex = this.topBorderColor != null ? this.topBorderColor.getARGBHex() : null;
        String bottomHex = this.bottomBorderColor != null ? this.bottomBorderColor.getARGBHex() : null;
        String leftHex = this.leftBorderColor != null ? this.leftBorderColor.getARGBHex() : null;
        String rightHex = this.rightBorderColor != null ? this.rightBorderColor.getARGBHex() : null;
        return Objects.hash(this.borderTop, this.borderBottom, this.borderLeft, this.borderRight, topHex, bottomHex, leftHex, rightHex);
    }

    public String toString() {
        return "BorderKey{borderTop=" + this.borderTop + ", borderBottom=" + this.borderBottom + ", borderLeft=" + this.borderLeft + ", borderRight=" + this.borderRight + ", topBorderColor=" + this.topBorderColor + ", bottomBorderColor=" + this.bottomBorderColor + ", leftBorderColor=" + this.leftBorderColor + ", rightBorderColor=" + this.rightBorderColor + '}';
    }

    public static BorderKey getBorderKeyStyle(boolean hasTop, boolean hasLeft, boolean hasRight, boolean hasBottom, BorderStyle borderStyle, XSSFColor color) {
        XSSFColor blackColor = ColorHelper.getDefaultColor();
        return new BorderKey(hasTop ? borderStyle : BorderStyle.NONE, hasBottom ? borderStyle : BorderStyle.NONE, hasLeft ? borderStyle : BorderStyle.NONE, hasRight ? borderStyle : BorderStyle.NONE, hasTop ? color : blackColor, hasBottom ? color : blackColor, hasLeft ? color : blackColor, hasRight ? color : blackColor);
    }

    private boolean colorEquals(XSSFColor c1, XSSFColor c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        String argb1 = c1.getARGBHex();
        String argb2 = c2.getARGBHex();
        return Objects.equals(argb1, argb2);
    }

    private String colorHashCode(XSSFColor color) {
        if (color == null) {
            return null;
        }
        return color.getARGBHex();
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public XSSFColor getTopBorderColor() {
        return this.topBorderColor;
    }

    public XSSFColor getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public XSSFColor getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public XSSFColor getRightBorderColor() {
        return this.rightBorderColor;
    }
}

