/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.SheetConditionFormatHelper;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;

public class StringUtil {
    private static final Pattern patternFormatTextContains = Pattern.compile("(?<=\\()[^(),]*(?=,[^()]*\\))");
    private static final Pattern patternTextContains = Pattern.compile("SEARCH\\s*\\(\\s*\"([^\"]+)\"");
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    private static final Pattern NON_ASCII_PATTERN = Pattern.compile(".*[^\\x00-\\x7F].*");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[-+]?\\d+\\.\\d+|[-+]?\\d+");

    public static String getMapVal(Map<String, Object> map, String k) {
        Object o;
        if (map.containsKey(k) && (o = map.get(k)) != null) {
            return o.toString();
        }
        return "";
    }

    public static String handlingSpecialCharacters(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        return data.replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]");
    }

    public static <T> String listConversion(List<T> lists) {
        try {
            return mapper.writerWithType((TypeReference)new TypeReference<Object>(){}).writeValueAsString(lists);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u7c7b\u578b: " + lists.getClass(), e);
        }
    }

    public static String extractBracketContent(String input) {
        int endIndex;
        int startIndex = input.indexOf("[");
        if (startIndex == -1) {
            return "";
        }
        if ((endIndex = input.indexOf("]", ++startIndex)) == -1) {
            return "";
        }
        return input.substring(startIndex, endIndex);
    }

    public static Object deepParseJson(String jsonStr) {
        System.out.println(jsonStr);
        try {
            return JSON.parse((String)jsonStr);
        }
        catch (Exception e) {
            String cleaned = jsonStr.replaceAll("^\"+|\"+$", "");
            if (cleaned.startsWith("{") && cleaned.endsWith("}")) {
                cleaned = cleaned.replaceAll("[\\\\]", "");
            }
            return JSONObject.parse((String)cleaned);
        }
    }

    public static String garbled(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        if (NON_ASCII_PATTERN.matcher(str).matches() && str.contains("\u00e6")) {
            str = new String(str.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return str;
    }

    public static boolean isStringEmptyObject(String str) {
        return "{}".equals(str.trim()) || "\"{}\"".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.isEmpty();
    }

    public static boolean isNumber(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        value = value.replaceAll("\\p{C}", "");
        value = value.trim().replaceAll("[\\u200B-\\u200D\\uFEFF]", "");
        return NUMBER_PATTERN.matcher(value).matches();
    }

    public static String cleanExcelFormulaValue(String value, String cfName) {
        String[] patterns;
        if (value == null) {
            return null;
        }
        value = value.replaceAll("\\p{C}", "");
        if (StringUtil.isNumber(value = value.trim().replaceAll("[\\u200B-\\u200D\\uFEFF]", ""))) {
            return value;
        }
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return value;
        }
        if (value.matches("[A-Za-z]+\\$?\\d+")) {
            return value;
        }
        for (String pattern : patterns = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "dd-MMM-yyyy", "MM/dd/yyyy", "yyyy-MM-dd HH:mm:ss"}) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                sdf.setLenient(false);
                Date date = sdf.parse(value);
                return String.valueOf(DateUtil.getExcelDate((Date)date));
            }
            catch (ParseException parseException) {
            }
        }
        if (cfName.equals("formula")) {
            return value;
        }
        return "\"" + value + "\"";
    }

    public static String cleaningHtml(String htmlStr) {
        if (htmlStr.contains("Evaluation Warning : The document was created with Spire.PDF for Java.")) {
            htmlStr = htmlStr.replace("Evaluation Warning : The document was created with Spire.PDF for Java.", "");
        }
        return htmlStr;
    }

    public static String encode(String plainText) {
        if (plainText == null) {
            return null;
        }
        byte[] bytes = plainText.getBytes(StandardCharsets.UTF_8);
        byte[] encodedBytes = Base64.getEncoder().encode(bytes);
        return new String(encodedBytes, StandardCharsets.UTF_8);
    }

    public static String decode(String base64Text) {
        if (base64Text == null) {
            return null;
        }
        try {
            byte[] encodedBytes = base64Text.getBytes(StandardCharsets.UTF_8);
            byte[] decodedBytes = Base64.getDecoder().decode(encodedBytes);
            return new String(decodedBytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return base64Text;
        }
    }

    public static String cleanExcelImportFormulaValue(String formula) {
        if (formula == null) {
            return null;
        }
        try {
            Matcher matcher;
            if (SheetConditionFormatHelper.isFormatTextContains(formula) && (matcher = patternFormatTextContains.matcher(formula)).find()) {
                formula = matcher.group().trim();
            }
            if (SheetConditionFormatHelper.isTextContains(formula) && (matcher = patternTextContains.matcher(formula)).find()) {
                formula = matcher.group(1).trim();
            }
        }
        catch (Exception e) {
            return formula;
        }
        return formula;
    }

    public static String cleanJsonString(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        String cleaned = jsonString.trim();
        if (cleaned.startsWith("\"") && cleaned.endsWith("\"")) {
            cleaned = cleaned.substring(1, cleaned.length() - 1);
        }
        cleaned = cleaned.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\/", "/");
        return cleaned;
    }
}

