/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.LuckySheet;
import java.util.HashMap;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class SheetFrozenHelper {
    public static void setFrozen(XSSFSheet sheet, LuckySheet luckySheet) {
        PaneInformation paneInfo = sheet.getPaneInformation();
        if (paneInfo == null) {
            return;
        }
        short topRow = paneInfo.getHorizontalSplitPosition();
        short leftColumn = paneInfo.getVerticalSplitPosition();
        HashMap<String, Object> frozen = new HashMap<String, Object>();
        String type = SheetFrozenHelper.getType(topRow, leftColumn);
        frozen.put("type", type);
        if (type.equals("rangeBoth")) {
            HashMap<String, Integer> range = new HashMap<String, Integer>();
            range.put("row_focus", Integer.valueOf(topRow == 1 ? (short)0 : topRow));
            range.put("column_focus", Integer.valueOf(leftColumn == 1 ? (short)0 : leftColumn));
            frozen.put("range", range);
        }
        luckySheet.setFrozen(frozen);
    }

    private static String getType(int topRow, int leftColumn) {
        if (topRow == 1 && leftColumn == 0) {
            return "row";
        }
        if (topRow == 0 && leftColumn == 1) {
            return "column";
        }
        if (topRow > 0 && leftColumn > 0) {
            return "rangeBoth";
        }
        return "row";
    }
}

