/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathUtil {
    private static final Logger logger = LoggerFactory.getLogger(FilePathUtil.class);

    public static String getDefaultFilePath() {
        String tempDir = System.getProperty("java.io.tmpdir");
        logger.info("Temp directory: {}", (Object)tempDir);
        return tempDir;
    }

    public static Path getNormalizedFilePath() {
        Path path = Paths.get(FilePathUtil.getDefaultFilePath(), new String[0]).normalize();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("path \u5fc5\u987b\u662f\u6709\u6548\u76ee\u5f55: " + path);
        }
        return path;
    }

    public static String getNormalizedFileName() {
        return UUID.randomUUID().toString().replace("-", "").replace(":", "").replace("<", "").replace(">", "").replace("\"", "").replace("\\", "").replace("/", "").replace("|", "").replace("?", "").replace("*", "");
    }

    public static String getFilePathSplicing(String filePath) {
        File file = new File(FilePathUtil.getDefaultFilePath() + File.separator + filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getPath();
    }
}

