/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.sql;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.sql.DataTable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DaoUtil {
    static Map<String, String> jkm = new HashMap<String, String>();

    public static CallableStatement getCallableStatement(Connection conn, String sql, Object ... paras) throws Exception {
        CallableStatement cstmt = null;
        cstmt = conn.prepareCall(sql);
        int idx = 1;
        for (Object obj : paras) {
            if (obj != null) {
                String objType;
                switch (objType = obj.getClass().getName()) {
                    case "java.lang.Boolean": {
                        boolean v = (Boolean)obj;
                        if (v) {
                            cstmt.setInt(idx, 1);
                            break;
                        }
                        cstmt.setInt(idx, 0);
                        break;
                    }
                    case "java.util.Date": 
                    case "java.sql.Date": 
                    case "java.sql.Timestamp": {
                        cstmt.setTimestamp(idx, new Timestamp(((Date)obj).getTime()));
                        break;
                    }
                    default: {
                        cstmt.setObject(idx, obj);
                        break;
                    }
                }
            } else {
                cstmt.setObject(idx, null);
            }
            ++idx;
        }
        return cstmt;
    }

    public static DataTable mapResultSetToDataTable(ResultSet rs) throws Exception {
        DataTable result = new DataTable();
        ArrayList<String> columnNames = new ArrayList<String>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String colName = rsmd.getColumnLabel(i);
            if (colName.isEmpty()) {
                colName = rsmd.getColumnName(i);
            }
            if (colName.isEmpty()) continue;
            columnNames.add(colName);
        }
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String col : columnNames) {
                row.put(col, rs.getObject(col));
            }
            result.rows.add(row);
        }
        return result;
    }

    public static JSONObject convertDataRowToJsonObject(Map<String, Object> r) {
        JSONObject o = new JSONObject();
        for (String k : r.keySet()) {
            if (!jkm.containsKey(k)) {
                String[] ks = k.split("_");
                String t = "";
                for (int i = 0; i < ks.length; ++i) {
                    if (i == 0) {
                        t = ks[i].toLowerCase();
                        continue;
                    }
                    t = t + ks[i].substring(0, 1).toUpperCase();
                    t = t + ks[i].substring(1).toLowerCase();
                }
                jkm.put(k, t);
            }
            String jk = jkm.get(k);
            o.put(jk, r.get(k));
        }
        return o;
    }

    public static JSONArray convertDataTableToJsonArray(DataTable dt) {
        JSONArray arr = new JSONArray();
        for (Map<String, Object> r : dt.rows) {
            arr.add((Object)DaoUtil.convertDataRowToJsonObject(r));
        }
        return arr;
    }
}

