/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders.ComputedRes;
import com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders.DataBinderContext;
import com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders.FillItemRowOption;
import com.jxdinfo.document.excel.tools.core.common.utils.replacePlaceholders.LsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class DataRender {
    public static void lsRenderData(DataBinderContext opt) {
        JSONObject sheet = opt.getSheet();
        if (sheet.get((Object)"data") == null || sheet.getJSONArray("data").size() == 0) {
            sheet.put("data", (Object)LsUtil.transCellDataToData(sheet.getJSONArray("celldata")));
        }
        if (sheet.get((Object)"celldata") != null) {
            sheet.put("celldata", null);
        }
        JSONObject nd = JSONObject.parseObject((String)sheet.toJSONString());
        opt.setNd(nd);
        DataRender.renderData(opt);
        ComputedRes computedRes = opt.getComputedRes();
        nd.put("computedRes", (Object)computedRes);
        opt.setSheet(null);
        JSONObject config = nd.getJSONObject("pageConfig");
        JSONObject headerFooter = new JSONObject();
        if (config != null) {
            if (opt.getVersion() == 2) {
                int nk;
                if (computedRes.getPageHeaderStartRow() > -1) {
                    headerFooter.put(String.valueOf(LsUtil.getNrn(opt, computedRes.getPageHeaderStartRow())), (Object)"\u9875\u7709");
                    headerFooter.put(String.valueOf(LsUtil.getNrn(opt, computedRes.getPageHeaderEndRow())), (Object)"\u6b63\u6587");
                }
                if (computedRes.getPageFooterStartRow() > -1) {
                    headerFooter.put(String.valueOf(LsUtil.getNrn(opt, computedRes.getPageFooterStartRow())), (Object)"\u9875\u811a");
                    headerFooter.put(String.valueOf(LsUtil.getNrn(opt, computedRes.getPageFooterEndRow())), (Object)"\u7ed3\u675f");
                }
                config.put("headerFooter", (Object)headerFooter);
                if (config.get((Object)"pageBreak") != null) {
                    JSONArray pb = new JSONArray();
                    for (int i = 0; i < config.getJSONArray("pageBreak").size(); ++i) {
                        int l = config.getJSONArray("pageBreak").getIntValue(i);
                        pb.add((Object)LsUtil.getNrn(opt, l));
                    }
                    config.put("pageBreak", (Object)pb);
                }
                if (config.get((Object)"catalog") != null) {
                    JSONObject cat = new JSONObject();
                    for (String k : config.getJSONObject("catalog").keySet()) {
                        nk = Integer.parseInt(k);
                        cat.put(String.valueOf(LsUtil.getNrn(opt, nk)), config.getJSONObject("catalog").get((Object)k));
                    }
                    config.put("catalog", (Object)cat);
                }
                if (config.get((Object)"tableHeader") != null) {
                    JSONObject th = new JSONObject();
                    for (String k : config.getJSONObject("tableHeader").keySet()) {
                        nk = Integer.parseInt(k);
                        th.put(String.valueOf(LsUtil.getNrn(opt, nk)), config.getJSONObject("tableHeader").get((Object)k));
                    }
                    config.put("tableHeader", (Object)th);
                }
            }
        }
        if (nd.get((Object)"config") != null && nd.getJSONObject("config").get((Object)"authority") != null && nd.getJSONObject("config").getJSONObject("authority").get((Object)"allowRangeList") != null) {
            for (int i = 0; i < nd.getJSONObject("config").getJSONObject("authority").getJSONArray("allowRangeList").size(); ++i) {
                JSONObject au = nd.getJSONObject("config").getJSONObject("authority").getJSONArray("allowRangeList").getJSONObject(i);
                for (int j = 0; j < au.getJSONArray("range").size(); ++j) {
                    JSONObject auRangei = au.getJSONArray("range").getJSONObject(j);
                    JSONArray nrow = new JSONArray();
                    nrow.add((Object)LsUtil.getNrn(opt, auRangei.getJSONArray("row").getIntValue(0)));
                    nrow.add((Object)LsUtil.getNrn(opt, auRangei.getJSONArray("row").getIntValue(1)));
                    auRangei.put("row", (Object)nrow);
                }
            }
        }
        DataRender.mergeComponents(opt);
    }

    public static void renderData(DataBinderContext opt) {
        JSONObject nd = opt.getNd();
        JSONObject pageConfig = nd.getJSONObject("pageConfig");
        ComputedRes computedRes = new ComputedRes();
        computedRes.setPhVarStart("${");
        computedRes.setPhVarEnd("}");
        computedRes.setPhVarStartLen(2);
        computedRes.setPageHeaderStartRow(-1);
        computedRes.setPageHeaderEndRow(0);
        computedRes.setPageFooterStartRow(-1);
        computedRes.setPageFooterEndRow(0);
        int version = 0;
        if (pageConfig != null) {
            version = pageConfig.getIntValue("version");
        }
        if (version == 0) {
            version = 2;
        }
        computedRes.setVersion(version);
        DataBinderContext.setVersion(version);
        if (version == 2) {
            computedRes.setPhVarStart("[");
            computedRes.setPhVarEnd("]");
            computedRes.setPhVarStartLen(1);
            computedRes.setPageHeaderStartRow(-1);
            computedRes.setPageHeaderEndRow(0);
            computedRes.setPageFooterStartRow(-1);
            computedRes.setPageFooterEndRow(0);
        }
        if (pageConfig != null && version == 2) {
            JSONObject headerFooter = pageConfig.getJSONObject("headerFooter");
            if (headerFooter != null) {
                for (String k : headerFooter.keySet()) {
                    if (headerFooter.getString(k).equals("\u9875\u7709")) {
                        computedRes.setPageHeaderStartRow(Integer.parseInt(k));
                        continue;
                    }
                    if (headerFooter.getString(k).equals("\u6b63\u6587")) {
                        computedRes.setPageHeaderEndRow(Integer.parseInt(k));
                        continue;
                    }
                    if (headerFooter.getString(k).equals("\u9875\u811a")) {
                        computedRes.setPageFooterStartRow(Integer.parseInt(k));
                        continue;
                    }
                    if (!headerFooter.getString(k).equals("\u7ed3\u675f")) continue;
                    computedRes.setPageFooterEndRow(Integer.parseInt(k));
                }
            }
            if (computedRes.getPageHeaderEndRow() == 0) {
                computedRes.setPageHeaderStartRow(-1);
            }
            if (computedRes.getPageFooterEndRow() == 0) {
                computedRes.setPageFooterStartRow(-1);
            }
        }
        nd.put("data", (Object)new JSONArray());
        computedRes.setRp(new JSONArray());
        computedRes.setRds(new JSONArray());
        computedRes.setNrs(new JSONArray());
        computedRes.setImgs(new JSONArray());
        computedRes.setRcSpan(new JSONArray());
        computedRes.setTrs(new JSONArray());
        computedRes.setComs(new JSONArray());
        computedRes.setRtr(new JSONArray());
        opt.setComputedRes(computedRes);
        DataRender.analysisRows(opt);
        DataRender.fillRowsData(opt);
        if (computedRes.getNrs().size() == 0) {
            for (int i = 0; i < computedRes.getRds().size(); ++i) {
                computedRes.getRds().getJSONObject(i).put("nrn", (Object)i);
                JSONObject rpObj = new JSONObject();
                rpObj.put("rIdx", (Object)i);
                computedRes.getRp().set(i, (Object)rpObj);
            }
            if (computedRes.getRcSpan().size() > 0) {
                DataRender.addMergeInfo(opt);
            }
            DataRender.processConditionFormat(opt);
            DataRender.processStyle_RichText(opt);
        } else {
            int addedRowCount = 0;
            for (int i = 0; i < computedRes.getNrs().size(); ++i) {
                int j;
                JSONObject nr = computedRes.getNrs().getJSONObject(i);
                int osr = 0;
                if (i > 0) {
                    osr = computedRes.getNrs().getJSONObject(i - 1).getIntValue("sr");
                }
                for (j = osr; j < nr.getIntValue("sr"); ++j) {
                    computedRes.getRds().getJSONObject(j).put("nrn", (Object)(j + addedRowCount));
                    JSONObject nrp = new JSONObject();
                    nrp.put("rIdx", (Object)j);
                    computedRes.getRp().set(j + addedRowCount, (Object)nrp);
                }
                nr.put("nsr", (Object)(nr.getIntValue("sr") + addedRowCount));
                for (int k = 0; k < nr.getIntValue("bs"); ++k) {
                    for (int l = 0; l < nr.getIntValue("bc"); ++l) {
                        JSONObject nrp = new JSONObject();
                        nrp.put("rIdx", (Object)(nr.getIntValue("sr") - nr.getIntValue("bs") + k));
                        nrp.put("isNew", (Object)true);
                        computedRes.getRp().set(nr.getIntValue("nsr") + k + l * nr.getIntValue("bs"), (Object)nrp);
                    }
                }
                addedRowCount += nr.getIntValue("cnt");
                if (i != computedRes.getNrs().size() - 1) continue;
                for (j = nr.getIntValue("sr"); j < computedRes.getRds().size(); ++j) {
                    computedRes.getRds().getJSONObject(j).put("nrn", (Object)(j + addedRowCount));
                    JSONObject nrp = new JSONObject();
                    nrp.put("rIdx", (Object)j);
                    computedRes.getRp().set(j + addedRowCount, (Object)nrp);
                }
            }
            DataRender.processNRAffection(opt);
        }
    }

    public static void analysisRows(DataBinderContext opt) {
        JSONObject od = opt.getSheet();
        JSONObject model = opt.getModel();
        ComputedRes computedRes = opt.getComputedRes();
        JSONArray rds = computedRes.getRds();
        JSONArray tRowStack = new JSONArray();
        JSONObject preListRow = null;
        JSONArray odData = od.getJSONArray("data");
        JSONObject rd = null;
        for (int rIdx = 0; rIdx < odData.size(); ++rIdx) {
            if (opt.getDelParamsList() != null && opt.getDelParamsList().size() > 0 && DataRender.getRowIdxInDelParams(rIdx, opt.getDelParamsList())) {
                rd = new JSONObject();
                rd.put("type", (Object)"text");
                rd.put("nrn", (Object)0);
            } else {
                JSONArray r1 = odData.getJSONArray(rIdx);
                rd = DataRender.anaDataRowType(opt, rIdx, r1, model);
            }
            rds.add((Object)rd);
            if (rd.getString("type").equals("list")) {
                JSONObject ttr;
                int ptrIdx;
                rd.put("sr", (Object)rIdx);
                rd.put("er", (Object)(rd.getIntValue("sr") + rd.getIntValue("rs")));
                if (preListRow != null && preListRow.getString("ns").equals(rd.getString("ns"))) {
                    preListRow.put("er", (Object)rd.getIntValue("er"));
                } else {
                    preListRow = rd;
                }
                if (tRowStack.size() == 0) {
                    tRowStack.add((Object)rd);
                    continue;
                }
                JSONObject ltr = tRowStack.getJSONObject(tRowStack.size() - 1);
                if (ltr.getString("ns").equals(rd.getString("ns"))) continue;
                for (ptrIdx = tRowStack.size() - 1; ptrIdx > -1 && ((ttr = tRowStack.getJSONObject(ptrIdx)).getString("ns").equals(rd.getString("ns")) || !rd.getString("ns").startsWith(ttr.getString("ns"))); --ptrIdx) {
                }
                if (ptrIdx < tRowStack.size() - 1) {
                    if (ptrIdx == -1 && tRowStack.size() > 1) {
                        computedRes.getTrs().add((Object)tRowStack.getJSONObject(0));
                    }
                    for (int i = tRowStack.size() - 1; i > ptrIdx; --i) {
                        tRowStack.remove(i);
                    }
                }
                if (tRowStack.size() > 0) {
                    ttr = tRowStack.getJSONObject(tRowStack.size() - 1);
                    if (ttr.get((Object)"tr") == null) {
                        ttr.put("tr", (Object)new JSONArray());
                    }
                    ttr.getJSONArray("tr").add((Object)rd);
                }
                tRowStack.add((Object)rd);
                continue;
            }
            if (preListRow == null || preListRow.getIntValue("sr") + preListRow.getIntValue("rs") - 1 >= rIdx) continue;
            preListRow = null;
        }
        if (rds.size() > 0) {
            JSONObject o = new JSONObject();
            o.put("type", (Object)"empty");
            o.put("nrn", (Object)0);
            rds.add((Object)o);
        }
        if (tRowStack.size() > 1) {
            computedRes.getTrs().add((Object)tRowStack.getJSONObject(0));
        }
    }

    public static JSONObject anaDataRowType(DataBinderContext opt, int rIdx, JSONArray r1, JSONObject model) {
        ComputedRes computedRes = opt.getComputedRes();
        int n = 0;
        if (r1 != null) {
            for (int i = 0; i < r1.size(); ++i) {
                if (r1.get(i) == null) continue;
                ++n;
            }
        }
        if (n == 0) {
            JSONObject res = new JSONObject();
            res.put("type", (Object)"empty");
            res.put("nrn", (Object)0);
            return res;
        }
        JSONObject rd = new JSONObject();
        rd.put("type", (Object)"text");
        rd.put("nrn", (Object)0);
        int rs = 1;
        for (int cIdx = 0; cIdx < r1.size(); ++cIdx) {
            int ep;
            Object cvo;
            int cMcRs;
            JSONObject c = r1.getJSONObject(cIdx);
            if (c == null) continue;
            if (c.get((Object)"mc") != null && c.getJSONObject("mc").get((Object)"rs") != null && rs < (cMcRs = c.getJSONObject("mc").getIntValue("rs"))) {
                rs = cMcRs;
            }
            if ((cvo = LsUtil.getFirstValueFromCell(c)) == null || cvo instanceof Number) continue;
            String cv = cvo.toString();
            if (computedRes.getPageHeaderStartRow() > -1 && (computedRes.getPageHeaderEndRow() == 0 || rIdx >= computedRes.getPageHeaderStartRow() && rIdx < computedRes.getPageHeaderEndRow())) {
                JSONObject res = new JSONObject();
                res.put("type", (Object)"header");
                res.put("nrn", (Object)0);
                return res;
            }
            if (computedRes.getPageFooterStartRow() > -1 && (computedRes.getPageFooterEndRow() == 0 || rIdx >= computedRes.getPageFooterStartRow() && rIdx < computedRes.getPageFooterEndRow())) {
                JSONObject res = new JSONObject();
                res.put("type", (Object)"footer");
                res.put("nrn", (Object)0);
                return res;
            }
            int sp = cv.indexOf(computedRes.getPhVarStart());
            if (sp <= -1 || (ep = cv.indexOf(computedRes.getPhVarEnd(), sp)) <= -1) continue;
            if (rd.getString("type").equals("text")) {
                rd.put("type", (Object)"item");
            }
            String exp = cv.substring(sp + computedRes.getPhVarStartLen(), ep);
            Object phModel = model;
            String[] exs = exp.split("\\.");
            String ns = "";
            for (int i = 0; i < exs.length; ++i) {
                try {
                    if (!(phModel instanceof JSONObject)) continue;
                    Object tempPhModel = phModel.get((Object)exs[i]);
                    if (tempPhModel == null) break;
                    if (!ns.equals("")) {
                        ns = ns + ".";
                    }
                    ns = ns + exs[i];
                    if (tempPhModel instanceof JSONArray && phModel.getJSONArray(exs[i]).size() > 1) {
                        phModel = phModel.getJSONArray(exs[i]).get(0);
                        rd.put("type", (Object)"list");
                        rd.put("sr", (Object)0);
                        rd.put("er", (Object)0);
                        rd.put("nrn", (Object)0);
                        rd.put("ns", (Object)ns);
                        continue;
                    }
                    if (!(tempPhModel instanceof JSONObject)) continue;
                    phModel = phModel.get((Object)exs[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            if (rd.getString("type").equals("item")) {
                if (phModel != null && phModel instanceof JSONObject) {
                    if (phModel.get((Object)"columns") != null && phModel.get((Object)"data") != null && phModel.getJSONArray("columns").size() > 0 && phModel.getJSONArray("data").size() > 0) {
                        rd = DataRender.getNewDynamicColumnTemplateRow();
                        rd.put("sr", (Object)rIdx);
                        rd.put("colIdx", (Object)cIdx);
                    } else if (phModel.getBooleanValue("isComponent") && phModel.get((Object)"coms") != null && phModel.getJSONArray("coms").size() > 0) {
                        rd = DataRender.getNewComponentsTemplateRow();
                        rd.put("sr", (Object)rIdx);
                        rd.put("colIdx", (Object)cIdx);
                    } else if (phModel.getBooleanValue("isRichText") && phModel.get((Object)"contentRows") != null && phModel.getJSONArray("contentRows").size() > 0) {
                        rd = DataRender.getNewRichTextTemplateRow();
                        rd.put("sr", (Object)rIdx);
                        rd.put("colIdx", (Object)cIdx);
                    }
                }
                return rd;
            }
            if (!rd.getString("type").equals("list")) continue;
            if (rd.get((Object)"vars") == null) {
                rd.put("vars", (Object)new JSONArray());
            }
            JSONObject listObj = new JSONObject();
            listObj.put("exp", (Object)exp);
            listObj.put("cIdx", (Object)cIdx);
            rd.getJSONArray("vars").add((Object)listObj);
        }
        if (rd.getString("type").equals("list")) {
            rd.put("rs", (Object)rs);
            if (rd.getJSONArray("vars") != null && rd.getJSONArray("vars").size() > 1) {
                JSONArray vars = rd.getJSONArray("vars");
                JSONObject v1 = vars.getJSONObject(0);
                rd.put("ss", (Object)new JSONArray());
                int sc = v1.getIntValue("cIdx");
                for (int i = 1; i < vars.size(); ++i) {
                    if (!vars.getJSONObject(i).getString("exp").equals(v1.getString("exp"))) continue;
                    int ec = vars.getJSONObject(i - 1).getIntValue("cIdx");
                    JSONObject o = new JSONObject();
                    o.put("sc", (Object)sc);
                    o.put("ec", (Object)ec);
                    rd.getJSONArray("ss").add((Object)o);
                    sc = vars.getJSONObject(i).getIntValue("cIdx");
                }
                if (sc != v1.getIntValue("cIdx")) {
                    JSONObject o = new JSONObject();
                    o.put("sc", (Object)sc);
                    o.put("ec", (Object)vars.getJSONObject(vars.size() - 1).getIntValue("cIdx"));
                    rd.getJSONArray("ss").add((Object)o);
                }
            }
        }
        return rd;
    }

    public static JSONObject getNewDynamicColumnTemplateRow() {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"dynamicColumn");
        obj.put("model", (Object)"");
        obj.put("sr", (Object)0);
        obj.put("er", (Object)0);
        obj.put("nrn", (Object)0);
        obj.put("colIdx", (Object)0);
        return obj;
    }

    public static JSONObject getNewComponentsTemplateRow() {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"components");
        obj.put("model", (Object)"");
        obj.put("sr", (Object)0);
        obj.put("nrn", (Object)0);
        obj.put("colIdx", (Object)0);
        return obj;
    }

    public static JSONObject getNewRichTextTemplateRow() {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"richtext");
        obj.put("model", (Object)"");
        obj.put("sr", (Object)0);
        obj.put("nrn", (Object)0);
        obj.put("colIdx", (Object)0);
        return obj;
    }

    public static void fillRowsData(DataBinderContext opt) {
        JSONObject od = opt.getSheet();
        JSONObject model = opt.getModel();
        JSONObject nd = opt.getNd();
        JSONArray ndData = nd.getJSONArray("data");
        ComputedRes computedRes = opt.getComputedRes();
        JSONArray rds = computedRes.getRds();
        JSONObject rd = null;
        block17: for (int rIdx = 0; rIdx < od.getJSONArray("data").size(); ++rIdx) {
            JSONArray r1 = od.getJSONArray("data").getJSONArray(rIdx);
            rd = rds.getJSONObject(rIdx);
            switch (rd.getString("type")) {
                case "item": {
                    JSONArray nr1 = JSONArray.parseArray((String)r1.toJSONString());
                    FillItemRowOption o1 = new FillItemRowOption();
                    o1.setR1(nr1);
                    o1.setModel(model);
                    o1.setrIdx(rIdx);
                    o1.setOpt(opt);
                    String[] ignoreWords1 = new String[]{"cpw", "pcw"};
                    o1.setIgnoreWords(ignoreWords1);
                    DataRender.fillItemRow(o1);
                    ndData.add((Object)nr1);
                    continue block17;
                }
                case "header": 
                case "footer": {
                    JSONArray nr2 = JSONArray.parseArray((String)r1.toJSONString());
                    FillItemRowOption o2 = new FillItemRowOption();
                    o2.setR1(nr2);
                    o2.setModel(model);
                    o2.setrIdx(rIdx);
                    o2.setOpt(opt);
                    String[] ignoreWords2 = new String[]{"cp", "pc"};
                    o2.setIgnoreWords(ignoreWords2);
                    DataRender.fillItemRow(o2);
                    ndData.add((Object)nr2);
                    continue block17;
                }
                case "list": {
                    DataRender.fillListRow(opt, rIdx);
                    rIdx += rd.getIntValue("er") - rd.getIntValue("sr") - 1;
                    continue block17;
                }
                case "dynamicColumn": {
                    DataRender.fillDynamicColumn(opt, rd);
                    ++rIdx;
                    continue block17;
                }
                case "components": {
                    if (opt.getMainOpt() == null) {
                        DataRender.fillComponentsRow(opt, rd);
                        continue block17;
                    }
                    JSONArray nr3 = JSONArray.parseArray((String)r1.toJSONString());
                    FillItemRowOption o3 = new FillItemRowOption();
                    o3.setR1(nr3);
                    o3.setModel(model);
                    o3.setrIdx(rIdx);
                    o3.setOpt(opt);
                    DataRender.fillItemRow(o3);
                    ndData.add((Object)nr3);
                    continue block17;
                }
                case "richtext": {
                    DataRender.fillRichTextRow(opt, rd);
                    continue block17;
                }
                default: {
                    if (r1 == null) {
                        ndData.add((Object)r1);
                        continue block17;
                    }
                    JSONArray nr100 = JSONArray.parseArray((String)r1.toJSONString());
                    ndData.add((Object)nr100);
                }
            }
        }
    }

    public static void fillItemRow(FillItemRowOption o) {
        boolean keepExp;
        JSONArray r1 = o.getR1();
        JSONObject model = o.getModel();
        boolean inList = o.isInList();
        String[] ignoreWords = o.getIgnoreWords();
        int rIdx = o.getrIdx();
        int rowOffset = o.getRowOffset();
        DataBinderContext opt = o.getOpt();
        ComputedRes computedRes = opt.getComputedRes();
        int sc = o.getSc();
        int ec = o.getEc();
        boolean bl = o.isKeepExp() ? true : (keepExp = false);
        if (!keepExp && opt != null && opt.isKeepExp()) {
            keepExp = true;
        }
        if (ec == 0) {
            ec = r1.size() - 1;
        }
        for (int cIdx = sc; cIdx <= ec; ++cIdx) {
            JSONArray ovs;
            JSONObject c = r1.getJSONObject(cIdx);
            if (c == null) continue;
            if (c.get((Object)"v") != null) {
                if (c.get((Object)"v") instanceof Number) continue;
                String cv = c.getString("v");
                boolean needChange2InlineStr = false;
                int sp = cv.indexOf(computedRes.getPhVarStart());
                if (sp > -1) {
                    int ep = cv.indexOf(computedRes.getPhVarEnd(), sp);
                    int pti = 0;
                    String nv = "";
                    if (ep > -1) {
                        while (sp > -1 && ep > -1) {
                            if (pti < sp) {
                                nv = nv + cv.substring(pti, sp);
                            }
                            pti = ep + 1;
                            String exp = cv.substring(sp + computedRes.getPhVarStartLen(), ep);
                            Object d = null;
                            if (model != null) {
                                d = inList ? LsUtil.getDataObj(model, exp.substring((o.getNs() != null ? o.getNs().length() : 0) + 1), 0) : LsUtil.getSingleDataObj(model, exp, 0);
                            }
                            if (!(c.get((Object)"ct") != null && c.getJSONObject("ct").get((Object)"fa") != null && c.getJSONObject("ct").getString("fa").equals("html") || LsUtil.getStrValue(d).indexOf("\r\n") <= -1)) {
                                needChange2InlineStr = true;
                                break;
                            }
                            sp = cv.indexOf(computedRes.getPhVarStart(), ep);
                            ep = cv.indexOf(computedRes.getPhVarEnd(), sp);
                        }
                    }
                }
                if (needChange2InlineStr) {
                    if (c.get((Object)"ct") == null) {
                        c.put("ct", (Object)new JSONObject());
                    }
                    JSONObject ct = c.getJSONObject("ct");
                    ct.put("fa", (Object)"General");
                    ct.put("t", (Object)"inlineStr");
                    if (ct.get((Object)"s") == null) {
                        ct.put("s", (Object)new JSONArray());
                    }
                    JSONArray ctS = ct.getJSONArray("s");
                    JSONObject sv = new JSONObject();
                    sv.put("v", (Object)c.getString("v"));
                    ctS.add((Object)sv);
                    c.put("v", null);
                }
            }
            if ((ovs = LsUtil.getCellValueFromData(c)) == null || ovs.size() <= 0) continue;
            JSONArray nvs = new JSONArray();
            JSONObject modelEmpty = new JSONObject();
            int rowSpan = 1;
            int colSpan = 1;
            boolean extend = false;
            for (int oi = 0; oi < ovs.size(); ++oi) {
                Object ovo = ovs.get(oi);
                if (ovo == null || ovo instanceof Number) {
                    nvs.add(ovo);
                    continue;
                }
                String ov = ovo.toString();
                int sp = ov.indexOf(computedRes.getPhVarStart());
                if (sp > -1) {
                    int ep = ov.indexOf(computedRes.getPhVarEnd(), sp);
                    if (ep > -1) {
                        String nv = "";
                        int pti = 0;
                        while (sp > -1) {
                            if (pti < sp) {
                                nv = nv + ov.substring(pti, sp);
                            }
                            pti = ep + 1;
                            String exp = ov.substring(sp + computedRes.getPhVarStartLen(), ep);
                            boolean ignoreWordsIncludeExp = false;
                            if (ignoreWords != null && ignoreWords.length > 0) {
                                for (int i = 0; i < ignoreWords.length; ++i) {
                                    if (!ignoreWords[i].equals(exp)) continue;
                                    ignoreWordsIncludeExp = true;
                                    break;
                                }
                            }
                            if (ignoreWordsIncludeExp) {
                                nv = nv + computedRes.getPhVarStart() + exp + computedRes.getPhVarEnd();
                            } else if (model != null) {
                                JSONObject dObj;
                                Object d = null;
                                d = inList ? LsUtil.getDataObj(model, exp.substring((o.getNs() != null ? o.getNs().length() : 0) + 1), 0) : LsUtil.getSingleDataObj(model, exp, 0);
                                String lastPartVal = exp;
                                if (lastPartVal.lastIndexOf(".") > -1) {
                                    lastPartVal = lastPartVal.substring(lastPartVal.lastIndexOf(".") + 1);
                                }
                                boolean isImg = false;
                                if (lastPartVal.startsWith("img_")) {
                                    isImg = true;
                                } else if (d instanceof JSONObject) {
                                    dObj = (JSONObject)d;
                                    if (dObj.getBooleanValue("isQrcode")) {
                                        isImg = true;
                                    } else if (dObj.get((Object)"type") != null && dObj.getString("type").startsWith("img_")) {
                                        isImg = true;
                                    }
                                }
                                if (isImg) {
                                    if (d != null && !d.toString().isEmpty()) {
                                        JSONObject imgObj = new JSONObject();
                                        imgObj.put("rIdx", (Object)rIdx);
                                        imgObj.put("cIdx", (Object)cIdx);
                                        imgObj.put("rowOffset", (Object)rowOffset);
                                        imgObj.put("data", d);
                                        imgObj.put("exp", (Object)exp);
                                        imgObj.put("inList", (Object)inList);
                                        imgObj.put("inComponent", (Object)false);
                                        computedRes.getImgs().add((Object)imgObj);
                                    }
                                    if (!inList) {
                                        nv = nv + computedRes.getPhVarStart() + exp + computedRes.getPhVarEnd();
                                    }
                                } else if (d != null && !d.toString().isEmpty()) {
                                    String strVal;
                                    if (d instanceof JSONObject) {
                                        dObj = (JSONObject)d;
                                        if (dObj.get((Object)"rowSpan") != null) {
                                            rowSpan = dObj.getIntValue("rowSpan");
                                        }
                                        if (dObj.get((Object)"colSpan") != null) {
                                            colSpan = dObj.getIntValue("colSpan");
                                        }
                                        if (dObj.get((Object)"extend") != null) {
                                            extend = dObj.getBooleanValue("extend");
                                        }
                                    }
                                    if ((strVal = LsUtil.getStrValue(d)) != null && !strVal.isEmpty()) {
                                        nv = nv + strVal;
                                    } else {
                                        modelEmpty.put("flag", (Object)true);
                                        String placeholder = (modelEmpty.getString("placeholder") == null || modelEmpty.getString("placeholder").isEmpty() ? "" : modelEmpty.getString("placeholder")) + computedRes.getPhVarStart() + exp + computedRes.getPhVarEnd();
                                        modelEmpty.put("placeholder", (Object)placeholder);
                                    }
                                } else {
                                    if (keepExp || DataRender.shouldKeepOriginalValue(exp)) {
                                        nv = nv + computedRes.getPhVarStart() + exp + computedRes.getPhVarEnd();
                                    }
                                    modelEmpty.put("flag", (Object)true);
                                    String placeholder = (modelEmpty.getString("placeholder") == null || modelEmpty.getString("placeholder").isEmpty() ? "" : modelEmpty.getString("placeholder")) + computedRes.getPhVarStart() + exp + computedRes.getPhVarEnd();
                                    modelEmpty.put("placeholder", (Object)placeholder);
                                }
                            } else {
                                if (keepExp || DataRender.shouldKeepOriginalValue(exp)) {
                                    nv = nv + computedRes.getPhVarStart() + exp + computedRes.getPhVarEnd();
                                }
                                modelEmpty.put("flag", (Object)true);
                                String placeholder = (modelEmpty.getString("placeholder") == null || modelEmpty.getString("placeholder").isEmpty() ? "" : modelEmpty.getString("placeholder")) + computedRes.getPhVarStart() + exp + computedRes.getPhVarEnd();
                                modelEmpty.put("placeholder", (Object)placeholder);
                            }
                            sp = ov.indexOf(computedRes.getPhVarStart(), ep);
                            ep = ov.indexOf(computedRes.getPhVarEnd(), sp);
                        }
                        if (pti < ov.length()) {
                            nv = nv + ov.substring(pti);
                        }
                        if (nv.length() == 0) {
                            nv = " ";
                        }
                        nvs.add((Object)nv);
                        continue;
                    }
                    nvs.add((Object)ov);
                    continue;
                }
                nvs.add((Object)ov);
            }
            LsUtil.setCellValue2Data(c, nvs, modelEmpty);
            if (rowSpan <= 0 && colSpan <= 0) continue;
            JSONObject rcSpanObj = new JSONObject();
            rcSpanObj.put("rIdx", (Object)rIdx);
            rcSpanObj.put("rowOffset", (Object)rowOffset);
            rcSpanObj.put("cIdx", (Object)cIdx);
            rcSpanObj.put("rowSpan", (Object)rowSpan);
            rcSpanObj.put("colSpan", (Object)colSpan);
            rcSpanObj.put("extend", (Object)extend);
            computedRes.getRcSpan().add((Object)rcSpanObj);
        }
    }

    public static boolean shouldKeepOriginalValue(String exp) {
        return exp.startsWith("\u62a5\u544a\u4fe1\u606f.");
    }

    public static void fillListRow(DataBinderContext opt, int rIdx) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONObject rd = computedRes.getRds().getJSONObject(rIdx);
        JSONObject model = opt.getModel();
        JSONArray lstData = (JSONArray)LsUtil.getDataObj(model, rd.getString("ns"), 0);
        int dl = lstData.size();
        JSONObject nd = opt.getNd();
        JSONArray ndData = nd.getJSONArray("data");
        if (dl == 0) {
            JSONArray nr = JSONArray.parseArray((String)opt.getSheet().getJSONArray("data").getJSONArray(rIdx).toJSONString());
            FillItemRowOption o = new FillItemRowOption();
            o.setR1(nr);
            o.setrIdx(rIdx);
            o.setOpt(opt);
            DataRender.fillItemRow(o);
            ndData.add((Object)nr);
            return;
        }
        JSONArray nrs = computedRes.getNrs();
        int cc = 1;
        if (rd.get((Object)"ss") != null && rd.getJSONArray("ss").size() > 1) {
            cc = rd.getJSONArray("ss").size();
        }
        int rrc = (int)Math.ceil(dl / cc);
        for (int i = 0; i < rrc; ++i) {
            for (int j = rIdx; j < rd.getIntValue("er"); ++j) {
                JSONArray nr = JSONArray.parseArray((String)opt.getSheet().getJSONArray("data").getJSONArray(j).toJSONString());
                if (i > 0) {
                    for (int m = 0; m < nr.size(); ++m) {
                        if (nr.get(m) != null && nr.getJSONObject(m).get((Object)"cgid") != null) {
                            nr.getJSONObject(m).put("cgid", (Object)("extend-" + i + "@" + nr.getJSONObject(m).getString("cgid")));
                        }
                        if (nr.get(m) == null || nr.getJSONObject(m).get((Object)"rowId") == null) continue;
                        nr.getJSONObject(m).put("rowId", (Object)("extend-" + i + "@" + nr.getJSONObject(m).getString("rowId")));
                    }
                }
                for (int k = 0; k < cc; ++k) {
                    int di = i * cc + k;
                    int sc = 0;
                    int ec = 0;
                    if (cc > 1) {
                        sc = rd.getJSONArray("ss").getJSONObject(k).getIntValue("sc");
                        ec = rd.getJSONArray("ss").getJSONObject(k).getIntValue("ec");
                    }
                    if (di >= dl) continue;
                    FillItemRowOption o = new FillItemRowOption();
                    o.setR1(nr);
                    o.setModel(lstData.getJSONObject(di));
                    o.setInList(true);
                    o.setrIdx(rIdx);
                    o.setRowOffset(i * (rd.getIntValue("er") - rd.getIntValue("sr")) + j - rIdx);
                    o.setOpt(opt);
                    o.setSc(sc);
                    o.setEc(ec);
                    o.setNs(rd.getString("ns"));
                    DataRender.fillItemRow(o);
                }
                if (cc > 1) {
                    FillItemRowOption o = new FillItemRowOption();
                    o.setR1(nr);
                    o.setrIdx(rIdx);
                    o.setOpt(opt);
                    DataRender.fillItemRow(o);
                }
                ndData.add((Object)nr);
            }
        }
        if (rrc > 1) {
            JSONObject nr = new JSONObject();
            nr.put("sr", (Object)rd.getIntValue("er"));
            nr.put("bs", (Object)(rd.getIntValue("er") - rd.getIntValue("sr")));
            nr.put("bc", (Object)(rrc - 1));
            nr.put("cnt", (Object)(nr.getIntValue("bc") * nr.getIntValue("bs")));
            nrs.add((Object)nr);
        }
    }

    public static void fillDynamicColumn(DataBinderContext opt, JSONObject rd) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONArray hr = JSONArray.parseArray((String)opt.getSheet().getJSONArray("data").getJSONArray(rd.getIntValue("sr")).toJSONString());
        JSONObject nd = opt.getNd();
        JSONArray ndData = nd.getJSONArray("data");
        ndData.add((Object)hr);
        JSONArray fld = ndData.getJSONArray(0);
        int mc = 0;
        JSONObject headerCell = hr.getJSONObject(rd.getIntValue("colOdx"));
        JSONArray ov = LsUtil.getCellValueFromData(headerCell);
        rd.put("model", (Object)ov.getString(0).substring(computedRes.getPhVarStartLen(), ov.getString(0).length() - 1));
        JSONObject model = (JSONObject)LsUtil.getDataObj(opt.getModel(), rd.getString("model"), 0);
        int cellColWidth = 1;
        if (headerCell.get((Object)"mc") != null) {
            cellColWidth = headerCell.getJSONObject("mc").getIntValue("cs");
        }
        if (nd.get((Object)"config") == null) {
            nd.put("config", (Object)new JSONObject());
        }
        JSONArray headerCellBoderInfo_Cell = new JSONArray();
        JSONArray headerCellBoderInfo_Range = new JSONArray();
        if (nd.getJSONObject("config").get((Object)"borderInfo") == null) {
            nd.getJSONObject("config").put("borderInfo", (Object)new JSONArray());
        }
        for (int i = 0; i < nd.getJSONObject("config").getJSONArray("borderInfo").size(); ++i) {
            JSONObject cfg = nd.getJSONObject("config").getJSONArray("borderInfo").getJSONObject(i);
            if (cfg.getString("rangeType").equals("cell") && cfg.getJSONObject("value").getIntValue("row_index") == rd.getIntValue("sr") && cfg.getJSONObject("value").getIntValue("col_index") >= rd.getIntValue("colIdx") && cfg.getJSONObject("value").getIntValue("col_index") < rd.getIntValue("colIdx") + cellColWidth) {
                headerCellBoderInfo_Cell.add((Object)cfg);
            }
            if (!cfg.getString("rangeType").equals("range") || cfg.getJSONArray("range").size() != 1) continue;
            JSONObject r = cfg.getJSONArray("range").getJSONObject(0);
            int sr = rd.getIntValue("sr");
            int er = rd.getIntValue("sr");
            if (r.getJSONArray("row").getIntValue(0) > er || r.getJSONArray("row").getIntValue(1) < sr) continue;
            headerCellBoderInfo_Range.add((Object)cfg);
        }
        if (nd.getJSONObject("config").get((Object)"merge") == null) {
            nd.getJSONObject("config").put("merge", (Object)new JSONObject());
        }
        JSONObject hearerCellMergeInfo = nd.getJSONObject("config").getJSONObject("merge").getJSONObject(rd.getIntValue("sr") + "_" + rd.getIntValue("colIdx"));
        for (int ci = 0; ci < model.getJSONArray("columns").size(); ++ci) {
            JSONObject c = JSONArray.parseObject((String)headerCell.toJSONString());
            hr.set(rd.getIntValue("colIdx") + ci * cellColWidth, (Object)c);
            if (mc < rd.getIntValue("colIdx") + (ci + 1) * cellColWidth) {
                mc = rd.getIntValue("colIdx") + (ci + 1) * cellColWidth;
            }
            if (ci > 0) {
                int j;
                if (hearerCellMergeInfo != null && c.get((Object)"mc") != null) {
                    c.getJSONObject("mc").put("c", (Object)(c.getJSONObject("mc").getIntValue("c") + ci * cellColWidth));
                    JSONObject cellMergeInfo = JSONObject.parseObject((String)hearerCellMergeInfo.toJSONString());
                    cellMergeInfo.put("c", (Object)c.getJSONObject("mc").getIntValue("c"));
                    nd.getJSONObject("config").getJSONObject("merge").put(c.getJSONObject("mc").getIntValue("r") + "_" + c.getJSONObject("mc").getIntValue("c"), (Object)cellMergeInfo);
                }
                for (j = 0; j < headerCellBoderInfo_Cell.size(); ++j) {
                    JSONObject nb = JSONObject.parseObject((String)headerCellBoderInfo_Cell.getJSONObject(j).toJSONString());
                    nb.getJSONObject("value").put("col_index", (Object)(nb.getJSONObject("value").getIntValue("col_index") + ci * cellColWidth));
                    nd.getJSONObject("config").getJSONArray("borderInfo").add((Object)nb);
                }
                for (j = 0; j < headerCellBoderInfo_Range.size(); ++j) {
                    JSONObject b = headerCellBoderInfo_Range.getJSONObject(j);
                    JSONObject r = b.getJSONArray("range").getJSONObject(0);
                    int sr = rd.getIntValue("sr");
                    int er = rd.getIntValue("sr");
                    if (r.getJSONArray("row").getIntValue(0) > sr || r.getJSONArray("row").getIntValue(1) < er) continue;
                    r.getJSONArray("column").set(1, (Object)(rd.getIntValue("colIdx") + cellColWidth - 1 + ci * cellColWidth));
                }
            }
            JSONArray vs = new JSONArray();
            vs.add(model.getJSONArray("columns").getJSONObject(ci).get((Object)"label"));
            LsUtil.setCellValue2Data(c, vs, null);
        }
        if (fld.size() < mc) {
            while (fld.size() < mc + 10) {
                JSONObject co = new JSONObject();
                co.put("c", (Object)"");
                co.put("v", (Object)"");
                fld.add((Object)co);
            }
        }
        JSONArray dr = JSONArray.parseArray((String)opt.getSheet().getJSONArray("data").getJSONArray(rd.getIntValue("sr") + 1).toJSONString());
        ndData.add((Object)"dr");
        JSONObject dataCell = dr.getJSONObject(rd.getIntValue("colIdx"));
        if (dataCell == null) {
            dataCell = new JSONObject();
        }
        if (model.getJSONArray("data").size() > 0) {
            JSONArray dataCellBoderInfo_Cell = new JSONArray();
            JSONArray dataCellBoderInfo_Range = new JSONArray();
            for (int i = 0; i < nd.getJSONObject("config").getJSONArray("borderInfo").size(); ++i) {
                JSONObject cfg = nd.getJSONObject("config").getJSONArray("borderInfo").getJSONObject(i);
                if (cfg.getString("range").equals("cell") && cfg.getJSONObject("value").getIntValue("row_index") == rd.getIntValue("sr") + 1 && cfg.getJSONObject("value").getIntValue("col_index") >= rd.getIntValue("colIdx") && cfg.getJSONObject("value").getIntValue("col_index") < rd.getIntValue("colIdx") + cellColWidth) {
                    dataCellBoderInfo_Cell.add((Object)cfg);
                }
                if (!cfg.getString("rangeType").equals("range") || cfg.getJSONArray("range").size() != 1) continue;
                JSONObject r = cfg.getJSONArray("range").getJSONObject(0);
                int sr = rd.getIntValue("sr") + 1;
                int er = rd.getIntValue("sr") + 1;
                if (r.getJSONArray("row").getIntValue(0) > er || r.getJSONArray("row").getIntValue(1) < sr) continue;
                dataCellBoderInfo_Range.add((Object)cfg);
            }
            JSONObject dataCellMergeInfo = nd.getJSONObject("config").getJSONObject("merge").getJSONObject(rd.getIntValue("sr") + 1 + "_" + rd.getIntValue("colIdx"));
            for (int di = 0; di < model.getJSONArray("data").size(); ++di) {
                JSONObject rowData = model.getJSONArray("data").getJSONObject(di);
                if (di > 0) {
                    dr = JSONArray.parseArray((String)opt.getSheet().getJSONArray("data").getJSONArray(rd.getIntValue("sr") + 1).toJSONString());
                    ndData.add((Object)dr);
                }
                for (int ci = 0; ci < model.getJSONArray("columns").size(); ++ci) {
                    int j;
                    JSONObject c = JSONObject.parseObject((String)dataCell.toJSONString());
                    Object cellDataObj = rowData.get(model.getJSONArray("columns").getJSONObject(ci).get((Object)"field"));
                    if (cellDataObj instanceof JSONObject) {
                        JSONObject cellData = (JSONObject)cellDataObj;
                        int rowSpan = 1;
                        int colSpan = 1;
                        if (cellData.get((Object)"rowSpan") != null) {
                            rowSpan = cellData.getIntValue("rowSpan");
                        }
                        if (cellData.get((Object)"colSpan") != null) {
                            colSpan = cellData.getIntValue("colSpan");
                        }
                        boolean extend = false;
                        if (cellData.get((Object)"extend") != null) {
                            extend = cellData.getBooleanValue("extend");
                        }
                        if (rowSpan > 1 || colSpan > 1) {
                            JSONObject rcSpanObj = new JSONObject();
                            rcSpanObj.put("rIdx", (Object)(rd.getIntValue("sr") + 1));
                            rcSpanObj.put("rowOffset", (Object)di);
                            rcSpanObj.put("cIdx", (Object)(rd.getIntValue("colIdx") + ci * cellColWidth));
                            rcSpanObj.put("rowSpan", (Object)rowSpan);
                            rcSpanObj.put("colSpan", (Object)colSpan);
                            rcSpanObj.put("extend", (Object)extend);
                            computedRes.getRcSpan().add((Object)rcSpanObj);
                        }
                    }
                    JSONArray vs = new JSONArray();
                    vs.add(LsUtil.getDataValue(cellDataObj));
                    LsUtil.setCellValue2Data(c, vs, null);
                    dr.set(rd.getIntValue("colIdx") + ci * cellColWidth, (Object)c);
                    if (c.get((Object)"mc") != null) {
                        c.getJSONObject("mc").put("c", (Object)(c.getJSONObject("mc").getIntValue("c") + ci * cellColWidth));
                        if (di == 0 && dataCellMergeInfo != null) {
                            JSONObject cellMergeInfo = JSONObject.parseObject((String)dataCellMergeInfo.toJSONString());
                            cellMergeInfo.put("c", (Object)c.getJSONObject("mc").getIntValue("c"));
                            nd.getJSONObject("config").getJSONObject("merge").put(c.getJSONObject("mc").getIntValue("r") + "_" + c.getJSONObject("mc").getIntValue("c"), (Object)cellMergeInfo);
                        }
                    }
                    if (di != 0) continue;
                    for (j = 0; j < dataCellBoderInfo_Cell.size(); ++j) {
                        JSONObject nb = JSONObject.parseObject((String)dataCellBoderInfo_Cell.getJSONObject(j).toJSONString());
                        nb.getJSONObject("value").put("col_index", (Object)(nb.getJSONObject("value").getIntValue("col_index") + ci * cellColWidth));
                        nd.getJSONObject("config").getJSONArray("borderInfo").add((Object)nb);
                    }
                    for (j = 0; j < dataCellBoderInfo_Range.size(); ++j) {
                        JSONObject b = JSONObject.parseObject((String)dataCellBoderInfo_Range.getJSONObject(j).toJSONString());
                        JSONObject r = b.getJSONArray("range").getJSONObject(0);
                        int sr = rd.getIntValue("sr") + 1;
                        int er = rd.getIntValue("sr") + 1;
                        if (r.getJSONArray("row").getIntValue(0) > sr || r.getJSONArray("row").getIntValue(1) < er) continue;
                        r.getJSONArray("column").set(1, (Object)(rd.getIntValue("colIdx") + cellColWidth - 1 + ci * cellColWidth));
                    }
                }
            }
            if (model.getJSONArray("data").size() > 1) {
                JSONObject nr = new JSONObject();
                nr.put("sr", (Object)(rd.getIntValue("sr") + 2));
                nr.put("bs", (Object)1);
                nr.put("bc", (Object)(model.getJSONArray("data").size() - 1));
                nr.put("cnt", (Object)0);
                nr.put("nsr", (Object)0);
                nr.put("cnt", (Object)(nr.getIntValue("bc") * nr.getIntValue("bs")));
                computedRes.getNrs().add((Object)nr);
            }
        }
    }

    public static void fillComponentsRow(DataBinderContext opt, JSONObject rd) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONObject cell = opt.getSheet().getJSONArray("data").getJSONArray(rd.getIntValue("sr")).getJSONObject(rd.getIntValue("colIdx"));
        if (cell.get((Object)"mc") != null && cell.getJSONObject("mc").get((Object)"rs") != null && opt.getNd().getJSONObject("config").get((Object)"merge") != null) {
            opt.getNd().getJSONObject("config").getJSONObject("merge").put(cell.getJSONObject("mc").getIntValue("r") + "_" + cell.getJSONObject("mc").getIntValue("c"), null);
        }
        JSONArray ov = LsUtil.getCellValueFromData(cell);
        rd.put("model", (Object)ov.getString(0).substring(computedRes.getPhVarStartLen(), ov.getString(0).length() - 1));
        JSONObject comData = (JSONObject)LsUtil.getDataObj(opt.getModel(), rd.getString("model"), 0);
        JSONArray templates = null;
        String tm = rd.getString("model");
        while (templates == null) {
            int lio = tm.lastIndexOf(".");
            if (lio == -1) {
                templates = opt.getModel().getJSONArray("comTemplates");
                break;
            }
            tm = tm.substring(0, tm.lastIndexOf("."));
            templates = ((JSONObject)LsUtil.getDataObj(opt.getModel(), tm, 0)).getJSONArray("comTemplates");
        }
        int addedRowCount = 0;
        for (int i = 0; i < comData.getJSONArray("coms").size(); ++i) {
            JSONObject com = comData.getJSONArray("coms").getJSONObject(i);
            JSONObject json = new JSONObject();
            Object jsonObj = null;
            for (int j = 0; j < templates.size(); ++j) {
                if (!templates.getJSONObject(j).getString("id").equals(com.getString("templateId"))) continue;
                jsonObj = templates.getJSONObject(j).get((Object)"json");
                break;
            }
            if (jsonObj instanceof String) {
                json = (JSONObject)ZipUtil.unZipReport((String)jsonObj);
            } else if (jsonObj instanceof JSONObject) {
                json = (JSONObject)jsonObj;
            }
            if (json.get((Object)"data") == null || json.getJSONArray("data").size() == 0) {
                JSONArray data = LsUtil.transCellDataToData(json.getJSONArray("celldata"));
                json.put("data", (Object)data);
                json.put("celldata", null);
            }
            if (json.get((Object)"pageConfig") == null) {
                JSONObject pg = new JSONObject();
                pg.put("version", (Object)opt.getVersion());
                json.put("pageConfig", (Object)pg);
            } else if (json.getJSONObject("pageConfig").get((Object)"version") == null) {
                json.getJSONObject("pageConfig").put("version", (Object)opt.getVersion());
            }
            JSONObject nopt = new JSONObject();
            DataBinderContext copt = new DataBinderContext(json, JSONObject.parseObject((String)json.toJSONString()), com.getJSONObject("model"), opt.isKeepExp(), nopt);
            DataRender.renderData(copt);
            for (int j = 0; j < copt.getNd().getJSONArray("data").size(); ++j) {
                JSONArray coptR = copt.getNd().getJSONArray("data").getJSONArray(j);
                opt.getNd().getJSONArray("data").add(coptR == null ? null : JSONArray.parseArray((String)coptR.toJSONString()));
            }
            JSONObject comObj = new JSONObject();
            comObj.put("sr", (Object)rd.getIntValue("sr"));
            comObj.put("json", (Object)json);
            comObj.put("addedRowCount", (Object)addedRowCount);
            comObj.put("copt", (Object)copt);
            computedRes.getComs().add((Object)comObj);
            addedRowCount += copt.getNd().getJSONArray("data").size();
        }
        if (addedRowCount > 1) {
            JSONObject nrObj = new JSONObject();
            nrObj.put("sr", (Object)(rd.getIntValue("sr") + 1));
            nrObj.put("cnt", (Object)(addedRowCount - 1));
            nrObj.put("bc", (Object)(addedRowCount - 1));
            nrObj.put("bs", (Object)1);
            nrObj.put("ignoreParentStyle", (Object)true);
            computedRes.getNrs().add((Object)nrObj);
        }
    }

    public static void fillRichTextRow(DataBinderContext opt, JSONObject rd) {
        ComputedRes computedRes = opt.getComputedRes();
        if (computedRes.getRtr() == null) {
            computedRes.setRtr(new JSONArray());
        }
        computedRes.getRtr().add((Object)rd);
        JSONArray cr = opt.getSheet().getJSONArray("data").getJSONArray(rd.getIntValue("sr"));
        JSONObject cell = cr.getJSONObject(rd.getIntValue("colIdx"));
        if (cell.get((Object)"mc") != null && cell.getJSONObject("mc").get((Object)"rs") != null && opt.getNd().getJSONObject("config").get((Object)"merge") != null) {
            opt.getNd().getJSONObject("config").getJSONObject("merge").put(cell.getJSONObject("mc").getIntValue("r") + "_" + cell.getJSONObject("mc").getIntValue("c"), null);
        }
        JSONArray ov = LsUtil.getCellValueFromData(cell);
        rd.put("model", (Object)ov.getString(0).substring(computedRes.getPhVarStartLen(), ov.getString(0).length() - 1));
        JSONObject mData = (JSONObject)LsUtil.getDataObj(opt.getModel(), rd.getString("model"), 0);
        for (int i = 0; i < mData.getJSONArray("contentRows").size(); ++i) {
            JSONObject rowData = mData.getJSONArray("contentRows").getJSONObject(i);
            JSONArray row = new JSONArray();
            for (int j = 0; j < cr.size(); ++j) {
                row.add(null);
            }
            JSONArray cells = rowData.getJSONArray("cells");
            int ci = rd.getIntValue("colIdx");
            for (int j = 0; j < cells.size(); ++j) {
                JSONObject c = cells.getJSONObject(j);
                if (!c.getString("type").equals("empty")) {
                    JSONObject co = new JSONObject();
                    co.put("ct", (Object)new JSONObject());
                    row.set(ci, (Object)co);
                }
                if (c.getString("type").equals("cell")) {
                    row.getJSONObject(ci).put("v", c.get((Object)"v"));
                }
                int t = 1;
                if (c.get((Object)"cols") != null) {
                    t = c.getIntValue("cols");
                }
                ci += t;
            }
            opt.getNd().getJSONArray("data").add((Object)row);
        }
        int addedRowCount = mData.getJSONArray("contentRows").size() - 1;
        if (addedRowCount > 0) {
            JSONObject nrObj = new JSONObject();
            nrObj.put("sr", (Object)(rd.getIntValue("sr") + 1));
            nrObj.put("cnt", (Object)addedRowCount);
            nrObj.put("bc", (Object)addedRowCount);
            nrObj.put("bs", (Object)1);
            nrObj.put("ignoreParentStyle", (Object)true);
            computedRes.getNrs().add((Object)nrObj);
        }
    }

    public static void addMergeInfo(DataBinderContext opt) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONObject nd = opt.getNd();
        for (int i = 0; i < computedRes.getRcSpan().size(); ++i) {
            JSONObject s = computedRes.getRcSpan().getJSONObject(i);
            if (s.getIntValue("rowSpan") <= 1 && s.getIntValue("colSpan") <= 1) continue;
            int nsr = LsUtil.getNrn(opt, s.getIntValue("rIdx")) + s.getIntValue("rowOffset");
            String omk = nsr + "_" + s.getIntValue("cIdx");
            if (nd.getJSONObject("config").getJSONObject("merge").getJSONObject(omk) != null) {
                if (s.getIntValue("rowSpan") == 1 || s.getBooleanValue("extend")) {
                    s.put("rowSpan", (Object)(s.getIntValue("rowSpan") * nd.getJSONObject("config").getJSONObject("merge").getJSONObject(omk).getIntValue("rs")));
                }
                if (s.getIntValue("colSpan") == 1 || s.getBooleanValue("extend")) {
                    s.put("colSpan", (Object)(s.getIntValue("colSpan") * nd.getJSONObject("config").getJSONObject("merge").getJSONObject(omk).getIntValue("cs")));
                }
            }
            JSONObject mc = new JSONObject();
            mc.put("rs", (Object)s.getIntValue("rowSpan"));
            mc.put("cs", (Object)s.getIntValue("colSpan"));
            mc.put("r", (Object)nsr);
            mc.put("c", (Object)s.getIntValue("cIdx"));
            nd.getJSONObject("config").getJSONObject("merge").put(nsr + "_" + s.getIntValue("cIdx"), (Object)mc);
            if (nd.getJSONArray("data").getJSONArray(nsr).get(s.getIntValue("cIdx")) == null) {
                nd.getJSONArray("data").getJSONArray(nsr).set(s.getIntValue("cIdx"), (Object)new JSONObject());
            }
            nd.getJSONArray("data").getJSONArray(nsr).getJSONObject(s.getIntValue("cIdx")).put("mc", (Object)JSONObject.parseObject((String)mc.toJSONString()));
            for (int r = 0; r < s.getIntValue("rowSpan"); ++r) {
                for (int c = 0; c < s.getIntValue("colSpan"); ++c) {
                    if (r == 0 && c == 0) continue;
                    int ri = nsr + r;
                    int ci = s.getIntValue("cIdx") + c;
                    JSONObject co = new JSONObject();
                    JSONObject cmco = new JSONObject();
                    cmco.put("r", (Object)nsr);
                    cmco.put("c", (Object)s.getIntValue("cIdx"));
                    co.put("mc", (Object)cmco);
                    nd.getJSONArray("data").getJSONArray(ri).set(ci, (Object)co);
                    String omk1 = ri + "_" + ci;
                    if (nd.getJSONObject("config").getJSONObject("merge").get((Object)omk1) == null) continue;
                    nd.getJSONObject("config").getJSONObject("merge").put(omk1, null);
                }
            }
        }
    }

    public static void processConditionFormat(DataBinderContext opt) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONObject nd = opt.getNd();
        if (nd.get((Object)"luckysheet_conditionformat_save") == null) {
            return;
        }
        JSONArray ncc = new JSONArray();
        for (int i = 0; i < nd.getJSONArray("luckysheet_conditionformat_save").size(); ++i) {
            JSONArray nr;
            int k;
            JSONObject nc;
            JSONObject cc = nd.getJSONArray("luckysheet_conditionformat_save").getJSONObject(i);
            JSONArray conditionValueType = new JSONArray();
            block1: for (int k2 = 0; k2 < cc.getJSONArray("conditionValue").size(); ++k2) {
                int ep;
                conditionValueType.add((Object)"text");
                String cfV = cc.getJSONArray("conditionValue").getString(k2);
                int sp = cfV.indexOf(computedRes.getPhVarStart());
                if (sp <= -1) continue;
                if (conditionValueType.getString(k2).equals("text")) {
                    conditionValueType.set(k2, (Object)"item");
                }
                if ((ep = cfV.indexOf(computedRes.getPhVarEnd(), sp)) <= -1) continue;
                String exp = cfV.substring(sp + computedRes.getPhVarStartLen(), ep);
                String[] exs = exp.split("\\.");
                Object phModelObj = opt.getModel();
                for (int ei = 0; ei < exs.length; ++ei) {
                    if (phModelObj instanceof JSONObject) {
                        phModelObj = phModelObj.get((Object)exs[ei]);
                    }
                    if (phModelObj == null) continue block1;
                    if (!(phModelObj instanceof JSONArray) || ((JSONArray)phModelObj).size() <= 1) continue;
                    phModelObj = ((JSONArray)phModelObj).get(0);
                    conditionValueType.set(k2, (Object)"list");
                }
            }
            boolean listFlag = false;
            for (int j = 0; j < conditionValueType.size(); ++j) {
                if (!conditionValueType.getString(j).equals("list")) continue;
                listFlag = true;
                break;
            }
            if (listFlag) {
                nc = JSONObject.parseObject((String)cc.toJSONString());
                for (k = 0; k < nc.getJSONArray("cellrange").size(); ++k) {
                    JSONObject ncCellRange = nc.getJSONArray("cellrange").getJSONObject(k);
                    int sr = ncCellRange.getJSONArray("row").getIntValue(0);
                    int nsr = LsUtil.getNrn(opt, sr);
                    JSONArray nRow = new JSONArray();
                    nRow.add((Object)nsr);
                    nRow.add((Object)(ncCellRange.getJSONArray("row").getIntValue(1) + nsr - sr));
                    ncCellRange.put("row", (Object)nRow);
                }
                for (k = 0; k < nc.getJSONArray("cellrange").size(); ++k) {
                    JSONObject nr2 = computedRes.getNrs().getJSONObject(k);
                    if (nr2.getBooleanValue("ignoreParentStyle")) continue;
                    int baseSr = nr2.getIntValue("sr") - nr2.getIntValue("bs");
                    int baseEr = nr2.getIntValue("sr");
                    for (int l = 0; l < nc.getJSONArray("cellrange").size(); ++l) {
                        JSONObject ncCellRange = nc.getJSONArray("cellrange").getJSONObject(l);
                        int sri = cc.getJSONArray("cellrange").getJSONObject(l).getJSONArray("row").getIntValue(0);
                        int eri = cc.getJSONArray("cellrange").getJSONObject(l).getJSONArray("row").getIntValue(1);
                        if (sri >= baseEr || eri < baseSr) continue;
                        ncCellRange.getJSONArray("row").set(1, (Object)(ncCellRange.getJSONArray("row").getIntValue(1) + nr2.getIntValue("cnt")));
                    }
                }
                JSONArray newConditionValue = new JSONArray();
                for (int k3 = 0; k3 < nc.getJSONArray("conditionValue").size(); ++k3) {
                    int ep;
                    String ccConditionValue = nc.getJSONArray("conditionValue").getString(k3);
                    int sp = ccConditionValue.indexOf(computedRes.getPhVarStart());
                    if (sp <= -1 || (ep = ccConditionValue.indexOf(computedRes.getPhVarEnd(), sp)) <= -1) continue;
                    String exp = ccConditionValue.substring(sp + computedRes.getPhVarStartLen(), ep);
                    Object dO = LsUtil.getDataObj1(opt.getModel(), exp, 0);
                    newConditionValue.add(dO);
                }
                JSONArray range = nc.getJSONArray("cellrange");
                if (range.size() > 1) {
                    for (int k4 = 0; k4 < range.size(); ++k4) {
                        JSONObject rule = new JSONObject();
                        rule.put("type", (Object)nc.getString("type"));
                        JSONArray ncr = new JSONArray();
                        ncr.add((Object)range.getJSONObject(k4));
                        rule.put("cellrange", (Object)ncr);
                        JSONObject nf = new JSONObject();
                        nf.put("textColor", nc.getJSONObject("format") == null ? null : nc.getJSONObject("format").getString("textColor"));
                        nf.put("cellColor", nc.getJSONObject("format") == null ? null : nc.getJSONObject("format").getString("cellColor"));
                        rule.put("format", (Object)nf);
                        rule.put("conditionName", (Object)nc.getString("conditionName"));
                        rule.put("conditionRange", (Object)new JSONArray());
                        JSONArray ncv = new JSONArray();
                        ncv.add(newConditionValue.getJSONArray(0).get(k4 % newConditionValue.getJSONArray(0).size()));
                        rule.put("conditionValue", (Object)ncv);
                        if (nc.getString("conditionName").equals("betweenness")) {
                            JSONArray ncv1 = new JSONArray();
                            ncv1.add(newConditionValue.getJSONArray(0).get(k4 % newConditionValue.getJSONArray(0).size()));
                            ncv1.add(newConditionValue.getJSONArray(1).get(k4 % newConditionValue.getJSONArray(1).size()));
                            rule.put("conditionValue", (Object)ncv1);
                        }
                        ncc.add((Object)rule);
                    }
                    continue;
                }
                if (range.size() != 1) continue;
                JSONArray row = range.getJSONObject(0).getJSONArray("row");
                int k5 = row.getIntValue(0);
                while (k5 <= row.getIntValue(1)) {
                    JSONObject mc;
                    JSONObject rule = new JSONObject();
                    rule.put("type", (Object)nc.getString("type"));
                    JSONArray ncr = new JSONArray();
                    JSONObject ncro = new JSONObject();
                    JSONArray ncror = new JSONArray();
                    ncror.add((Object)k5);
                    ncror.add((Object)k5);
                    ncro.put("row", (Object)ncror);
                    ncro.put("column", (Object)range.getJSONObject(0).getJSONArray("column"));
                    ncr.add((Object)ncro);
                    rule.put("cellrange", (Object)ncr);
                    JSONObject nf = new JSONObject();
                    nf.put("textColor", nc.getJSONObject("format") == null ? null : nc.getJSONObject("format").getString("textColor"));
                    nf.put("cellColor", nc.getJSONObject("format") == null ? null : nc.getJSONObject("format").getString("cellColor"));
                    rule.put("format", (Object)nf);
                    rule.put("conditionName", (Object)nc.getString("conditionName"));
                    rule.put("conditionRange", (Object)new JSONArray());
                    JSONArray ncv = new JSONArray();
                    ncv.add(newConditionValue.getJSONArray(0).get((k5 - row.getIntValue(0)) % newConditionValue.getJSONArray(0).size()));
                    rule.put("conditionValue", (Object)ncv);
                    if (nc.getString("conditionName").equals("betweenness")) {
                        JSONArray ncv1 = new JSONArray();
                        ncv1.add(newConditionValue.getJSONArray(0).get((k5 - row.getIntValue(0)) % newConditionValue.getJSONArray(0).size()));
                        ncv1.add(newConditionValue.getJSONArray(1).get((k5 - row.getIntValue(0)) % newConditionValue.getJSONArray(1).size()));
                        rule.put("conditionValue", (Object)ncv1);
                    }
                    if ((mc = nd.getJSONObject("config").getJSONObject("merge").getJSONObject(k5 + "_" + range.getJSONObject(0).getJSONArray("column").getIntValue(0))) != null && mc.get((Object)"rs") != null) {
                        JSONArray ncr1 = new JSONArray();
                        JSONObject ncro1 = new JSONObject();
                        JSONArray ncror1 = new JSONArray();
                        ncror1.add((Object)k5);
                        ncror1.add((Object)(k5 + mc.getIntValue("rs")));
                        ncro1.put("row", (Object)ncror1);
                        ncro1.put("column", (Object)range.getJSONObject(0).getJSONArray("column"));
                        ncr1.add((Object)ncro1);
                        rule.put("cellrange", (Object)ncr1);
                        k5 += mc.getIntValue("rs");
                    } else {
                        ++k5;
                    }
                    ncc.add((Object)rule);
                }
                continue;
            }
            nc = JSONObject.parseObject((String)cc.toJSONString());
            for (k = 0; k < nc.getJSONArray("conditionValue").size(); ++k) {
                int ep;
                String ccConditionValue = nc.getJSONArray("conditionValue").getString(k);
                int sp = ccConditionValue.indexOf(computedRes.getPhVarStart());
                if (sp <= -1 || (ep = ccConditionValue.indexOf(computedRes.getPhVarEnd(), sp)) <= -1) continue;
                String exp = ccConditionValue.substring(sp + computedRes.getPhVarStartLen(), ep);
                nc.getJSONArray("conditionValue").set(k, LsUtil.getSingleDataObj(opt.getModel(), exp, 0));
            }
            for (k = 0; k < nc.getJSONArray("cellrange").size(); ++k) {
                JSONObject ncCellRange = nc.getJSONArray("cellrange").getJSONObject(k);
                int sr = ncCellRange.getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                nr = new JSONArray();
                nr.add((Object)nsr);
                nr.add((Object)(ncCellRange.getJSONArray("row").getIntValue(1) + nsr - sr));
                ncCellRange.put("row", (Object)nr);
            }
            for (k = 0; k < nc.getJSONArray("conditionRange").size(); ++k) {
                JSONObject ncConditionRange = nc.getJSONArray("conditionRange").getJSONObject(k);
                int sr = ncConditionRange.getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                nr = new JSONArray();
                nr.add((Object)nsr);
                nr.add((Object)(ncConditionRange.getJSONArray("row").getIntValue(1) + nsr - sr));
                ncConditionRange.put("row", (Object)nr);
            }
            ncc.add((Object)nc);
            for (k = 0; k < computedRes.getNrs().size(); ++k) {
                int eri;
                int sri;
                int l;
                JSONObject nr3 = computedRes.getNrs().getJSONObject(k);
                if (nr3.getBooleanValue("ignoreParentStyle")) continue;
                int baseSr = nr3.getIntValue("sr") - nr3.getIntValue("bs");
                int baseEr = nr3.getIntValue("sr");
                for (l = 0; l < nc.getJSONArray("cellrange").size(); ++l) {
                    JSONObject ncCellRange = nc.getJSONArray("cellrange").getJSONObject(l);
                    sri = cc.getJSONArray("cellrange").getJSONObject(l).getJSONArray("row").getIntValue(0);
                    eri = cc.getJSONArray("cellrange").getJSONObject(l).getJSONArray("row").getIntValue(1);
                    if (sri >= baseEr || eri < baseSr) continue;
                    ncCellRange.getJSONArray("row").set(1, (Object)(ncCellRange.getJSONArray("row").getIntValue(1) + nr3.getIntValue("cnt")));
                }
                for (l = 0; l < nc.getJSONArray("conditionRange").size(); ++l) {
                    JSONObject ncConditionRange = nc.getJSONArray("conditionRange").getJSONObject(l);
                    sri = cc.getJSONArray("conditionRange").getJSONObject(l).getJSONArray("row").getIntValue(0);
                    eri = cc.getJSONArray("conditionRange").getJSONObject(l).getJSONArray("row").getIntValue(1);
                    if (sri >= baseEr || eri < baseSr) continue;
                    ncConditionRange.getJSONArray("row").set(1, (Object)(ncConditionRange.getJSONArray("row").getIntValue(1) + nr3.getIntValue("cnt")));
                }
            }
        }
        nd.put("luckysheet_conditionformat_save", (Object)ncc);
    }

    public static void processNRAffection(DataBinderContext opt) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONArray nrs = computedRes.getNrs();
        if (nrs.size() == 0) {
            return;
        }
        DataRender.processStyle_Border(opt);
        DataRender.processStyle_RowHeight(opt);
        DataRender.processStyle_MergeCell(opt);
        DataRender.processRowChange_Verification(opt);
        DataRender.addMergeInfo(opt);
        DataRender.processStyle_RichText(opt);
        DataRender.processFormula(opt);
        DataRender.processConditionFormat(opt);
        DataRender.processStatisticalTable(opt);
    }

    public static void processStyle_Border(DataBinderContext opt) {
        JSONObject nd = opt.getNd();
        if (nd.getJSONObject("config").get((Object)"borderInfo") == null) {
            return;
        }
        ComputedRes computedRes = opt.getComputedRes();
        JSONArray nrs = computedRes.getNrs();
        if (nrs.size() == 0) {
            return;
        }
        JSONArray nbi = new JSONArray();
        for (int i = 0; i < nd.getJSONObject("config").getJSONArray("borderInfo").size(); ++i) {
            JSONObject cfg = JSONObject.parseObject((String)nd.getJSONObject("config").getJSONArray("borderInfo").getJSONObject(i).toJSONString());
            nbi.add((Object)cfg);
            if (cfg.getString("rangeType").equals("cell")) {
                for (int j = 0; j < nrs.size(); ++j) {
                    JSONObject nri = nrs.getJSONObject(j);
                    if (nri.getBooleanValue("ignoreParentStyle")) continue;
                    int baseSr = nri.getIntValue("sr") - nri.getIntValue("bs");
                    int baseEr = nri.getIntValue("sr");
                    if (cfg.getJSONObject("value").getIntValue("row_index") < baseSr || cfg.getJSONObject("value").getIntValue("row_index") >= baseEr) continue;
                    for (int k = 0; k < nri.getIntValue("bc"); ++k) {
                        JSONObject ncbi = JSONObject.parseObject((String)cfg.toJSONString());
                        ncbi.getJSONObject("value").put("row_index", (Object)(nri.getIntValue("nsr") + k * nri.getIntValue("bs") + cfg.getJSONObject("value").getIntValue("row_index") - baseSr));
                        nbi.add((Object)ncbi);
                    }
                }
                cfg.getJSONObject("value").put("row_index", (Object)LsUtil.getNrn(opt, cfg.getJSONObject("value").getIntValue("row_index")));
            }
            if (!cfg.getString("rangeType").equals("range")) continue;
            JSONArray ri = JSONArray.parseArray((String)cfg.getJSONArray("range").toJSONString());
            for (int k = 0; k < cfg.getJSONArray("range").size(); ++k) {
                JSONObject r = cfg.getJSONArray("range").getJSONObject(k);
                int sr = r.getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                JSONArray nr = new JSONArray();
                nr.add((Object)nsr);
                nr.add((Object)(r.getJSONArray("row").getIntValue(1) + nsr - sr));
                r.put("row", (Object)nr);
            }
            for (int j = 0; j < nrs.size(); ++j) {
                JSONObject nri = nrs.getJSONObject(j);
                if (nri.getBooleanValue("ignoreParentStyle")) continue;
                int baseSr = nri.getIntValue("sr") - nri.getIntValue("bs");
                int baseEr = nri.getIntValue("sr");
                for (int k = 0; k < cfg.getJSONArray("range").size(); ++k) {
                    int sri = ri.getJSONObject(k).getJSONArray("row").getIntValue(0);
                    int eri = ri.getJSONObject(k).getJSONArray("row").getIntValue(1);
                    if (sri >= baseEr || eri < baseSr) continue;
                    cfg.getJSONArray("range").getJSONObject(k).getJSONArray("row").set(1, (Object)(cfg.getJSONArray("range").getJSONObject(k).getJSONArray("row").getIntValue(1) + nri.getIntValue("cnt")));
                }
            }
        }
        nd.getJSONObject("config").put("borderInfo", (Object)nbi);
    }

    public static void processStyle_RowHeight(DataBinderContext opt) {
        JSONObject nd = opt.getNd();
        if (nd.getJSONObject("config").get((Object)"rowlen") == null) {
            return;
        }
        ComputedRes computedRes = opt.getComputedRes();
        JSONArray nrs = computedRes.getNrs();
        if (nrs.size() == 0) {
            return;
        }
        JSONObject nrl = new JSONObject();
        for (int i = 0; i < nrs.size(); ++i) {
            JSONObject nri = nrs.getJSONObject(i);
            if (nri.getBooleanValue("ignoreParentStyle")) continue;
            int baseSr = nri.getIntValue("sr") - nri.getIntValue("bs");
            int baseEr = nri.getIntValue("sr");
            for (int k = baseSr; k < baseEr; ++k) {
                if (nd.getJSONObject("config").getJSONObject("rowlen").get((Object)k) == null) continue;
                for (int j = 0; j < nri.getIntValue("bc"); ++j) {
                    nrl.put(String.valueOf(nri.getIntValue("nsr") + nri.getIntValue("bs") * j + k - baseSr), nd.getJSONObject("config").getJSONObject("rowlen").get((Object)k));
                }
            }
        }
        for (String i : nd.getJSONObject("config").getJSONObject("rowlen").keySet()) {
            int nIdx = Integer.parseInt(i);
            if (nIdx >= computedRes.getRds().size()) continue;
            nrl.put(String.valueOf(LsUtil.getNrn(opt, nIdx)), nd.getJSONObject("config").getJSONObject("rowlen").get((Object)i));
        }
        nd.getJSONObject("config").put("rowlen", (Object)nrl);
    }

    public static void processStyle_MergeCell(DataBinderContext opt) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONArray nrs = computedRes.getNrs();
        if (nrs.size() == 0) {
            return;
        }
        JSONObject nd = opt.getNd();
        JSONObject m = new JSONObject();
        JSONObject om = nd.getJSONObject("config").getJSONObject("merge");
        for (int i = 0; i < nrs.size(); ++i) {
            int j;
            JSONObject nr = nrs.getJSONObject(i);
            int osr = 0;
            if (i > 0) {
                osr = computedRes.getRds().getJSONObject(nrs.getJSONObject(i - 1).getIntValue("sr")).getIntValue("nrn");
            }
            int er = nr.getIntValue("sr") - 1;
            if (nr.getBooleanValue("ignoreParentStyle")) {
                --er;
            }
            if (er > 0) {
                er = computedRes.getRds().getJSONObject(er).getIntValue("nrn");
            }
            for (j = osr; j <= er; ++j) {
                DataRender.setMergeInfo(j, nd.getJSONArray("data").getJSONArray(j), om, m, opt);
            }
            if (!nr.getBooleanValue("ignoreParentStyle")) {
                for (j = er + 1; j <= er + nr.getIntValue("cnt"); ++j) {
                    DataRender.processMainMergeCell(j, nd.getJSONArray("data").getJSONArray(j), m, opt, nr);
                    DataRender.setMergeInfo(j, nd.getJSONArray("data").getJSONArray(j), om, m, opt);
                }
            }
            if (i != nrs.size() - 1) continue;
            for (j = computedRes.getRds().getJSONObject(nr.getIntValue("sr")).getIntValue("nrn"); j < nd.getJSONArray("data").size(); ++j) {
                DataRender.setMergeInfo(j, nd.getJSONArray("data").getJSONArray(j), om, m, opt);
            }
        }
        nd.getJSONObject("config").put("merge", (Object)m);
    }

    public static void setMergeInfo(int rowIndex, JSONArray row, JSONObject om, JSONObject m, DataBinderContext opt) {
        if (row == null) {
            return;
        }
        ComputedRes computedRes = opt.getComputedRes();
        for (int j = 0; j < row.size(); ++j) {
            JSONObject c = row.getJSONObject(j);
            if (c == null || c.get((Object)"mc") == null) continue;
            if (c.getJSONObject("mc").get((Object)"rs") != null && c.getJSONObject("mc").get((Object)"cs") != null) {
                JSONObject mi = JSONObject.parseObject((String)om.getJSONObject(c.getJSONObject("mc").getIntValue("r") + "_" + c.getJSONObject("mc").getIntValue("c")).toJSONString());
                mi.put("r", (Object)rowIndex);
                m.put(rowIndex + "_" + c.getJSONObject("mc").getIntValue("c"), (Object)mi);
                c.getJSONObject("mc").put("r", (Object)rowIndex);
                continue;
            }
            c.getJSONObject("mc").put("r", (Object)(c.getJSONObject("mc").getIntValue("r") + (rowIndex - computedRes.getRp().getJSONObject(rowIndex).getIntValue("rIdx"))));
        }
    }

    public static void processMainMergeCell(int rowIndex, JSONArray row, JSONObject m, DataBinderContext opt, JSONObject nr) {
        if (row == null) {
            return;
        }
        ComputedRes computedRes = opt.getComputedRes();
        for (int j = 0; j < row.size(); ++j) {
            JSONObject c = row.getJSONObject(j);
            if (c == null || c.get((Object)"mc") == null || c.getJSONObject("mc").get((Object)"rs") != null) continue;
            JSONArray arr = new JSONArray();
            int t = nr.getIntValue("sr") - nr.getIntValue("bs");
            for (int k = 1; k < nr.getIntValue("cnt"); ++k) {
                arr.add((Object)(t + k));
            }
            int cmcr = c.getJSONObject("mc").getIntValue("r");
            int cmcc = c.getJSONObject("mc").getIntValue("c");
            boolean flag = false;
            for (int i = 0; i < arr.size(); ++i) {
                if (arr.getIntValue(i) != computedRes.getRp().getJSONObject(rowIndex).getIntValue("rIdx")) continue;
                flag = true;
                break;
            }
            if (cmcr == computedRes.getRp().getJSONObject(rowIndex).getIntValue("rIdx") || flag || m.get((Object)(cmcr + "_" + cmcc)) == null || cmcc != j) continue;
            m.getJSONObject(cmcr + "_" + cmcc).put("rs", (Object)(m.getJSONObject(cmcr + "_" + cmcc).getIntValue("rs") + 1));
            JSONObject ndDataCellMc = opt.getNd().getJSONArray("data").getJSONArray(cmcr).getJSONObject(cmcc).getJSONObject("mc");
            ndDataCellMc.put("rs", (Object)(ndDataCellMc.getIntValue("rs") + 1));
        }
    }

    public static void processRowChange_Verification(DataBinderContext opt) {
        JSONObject nd = opt.getNd();
        if (nd.get((Object)"dataVerification") == null) {
            return;
        }
        JSONObject ndv = new JSONObject();
        for (String key : nd.getJSONObject("dataVerification").keySet()) {
            String[] ss = key.split("_");
            int r = Integer.parseInt(ss[0]);
            ndv.put(LsUtil.getNrn(opt, r) + "_" + ss[1], (Object)nd.getJSONObject("dataVerification").getJSONObject(key));
        }
        nd.put("dataVerification", (Object)ndv);
    }

    public static void processStyle_RichText(DataBinderContext opt) {
        ComputedRes computedRes = opt.getComputedRes();
        if (computedRes.getRtr() == null) {
            return;
        }
        for (int k = 0; k < computedRes.getRtr().size(); ++k) {
            JSONObject rd = computedRes.getRtr().getJSONObject(k);
            int sr = computedRes.getRds().getJSONObject(rd.getIntValue("sr")).getIntValue("nrn");
            JSONObject mData = (JSONObject)LsUtil.getDataObj(opt.getModel(), rd.getString("model"), 0);
            JSONObject tableStyle = new JSONObject();
            if (mData.get((Object)"style") != null) {
                tableStyle = mData.getJSONObject("style");
            }
            for (int i = 0; i < mData.getJSONArray("contentRows").size(); ++i) {
                JSONObject rowData = mData.getJSONArray("contentRows").getJSONObject(i);
                JSONObject rowStyle = new JSONObject();
                if (rowData.get((Object)"style") != null) {
                    rowStyle = rowData.getJSONObject("style");
                }
                for (String key : tableStyle.keySet()) {
                    rowStyle.put(key, tableStyle.get((Object)key));
                }
                JSONArray row = opt.getNd().getJSONArray("data").getJSONArray(sr);
                int ci = rd.getIntValue("colIdx");
                for (int j = 0; j < rowData.getJSONArray("cells").size(); ++j) {
                    JSONObject cd = rowData.getJSONArray("cells").getJSONObject(j);
                    int cellMcRs = 1;
                    int cellMcCs = 1;
                    if (cd.get((Object)"rows") != null) {
                        cellMcRs = cd.getIntValue("rows");
                    }
                    if (cd.get((Object)"cols") != null) {
                        cellMcCs = cd.getIntValue("cols");
                    }
                    if (cd.getString("type").equals("empty")) {
                        JSONObject crb;
                        JSONObject cell = row.getJSONObject(ci);
                        JSONObject cellStyle = new JSONObject();
                        if (cd.get((Object)"style") != null) {
                            cellStyle = cd.getJSONObject("style");
                        }
                        for (String key : rowStyle.keySet()) {
                            cellStyle.put(key, rowStyle.get((Object)key));
                        }
                        if (cellStyle.get((Object)"textAlign") != null && cellStyle.getString("textAlign").equals("center")) {
                            cell.put("ht", (Object)"0");
                        }
                        if (cd.get((Object)"cols") != null && cd.getIntValue("cols") > 1 || cd.get((Object)"rows") != null && cd.getIntValue("rows") > 1) {
                            JSONObject c;
                            if (cd.get((Object)"cols") == null) {
                                cd.put("cols", (Object)1);
                            }
                            if (cd.get((Object)"rows") == null) {
                                cd.put("rows", (Object)1);
                            }
                            if ((c = opt.getNd().getJSONArray("data").getJSONArray(sr).getJSONObject(ci)).get((Object)"mc") != null && c.getJSONObject("mc").get((Object)"rs") == null) {
                                c.put("v", null);
                                int t = 1;
                                if (cd.get((Object)"cols") != null) {
                                    t = cd.getIntValue("cols");
                                }
                                ci += t;
                                break;
                            }
                            JSONObject cellMc = new JSONObject();
                            cellMc.put("rs", (Object)cellMcRs);
                            cellMc.put("cs", (Object)cellMcCs);
                            cellMc.put("r", (Object)sr);
                            cellMc.put("c", (Object)ci);
                            cell.put("mc", (Object)cellMc);
                            opt.getNd().getJSONObject("config").getJSONObject("merge").put(cell.getJSONObject("mc").getIntValue("r") + "_" + cell.getJSONObject("mc").getIntValue("c"), (Object)cell.getJSONObject("mc"));
                            for (int n = 0; n < cd.getIntValue("rows"); ++n) {
                                for (int l = 1; l < cd.getIntValue("cols"); ++l) {
                                    if (opt.getNd().getJSONArray("data").getJSONArray(sr + n).get(ci) == null) {
                                        opt.getNd().getJSONArray("data").getJSONArray(sr + n).set(ci, (Object)new JSONObject());
                                    }
                                    JSONObject cMc = new JSONObject();
                                    cMc.put("r", (Object)sr);
                                    cMc.put("c", (Object)ci);
                                    opt.getNd().getJSONArray("data").getJSONArray(sr + n).getJSONObject(ci).put("mc", (Object)cMc);
                                }
                            }
                        }
                        if (opt.getNd().getJSONObject("config").get((Object)"borderInfo") == null) {
                            opt.getNd().getJSONObject("config").put("borderInfo", (Object)new JSONArray());
                        }
                        if (cellStyle.get((Object)"borderLeft") != null || cellStyle.get((Object)"borderRight") != null || cellStyle.get((Object)"borderTop") != null || cellStyle.get((Object)"borderBottom") != null) {
                            JSONObject crbv;
                            if (cellStyle.get((Object)"borderLeft") != null) {
                                crb = new JSONObject();
                                crb.put("rangeType", (Object)"cell");
                                crbv = new JSONObject();
                                crbv.put("row_index", (Object)(sr + cellMcRs - 1));
                                crbv.put("col_index", (Object)(ci + cellMcCs - 1));
                                JSONObject bStyle = new JSONObject();
                                bStyle.put("color", (Object)"#000");
                                bStyle.put("style", (Object)1);
                                crbv.put("l", (Object)bStyle);
                                crb.put("value", (Object)crbv);
                                opt.getNd().getJSONObject("config").getJSONArray("borderInfo").add((Object)crb);
                            }
                            if (cellStyle.get((Object)"borderRight") != null) {
                                crb = new JSONObject();
                                crb.put("rangeType", (Object)"cell");
                                crbv = new JSONObject();
                                crbv.put("row_index", (Object)(sr + cellMcRs - 1));
                                crbv.put("col_index", (Object)(ci + cellMcCs - 1));
                                JSONObject bStyle = new JSONObject();
                                bStyle.put("color", (Object)"#000");
                                bStyle.put("style", (Object)1);
                                crbv.put("r", (Object)bStyle);
                                crb.put("value", (Object)crbv);
                                opt.getNd().getJSONObject("config").getJSONArray("borderInfo").add((Object)crb);
                            }
                            if (cellStyle.get((Object)"borderTop") != null) {
                                crb = new JSONObject();
                                crb.put("rangeType", (Object)"cell");
                                crbv = new JSONObject();
                                crbv.put("row_index", (Object)(sr + cellMcRs - 1));
                                crbv.put("col_index", (Object)(ci + cellMcCs - 1));
                                JSONObject bStyle = new JSONObject();
                                bStyle.put("color", (Object)"#000");
                                bStyle.put("style", (Object)1);
                                crbv.put("t", (Object)bStyle);
                                crb.put("value", (Object)crbv);
                                opt.getNd().getJSONObject("config").getJSONArray("borderInfo").add((Object)crb);
                            }
                            if (cellStyle.get((Object)"borderBottom") != null) {
                                crb = new JSONObject();
                                crb.put("rangeType", (Object)"cell");
                                crbv = new JSONObject();
                                crbv.put("row_index", (Object)(sr + cellMcRs - 1));
                                crbv.put("col_index", (Object)(ci + cellMcCs - 1));
                                JSONObject bStyle = new JSONObject();
                                bStyle.put("color", (Object)"#000");
                                bStyle.put("style", (Object)1);
                                crbv.put("b", (Object)bStyle);
                                crb.put("value", (Object)crbv);
                                opt.getNd().getJSONObject("config").getJSONArray("borderInfo").add((Object)crb);
                            }
                        } else if (cellStyle.get((Object)"border") != null) {
                            crb = new JSONObject();
                            crb.put("rangeType", (Object)"range");
                            crb.put("borderType", (Object)"border-outside");
                            crb.put("color", (Object)"#000");
                            crb.put("style", (Object)1);
                            JSONArray crbr = new JSONArray();
                            JSONObject crbro = new JSONObject();
                            JSONArray crbror = new JSONArray();
                            crbror.add((Object)sr);
                            crbror.add((Object)(sr + cellMcRs - 1));
                            crbro.put("row", (Object)crbror);
                            JSONArray crbroc = new JSONArray();
                            crbroc.add((Object)ci);
                            crbroc.add((Object)(ci + cellMcCs - 1));
                            crbro.put("column", (Object)crbroc);
                            crbr.add((Object)crbro);
                            crb.put("range", (Object)crbr);
                            opt.getNd().getJSONObject("config").getJSONArray("borderInfo").add((Object)crb);
                        }
                        if (cellStyle.get((Object)"backgroundColor") != null) {
                            cell.put("bg", cellStyle.get((Object)"backgroundColor"));
                        }
                        if (cellStyle.get((Object)"fontSize") != null) {
                            cell.put("fs", cellStyle.get((Object)"fontSize"));
                        }
                        if (cellStyle.get((Object)"fontColor") != null) {
                            cell.put("fc", cellStyle.get((Object)"fontColor"));
                        }
                        if (cellStyle.get((Object)"fontFamily") != null) {
                            cell.put("ff", cellStyle.get((Object)"fontFamily"));
                        }
                        if (cellStyle.get((Object)"cellType") != null) {
                            JSONObject cellType = new JSONObject();
                            JSONObject numberO = new JSONObject();
                            numberO.put("t", (Object)"n");
                            JSONObject numberOFa = new JSONObject();
                            numberOFa.put("default", (Object)"##0.00");
                            numberO.put("fa", (Object)numberOFa);
                            cellType.put("number", (Object)numberO);
                            JSONObject textO = new JSONObject();
                            textO.put("t", (Object)"g");
                            JSONObject textOFa = new JSONObject();
                            textOFa.put("default", (Object)"General");
                            textO.put("fa", (Object)textOFa);
                            cellType.put("text", (Object)textO);
                            if (cell.get((Object)"ct") == null) {
                                cell.put("ct", (Object)new JSONObject());
                            }
                            if (cellStyle.getJSONObject("cellType").get((Object)"type") != null) {
                                cell.getJSONObject("ct").put("t", (Object)cellType.getJSONObject(cellStyle.getJSONObject("cellType").getString("type")).getString("t"));
                                cell.getJSONObject("ct").put("fa", (Object)cellType.getJSONObject(cellStyle.getJSONObject("cellType").getString("type")).getJSONObject("fa").getString("default"));
                            }
                            if (cellStyle.getJSONObject("cellType").get((Object)"format") != null) {
                                cell.getJSONObject("ct").put("fa", (Object)cellStyle.getJSONObject("cellType").getString("format"));
                            }
                        }
                        if (cellStyle.get((Object)"textBeak") != null || cellStyle.get((Object)"textBreak") != null) {
                            String tb = "1";
                            if (cellStyle.get((Object)"textBeak") != null) {
                                tb = cellStyle.getString("textBeak");
                            }
                            if (cellStyle.get((Object)"textBreak") != null) {
                                tb = cellStyle.getString("textBreak");
                            }
                            cell.put("tb", (Object)tb);
                        }
                    }
                    ci += cellMcCs;
                }
                ++sr;
            }
        }
    }

    public static void processFormula(DataBinderContext opt) {
        JSONObject nd = opt.getNd();
        if (nd.get((Object)"calcChain") == null) {
            return;
        }
        ComputedRes computedRes = opt.getComputedRes();
        if (computedRes.getNrs().size() == 0) {
            return;
        }
        JSONArray ncc = new JSONArray();
        for (int i = 0; i < nd.getJSONArray("calcChain").size(); ++i) {
            JSONObject cc = nd.getJSONArray("calcChain").getJSONObject(i);
            JSONObject nc = JSONObject.parseObject((String)cc.toJSONString());
            nc.put("r", (Object)LsUtil.getNrn(opt, cc.getIntValue("r")));
            ncc.add((Object)nc);
            DataRender.updateFormulaData(opt, nd.getJSONArray("data").getJSONArray(nc.getIntValue("r")).getJSONObject(nc.getIntValue("c")), 0, 0);
            for (int j = 0; j < computedRes.getNrs().size(); ++j) {
                JSONObject nr = computedRes.getNrs().getJSONObject(j);
                if (nr.getBooleanValue("ignoreParentStyle")) continue;
                int baseSr = nr.getIntValue("sr") - nr.getIntValue("bs");
                int baseEr = nr.getIntValue("sr");
                if (cc.getIntValue("r") < baseSr || cc.getIntValue("r") >= baseEr) continue;
                for (int k = 0; k < nr.getIntValue("bc"); ++k) {
                    int nrIdx = nr.getIntValue("sr") + k * nr.getIntValue("bs") + LsUtil.getNrn(opt, cc.getIntValue("r")) - baseSr;
                    nc = JSONObject.parseObject((String)cc.toJSONString());
                    nc.put("r", (Object)nrIdx);
                    ncc.add((Object)nc);
                    DataRender.updateFormulaData(opt, nd.getJSONArray("data").getJSONArray(nrIdx).getJSONObject(nc.getIntValue("c")), cc.getIntValue("r") + 1, nrIdx + 1);
                }
            }
        }
        nd.put("calcChain", (Object)ncc);
    }

    public static void updateFormulaData(DataBinderContext opt, JSONObject cd, int orIdx, int nrIdx) {
        if (cd == null || cd.get((Object)"f") == null) {
            return;
        }
        String f = cd.getString("f");
        if (!f.startsWith("=")) {
            return;
        }
        int idx = 0;
        int pi = 0;
        String nf = "";
        while (idx < f.length()) {
            int c = f.codePointAt(idx);
            if (c >= 48 && c <= 57) {
                int pc;
                int ec;
                int ei;
                for (ei = idx + 1; ei < f.length() && (ec = f.codePointAt(ei)) >= 48 && ec <= 57; ++ei) {
                }
                if (idx > 0 && ((pc = f.codePointAt(idx - 1)) >= 65 && pc <= 90 || pc >= 97 && pc <= 122)) {
                    int nc = 0;
                    if (ei < f.length()) {
                        nc = f.codePointAt(ei);
                    }
                    if (nc != 33) {
                        if (idx > pi) {
                            nf = nf + f.substring(pi, idx);
                        }
                        int ov = Integer.parseInt(f.substring(idx, ei));
                        nf = nc == 126 ? nf + String.valueOf(LsUtil.getNrn(opt, ov)) : (orIdx != 0 && ov == orIdx ? nf + String.valueOf(nrIdx) : nf + String.valueOf(LsUtil.getNrn(opt, ov - 1) + 1));
                        idx = ++ei;
                        pi = ei;
                        continue;
                    }
                }
            }
            ++idx;
        }
        if (pi < f.length()) {
            nf = nf + f.substring(pi);
        }
        cd.put("f", (Object)nf);
    }

    public static void processStatisticalTable(DataBinderContext opt) {
        JSONObject nd = opt.getNd();
        if (nd.get((Object)"statistical_table") == null) {
            return;
        }
        ComputedRes computedRes = opt.getComputedRes();
        if (computedRes.getNrs().size() == 0) {
            return;
        }
        JSONArray ncc = new JSONArray();
        for (int i = 0; i < nd.getJSONArray("statistical_table").size(); ++i) {
            Object resRangeArrObj;
            JSONObject rangeSplitArray;
            JSONArray nrow;
            JSONObject cc = nd.getJSONArray("statistical_table").getJSONObject(i);
            JSONObject nc = JSONObject.parseObject((String)cc.toJSONString());
            Object rangeArrObj = nc.getJSONObject("tableOptions").get((Object)"rangeArr");
            if (rangeArrObj instanceof JSONArray) {
                for (int k = 0; k < ((JSONArray)rangeArrObj).size(); ++k) {
                    JSONObject ncRangeArr = ((JSONArray)rangeArrObj).getJSONObject(k);
                    int sr = ncRangeArr.getJSONArray("row").getIntValue(0);
                    int nsr = LsUtil.getNrn(opt, sr);
                    nrow = new JSONArray();
                    nrow.add((Object)nsr);
                    nrow.add((Object)(ncRangeArr.getJSONArray("row").getIntValue(1) + nsr - sr));
                    ncRangeArr.put("row", (Object)nrow);
                }
            } else if (rangeArrObj instanceof JSONObject) {
                int sr = ((JSONObject)rangeArrObj).getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                JSONArray nrow2 = new JSONArray();
                nrow2.add((Object)nsr);
                nrow2.add((Object)(((JSONObject)rangeArrObj).getJSONArray("row").getIntValue(1) + nsr - sr));
                ((JSONObject)rangeArrObj).put("row", (Object)nrow2);
            }
            if ((rangeSplitArray = nc.getJSONObject("tableOptions").getJSONObject("rangeSplitArray")) != null && rangeSplitArray.get((Object)"content") != null) {
                int sr = rangeSplitArray.getJSONObject("content").getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                JSONArray nrow3 = new JSONArray();
                nrow3.add((Object)nsr);
                nrow3.add((Object)(rangeSplitArray.getJSONObject("content").getJSONArray("row").getIntValue(1) + nsr - sr));
                rangeSplitArray.getJSONObject("content").put("row", (Object)nrow3);
            }
            if (rangeSplitArray != null && rangeSplitArray.get((Object)"rowtitle") != null) {
                int sr = rangeSplitArray.getJSONObject("rowtitle").getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                JSONArray nrow4 = new JSONArray();
                nrow4.add((Object)nsr);
                nrow4.add((Object)(rangeSplitArray.getJSONObject("rowtitle").getJSONArray("row").getIntValue(1) + nsr - sr));
                rangeSplitArray.getJSONObject("rowtitle").put("row", (Object)nrow4);
            }
            if (rangeSplitArray != null && rangeSplitArray.get((Object)"coltitle") != null) {
                int sr = rangeSplitArray.getJSONObject("coltitle").getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                JSONArray nrow5 = new JSONArray();
                nrow5.add((Object)nsr);
                nrow5.add((Object)(rangeSplitArray.getJSONObject("coltitle").getJSONArray("row").getIntValue(1) + nsr - sr));
                rangeSplitArray.getJSONObject("coltitle").put("row", (Object)nrow5);
            }
            if ((resRangeArrObj = nc.getJSONObject("resTableOptions").get((Object)"rangeArr")) instanceof JSONArray) {
                for (int k = 0; k < ((JSONArray)resRangeArrObj).size(); ++k) {
                    JSONObject ncRangeArr = ((JSONArray)resRangeArrObj).getJSONObject(k);
                    int sr = ncRangeArr.getJSONArray("row").getIntValue(0);
                    int nsr = LsUtil.getNrn(opt, sr);
                    JSONArray nrow6 = new JSONArray();
                    nrow6.add((Object)nsr);
                    nrow6.add((Object)(ncRangeArr.getJSONArray("row").getIntValue(1) + nsr - sr));
                    ncRangeArr.put("row", (Object)nrow6);
                }
            } else if (resRangeArrObj instanceof JSONObject) {
                int sr = ((JSONObject)resRangeArrObj).getJSONArray("row").getIntValue(0);
                int nsr = LsUtil.getNrn(opt, sr);
                nrow = new JSONArray();
                nrow.add((Object)nsr);
                nrow.add((Object)(((JSONObject)resRangeArrObj).getJSONArray("row").getIntValue(1) + nsr - sr));
                ((JSONObject)resRangeArrObj).put("row", (Object)nrow);
            }
            ncc.add((Object)nc);
            for (int j = 0; j < computedRes.getNrs().size(); ++j) {
                JSONObject nr = computedRes.getNrs().getJSONObject(j);
                if (nr.getBooleanValue("ignoreParentStyle")) continue;
                int baseSr = nr.getIntValue("sr") - nr.getIntValue("bs");
                int baseEr = nr.getIntValue("sr");
                Object ccRangeArrObj = cc.getJSONObject("tableOptions").get((Object)"rangeArr");
                if (rangeArrObj instanceof JSONArray) {
                    for (int k = 0; k < ((JSONArray)rangeArrObj).size(); ++k) {
                        JSONObject ncRangeArr = ((JSONArray)rangeArrObj).getJSONObject(k);
                        JSONObject ccRangeArr = ((JSONArray)ccRangeArrObj).getJSONObject(k);
                        int sri = ccRangeArr.getJSONArray("row").getIntValue(0);
                        int eri = ccRangeArr.getJSONArray("row").getIntValue(1);
                        if (sri >= baseEr || eri < baseSr) continue;
                        ncRangeArr.getJSONArray("row").set(1, (Object)(ncRangeArr.getJSONArray("row").getIntValue(1) + nr.getIntValue("cnt")));
                    }
                } else if (rangeArrObj instanceof JSONObject) {
                    int sri = ((JSONObject)ccRangeArrObj).getJSONArray("row").getIntValue(0);
                    int eri = ((JSONObject)ccRangeArrObj).getJSONArray("row").getIntValue(1);
                    if (sri < baseEr && eri >= baseSr) {
                        ((JSONObject)rangeArrObj).getJSONArray("row").set(1, (Object)(((JSONObject)rangeArrObj).getJSONArray("row").getIntValue(1) + nr.getIntValue("cnt")));
                    }
                }
                JSONObject ccRangeSplitArray = cc.getJSONObject("tableOptions").getJSONObject("rangeSplitArray");
                if (rangeSplitArray != null && rangeSplitArray.get((Object)"content") != null) {
                    int sri = ccRangeSplitArray.getJSONObject("content").getJSONArray("row").getIntValue(0);
                    int eri = ccRangeSplitArray.getJSONObject("content").getJSONArray("row").getIntValue(1);
                    if (sri < baseEr && eri >= baseSr) {
                        rangeSplitArray.getJSONObject("content").getJSONArray("row").set(1, (Object)(rangeSplitArray.getJSONObject("content").getJSONArray("row").getIntValue(1) + nr.getIntValue("cnt")));
                    }
                }
                if (rangeSplitArray != null && rangeSplitArray.get((Object)"rowtitle") != null) {
                    int sri = ccRangeSplitArray.getJSONObject("rowtitle").getJSONArray("row").getIntValue(0);
                    int eri = ccRangeSplitArray.getJSONObject("rowtitle").getJSONArray("row").getIntValue(1);
                    if (sri < baseEr && eri >= baseSr) {
                        rangeSplitArray.getJSONObject("rowtitle").getJSONArray("row").set(1, (Object)(rangeSplitArray.getJSONObject("rowtitle").getJSONArray("row").getIntValue(1) + nr.getIntValue("cnt")));
                    }
                }
                if (rangeSplitArray != null && rangeSplitArray.get((Object)"coltitle") != null) {
                    int sri = ccRangeSplitArray.getJSONObject("coltitle").getJSONArray("row").getIntValue(0);
                    int eri = ccRangeSplitArray.getJSONObject("coltitle").getJSONArray("row").getIntValue(1);
                    if (sri < baseEr && eri >= baseSr) {
                        rangeSplitArray.getJSONObject("coltitle").getJSONArray("row").set(1, (Object)(rangeSplitArray.getJSONObject("coltitle").getJSONArray("row").getIntValue(1) + nr.getIntValue("cnt")));
                    }
                }
                Object ccResRangeArrObj = cc.getJSONObject("resTableOptions").get((Object)"rangeArr");
                if (resRangeArrObj instanceof JSONArray) {
                    for (int k = 0; k < ((JSONArray)resRangeArrObj).size(); ++k) {
                        JSONObject ncRangeArr = ((JSONArray)resRangeArrObj).getJSONObject(k);
                        JSONObject ccRangeArr = ((JSONArray)ccResRangeArrObj).getJSONObject(k);
                        int sri = ccRangeArr.getJSONArray("row").getIntValue(0);
                        int eri = ccRangeArr.getJSONArray("row").getIntValue(1);
                        if (sri >= baseEr || eri < baseSr) continue;
                        ncRangeArr.getJSONArray("row").set(1, (Object)(ncRangeArr.getJSONArray("row").getIntValue(1) + nr.getIntValue("cnt")));
                    }
                    continue;
                }
                if (!(resRangeArrObj instanceof JSONObject)) continue;
                int sri = ((JSONObject)ccResRangeArrObj).getJSONArray("row").getIntValue(0);
                int eri = ((JSONObject)ccResRangeArrObj).getJSONArray("row").getIntValue(1);
                if (sri >= baseEr || eri < baseSr) continue;
                ((JSONObject)resRangeArrObj).getJSONArray("row").set(1, (Object)(((JSONObject)resRangeArrObj).getJSONArray("row").getIntValue(1) + nr.getIntValue("cnt")));
            }
        }
        nd.put("statistical_table", (Object)ncc);
    }

    public static void mergeComponents(DataBinderContext opt) {
        ComputedRes computedRes = opt.getComputedRes();
        JSONObject nd = opt.getNd();
        if (computedRes.getComs() == null || computedRes.getComs().size() == 0) {
            return;
        }
        if (nd.get((Object)"config") == null) {
            nd.put("config", (Object)new JSONObject());
        }
        if (nd.getJSONObject("config").get((Object)"merge") == null) {
            nd.getJSONObject("config").put("merge", (Object)new JSONObject());
        }
        for (int i = 0; i < computedRes.getComs().size(); ++i) {
            JSONObject c = computedRes.getComs().getJSONObject(i);
            JSONObject o = new JSONObject();
            o.put("mainSheet", (Object)nd);
            o.put("startRowIndex", (Object)(computedRes.getRds().getJSONObject(c.getIntValue("sr")).getIntValue("nrn") + c.getIntValue("addedRowCount")));
            o.put("copt", (Object)c.getJSONObject("copt"));
            DataRender.mergeComponent_MergeInfo(o);
            DataRender.mergeComponent_RowHeight(o);
            DataRender.mergeComponent_BorderInfo(o);
            JSONObject no = new JSONObject();
            no.put("mainOpt", (Object)opt);
            no.put("startRowIndex", (Object)(computedRes.getRds().getJSONObject(c.getIntValue("sr")).getIntValue("nrn") + c.getIntValue("addedRowCount")));
            no.put("copt", (Object)c.getJSONObject("copt"));
            DataRender.mergeComponent_Images(no);
            DataRender.mergeComponent_PageConfig(no);
            DataRender.mergeComponent_Authority(o);
            JSONObject noo = new JSONObject();
            noo.put("mainSheet", (Object)nd);
            noo.put("startRowIndex", (Object)(computedRes.getRds().getJSONObject(c.getIntValue("sr")).getIntValue("nrn") + c.getIntValue("addedRowCount")));
            noo.put("copt", (Object)c.getJSONObject("copt"));
            noo.put("compIndex", (Object)i);
            DataRender.mergeComponent_Chart(noo);
            DataRender.mergeComponent_hyperlink(o);
        }
    }

    public static void mergeComponent_MergeInfo(JSONObject o) {
        JSONObject mainSheet = o.getJSONObject("mainSheet");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        JSONObject mergeCfg = copt.getJSONObject("nd").getJSONObject("config").getJSONObject("merge");
        if (mergeCfg == null) {
            return;
        }
        for (int i = 0; i < copt.getJSONObject("nd").getJSONArray("data").size(); ++i) {
            DataRender.setMergeInfo(startRowIndex + i, i, mainSheet.getJSONArray("data").getJSONArray(startRowIndex + i), mergeCfg, mainSheet.getJSONObject("config").getJSONObject("merge"), copt);
        }
    }

    public static void setMergeInfo(int rowIndex, int i, JSONArray row, JSONObject om, JSONObject m, JSONObject opt) {
        if (row == null) {
            return;
        }
        JSONObject computedRes = opt.getJSONObject("computedRes");
        for (int j = 0; j < row.size(); ++j) {
            JSONObject c = row.getJSONObject(j);
            if (c == null || c.get((Object)"mc") == null) continue;
            if (c.getJSONObject("mc").get((Object)"rs") != null && c.getJSONObject("mc").get((Object)"cs") != null) {
                int cmcr = c.getJSONObject("mc").getIntValue("r");
                int cmcc = c.getJSONObject("mc").getIntValue("c");
                JSONObject mi = JSONObject.parseObject((String)om.getJSONObject(cmcr + "_" + cmcc).toJSONString());
                mi.put("r", (Object)rowIndex);
                m.put(rowIndex + "_" + cmcc, (Object)mi);
                c.getJSONObject("mc").put("r", (Object)rowIndex);
                continue;
            }
            c.getJSONObject("mc").put("r", (Object)(c.getJSONObject("mc").getIntValue("r") + (rowIndex - computedRes.getJSONArray("rp").getJSONObject(i).getIntValue("rIdx"))));
        }
    }

    public static void mergeComponent_RowHeight(JSONObject o) {
        JSONObject mainSheet = o.getJSONObject("mainSheet");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        JSONObject ncfg = copt.getJSONObject("nd").getJSONObject("config").getJSONObject("rowlen");
        if (ncfg == null) {
            return;
        }
        if (mainSheet.getJSONObject("config").get((Object)"rowlen") == null) {
            mainSheet.getJSONObject("config").put("rowlen", (Object)new JSONObject());
        }
        for (String k : ncfg.keySet()) {
            int nk = Integer.parseInt(k);
            mainSheet.getJSONObject("config").getJSONObject("rowlen").put(String.valueOf(startRowIndex + nk), (Object)ncfg.getIntValue(k));
        }
    }

    public static void mergeComponent_BorderInfo(JSONObject o) {
        JSONObject mainSheet = o.getJSONObject("mainSheet");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        JSONArray ncfg = copt.getJSONObject("nd").getJSONObject("config").getJSONArray("borderInfo");
        if (ncfg == null) {
            return;
        }
        if (mainSheet.getJSONObject("config").get((Object)"borderInfo") == null) {
            mainSheet.getJSONObject("config").put("borderInfo", (Object)new JSONArray());
        }
        for (int i = 0; i < ncfg.size(); ++i) {
            JSONObject cfg = JSONObject.parseObject((String)ncfg.getJSONObject(i).toJSONString());
            mainSheet.getJSONObject("config").getJSONArray("borderInfo").add((Object)cfg);
            if (cfg.getString("rangeType").equals("cell")) {
                cfg.getJSONObject("value").put("row_index", (Object)(startRowIndex + cfg.getJSONObject("value").getIntValue("row_index")));
            }
            if (!cfg.getString("rangeType").equals("range")) continue;
            for (int j = 0; j < cfg.getJSONArray("range").size(); ++j) {
                JSONArray cfgRangeRow = cfg.getJSONArray("range").getJSONObject(j).getJSONArray("row");
                cfgRangeRow.set(0, (Object)(startRowIndex + cfgRangeRow.getIntValue(0)));
                cfgRangeRow.set(1, (Object)(startRowIndex + cfgRangeRow.getIntValue(1)));
            }
        }
    }

    public static void mergeComponent_Images(JSONObject o) {
        JSONObject mainOpt = o.getJSONObject("mainOpt");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        JSONObject computedRes = copt.getJSONObject("computedRes");
        JSONArray coptImgs = computedRes.getJSONArray("imgs");
        if (coptImgs == null) {
            return;
        }
        if (mainOpt.getJSONObject("computedRes").get((Object)"imgs") == null) {
            mainOpt.getJSONObject("computedRes").put("imgs", (Object)new JSONArray());
        }
        JSONArray mainImgs = mainOpt.getJSONObject("computedRes").getJSONArray("imgs");
        for (int i = 0; i < coptImgs.size(); ++i) {
            JSONObject nImg = JSONObject.parseObject((String)coptImgs.getJSONObject(i).toJSONString());
            nImg.put("rIdx", (Object)(startRowIndex + LsUtil.getNrn(copt, coptImgs.getJSONObject(i).getIntValue("rIdx"))));
            nImg.put("inComponent", (Object)true);
            mainImgs.add((Object)nImg);
        }
    }

    public static void mergeComponent_PageConfig(JSONObject o) {
        int nk;
        JSONObject mainOpt = o.getJSONObject("mainOpt");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        JSONObject compPageConfig = copt.getJSONObject("nd").getJSONObject("pageConfig");
        if (compPageConfig == null) {
            return;
        }
        if (mainOpt.getJSONObject("nd").get((Object)"pageConfig") == null) {
            JSONObject npc = new JSONObject();
            npc.put("version", (Object)2);
            mainOpt.getJSONObject("nd").put("pageConfig", (Object)npc);
        }
        JSONObject mainPageConfig = mainOpt.getJSONObject("nd").getJSONObject("pageConfig");
        if (compPageConfig.get((Object)"pageBreak") != null) {
            if (mainPageConfig.get((Object)"pageBreak") == null) {
                mainPageConfig.put("pageBreak", (Object)new JSONArray());
            }
            for (int i = 0; i < compPageConfig.getJSONArray("pageBreak").size(); ++i) {
                int pb = LsUtil.getNrn(copt, compPageConfig.getJSONArray("pageBreak").getIntValue(i));
                mainPageConfig.getJSONArray("pageBreak").add((Object)(startRowIndex + pb));
            }
            ArrayList<Integer> pageBreakList = new ArrayList<Integer>();
            for (int i = 0; i < mainPageConfig.getJSONArray("pageBreak").size(); ++i) {
                pageBreakList.add(mainPageConfig.getJSONArray("pageBreak").getIntValue(i));
            }
            Collections.sort(pageBreakList);
            JSONArray npb = new JSONArray();
            npb.addAll(pageBreakList);
            mainPageConfig.put("pageBreak", (Object)npb);
        }
        if (compPageConfig.get((Object)"tableHeader") != null) {
            if (mainPageConfig.get((Object)"tableHeader") == null) {
                mainPageConfig.put("tableHeader", (Object)new JSONObject());
            }
            for (String key : mainPageConfig.getJSONObject("tableHeader").keySet()) {
                nk = Integer.parseInt(key);
                String nth = DataRender.getTableHeaderVal(mainPageConfig.getJSONObject("tableHeader").getString(String.valueOf(startRowIndex + LsUtil.getNrn(copt, nk))), compPageConfig.getJSONObject("tableHeader").getString(key));
                mainPageConfig.getJSONObject("tableHeader").put(String.valueOf(startRowIndex + LsUtil.getNrn(copt, nk)), (Object)nth);
            }
        }
        if (compPageConfig.get((Object)"catalog") != null) {
            if (mainPageConfig.get((Object)"catalog") == null) {
                mainPageConfig.put("catalog", (Object)new JSONObject());
            }
            for (String key : mainPageConfig.getJSONObject("catalog").keySet()) {
                nk = Integer.parseInt(key);
                mainPageConfig.getJSONObject("catalog").put(String.valueOf(startRowIndex + LsUtil.getNrn(copt, nk)), compPageConfig.getJSONObject("catalog").get((Object)key));
            }
        }
    }

    public static String getTableHeaderVal(String mainVal, String compVal) {
        String resStr = compVal;
        if (mainVal != null && !mainVal.isEmpty()) {
            ArrayList<String> arr = new ArrayList<String>();
            arr.add(mainVal);
            arr.add(compVal);
            if (arr.contains("\u8868\u5934") && arr.contains("\u8868\u683c\u7ed3\u675f")) {
                return "\u8868\u683c\u7ed3\u675f,\u8868\u5934";
            }
            if (arr.contains("\u8868\u5934\u5f00\u59cb") && arr.contains("\u8868\u683c\u7ed3\u675f")) {
                return "\u8868\u683c\u7ed3\u675f,\u8868\u5934\u5f00\u59cb";
            }
        } else {
            return compVal;
        }
        return resStr;
    }

    public static void mergeComponent_Authority(JSONObject o) {
        JSONObject mainSheet = o.getJSONObject("mainSheet");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        JSONArray compAuthority = null;
        if (copt.get((Object)"nd") != null && copt.getJSONObject("nd").get((Object)"config") != null && copt.getJSONObject("nd").getJSONObject("config").get((Object)"authority") != null && copt.getJSONObject("nd").getJSONObject("config").getJSONObject("authority").get((Object)"allowRangeList") != null) {
            compAuthority = copt.getJSONObject("nd").getJSONObject("config").getJSONObject("authority").getJSONArray("allowRangeList");
        }
        if (compAuthority == null) {
            return;
        }
        if (mainSheet.getJSONObject("config").get((Object)"authority") == null) {
            mainSheet.getJSONObject("config").put("authority", (Object)new JSONObject());
        }
        if (mainSheet.getJSONObject("config").getJSONObject("authority").get((Object)"allowRangeList") == null) {
            mainSheet.getJSONObject("config").getJSONObject("authority").put("allowRangeList", (Object)new JSONArray());
        }
        JSONArray mainAllowRangeList = mainSheet.getJSONObject("config").getJSONObject("authority").getJSONArray("allowRangeList");
        for (int i = 0; i < compAuthority.size(); ++i) {
            JSONObject au = compAuthority.getJSONObject(i);
            for (int j = 0; j < au.getJSONArray("range").size(); ++j) {
                JSONArray nrow = new JSONArray();
                nrow.add((Object)(startRowIndex + LsUtil.getNrn(copt, au.getJSONArray("range").getJSONObject(j).getJSONArray("row").getIntValue(0))));
                nrow.add((Object)(startRowIndex + LsUtil.getNrn(copt, au.getJSONArray("range").getJSONObject(j).getJSONArray("row").getIntValue(1))));
                au.getJSONArray("range").getJSONObject(j).put("row", (Object)nrow);
            }
            JSONArray filterAuthority = new JSONArray();
            for (int j = 0; j < mainAllowRangeList.size(); ++j) {
                if (!mainAllowRangeList.getJSONObject(j).getString("id").equals(au.getString("id"))) continue;
                filterAuthority.add((Object)mainAllowRangeList.getJSONObject(j));
            }
            if (filterAuthority.size() > 0) {
                long w = Math.round((double)new Date().getTime() * Math.random());
                au.put("id", (Object)(au.getString("id") + "_" + w));
                au.put("name", (Object)(au.getString("name") + "_" + w));
            }
            mainAllowRangeList.add((Object)au);
        }
    }

    public static void mergeComponent_Chart(JSONObject o) {
        JSONObject mainSheet = o.getJSONObject("mainSheet");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        int compIndex = o.getIntValue("compIndex");
        JSONArray compChart = null;
        if (copt.get((Object)"nd") != null && copt.getJSONObject("nd").get((Object)"chart") != null) {
            compChart = copt.getJSONObject("nd").getJSONArray("chart");
        }
        if (compChart == null) {
            return;
        }
        if (mainSheet.get((Object)"chart") == null) {
            mainSheet.put("chart", (Object)new JSONArray());
        }
        for (int i = 0; i < compChart.size(); ++i) {
            JSONObject chart = compChart.getJSONObject(i);
            chart.put("sheetIndex", (Object)mainSheet.getString("index"));
            chart.put("top", (Object)(chart.getIntValue("top") + mainSheet.getJSONArray("visibledatarow").getIntValue(startRowIndex - 1)));
            for (int j = 0; j < chart.getJSONObject("chartOptions").getJSONArray("rangeArray").size(); ++j) {
                JSONObject range = chart.getJSONObject("chartOptions").getJSONArray("rangeArray").getJSONObject(j);
                JSONObject nRange = new JSONObject();
                nRange.put("column", (Object)range.getJSONArray("column"));
                JSONArray nRangeRow = new JSONArray();
                nRangeRow.add((Object)(startRowIndex + LsUtil.getNrn(copt, range.getJSONArray("row").getIntValue(0))));
                nRangeRow.add((Object)(startRowIndex + LsUtil.getNrn(copt, range.getJSONArray("row").getIntValue(1))));
                nRange.put("row", (Object)nRangeRow);
                chart.getJSONObject("chartOptions").getJSONArray("rangeArray").set(j, (Object)nRange);
            }
            JSONObject rangeSplitArrayRange = chart.getJSONObject("chartOptions").getJSONObject("rangeSplitArray").getJSONObject("range");
            JSONObject nSplitRange = new JSONObject();
            nSplitRange.put("column", (Object)rangeSplitArrayRange.getJSONArray("column"));
            JSONArray nSplitRangeRow = new JSONArray();
            nSplitRangeRow.add((Object)(startRowIndex + LsUtil.getNrn(copt, rangeSplitArrayRange.getJSONArray("range").getIntValue(0))));
            nSplitRangeRow.add((Object)(startRowIndex + LsUtil.getNrn(copt, rangeSplitArrayRange.getJSONArray("range").getIntValue(1))));
            nSplitRange.put("row", (Object)nSplitRangeRow);
            chart.getJSONObject("chartOptions").getJSONObject("rangeSplitArray").put("range", (Object)nSplitRange);
            chart.put("inComp", (Object)true);
            chart.put("compIndex", (Object)compIndex);
            chart.put("compStartRowIndex", (Object)startRowIndex);
            JSONArray filterChart = new JSONArray();
            for (int j = 0; j < mainSheet.getJSONArray("chart").size(); ++j) {
                if (!mainSheet.getJSONArray("chart").getJSONObject(j).getString("chart_id").equals(chart.getString("chart_id"))) continue;
                filterChart.add((Object)mainSheet.getJSONArray("chart").getJSONObject(j));
            }
            if (filterChart.size() > 0) {
                String newChartId = chart.getString("chart_id") + "_" + Math.round((double)new Date().getTime() * Math.random());
                chart.put("chart_id", (Object)newChartId);
                chart.getJSONObject("chartOptions").put("chart_id", (Object)newChartId);
            }
            mainSheet.getJSONArray("chart").add((Object)chart);
        }
    }

    public static void mergeComponent_hyperlink(JSONObject o) {
        JSONObject mainSheet = o.getJSONObject("mainSheet");
        int startRowIndex = o.getIntValue("startRowIndex");
        JSONObject copt = o.getJSONObject("copt");
        JSONObject compHyperlink = copt.getJSONObject("nd").getJSONObject("hyperlink");
        if (compHyperlink == null) {
            return;
        }
        if (mainSheet.get((Object)"hyperlink") == null) {
            mainSheet.put("hyperlink", (Object)new JSONObject());
        }
        for (String key : compHyperlink.keySet()) {
            String[] keyArr = key.split("_");
            int r = LsUtil.getNrn(copt, Integer.parseInt(keyArr[0]));
            int c = LsUtil.getNrn(copt, Integer.parseInt(keyArr[1]));
            mainSheet.getJSONObject("hyperlink").put(r + startRowIndex + "_" + c, compHyperlink.get((Object)key));
        }
    }

    public static boolean getRowIdxInDelParams(int rIdx, JSONArray delParamsList) {
        boolean res = false;
        if (delParamsList != null && delParamsList.size() > 0) {
            for (int i = 0; i < delParamsList.size(); ++i) {
                JSONObject param = delParamsList.getJSONObject(i);
                if (param.get((Object)"begin") == null || param.get((Object)"end") == null || param.getIntValue("begin") - 1 > rIdx || param.getIntValue("end") - 1 < rIdx) continue;
                res = true;
                break;
            }
        }
        return res;
    }
}

