/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.mergeCells;

import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeRegion;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MergeGroup {
    private List<Map<String, Object>> rows;
    private Map<String, MergeGroup> subGroups;
    private int level;
    private int rowSpan;

    public MergeGroup(List<Map<String, Object>> rows, int level) {
        this.rows = rows;
        this.level = level;
        this.subGroups = new LinkedHashMap<String, MergeGroup>();
    }

    public void calculateSpans(List<Map<String, Object>> dataList, List<String> mergeColumns, Map<String, Integer> columnIndexCache, List<MergeRegion> regions) {
        block0: for (int r = 0; r < regions.size(); ++r) {
            int startRow = regions.get(r).getStartRow();
            int endRow = regions.get(r).getEndRow();
            int column = regions.get(r).getColumn();
            String columns = MergeGroup.getKeyByValue(columnIndexCache, column);
            if (!mergeColumns.contains(columns)) continue;
            for (int i = 0; i < dataList.size(); ++i) {
                if (i != startRow) continue;
                dataList.get(i).put("__span_" + columns, endRow - startRow);
                continue block0;
            }
        }
    }

    public static String getKeyByValue(Map<String, Integer> map, Integer value) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (!Objects.equals(entry.getValue(), value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<Map<String, Object>> getRows() {
        return this.rows;
    }

    public void setRows(List<Map<String, Object>> rows) {
        this.rows = rows;
    }

    public Map<String, MergeGroup> getSubGroups() {
        return this.subGroups;
    }

    public void setSubGroups(Map<String, MergeGroup> subGroups) {
        this.subGroups = subGroups;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }
}

