/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper;

import com.jxdinfo.document.excel.tools.core.common.utils.CalUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.factory.LuckySheetFactory;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.border.BorderInfo;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellDataMc;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.LuckySheet;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SheetConfigHelper {
    public static void setBorder(XSSFWorkbook workbook, XSSFCell cell, LuckySheet luckySheet) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        if (cellStyle == null) {
            return;
        }
        BorderInfo border = LuckySheetFactory.createBorder();
        border.getValue().setCol_index(cell.getColumnIndex());
        border.getValue().setRow_index(cell.getRowIndex());
        border.getValue().setT(LuckySheetFactory.createBorderStyle(workbook, cellStyle.getTopBorderXSSFColor(), cellStyle.getBorderTop()));
        border.getValue().setR(LuckySheetFactory.createBorderStyle(workbook, cellStyle.getRightBorderXSSFColor(), cellStyle.getBorderRight()));
        border.getValue().setB(LuckySheetFactory.createBorderStyle(workbook, cellStyle.getBottomBorderXSSFColor(), cellStyle.getBorderBottom()));
        border.getValue().setL(LuckySheetFactory.createBorderStyle(workbook, cellStyle.getLeftBorderXSSFColor(), cellStyle.getBorderLeft()));
        if (LuckySheetFactory.hasBorderStyle(border)) {
            luckySheet.getConfig().getBorderInfo().add(border);
        }
    }

    public static void setMerge(XSSFSheet sheet, LuckySheet luckySheet) {
        List mergedRegions = sheet.getMergedRegions();
        for (CellRangeAddress mergedRegion : mergedRegions) {
            CellDataMc mergeCell = new CellDataMc();
            mergeCell.setR(mergedRegion.getFirstRow());
            mergeCell.setRs(mergedRegion.getLastRow() - mergedRegion.getFirstRow() + 1);
            mergeCell.setC(mergedRegion.getFirstColumn());
            mergeCell.setCs(mergedRegion.getLastColumn() - mergedRegion.getFirstColumn() + 1);
            luckySheet.getConfig().getMerge().put(mergeCell.getR() + "_" + mergeCell.getC(), mergeCell);
        }
    }

    public static void setRowHeightAndHidden(XSSFSheet sheet, LuckySheet luckySheet) {
        int accumulatedRowHeight = 0;
        for (int i = CalUtil.getFirstRowBase0((Sheet)sheet); i <= sheet.getLastRowNum(); ++i) {
            XSSFRow row = sheet.getRow(i);
            if (row == null) continue;
            int nowRowHeight = CalUtil.twips2Pixel(row.getHeight());
            luckySheet.getConfig().getRowlen().put(i + "", nowRowHeight);
            luckySheet.getVisibledatarow().add(accumulatedRowHeight += nowRowHeight);
            if (!row.getZeroHeight()) continue;
            luckySheet.getConfig().getRowhidden().put(i + "", 0);
        }
    }

    public static void setColumnWithAndHidden(XSSFSheet sheet, LuckySheet luckySheet) {
        int accumulatedColumnWidth = 0;
        int maxColNum = CalUtil.getMaxColNum((Sheet)sheet);
        for (int i = 0; i < maxColNum; ++i) {
            float columnWidthInPixels = sheet.getColumnWidthInPixels(i);
            int nowColumnWidth = CalUtil.getColumnWidthPixel(columnWidthInPixels);
            luckySheet.getConfig().getColumnlen().put(i + "", nowColumnWidth);
            luckySheet.getVisibledatacolumn().add(accumulatedColumnWidth += nowColumnWidth);
            if (!sheet.isColumnHidden(i)) continue;
            luckySheet.getConfig().getColhidden().put(i + "", 0);
        }
    }
}

