/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.cache.StyleCache;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.CheckParamHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor.CopyCellCommentProcessor;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor.CopyConditionalFormattingProcessor;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor.CopyDataValidationsProcessor;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor.CopyPicturesProcessor;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor.CopyPrintProcessor;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor.CopyZoomProcessor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CopyExcelProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XSSFWorkbook mergeWithOPCPackage(List<String> tempFiles, int activeSheetIndex) {
        XSSFWorkbook destWorkbook = new XSSFWorkbook();
        StyleCache styleCache = new StyleCache(destWorkbook);
        for (String srcFile : tempFiles) {
            int maxColumn = CheckParamHelper.getMaxColumnMap().get(CopyExcelProcessor.extractBetweenLastUnderscoreAndDot(srcFile));
            try {
                XSSFWorkbook srcWorkbook = new XSSFWorkbook((InputStream)new FileInputStream(srcFile));
                Throwable throwable = null;
                try {
                    for (int i = 0; i < srcWorkbook.getNumberOfSheets(); ++i) {
                        XSSFSheet srcSheet = srcWorkbook.getSheetAt(i);
                        String sheetName = CopyExcelProcessor.getUniqueSheetName((Workbook)destWorkbook, srcSheet.getSheetName());
                        XSSFSheet destSheet = destWorkbook.createSheet(sheetName);
                        CopyExcelProcessor.copySheet(srcWorkbook, srcSheet, destWorkbook, destSheet, styleCache, maxColumn);
                        if (srcSheet.isSelected()) {
                            destWorkbook.setActiveSheet(activeSheetIndex);
                        }
                        destWorkbook.setForceFormulaRecalculation(true);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (srcWorkbook == null) continue;
                    if (throwable != null) {
                        try {
                            srcWorkbook.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    srcWorkbook.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                styleCache.dispose();
            }
        }
        return destWorkbook;
    }

    private static void copyCell(XSSFCell srcCell, XSSFCell destCell, XSSFWorkbook srcWorkbook, StyleCache styleCache) {
        switch (srcCell.getCellType()) {
            case STRING: {
                XSSFRichTextString richText = srcCell.getRichStringCellValue();
                if (Objects.nonNull(richText)) {
                    destCell.setCellValue((RichTextString)richText);
                    break;
                }
                destCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)srcCell)) {
                    destCell.setCellValue(srcCell.getDateCellValue());
                    break;
                }
                destCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                destCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                destCell.setCellFormula(srcCell.getCellFormula());
                break;
            }
            default: {
                destCell.setCellType(CellType.BLANK);
                destCell.setCellValue("");
            }
        }
        destCell.setCellStyle((CellStyle)styleCache.getStyle(srcWorkbook, srcCell.getCellStyle()));
    }

    private static void copyHyperlink(XSSFCell srcCell, XSSFCell destCell, XSSFWorkbook destWorkbook) {
        XSSFHyperlink hyperlink = srcCell.getHyperlink();
        if (hyperlink == null) {
            return;
        }
        XSSFHyperlink destHyperlink = destWorkbook.getCreationHelper().createHyperlink(hyperlink.getType());
        destHyperlink.setAddress(hyperlink.getAddress());
        destCell.setHyperlink((Hyperlink)destHyperlink);
    }

    private static void copyFreezePane(XSSFSheet source, XSSFSheet target) {
        PaneInformation pane = source.getPaneInformation();
        if (pane == null) {
            return;
        }
        short rowSplit = pane.getHorizontalSplitPosition();
        short colSplit = pane.getVerticalSplitPosition();
        short leftmostColumn = pane.getVerticalSplitLeftColumn();
        short topRow = pane.getHorizontalSplitTopRow();
        target.createFreezePane((int)colSplit, (int)rowSplit, (int)leftmostColumn, (int)topRow);
    }

    private static void copySheet(XSSFWorkbook srcWorkbook, XSSFSheet srcSheet, XSSFWorkbook destWorkbook, XSSFSheet destSheet, StyleCache styleCache, int maxColumnTemp) {
        int i;
        int maxColumn = 0;
        for (Row row : srcSheet) {
            if (row == null) continue;
            maxColumn = Math.max(maxColumn, row.getLastCellNum());
        }
        maxColumn = Math.max(maxColumn, maxColumnTemp);
        for (i = 0; i < maxColumn; ++i) {
            destSheet.setColumnWidth(i, srcSheet.getColumnWidth(i));
        }
        for (i = 0; i < srcSheet.getNumMergedRegions(); ++i) {
            destSheet.addMergedRegion(srcSheet.getMergedRegion(i));
        }
        for (int rowNum = 0; rowNum <= srcSheet.getLastRowNum(); ++rowNum) {
            XSSFRow srcRow = srcSheet.getRow(rowNum);
            if (srcRow == null) continue;
            XSSFRow destRow = destSheet.createRow(rowNum);
            destRow.setHeight(srcRow.getHeight());
            for (int cellNum = 0; cellNum < srcRow.getLastCellNum(); ++cellNum) {
                XSSFCell srcCell = srcRow.getCell(cellNum);
                XSSFCell destCell = destRow.createCell(cellNum);
                if (CopyExcelProcessor.shouldSkipCell((Cell)srcCell)) {
                    destCell.setBlank();
                    if (srcCell == null) continue;
                    destCell.setCellStyle((CellStyle)styleCache.getStyle(srcWorkbook, srcCell.getCellStyle()));
                    continue;
                }
                CopyExcelProcessor.copyCell(srcCell, destCell, srcWorkbook, styleCache);
                CopyExcelProcessor.copyHyperlink(srcCell, destCell, destWorkbook);
            }
        }
        CopyPicturesProcessor.copyPictures(srcSheet, destSheet, destWorkbook);
        CopyDataValidationsProcessor.copyDataValidations(srcSheet, destSheet);
        CopyConditionalFormattingProcessor.copyConditionalFormatting(srcSheet, destSheet, styleCache);
        CopyExcelProcessor.copyFreezePane(srcSheet, destSheet);
        CopyCellCommentProcessor.copyCellComment(srcSheet, destSheet, destWorkbook);
        CopyPrintProcessor.copyPrintSetting((Workbook)srcWorkbook, (Workbook)destWorkbook, (Sheet)srcSheet, (Sheet)destSheet);
        CopyZoomProcessor.copyZoom(srcSheet, destSheet);
    }

    private static boolean shouldSkipCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue().trim().isEmpty();
        }
        return cell.getCellType() == CellType.BLANK;
    }

    private static String getUniqueSheetName(Workbook workbook, String baseName) {
        String sheetName = baseName;
        int counter = 1;
        while (workbook.getSheet(sheetName) != null) {
            sheetName = baseName + "(" + counter++ + ")";
        }
        return sheetName;
    }

    public static Integer extractBetweenLastUnderscoreAndDot(String fileName) {
        int lastUnderscoreIndex = fileName.lastIndexOf(95);
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastUnderscoreIndex == -1 || lastDotIndex == -1 || lastUnderscoreIndex >= lastDotIndex) {
            return -1;
        }
        String numberPart = fileName.substring(lastUnderscoreIndex + 1, lastDotIndex);
        if (!numberPart.matches("\\d+")) {
            return -1;
        }
        return Integer.parseInt(numberPart);
    }

    static {
        ZipSecureFile.setMinInflateRatio((double)0.001);
        System.setProperty("org.apache.poi.util.POILogger", "org.apache.poi.util.NullLogger");
    }
}

