/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelExportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.cache.StyleCache;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity.BorderKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ColorHelper;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BorderHelper {
    private final XSSFWorkbook srcWorkbook;
    private final StyleCache styleCache;

    public BorderHelper(XSSFWorkbook srcWorkbook, StyleCache styleCache) {
        this.srcWorkbook = srcWorkbook;
        this.styleCache = styleCache;
    }

    public XSSFCellStyle createNoBorderStyle(XSSFCellStyle style) {
        return this.styleCache.getStyle(this.srcWorkbook, style, new BorderKey(BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE, ColorHelper.getDefaultColor(), ColorHelper.getDefaultColor(), ColorHelper.getDefaultColor(), ColorHelper.getDefaultColor()));
    }

    public void setBorder(JSONArray borderInfoObjectList, XSSFSheet sheet) {
        sheet.setDisplayGridlines(false);
        sheet.setPrintGridlines(false);
        for (int r = 0; r <= sheet.getLastRowNum(); ++r) {
            XSSFRow row = sheet.getRow(r);
            if (row == null) continue;
            for (int c = 0; c < row.getLastCellNum(); ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                cell.setCellStyle((CellStyle)this.createNoBorderStyle((XSSFCellStyle)cell.getCellStyle()));
            }
        }
        for (int i = 0; i < borderInfoObjectList.size(); ++i) {
            JSONObject borderInfoObject = (JSONObject)borderInfoObjectList.get(i);
            if ("cell".equals(borderInfoObject.get((Object)"rangeType"))) {
                JSONObject borderValueObject = borderInfoObject.getJSONObject("value");
                JSONObject l = borderValueObject.getJSONObject("l");
                JSONObject r = borderValueObject.getJSONObject("r");
                JSONObject t = borderValueObject.getJSONObject("t");
                JSONObject b = borderValueObject.getJSONObject("b");
                int row = borderValueObject.getInteger("row_index");
                int col = borderValueObject.getInteger("col_index");
                XSSFCell cell = sheet.getRow(row).getCell(col);
                if (cell == null) continue;
                BorderStyle borderLeft = null;
                XSSFColor leftBorderColor = null;
                BorderStyle borderRight = null;
                XSSFColor rightBorderColor = null;
                BorderStyle borderTop = null;
                XSSFColor topBorderColor = null;
                BorderStyle borderBottom = null;
                XSSFColor bottomBorderColor = null;
                Map<Integer, BorderStyle> bordMap = ExcelExportConstant.bord;
                if (b != null) {
                    borderBottom = bordMap.get(b.getIntValue("style"));
                    bottomBorderColor = ColorHelper.parseColorToXSSF(b.getString("color"));
                }
                if (r != null) {
                    borderRight = bordMap.get(r.getIntValue("style"));
                    rightBorderColor = ColorHelper.parseColorToXSSF(r.getString("color"));
                }
                if (t != null) {
                    borderTop = bordMap.get(t.getIntValue("style"));
                    topBorderColor = ColorHelper.parseColorToXSSF(t.getString("color"));
                }
                if (l != null) {
                    borderLeft = bordMap.get(l.getIntValue("style"));
                    leftBorderColor = ColorHelper.parseColorToXSSF(l.getString("color"));
                }
                XSSFCellStyle xssfCellStyle = this.styleCache.getStyle(this.srcWorkbook, cell.getCellStyle(), new BorderKey(borderTop, borderBottom, borderLeft, borderRight, topBorderColor, bottomBorderColor, rightBorderColor, leftBorderColor));
                cell.setCellStyle((CellStyle)xssfCellStyle);
                continue;
            }
            if (!"range".equals(borderInfoObject.get((Object)"rangeType"))) continue;
            XSSFColor color = ColorHelper.parseColorToXSSF(borderInfoObject.getString("color"));
            int styleIndex = borderInfoObject.getInteger("style");
            String borderType = borderInfoObject.getString("borderType");
            JSONArray borderRanges = (JSONArray)borderInfoObject.get((Object)"range");
            for (Object borderRange : borderRanges) {
                JSONObject range = (JSONObject)borderRange;
                int startRow = range.getJSONArray("row").getIntValue(0);
                int endRow = range.getJSONArray("row").getIntValue(1);
                int startCol = range.getJSONArray("column").getIntValue(0);
                int endCol = range.getJSONArray("column").getIntValue(1);
                this.setRangeEdgeBorder(sheet, styleIndex, color, startRow, endRow, startCol, endCol, borderType);
            }
        }
    }

    private void setRangeEdgeBorder(XSSFSheet sheet, int styleIndex, XSSFColor borderColor, int startRow, int endRow, int startCol, int endCol, String borderType) {
        boolean hasTopBorder = borderType.contains("top");
        boolean hasBottomBorder = borderType.contains("bottom");
        boolean hasLeftBorder = borderType.contains("left");
        boolean hasRightBorder = borderType.contains("right");
        boolean hasOutSideBorder = borderType.contains("outside");
        boolean hasAllSideBorder = borderType.contains("all");
        boolean hasInsideBorder = borderType.contains("inside");
        boolean hasVerticalBorder = borderType.contains("vertical");
        boolean hasHorizontalBorder = borderType.contains("horizontal");
        BorderStyle borderStyle = ExcelExportConstant.bord.get(styleIndex);
        for (int rowIndex = startRow; rowIndex <= endRow; ++rowIndex) {
            XSSFRow row = sheet.getRow(rowIndex);
            if (row == null) {
                row = sheet.createRow(rowIndex);
            }
            for (int colIndex = startCol; colIndex <= endCol; ++colIndex) {
                Cell cell = row.getCell(colIndex);
                if (cell == null) {
                    cell = row.createCell(colIndex);
                }
                boolean isTopEdge = rowIndex == startRow;
                boolean isLeftEdge = colIndex == startCol;
                boolean isRightEdge = colIndex == endCol;
                boolean isBottomEdge = rowIndex == endRow;
                boolean applyTop = isTopEdge && hasTopBorder || isTopEdge && hasOutSideBorder || hasAllSideBorder || !isTopEdge && hasInsideBorder || !isTopEdge && !isBottomEdge && hasHorizontalBorder;
                boolean applyLeft = isLeftEdge && hasLeftBorder || isLeftEdge && hasOutSideBorder || hasAllSideBorder || !isLeftEdge && hasInsideBorder || !isLeftEdge && hasVerticalBorder;
                boolean applyRight = isRightEdge && hasRightBorder || isRightEdge && hasOutSideBorder || hasAllSideBorder || !isRightEdge && hasInsideBorder || !isRightEdge && hasVerticalBorder;
                boolean applyBottom = isBottomEdge && hasBottomBorder || isBottomEdge && hasOutSideBorder || hasAllSideBorder || !isBottomEdge && hasInsideBorder || !isBottomEdge && !isTopEdge && hasHorizontalBorder;
                XSSFCellStyle style = this.styleCache.getCustomBorderStyle((XSSFCellStyle)cell.getCellStyle(), applyTop, applyLeft, applyRight, applyBottom, borderStyle, borderColor);
                cell.setCellStyle((CellStyle)style);
            }
        }
        this.setCornerBorders((Sheet)sheet, startRow, endRow, startCol, endCol, hasTopBorder, hasLeftBorder, hasRightBorder, hasBottomBorder, borderStyle, borderColor, hasAllSideBorder);
    }

    private void setCornerBorders(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, boolean hasTopBorder, boolean hasLeftBorder, boolean hasRightBorder, boolean hasBottomBorder, BorderStyle borderStyle, XSSFColor borderColor, boolean hasAllSideBorder) {
        XSSFCellStyle style;
        Workbook workbook = sheet.getWorkbook();
        boolean forceTopLeft = hasAllSideBorder || hasTopBorder && hasLeftBorder;
        boolean forceTopRight = hasAllSideBorder || hasTopBorder && hasRightBorder;
        boolean forceBottomLeft = hasAllSideBorder || hasBottomBorder && hasLeftBorder;
        boolean forceBottomRight = hasAllSideBorder || hasBottomBorder && hasRightBorder;
        BorderKey borderKey = BorderKey.getBorderKeyStyle(hasTopBorder || hasAllSideBorder, hasBottomBorder || hasAllSideBorder, hasLeftBorder || hasAllSideBorder, hasRightBorder || hasAllSideBorder, borderStyle, borderColor);
        if (forceTopLeft) {
            Cell topLeftCell = sheet.getRow(firstRow).getCell(firstCol);
            style = this.styleCache.getStyle((XSSFWorkbook)workbook, (XSSFCellStyle)topLeftCell.getCellStyle(), borderKey);
            topLeftCell.setCellStyle((CellStyle)style);
        }
        if (forceTopRight) {
            Cell topRightCell = sheet.getRow(firstRow).getCell(lastCol);
            style = this.styleCache.getStyle((XSSFWorkbook)workbook, (XSSFCellStyle)topRightCell.getCellStyle(), borderKey);
            topRightCell.setCellStyle((CellStyle)style);
        }
        if (forceBottomLeft) {
            Cell bottomLeftCell = sheet.getRow(lastRow).getCell(firstCol);
            style = this.styleCache.getStyle((XSSFWorkbook)workbook, (XSSFCellStyle)bottomLeftCell.getCellStyle(), borderKey);
            bottomLeftCell.setCellStyle((CellStyle)style);
        }
        if (forceBottomRight) {
            Cell bottomRightCell = sheet.getRow(lastRow).getCell(lastCol);
            style = this.styleCache.getStyle((XSSFWorkbook)workbook, (XSSFCellStyle)bottomRightCell.getCellStyle(), borderKey);
            bottomRightCell.setCellStyle((CellStyle)style);
        }
    }
}

