/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.cache;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity.BorderKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity.FontKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity.RuleKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.entity.StyleKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ColorHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StyleCache
implements AutoCloseable {
    private final XSSFWorkbook destWorkbook;
    private XSSFWorkbook srcWorkbook;
    private static final ThreadLocal<Map<Integer, Map<StyleKey, XSSFCellStyle>>> THREAD_STYLE_CACHE = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<Integer, Map<String, XSSFColor>>> THREAD_COLOR_CACHE = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<Integer, Map<FontKey, XSSFFont>>> THREAD_FONT_CACHE = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<Integer, Map<RuleKey, ConditionalFormattingRule>>> THREAD_RULE_CACHE = ThreadLocal.withInitial(HashMap::new);

    public StyleCache(XSSFWorkbook destWorkbook) {
        this.destWorkbook = destWorkbook;
    }

    private Map<StyleKey, XSSFCellStyle> getStyleCacheMap() {
        int workbookHash = System.identityHashCode(this.destWorkbook);
        return THREAD_STYLE_CACHE.get().computeIfAbsent(workbookHash, k -> new ConcurrentHashMap());
    }

    private Map<FontKey, XSSFFont> getFontCacheMap() {
        int workbookHash = System.identityHashCode(this.destWorkbook);
        return THREAD_FONT_CACHE.get().computeIfAbsent(workbookHash, k -> new ConcurrentHashMap());
    }

    private Map<String, XSSFColor> getColorCacheMap() {
        int workbookHash = System.identityHashCode(this.destWorkbook);
        return THREAD_COLOR_CACHE.get().computeIfAbsent(workbookHash, k -> new ConcurrentHashMap());
    }

    private Map<RuleKey, ConditionalFormattingRule> getRuleCacheMap() {
        int workbookHash = System.identityHashCode(this.destWorkbook);
        return THREAD_RULE_CACHE.get().computeIfAbsent(workbookHash, k -> new ConcurrentHashMap());
    }

    public XSSFCellStyle getStyle() {
        FontKey fontKey = new FontKey(this.destWorkbook, null);
        BorderKey borderKey = new BorderKey(null);
        StyleKey styleKey = new StyleKey(this.destWorkbook, null, fontKey, borderKey);
        Map<StyleKey, XSSFCellStyle> styleCacheMap = this.getStyleCacheMap();
        return styleCacheMap.computeIfAbsent(styleKey, k -> {
            XSSFCellStyle newStyle = this.destWorkbook.createCellStyle();
            XSSFColor blackColor = ColorHelper.getDefaultColor();
            if (borderKey.getBorderTop() != null) {
                newStyle.setBorderTop(borderKey.getBorderTop());
                if (borderKey.getTopBorderColor() != null) {
                    newStyle.setTopBorderColor(borderKey.getTopBorderColor());
                } else {
                    newStyle.setTopBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderBottom() != null) {
                newStyle.setBorderBottom(borderKey.getBorderBottom());
                if (borderKey.getBottomBorderColor() != null) {
                    newStyle.setBottomBorderColor(borderKey.getBottomBorderColor());
                } else {
                    newStyle.setBottomBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderLeft() != null) {
                newStyle.setBorderLeft(borderKey.getBorderLeft());
                if (borderKey.getLeftBorderColor() != null) {
                    newStyle.setLeftBorderColor(borderKey.getLeftBorderColor());
                } else {
                    newStyle.setLeftBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderRight() != null) {
                newStyle.setBorderRight(borderKey.getBorderRight());
                if (borderKey.getRightBorderColor() != null) {
                    newStyle.setRightBorderColor(borderKey.getRightBorderColor());
                } else {
                    newStyle.setRightBorderColor(blackColor);
                }
            }
            Map<FontKey, XSSFFont> fontCacheMap = this.getFontCacheMap();
            XSSFFont destFont = fontCacheMap.computeIfAbsent(fontKey, key -> {
                XSSFFont newFont = this.destWorkbook.createFont();
                newFont.setBold(fontKey.isBold());
                newFont.setColor(ColorHelper.parseColorByARGBHex(fontKey.getColorHex()));
                newFont.setFontHeight(fontKey.getFontHeight());
                newFont.setFontName(fontKey.getFontName());
                newFont.setItalic(fontKey.isItalic());
                newFont.setStrikeout(fontKey.isStrikeout());
                newFont.setTypeOffset(fontKey.getTypeOffset());
                newFont.setUnderline(fontKey.getUnderline());
                newFont.setFontHeightInPoints(fontKey.getFontHeightInPoints());
                return newFont;
            });
            newStyle.setFont((Font)destFont);
            return newStyle;
        });
    }

    public XSSFCellStyle getStyle(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle) {
        this.srcWorkbook = srcWorkbook;
        short fontIndex = srcStyle.getFontIndex();
        if (fontIndex < 0 || fontIndex >= srcWorkbook.getNumberOfFonts()) {
            fontIndex = 0;
        }
        XSSFFont srcFont = srcWorkbook.getFontAt(fontIndex);
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        XSSFColor topBorderColorCache = this.getXssfColor(srcStyle.getTopBorderXSSFColor(), null);
        XSSFColor bottomBorderColorCache = this.getXssfColor(srcStyle.getBottomBorderXSSFColor(), null);
        XSSFColor leftBorderColorCache = this.getXssfColor(srcStyle.getLeftBorderXSSFColor(), null);
        XSSFColor rightBorderColorCache = this.getXssfColor(srcStyle.getRightBorderXSSFColor(), null);
        BorderKey borderKey = new BorderKey(srcStyle.getBorderTop(), srcStyle.getBorderBottom(), srcStyle.getBorderLeft(), srcStyle.getBorderRight(), topBorderColorCache, bottomBorderColorCache, rightBorderColorCache, leftBorderColorCache);
        return this.getCellStyle(srcStyle, borderKey, srcFont, fontKey);
    }

    public XSSFCellStyle getStyle(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle, XSSFFont srcFont) {
        this.srcWorkbook = srcWorkbook;
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        XSSFColor topBorderColorCache = this.getXssfColor(srcStyle.getTopBorderXSSFColor(), null);
        XSSFColor bottomBorderColorCache = this.getXssfColor(srcStyle.getBottomBorderXSSFColor(), null);
        XSSFColor leftBorderColorCache = this.getXssfColor(srcStyle.getLeftBorderXSSFColor(), null);
        XSSFColor rightBorderColorCache = this.getXssfColor(srcStyle.getRightBorderXSSFColor(), null);
        BorderKey borderKey = new BorderKey(srcStyle.getBorderTop(), srcStyle.getBorderBottom(), srcStyle.getBorderLeft(), srcStyle.getBorderRight(), topBorderColorCache, bottomBorderColorCache, rightBorderColorCache, leftBorderColorCache);
        return this.getCellStyle(srcStyle, borderKey, srcFont, fontKey);
    }

    public XSSFCellStyle getStyle(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle, BorderKey borderKey) {
        this.srcWorkbook = srcWorkbook;
        short fontIndex = srcStyle.getFontIndex();
        if (fontIndex < 0 || fontIndex >= srcWorkbook.getNumberOfFonts()) {
            fontIndex = 0;
        }
        XSSFFont srcFont = srcWorkbook.getFontAt(fontIndex);
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        return this.getCellStyle(srcStyle, borderKey, srcFont, fontKey);
    }

    public XSSFFont getStyle(XSSFFont srcFont) {
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        Map<FontKey, XSSFFont> fontCacheMap = this.getFontCacheMap();
        return fontCacheMap.computeIfAbsent(fontKey, key -> {
            XSSFFont newFont = this.destWorkbook.createFont();
            this.cloneFont(srcFont, newFont);
            return newFont;
        });
    }

    public XSSFColor getXssfColor(XSSFColor xssfColor, String colorHex) {
        String colorHexString = xssfColor != null ? xssfColor.getARGBHex() : (StringUtils.isNotBlank((CharSequence)colorHex) ? colorHex.toUpperCase() : ColorHelper.getDefaultColor().getARGBHex());
        if (colorHexString == null) {
            return null;
        }
        Map<String, XSSFColor> colorCacheMap = this.getColorCacheMap();
        return colorCacheMap.computeIfAbsent(colorHexString, key -> {
            if (key.matches("[0-9A-F]{8}")) {
                return ColorHelper.parseColorByARGBHex(key);
            }
            return ColorHelper.parseColorToXSSF(key);
        });
    }

    public XSSFCellStyle getCustomBorderStyle(XSSFCellStyle srcStyle, boolean hasTop, boolean hasLeft, boolean hasRight, boolean hasBottom, BorderStyle borderStyle, XSSFColor color) {
        BorderKey borderKey = BorderKey.getBorderKeyStyle(hasTop, hasLeft, hasRight, hasBottom, borderStyle, color);
        short fontIndex = srcStyle.getFontIndex();
        if (fontIndex < 0 || fontIndex >= this.destWorkbook.getNumberOfFonts()) {
            fontIndex = 0;
        }
        XSSFFont srcFont = this.destWorkbook.getFontAt(fontIndex);
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        StyleKey styleKey = new StyleKey(this.destWorkbook, (CellStyle)srcStyle, fontKey, borderKey);
        Map<StyleKey, XSSFCellStyle> styleCacheMap = this.getStyleCacheMap();
        return styleCacheMap.computeIfAbsent(styleKey, k -> {
            XSSFCellStyle newStyle = this.destWorkbook.createCellStyle();
            this.setBaseStyle(srcStyle, newStyle);
            Map<FontKey, XSSFFont> fontCacheMap = this.getFontCacheMap();
            XSSFFont destFont = fontCacheMap.computeIfAbsent(fontKey, key -> {
                XSSFFont font = this.destWorkbook.createFont();
                this.cloneFont(srcFont, font);
                return font;
            });
            newStyle.setFont((Font)destFont);
            if (hasTop) {
                newStyle.setBorderTop(borderStyle);
                newStyle.setTopBorderColor(color);
            }
            if (hasLeft) {
                newStyle.setBorderLeft(borderStyle);
                newStyle.setLeftBorderColor(color);
            }
            if (hasRight) {
                newStyle.setBorderRight(borderStyle);
                newStyle.setRightBorderColor(color);
            }
            if (hasBottom) {
                newStyle.setBorderBottom(borderStyle);
                newStyle.setBottomBorderColor(color);
            }
            return newStyle;
        });
    }

    public ConditionalFormattingRule getCachedRule(ConditionalFormattingRule srcRule, SheetConditionalFormatting targetScf, String sourceSheet, String targetSheet) {
        RuleKey key = new RuleKey(this.destWorkbook, srcRule, sourceSheet, targetSheet);
        Map<RuleKey, ConditionalFormattingRule> ruleCacheMap = this.getRuleCacheMap();
        return ruleCacheMap.computeIfAbsent(key, k -> {
            ConditionalFormattingRule newRule = key.createAdaptedRule(srcRule, targetScf, sourceSheet, targetSheet);
            newRule = key.deepCopyRule(srcRule, newRule);
            return newRule;
        });
    }

    private XSSFCellStyle getCellStyle(XSSFCellStyle srcStyle, BorderKey borderKey, XSSFFont srcFont, FontKey fontKey) {
        StyleKey styleKey = new StyleKey(this.destWorkbook, (CellStyle)srcStyle, fontKey, borderKey);
        Map<StyleKey, XSSFCellStyle> styleCacheMap = this.getStyleCacheMap();
        return styleCacheMap.computeIfAbsent(styleKey, k -> {
            XSSFCellStyle newStyle = this.destWorkbook.createCellStyle();
            this.setBaseStyle(srcStyle, newStyle);
            XSSFColor blackColor = ColorHelper.getDefaultColor();
            if (borderKey.getBorderTop() != null) {
                newStyle.setBorderTop(borderKey.getBorderTop());
                if (borderKey.getTopBorderColor() != null) {
                    newStyle.setTopBorderColor(borderKey.getTopBorderColor());
                } else {
                    newStyle.setTopBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderBottom() != null) {
                newStyle.setBorderBottom(borderKey.getBorderBottom());
                if (borderKey.getBottomBorderColor() != null) {
                    newStyle.setBottomBorderColor(borderKey.getBottomBorderColor());
                } else {
                    newStyle.setBottomBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderLeft() != null) {
                newStyle.setBorderLeft(borderKey.getBorderLeft());
                if (borderKey.getLeftBorderColor() != null) {
                    newStyle.setLeftBorderColor(borderKey.getLeftBorderColor());
                } else {
                    newStyle.setLeftBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderRight() != null) {
                newStyle.setBorderRight(borderKey.getBorderRight());
                if (borderKey.getRightBorderColor() != null) {
                    newStyle.setRightBorderColor(borderKey.getRightBorderColor());
                } else {
                    newStyle.setRightBorderColor(blackColor);
                }
            }
            Map<FontKey, XSSFFont> fontCacheMap = this.getFontCacheMap();
            XSSFFont destFont = fontCacheMap.computeIfAbsent(fontKey, key -> {
                XSSFFont newFont = this.destWorkbook.createFont();
                this.cloneFont(srcFont, newFont);
                return newFont;
            });
            newStyle.setFont((Font)destFont);
            return newStyle;
        });
    }

    private void setBaseStyle(XSSFCellStyle srcStyle, XSSFCellStyle newStyle) {
        String formatString = this.getFormatString(this.srcWorkbook, srcStyle);
        if (StringUtils.isNotBlank((CharSequence)formatString)) {
            newStyle.setDataFormat(this.destWorkbook.getCreationHelper().createDataFormat().getFormat(formatString));
        } else {
            newStyle.setDataFormat(srcStyle.getDataFormat());
        }
        newStyle.setAlignment(srcStyle.getAlignment());
        newStyle.setVerticalAlignment(srcStyle.getVerticalAlignment());
        newStyle.setWrapText(srcStyle.getWrapText());
        XSSFColor srcForegroundColor = srcStyle.getFillForegroundColorColor();
        if (srcForegroundColor != null) {
            XSSFColor cachedForegroundColor = this.getXssfColor(srcForegroundColor, srcForegroundColor.getARGBHex());
            if (cachedForegroundColor != null) {
                newStyle.setFillForegroundColor(cachedForegroundColor);
            } else {
                newStyle.setFillForegroundColor(srcStyle.getFillForegroundColor());
            }
        } else {
            newStyle.setFillForegroundColor(srcStyle.getFillForegroundColor());
        }
        XSSFColor srcBackgroundColor = srcStyle.getFillBackgroundColorColor();
        if (srcBackgroundColor != null) {
            XSSFColor cachedBackgroundColor = this.getXssfColor(srcBackgroundColor, srcBackgroundColor.getARGBHex());
            if (cachedBackgroundColor != null) {
                newStyle.setFillBackgroundColor(cachedBackgroundColor);
            } else {
                newStyle.setFillBackgroundColor(srcStyle.getFillBackgroundColor());
            }
        } else {
            newStyle.setFillBackgroundColor(srcStyle.getFillBackgroundColor());
        }
        newStyle.setFillPattern(srcStyle.getFillPattern());
    }

    private void cloneFont(XSSFFont src, XSSFFont dest) {
        dest.setBold(src.getBold());
        XSSFColor srcFontColor = src.getXSSFColor();
        XSSFColor cachedFontColor = this.getXssfColor(srcFontColor, srcFontColor != null ? srcFontColor.getARGBHex() : null);
        dest.setColor(cachedFontColor);
        dest.setFontHeight(src.getFontHeight());
        dest.setFontName(src.getFontName());
        dest.setItalic(src.getItalic());
        dest.setStrikeout(src.getStrikeout());
        dest.setTypeOffset(src.getTypeOffset());
        dest.setUnderline(src.getUnderline());
        dest.setFontHeightInPoints(src.getFontHeightInPoints());
    }

    private String getFormatString(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle) {
        short srcFormatCode = srcStyle.getDataFormat();
        if (srcWorkbook == null) {
            return this.destWorkbook.getCreationHelper().createDataFormat().getFormat(srcFormatCode);
        }
        return srcWorkbook.getCreationHelper().createDataFormat().getFormat(srcFormatCode);
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        int workbookHash = System.identityHashCode(this.destWorkbook);
        THREAD_STYLE_CACHE.get().remove(workbookHash);
        THREAD_FONT_CACHE.get().remove(workbookHash);
        THREAD_RULE_CACHE.get().remove(workbookHash);
        THREAD_COLOR_CACHE.get().remove(workbookHash);
        if (THREAD_STYLE_CACHE.get().isEmpty()) {
            THREAD_STYLE_CACHE.remove();
        }
        if (THREAD_FONT_CACHE.get().isEmpty()) {
            THREAD_FONT_CACHE.remove();
        }
        if (THREAD_RULE_CACHE.get().isEmpty()) {
            THREAD_RULE_CACHE.remove();
        }
        if (THREAD_COLOR_CACHE.get().isEmpty()) {
            THREAD_COLOR_CACHE.remove();
        }
    }
}

