/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.jxdinfo.document.excel.tools.core.common.utils.CalUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WpsThemeColorUtil {
    private static final Map<Integer, String> DEFAULT_THEME_COLORS = new HashMap<Integer, String>();
    private static final Logger logger = LoggerFactory.getLogger(WpsThemeColorUtil.class);

    public static String getColorFromTheme(XSSFWorkbook workbook, int themeIndex, double tint) {
        try {
            byte[] originalRgb;
            XSSFColor themeColor;
            ThemesTable theme = workbook.getStylesSource().getTheme();
            if (theme != null && (themeColor = theme.getThemeColor(themeIndex)) != null && (originalRgb = themeColor.getRGB()) != null) {
                int[] baseRgb = new int[3];
                for (int i = 0; i < 3; ++i) {
                    baseRgb[i] = originalRgb[i] & 0xFF;
                }
                int[] resultRgb = new int[3];
                for (int i = 0; i < 3; ++i) {
                    resultRgb[i] = tint > 0.0 ? (int)((double)baseRgb[i] * (1.0 - tint) + 255.0 * tint) : (int)((double)baseRgb[i] * (1.0 + tint));
                    resultRgb[i] = Math.max(0, Math.min(255, resultRgb[i]));
                }
                byte[] finalRgb = WpsThemeColorUtil.intRgbToByteRgb(resultRgb);
                return CalUtil.rgbToColorString(finalRgb);
            }
        }
        catch (Exception e) {
            logger.error("\u4ece\u5de5\u4f5c\u7c3f\u4e3b\u9898\u4e2d\u83b7\u53d6\u6307\u5b9a\u7d22\u5f15\u7684\u989c\u8272\u65f6\u51fa\u9519", (Throwable)e);
        }
        logger.warn("\u4ece\u5de5\u4f5c\u7c3f\u4e3b\u9898\u4e2d\u83b7\u53d6\u6307\u5b9a\u7d22\u5f15\u7684\u989c\u8272\u65f6\u51fa\u9519\uff0c\u4f7f\u7528\u9ed8\u8ba4\u989c\u8272");
        return DEFAULT_THEME_COLORS.getOrDefault(themeIndex, "#000000");
    }

    public static byte[] intRgbToByteRgb(int[] intRgb) {
        if (intRgb == null || intRgb.length != 3) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684RGB\u6570\u7ec4\uff0c\u5fc5\u987b\u662f\u957f\u5ea6\u4e3a3\u7684int\u6570\u7ec4");
        }
        byte[] byteRgb = new byte[3];
        for (int i = 0; i < 3; ++i) {
            byteRgb[i] = (byte)intRgb[i];
        }
        return byteRgb;
    }

    static {
        DEFAULT_THEME_COLORS.put(0, "#000000");
        DEFAULT_THEME_COLORS.put(1, "#FFFFFF");
        DEFAULT_THEME_COLORS.put(2, "#000000");
        DEFAULT_THEME_COLORS.put(3, "#D9D9D9");
        DEFAULT_THEME_COLORS.put(4, "#5B9BD5");
        DEFAULT_THEME_COLORS.put(5, "#ED7D31");
        DEFAULT_THEME_COLORS.put(6, "#A5A5A5");
        DEFAULT_THEME_COLORS.put(7, "#FFC000");
        DEFAULT_THEME_COLORS.put(8, "#4472C4");
        DEFAULT_THEME_COLORS.put(9, "#70AD47");
        DEFAULT_THEME_COLORS.put(10, "#0563C1");
        DEFAULT_THEME_COLORS.put(11, "#954F72");
    }
}

